;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: setindex.lisp,v 1.5 2004/04/29 13:45:24 dvm Exp $

(depends-on %module/ ytools)

; Index for sets of eq-tested objects that typically have large overlaps

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(Eq_setindex new-Eq_setindex)))

(def-class Eq_dtree
    (:options :key)
   (size 0 :type integer)
   (last-discrim-attempt 0) ; integer = size on last discrim attempt; 
                            ; or nil -> successfully discriminated
   (contents '())
   (discrim nil)
   (haves nil)     ; subtrees for sets containing discrim
   (have-nots nil) ; subtrees for sets not containing discrim
)

(defun new-Eq_dtree (contents)
   (make-Eq_dtree :size (length contents) :contents contents))

(defun Eq_dtree-discriminated (tr)
   (not (Eq_dtree-last-discrim-attempt tr)))

(def-class Eq_setindex
    (:options :key)

   (tree nil :type Eq_dtree)
   piecefn)

(defun new-Eq_setindex (piecefn)
   (make-Eq_setindex :tree (new-Eq_dtree '())
		     :piecefn piecefn))

(defvar eqt-rehash-thresh* 5)

(defun eq-index-fetch (x ind)
      (elts-eq-index-fetch (funcall (Eq_setindex-piecefn ind) x)
                           ind))

(defun elts-eq-index-fetch (elts ind)
   (let ((pfn (Eq_setindex-piecefn ind))
         (already '()))
      (labels ((walk-down (tr)
                  (cond ((member tr already)
                         (error "Hit twice"))
                        (t
                         (push tr already)))                                
		  (cond ((and (not (Eq_dtree-discriminated tr))
			      (>= (- (Eq_dtree-size tr)
				     (Eq_dtree-last-discrim-attempt tr))
				  eqt-rehash-thresh*))
			 (setindex-try-rehash tr pfn)))
		  (cond ((Eq_dtree-discriminated tr)
			 (cond ((member (Eq_dtree-discrim tr) elts
					:test #'eq)
				(walk-down (Eq_dtree-haves tr)))
			       (t
				(walk-down (Eq_dtree-have-nots tr)))))
			(t (Eq_dtree-contents tr)))))
	  (walk-down (Eq_setindex-tree ind)))))

(defun eq-index-add (x ind)
   (eq-index-add-or-remove x ind true))

(defun eq-index-remove (x ind)
   (eq-index-add-or-remove x ind false))
   
(defun eq-index-add-or-remove (x ind add-vs-remove)
   (let ((elts (funcall (Eq_setindex-piecefn ind) x)))
      (labels ((walk-down (tr)
                  (cond ((Eq_dtree-discriminated tr)
                         (cond ((member (Eq_dtree-discrim tr)
					elts
					:test #'eq)
                                (walk-down (Eq_dtree-haves tr)))
                               (t
                                (walk-down (Eq_dtree-have-nots tr)))))
                        (add-vs-remove
                         (push x (Eq_dtree-contents tr))
                         (!= (Eq_dtree-size tr)
			       (+ *-* 1)))
			(t
			 (!= (Eq_dtree-contents tr)
			     (dremove1q x *-*))
                         (!= (Eq_dtree-size tr)
			       (- *-* 1))))))
         (walk-down (Eq_setindex-tree ind)))))

(defun setindex-try-rehash (tr pfn)
   (multiple-value-bind
	      (ok dis)
	      (set-disting (Eq_dtree-contents tr) pfn)
      (cond (ok
             (setf (Eq_dtree-discrim tr) dis)
	     (setf (Eq_dtree-haves tr)
		   (new-Eq_dtree
		         (remove-if-not
			      #'(lambda (x)
			         (member dis (funcall pfn x)
					 :test #'eq))
			      (Eq_dtree-contents tr))))
	     (setf (Eq_dtree-have-nots tr)
		   (new-Eq_dtree
			 (remove-if
			      #'(lambda (x)
			          (member dis (funcall pfn x)
					      :test #'eq))
			      (Eq_dtree-contents tr))))
             (setf (Eq_dtree-last-discrim-attempt tr) nil)
             (let ((h (Eq_dtree-size (Eq_dtree-haves tr)))
                   (n (Eq_dtree-size (Eq_dtree-have-nots tr)))
                   (s (Eq_dtree-size tr)))
                ;(format t "Rehashed, haves=~s, have-nots=~s, tot=~s~%"
                ;          h n s)
                (cond ((not (= (+ h n) s))
                       (error "Rehash discrepancy ~s+~s=/=~s"))
                      ((or (= h 0) (= n 0))
                       (error "Rehash futility")))))
            (t
             (setf (Eq_dtree-last-discrim-attempt tr) (Eq_dtree-size tr))))
      (cond ((not (eq (not ok)
                      (not (Eq_dtree-discriminated tr))))
             (error "Rehash discrepancy ok = ~s discriminated = ~s ~%"
                    ok (Eq_dtree-discriminated tr))))
      ok))

; Find an object that divides the elements of SL into an approximate 
; dichotomy -- about half the sets in SL contain the object and about
; half don't.
; Typically, element of SL has <100 elements.  SL has <10 elements
(defun set-disting (sl pfn)
   (do ((sltl sl (cdr sltl))
	(found nil) (d))
       ((or found (null sltl))
	(cond (found (values t d))
	      (t (values nil nil))))
     (do ((xl (funcall pfn (car sltl)) (cdr xl))
	  (x) (haves) (have-nots))
	 ((or found (null xl)))
       (setf x (car xl))
       (setf haves 0)
       (setf have-nots 0)
       (do ((sltl1 sl (cdr sltl1))
	    ;(i 1 (+ i 1))
	   )
	   ((null sltl1))
	 (cond ((member x (funcall pfn (car sltl1))
			:test #'eq)
		(setf haves (+ haves 1)))
	       (t 
		(setf have-nots (+ have-nots 1)))))
       (cond ((and (> haves 0)
		   (> have-nots 0)
		   (let ((r (/ (float haves)
			       (float have-nots))))
		     (and (>= r 0.5)
			  (<= r 2.0))))
	      (setf d x)
	      (setf found t))))))

(defun random-ints (m n)
   (do  ((i 1 (+ i 1))
	 (s '()))
	((> i n)
	 s)
      (setf s (adjoin (random m) s))))

;;; Number of elements in index
(defun eq_setindex-size (s)
   (eq_dtree-tot-size (Eq_setindex-tree s)))

(defun eq_dtree-tot-size (subtree)
   (cond ((Eq_dtree-discriminated subtree)
	  (+ (eq_dtree-tot-size (Eq_dtree-haves subtree))
	     (eq_dtree-tot-size (Eq_dtree-have-nots subtree))))
	 (t
	  (len (Eq_dtree-contents subtree)))))

(defun eq_setindex-all-conts (s)
   (eq_dtree-all-conts (Eq_setindex-tree s)))

(defun eq_dtree-all-conts (subtree)
   (cond ((Eq_dtree-discriminated subtree)
	  (nconc (eq_dtree-all-conts (Eq_dtree-haves subtree))
		 (eq_dtree-all-conts (Eq_dtree-have-nots subtree))))
	 (t
	  (list-copy (Eq_dtree-contents subtree)))))
