;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)

;;; Skolem term is of form (sk-type id num -args-)
;;; where sk-type is a Sym-with-type, where the sym is 'sk'

(defvar skolem-num* 0)

(defun make-Skolem-term (type id args argtypes env)
   (!= skolem-num* (+ *-* 1))
   (let ((alspec (args->spec argtypes))
	 (rlspec (args->spec (list type))))
      `(,(make-Sym-with-type
	    'sk
	    (make-funtype 0 type
			  (make-tup-type 'Row alspec "" env)
			  rlspec alspec false env))
	,id ,skolem-num* ,@args)))

(defun Skolem-term-id (skt) (cadr skt))
(defun Skolem-term-num (skt) (caddr skt))
(defun Skolem-term-args (skt) (cdddr skt))

(defun is-Skolem-term (x)
   (matchq (?(:\| sk ?(:+ ?_ (\\ (sk) (eq-sym sk 'sk))))
	    ?(:+ ?_ is-Symbol)
	    ?(:+ ?_ is-Number)
	    ?@_)
       x))

(defun sk-pprint (srm sk-term)
   (let ((sk-type (cond ((is-Sym-with-type (car sk-term))
			 (let ((fty (Sym-with-type-type (car sk-term))))
			    (cond ((is-funtype fty)
				   (multi-let (((ok rty)
						(nity::simple-funtype-restype
					           fty)))
				      (cond (ok rty)
					    (t false))))
				  (t false))))
			(t false))))
      (let ((l (and sk-type
		    (type-find-feature sk-type 'pprint-id global-opt-env*))))
	 (out (:to srm)
	      "@:" (:q (l l "-") (t "sk-"))
	      (Skolem-term-id sk-term)
	      "/"
	      (Skolem-term-num sk-term)
	      (:q (skolem-pprint-verbose*
		   (Skolem-term-args sk-term)))))))
	      
(set-pprint-dispatch
   (cons (satisfies (lambda (x) (eq-sym x 'sk))))
   #'sk-pprint)

(defun with-link-bdgs-parse (link-decls env)
   (multi-let (((orig-alspec _ _ synerrs)
		(params-parse link-decls true
			      empty-val-type* false false env))
	       ((vals types)
		(repeat :for ((vt :in (Env-vartypes env))
			      :collectors vals types)
		 :while (is-Vartype vt)
		 :collect (:into vals (Vartype-val vt))
		 :collect (:into types (Vartype-type vt))
		 :result (values vals types))))
      (let ((link-alspec
	       (new-Arglistspec
		  (<# (\\ (as)
			 (let ((link-type
				  (make-link-type (Argspec-type as) env)))
			    (make-Argspec
			       (Argspec-name as)
			       (Argspec-mode as)
			       (Argspec-position as)
			       link-type
			       (make-Skolem-term
				  link-type (Argspec-name as) 
			          vals types env)
			       (<# list-copy (nisptype::Argspec-props as)))))
		      (Arglistspec-argspecs orig-alspec)))))
	 (repeat :for ((err :in synerrs))
	    (defective-exp-notify
	       (make-Defective-exp
		  ;;;; :has-target false
		  :target false
		  :observation (\\ (_ srm)
				  (synerr-out err srm))
		  :signaler (\\ (this-exp)
			       (signal-problem :place with-link-bdgs-parse
				  "Syntactic error in 'with-links'["
				  " vars list: " this-exp
				  (:continue "I'll ignore it"))))
	       true))
	 (values orig-alspec
		 (arglistspec->vartypes link-alspec)
))))







(DEFTYPE skolem-form
  (LSTRUCTURE &FLAG SK V - symbol ID - number &REST SKARGS - (LST sexp))
  (CONSER (V UNIVS)
	  (!= SKNUM* (FX+ *-* 1))
	  `(SK ,V ,SKNUM* ,@UNIVS)))
; Consed by hand in many places, unfortunately.

(DECLARE-TYPE-ACCEPTABLE 'sexp 'skolem-form)

(PROC NEW-SKOLEM skolem-form (symbol VAR)
   (LET (skolem-form
	  (V (MAKE skolem-form VAR
			       (<! (\\ (P - (LRCD symbol sexp))
				      (COND ((IS mvar (CADR P))
					     (LIST (CADR P)))   ))
				   BOUND-PC-VARS*))))
       (!= SKOLEM-TERMS* (CONS V *-*))
       V   ))

(DEFFUNC SKOLEMIZE - sexp (PAT - sexp)
   (BIND ((FREE-PC-VARS* NIL) - (LST (LRCD symbol mvar))
	  (OUT-UNIVARS* NIL) - (LST symbol)
	  (BOUND-PC-VARS* NIL) - (LST (LRCD symbol sexp))
	  (SKOLEM-TERMS* NIL) - (LST skolem-form))
      (!= PAT (PAT-SKOLEMIZE PAT T))
      (LOOP FOR ((X IN SKOLEM-TERMS*) - skolem-form
		 (VL (FOR (L IN FREE-PC-VARS*)
			  (SAVE (CADR L))   ))
		  - (LST mvar))
	  (NCONC X VL)   )
      PAT   ))

(DEFFUNC SKOLEMIZE-WHICHEVER - sexp (PAT - sexp AFFIRM - boolean)
   (BIND ((FREE-PC-VARS* NIL) - (LST (LRCD symbol mvar))
	  (OUT-UNIVARS* NIL) - (LST symbol)
	  (BOUND-PC-VARS* NIL) - (LST (LRCD symbol sexp))
	  (SKOLEM-TERMS* NIL) - (LST skolem-form))
      (!= PAT (PAT-SKOLEMIZE PAT AFFIRM))
      (LOOP FOR ((X IN SKOLEM-TERMS*) - skolem-form
		 (VL (FOR (L IN FREE-PC-VARS*)
			  (SAVE (CADR L))   ))
		  - (LST mvar))
	  (NCONC X VL)   )
      PAT   ))

;;--added clauses for <- and -> --Denys, 10/17/89
(FUNC PAT-SKOLEMIZE - sexp (PAT - sexp AFFIRM - boolean)
  (COND ((ATOM PAT) (SKOLEM-SUBST PAT))
	(T
	 (SELQ (CAR PAT)
	   ((FORALL EXISTS)
	    (BIND ((BOUND-PC-VARS* 
		    (NCONC (COND ((EQ (EQ (CAR PAT) 'FORALL) AFFIRM)
				  (UNIV-BOUND-PC-VARS-TRANSLATE (CADR PAT)))
				 (T
				  (EXIS-BOUND-PC-VARS-TRANSLATE (CADR PAT)))   )
			   BOUND-PC-VARS*)))
	      (PAT-SKOLEMIZE (CADDR PAT) AFFIRM)   ))
	   ((OR AND) 
	    `(,(CAR PAT) . ,(FOR (P IN (CDR PAT)) 
				 (SAVE (PAT-SKOLEMIZE P AFFIRM)))))
	   ((IF ->)
	    `(,(CAR PAT) ,(PAT-SKOLEMIZE (CADR PAT) (NOT AFFIRM))
			 ,(PAT-SKOLEMIZE (CADDR PAT) AFFIRM)))
	   (<-
	    `(<- ,(PAT-SKOLEMIZE (CADR PAT) AFFIRM)
		 ,(PAT-SKOLEMIZE (CADDR PAT) (NOT AFFIRM))))
	   (NOT `(NOT ,(PAT-SKOLEMIZE (CADR PAT) (NOT AFFIRM))))
	   (T (SKOLEM-SUBST PAT))   ))   ))

;;;--is the case of a skolem form, do not substitute the
;;;--the skolem function with a variable. --Denys 7/21/89
(DEFFUNC SKOLEM-SUBST - sexp (PAT)
  (COND ((IS symbol PAT) (SYM-SKOLEMIZE PAT T))
	((IS mvar PAT) (SYM-SKOLEMIZE (!_VAR PAT) NIL))
	((ATOM PAT) PAT)
	((MEMQ (CAR PAT) '(FORALL EXISTS LAMBDA))
	 (BIND ((BOUND-PC-VARS*
		 (NCONC (FOR (V IN (CADR PAT)) (SAVE (LRECORD V V))   )
			BOUND-PC-VARS*)))
	   `(,(CAR PAT) ,(CADR PAT) ,(SKOLEM-SUBST (CADDR PAT)))   ))
	((IS skolem-form PAT)
	 `(SK ,!>PAT.V ,!>PAT.ID ,@(<# SKOLEM-SUBST !>PAT.SKARGS)))
	(T (<# SKOLEM-SUBST PAT))   ))

(FUNC SYM-SKOLEMIZE - sexp (V - symbol ATOM-SW - boolean)
  (LET ((VARSPEC (ASSQ V BOUND-PC-VARS*)) - (~ (LRCD symbol sexp)))
     (COND ((NULL VARSPEC)
	    (COND (ATOM-SW V)
		  (T
		   ; Free occurrence of ?V
		   (LET ((VARSPEC (ASSQ V FREE-PC-VARS*)) - (~ (LRCD symbol mvar)))
		      (COND ((NULL VARSPEC)
			     (LOOP FOR ((VAR V) - symbol)
		              UNTIL (NOT (MEMQ VAR OUT-UNIVARS*))
			        ; Did it also occur locally
				; If so, change its name
				(!= VAR (SYMBOL (< V) "." (++ VARNO*)))
			      RESULT (LET ((MV (MAKE mvar VAR)))
					(!= FREE-PC-VARS* (CONS (LRECORD V MV) *-*))
					(!= OUT-UNIVARS* (CONS VAR *-*))
					MV   )))
			    (T (CADR VARSPEC))   )))   ))
	   (T (CADR VARSPEC))   )))

;; Changed 7.8.88
(DEFPROC UNIV-BOUND-PC-VARS-TRANSLATE - (LST (LRCD symbol sexp))
	 (BVARS - (LST symbol))
    (FOR (V IN BVARS)
	 (SAVE (LOOP FOR ((VAR V) - symbol VARSPEC - (LST symbol))
		  (!= VARSPEC (MEMQ VAR OUT-UNIVARS*))
		WHILE VARSPEC 
		  ; This name is already used
		  (!= VAR (SYMBOL (< V) "." (++ VARNO*)))
		RESULT (PROGN (!= OUT-UNIVARS* (CONS VAR *-*))
			      (LRECORD V (MAKE mvar VAR)))   ))   )) ;was (LIST...)

(DEFFUNC EXIS-BOUND-PC-VARS-TRANSLATE - (LST (LRCD symbol sexp))
	 (BVARS - (LST symbol))
   (FOR (V IN BVARS)
	(SAVE (LRECORD V (NEW-SKOLEM V)))   ))


