;-*- Mode: Common-lisp; Package: opt; Readtable: ytools -*-
(in-package :opt)

(depends-on %module/ ytools)

(depends-on %ytools/ debug)

(auxiliary-code
   (defvar foo-count* 0)

   (defun set-equal (s1 s2)
      (and (subsetp s1 s2 :test #'equal)
	   (subsetp s1 s1 :test #'equal)))
)

(define (domain test-deduce)
  (:requirements :equality :numbers)

  (:objects omphalos)

  (:predicates (foo ?x) (baz ?x) (blech ?x)
	       (zoik ?x ?y) (zowk ?x ?y)
	       (zoi-owk ?x ?y)
	       (zowk-trans ?x ?y))

  (:axiom
   :vars (x)
   :implies (foo ?x)
   :procedure
   #'(lambda (vid bdgs sit dom)
	(!= foo-count* (+ *-* 1))
	(multi-let (((ok env)
		     (unify '?x foo-count* vid ground-id* bdgs)))
	   (cond (ok (list env))
		 (t !())))))

  (:facts
      (forall (x)
	 (<- (foo ?x) (baz ?x)))

      (forall (x)
	 (<- (baz ?x) (blech ?x)))

      (forall (x y z)
	 (<- (zoi-owk ?x ?y)
	     (or (and (zoik ?x ?y) (zowk ?y ?z))
		 (zowk ?y omphalos))))

      (forall (x y)
	 (<- (zowk-trans ?x ?y) (zowk ?x ?y)))

      (forall (x y z)
	 (<- (zowk-trans ?x ?z)
	     (and (zowk-trans ?x ?y)
		  (zowk-trans ?y ?z))))))

(define (situation test-sit)
    (:domain test-deduce)

  (:objects a b c p1 p2 p3 d e q)

  (:init
     (foo b) (baz c) (blech d)
     (zoik b p1)
     (zoik b p2)
     (zoik c p1)
     (zowk e d)
     (zowk p2 c)
     (zowk p2 a)
     (zowk c d)
     (zowk d e)
     (zowk q omphalos)))

(defvar test-dom*
    (or (try-domain-with-name 'test-deduce false)
	(signal-problem test-deduce
	    "Failed to define domain 'test-deduce'")))

(defvar test-sit*
    (sit-ini 'test-sit test-dom*))

(defvar test-id* (new-Varid))

(defun test-ded (q)
   (deduce-instances q test-id* (empty-env) true test-sit* test-dom*))

(test "Backward chaining"
   (check (set-equal (test-ded '(foo ?x))
		     `((foo ,foo-count*)
		       (foo b) (foo c) (foo d)))))

(test "Transitivity"
   (check (set-equal (test-ded '(zowk-trans p2 ?z))
		     '((zowk-trans p2 c) (zowk-trans p2 e)
		       (zowk-trans p2 d) (zowk-trans p2 a)))))

(test "Equality"
   (check (set-equal (test-ded '(= a a))
		     '((= a a)))
       "Deduction that (= a a)")
   (check (set-equal (test-ded '(= a b))
		     !())
      "Failed deduction that (= a b)")
   (check (set-equal (test-ded '(not (= a a)))
		     !())
      "Failed deduction that (not (= a a))"))
   
(test "Forall"       
   (check (null
	     (deduce
		'(forall (x)
		    (if (zowk-trans p2 x)
			(or (blech x) (zowk-trans x x))))
		test-id* (empty-env) test-sit* test-dom*))
      "It is not the case that all things related by 'zowk-trans' to p2"
      :% " are either blech or are zowk-trans to themselves")

   (check (not
	     (null
	        (deduce
		   '(forall (x)
		       (if (zowk-trans c x)
			   (or (blech x) (zowk-trans x x))))
		test-id* (empty-env) test-sit* test-dom*)))
      "Everything zowk-trans to c is either blech or zowk-trans to itself")

   (check (not
	     (null
	        (deduce
		   '(forall (x)
		       (if (zowk-trans p2 x)
			   (or (baz x) (= x a) (zowk-trans x x))))
		test-id* (empty-env) test-sit* test-dom*)))
      "Everything zowk-trans to p2 except 'a'"
      :% " is either blech or zowk-trans to itself"))
