;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

(depends-on types/ teshow)

(defvar e0)

(!= e0 (empty-vartypes opt-type-sys*))

(defvar check-env* e0)

(defun term-check-show (e dest-type)
   (bind ((syntax-handler-finder* #'opt-term-checker))
      (let ((te (term-check e dest-type
			    '()
			    (list (context-stack e))
			    check-env*)))
	 (multiple-value-let (lo hi)
			     (type-bounds (Typed-exp-type te) false check-env*)
;;;;	    (dbg-save lo hi te)
;;;;	    (breakpoint term-check-show
;;;;	       "Ready to show: " te)
	    (out t "ANNOTATED EXPRESSION TREE:" t)
	    (show te)
	    (out (q ((equal (Type-desig lo)
			    (Type-desig hi))
		     "Type: " lo)
		    (t
		     "Lo: " lo
		     t "Hi: " hi))
		 t (q ((> (Typed-exp-totbugs te) 0)
		       (Typed-exp-totbugs te) " bug(s)" t)))
	    te))))

(defun es-show ()
   (expstack-show (nisptype::context-find-expstack (g context) false) 5))

(typedecl 'apply (designated-type
		    '(Fun e (f - (Fun e <- (&rest _ -- v))
			     l - (Tup &rest (v) r - v)
			     !& e - (t) v - (tt)))
		    false e0)
	  nil universal-type-sys*)

(typedecl 'map (designated-type
		   '(Fun (Lst e) (f - (Fun e <- (&rest (= u)))
				  &rest (u) l - (Lst u)
				  !& e - t u - tt))
; 		   '(Fun 1
; 		         (Fun 0 (Lst e) (f - (Fun e u)
; 					 &rest (u) l - (Lst u)))
; 		         (e - t u - tt))
		   nil
		   e0)
	  nil universal-type-sys*)

(typedecl 'reverse
	  (designated-type
	        '(Fun (Lst e) <- (l - (Lst e) !& e - (t)))
		true e0)
	  nil universal-type-sys*)

(typedecl 'append
	  (designated-type
	        '(Fun (Lst e) <- (l1 l2 - (Lst e) !& e - (t)))
		true e0)
	  nil universal-type-sys*)

(typedecl 'f1 (designated-type
	         '(Fun Number (Number Number))
		 false e0)
	  nil universal-type-sys*)

(typedecl 'consnum (designated-type '(Fun (Lst Number) (Number (Lst Number)))
				    false e0)
	  nil universal-type-sys*)

(typedecl 'numtup2 (designated-type '(Fun (Tup Number Number) (Number Number))
				    false e0)
	  nil universal-type-sys*)

(!= num-type* (designated-type 'Number false e0))
(!= str-type* (designated-type 'String false e0))

(term-check-show '(f1 3 4) num-type*) 

(term-check-show '(apply (\\ (x y - Number) (f1 y x))
		         (numtup2 3 4))
		 num-type*)

(term-check-show '(\\ (x y - Number)
	             (apply f1 (numtup2 x y)))
		 univ-type*)

(term-check-show '(\\ (x y)
	             (apply f1 (numtup2 x y)))
		 univ-type*)

(typedecl 'f2 (designated-type
	         '(Fun Number (&rest l - Number))
		 false e0)
	  nil universal-type-sys*)

;; Should die with wrong-type bug.
;; Rationale: u is totally unknown, so there's no guarantee it's a list 
;; of numbers.
(term-check-show '(\\ (&rest (u) l - u !& u - tt)
	             (apply f2 l))
		 univ-type*)


;;; f-undef is undefined, so the types should work 
;;; There will still be an "undefined symbol" bug, of course.
(term-check-show '(\\ (&rest (u) l - u !& u - tt)
	             (apply f-undef l))
		 univ-type*)

(term-check-show '(\\ (&rest l - u !& u - t)
		     (append (reverse l) l))
		 univ-type*)

(typedecl 'augtup (designated-type
			   '(Fun 1 (Fun (Tup x - u &rest (v) l - v)
					(x - u l - (Tup &rest (v) l - v)))
				   (u - t v - tt))
			   false e0)
	  nil universal-type-sys*)

(term-check-show '(\\ (&rest (z) l - z !& z - tt)
	             ((!& augtup Number z) 3 l))
		 univ-type*)

(term-check-show '(\\ (&rest (z) l - z !& z - tt)
	             (augtup 3 l))
		 univ-type*)

;; Blows up with wrong-type bug (because it can't prove that u 
;; is a list of numbers).
(term-check-show '(\\ (&rest (u) l - u !& u - tt)
	             (apply f2 (augtup 3 l)))
		 univ-type*)

(term-check-show '(\\ (&rest l - Number)
	             (apply f2 (augtup 3 l)))
		 univ-type*)

(term-check-show '(\\ (l1 l2 - (Lst Number))
		     (apply f2 (map f1 l1 l2)))
		 univ-type*)

(typedecl 'tuple
	  (compile-time-designated-type
	     (Fun 1 (Fun (Tup &rest r -- a) <- (&rest r -- a))
	             <- (a - tt))
	     universal)
	  '(constructor 1)
	  universal-type-sys*)

;; Not clear what this one should do.
(term-check-show '(tuple 1 :a 'wow)
		 univ-type*)

(typedecl 'nums-bung
	  (designated-type '(Fun Number (&rest (= (Tup &rest _ - Number))))
			   true e0)
	  nil universal-type-sys*)

;; Bet this doesn't work, although it should:
(typedecl 'nums-munge
	  (designated-type '(Fun Number (&rest (= (Lst Number))))
			   true e0)
	  nil universal-type-sys*)


