;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

(defvar opt-env* (place-type-system-env opt-type-sys*))

(defvar check-env* (place-type-system-env opt-type-sys*))

(defun des (d) (designated-type d true check-env*))

(defun stk (e) (list (tuple ':polarity true) (context-stack e)))

(defun es-show (&optional (cxt (g context)))
   (expstack-show (nisptype::context-find-expstack cxt false) 5))

(!= check-env* (make-Env true
		  (list (new-Vartype 'l (des '(Lst Integer)) false)
			opt-type-sys*)))

(defun term-check-show (e dest-type)
   (bind ((syntax-handler-finder* #'opt-term-checker))
      (multi-let (((te _)
		   (term-check e dest-type
			    '()
			    (stk e)
			    check-env*)))
	 (multiple-value-let (lo hi)
			     (type-bounds (Typed-exp-type te) false check-env*)
;;;;	    (dbg-save lo hi te)
;;;;	    (breakpoint term-check-show
;;;;	       "Ready to show: " te)
	    (out t "ANNOTATED EXPRESSION TREE:" t)
	    (show te)
	    (out (q ((equal (Type-desig lo)
			    (Type-desig hi))
		     "Type: " lo)
		    (t
		     "Lo: " lo
		     t "Hi: " hi))
		 t (q ((> (Typed-exp-totbugs te) 0)
		       (Typed-exp-totbugs te) " bug(s)" t)))
	    te))))

(defmacro declare-sym (sym type &key (val-ob^ false))
   `(typedecl ',sym
	      (designated-type ',type true global-env*)
	      ,val-ob^
	      universal-type-sys*))

(typedecl '+
	  (designated-type
	     '(Fun Number <- (&rest Number)) true check-env*)
	  false
	  universal-type-sys*)

(declare-sym < (Fun Boolean <- (n1 n2 - Number)))


(def-type-fun Twolist (u) (Alt Empty-tup (Dot u (Dot u (Twolist u)))))

(typedecl 'car (designated-type
		  '(Fun ?u <- (Lst ?u))
		  true global-env*)
	  (make-object
	     ((fcn-type-invert (self type args)
		 (values true
			 (list (new-Vartype (car args)
					    (make-lstype type)
					    false))))
	      (print (ob srm)
		 (out (to srm) "#{Object CAR}"))))
	  universal-type-sys*)

(typedecl 'cdr (designated-type
		  '(Fun (Lst ?v) <- (Lst ?v))
		  true global-env*)
	  (make-object
	     ((fcn-type-invert (self type args)
		 (values true
			 (list (new-Vartype (car args)
					    type
					    false))))
	      (print (ob srm)
		 (out (to srm) "#{Object CDR}"))))
	  universal-type-sys*)

(typedecl 'null (designated-type
		   '(Fun Boolean <- (Lst ?v))
		   true global-env*)
	  (make-object
	     ((fcn-type-invert (self type args)
		 (cond ((types-equal type true-type*
				     empty-env* global-env*)
			(values true
				(list (new-Vartype (car args)
						   empty-tup-type*
						   false))))
		       (t
			(values true '()))))))
	  universal-type-sys*)

(typedecl 'not (designated-type
		  '(Fun Prop <- Prop) 
		  true global-env*)
	  (make-object
	     ((fcn-type-invert (self type args)
		 (multi-let (((cl found)
			      (type-find-feature type 'consts empty-env*)))
		    (cond (found
			   (cond ((equal cl '(false))
				  (values true
					  (list (new-Vartype
						   (car args)
						   (make-const-type
						      '('true))
						   false))))
				  ((not (member 'false cl))
				   (values true
					   (list (new-Vartype
						    (car args)
						    (make-const-type
						       '('false))
						    false))))
				  (t
				   (values true '()))))
			  (t
			   (values true '())))))
	      (print (ob srm)
		 (out (to srm) "#{Object NOT}"))))
	  universal-type-sys*)

(defvar pair-type* 
	(nisptype::make-dot-type
	   'Tup
	   univ-type*
	   univ-type*
	   global-env*))

(typedecl 'atom (designated-type
		   '(Fun Boolean Obj)
		   true global-env*)
	  (make-object
	     ((fcn-type-invert (self type args)
		 (multi-let (((cl found)
			      (type-find-feature type 'consts empty-env*)))
		    (out "Atom val found = " found " consts = " cl t)
		    (cond (found
			   (cond ((equal cl '('false))
				  (values true
					  (list (new-Vartype
						   (car args)
						   pair-type*
						   false))))
				  ((not (member ''false cl))
				   (typed-exp-type-narrow
				      (car args) false 
				      pair-type* global-env*))
				  (t
				   (values true '()))))
			  (t
			   (values true '())))))
	      (print (ob srm)
		 (out (to srm) "#{Object ATOM}"))))
	  universal-type-sys*)

(!= env1
    (make-Env true
	      (list (new-Vartype 'xx
				 (designated-type
				    '(Alt (Dot (Con true) Integer)
				          (Dot (Con false) String))
				    true
				    check-env*)
				 false)
		     opt-type-sys*)))
(!= term1
    '(if (car xx) (cdr xx) 0))

(typedecl 'apply (designated-type
		    '(Fun e (f - (Fun e <- (&rest _ -- v))
			     l - (Tup &rest (v) r - v)
			     !& e - (t) v - (tt)))
		    false global-env*)
	  nil universal-type-sys*)

(typedecl 'map (designated-type
		   '(Fun (Lst e) (f - (Fun e <- (&rest (= u)))
				  &rest (u) l - (Lst u)
				  !& e - t u - tt))
; 		   '(Fun 1
; 		         (Fun 0 (Lst e) (f - (Fun e u)
; 					 &rest (u) l - (Lst u)))
; 		         (e - t u - tt))
		   nil
		   global-env*)
	  nil universal-type-sys*)

(typedecl 'reverse
	  (designated-type
	        '(Fun (Lst er) <- (l - (Lst er) !& er - (t)))
		true global-env*)
	  nil universal-type-sys*)

(typedecl 'append
	  (designated-type
	        '(Fun (Lst ea) <- (l1 l2 - (Lst ea) !& ea - (t)))
		true global-env*)
	  nil universal-type-sys*)

(typedecl 'f1 (designated-type
	         '(Fun Number (Number Number))
		 false global-env*)
	  nil universal-type-sys*)

(typedecl 'consnum (designated-type '(Fun (Lst Number) (Number (Lst Number)))
				    false global-env*)
	  nil universal-type-sys*)

(typedecl 'numtup2 (designated-type '(Fun (Tup Number Number) (Number Number))
				    false global-env*)
	  nil universal-type-sys*)

(!= num-type* (designated-type 'Number false global-env*))
(!= str-type* (designated-type 'String false global-env*))

(defun nreset ()
   (!= nisptype::unkno* 100)
   (!= nisptype::tvar-no* 200))


(!= examples5
'(
(term-check-show
   '(let-var ((x 3))
       (+ x x))
   univ-type*)

(term-check-show
   '(let-var ((y 5))
       (let-fun (((dub x) (+ x x)))
          (+ (dub y) (dub y))))
   univ-type*)

(term-check-show
   '(let-fun ((rrr (x - (Lst Integer))
	         (if (null x)
		     0
		     (if (< (car x) 0)
			 (car x)
		         (rrr (cdr x))))))
       (rrr '(3 -3 3)))
   univ-type*)
		     
(term-check-show
                  ;;;;(let-var ((m '(3 2 1)) - (Lst Integer)) ...)
       `(let-fun ((uuu (l) (append (reverse l) l)))
          (uuu l))
   univ-type*)

(term-check-show '(apply (\\ (x y - Number) (f1 y x))
		         (numtup2 3 4))
		 num-type*)

(term-check-show
     '(let-fun ((ying (l)
		   (if (null l) l
		       (if (yang (car l))
			   (ying (cdr l))
			   '())))
		(yang (x) (> x 0)))
       (ying '(3 4 5))))

))
