;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

(defvar opt-env* (place-type-system-env opt-type-sys*))

(defvar check-env* (place-type-system-env opt-type-sys*))

(defun des (d) (designated-type d true check-env*))

;;(defun stk (e) (list (tuple ':polarity true) (context-stack e)))

(defun es-show (&optional (cxt (g context)))
   (expstack-show (nisptype::context-find-expstack cxt false) 5))

(!= check-env* (make-Env true
		  (list (new-Vartype 'l (des '(Lst Integer)) false)
			opt-type-sys*)))

(defun var-counters-reset ()
   (!= nisptype::unkno* 100)
   (!= nisptype::tvar-no* 200))

(defvar reset-before-term-check-show* true)

(defun term-check-show (e dest-type)
   ;;;;(bind ((syntax-handler-finder* #'opt-term-checker)) ...)
      (cond (reset-before-term-check-show*
	     (var-counters-reset)))
      (multi-let (((te _)
		   (term-check e dest-type
			    '()
			    (opt-syn-context e '())
			    check-env*)))
	 (multiple-value-let (lo hi)
			     (type-bounds (Typed-exp-type te) false check-env*)
;;;;	    (dbg-save lo hi te)
;;;;	    (breakpoint term-check-show
;;;;	       "Ready to show: " te)
	    (out t "ANNOTATED EXPRESSION TREE:" t)
	    (show te)
	    (out (q ((equal (Type-desig lo)
			    (Type-desig hi))
		     "Type: " lo)
		    (t
		     "Lo: " lo
		     t "Hi: " hi))
		 t (q ((> (Typed-exp-totbugs te) 0)
		       (Typed-exp-totbugs te) " bug(s)" t)))
	    te)))

(defmacro declare-sym (sym type
		       &key ((:val-ob val-ob^) 'false)
			    ((:type-system type-sys^) 
   `(typedecl ',sym
	      (designated-type ',type true global-env*)
	      ,val-ob^
	      universal-type-sys*))

(defmacro primitive-function-object (name clauses)
   `(make-object
       ((print (ob srm)
	   (out (to srm) "#{Primitive function " ',name "}"))
	(constval #',name)
	,@clauses)))

(declare-sym + (Fun Number <- (&rest Number))
   :val-ob (primitive-function-object + ()))

(declare-sym - (Fun Number <- (&rest Number))
   :val-ob (primitive-function-object - ()))

(declare-sym * (Fun Number <- (&rest Number))
   :val-ob (primitive-function-object * ()))

(declare-sym < (Fun Boolean <- (n1 n2 - Number))
   :val-ob (primitive-function-object < ()))

(def-type-fun Twolist (u) (Alt Empty-tup (Dot u (Dot u (Twolist u)))))

(declare-sym head (Fun ?u <- (Lst ?u))
   :val-ob (primitive-function-object head
	     ((fcn-type-invert (self type args)
		 (values true
			 (list (new-Vartype (car args)
					    (make-lstype type)
					    false)))))))

(declare-sym tail (Fun (Lst ?v) <- (Lst ?v))
   :val-ob (primitive-function-object tail
	     ((fcn-type-invert (self type args)
		 (values true
			 (list (new-Vartype (car args)
					    type
					    false)))))))

(declare-sym car (Fun ?u <- (Dot ?u ?v))
   :val-ob (primitive-function-object car
	      ((fcn-type-invert (self type args)
		  (values true
			  (list (new-Vartype (car args)
					     (make-dot-type
					        'Tup
						type
						(type-must-find-feature
						    (Typed-exp-type
						       (car args))
						    'nisptype::cdrtype
						    empty-env*)
						empty-env*)
					     false)))))))

(declare-sym cdr (Fun ?v <- (Dot ?u ?v))
   :val-ob (primitive-function-object cdr
	      ((print (ob srm) (out (to srm) "#{Object " 'car "}"))
	       (constval (ob) #'car)
	       (fcn-type-invert (self type args)
		  (values true
			  (list (new-Vartype (car args)
					     (make-dot-type
					        'Tup
						(type-must-find-feature
						    (Typed-exp-type
						       (car args))
						    'nisptype::cartype
						    empty-env*)
						type
						empty-env*)
					     false)))))))

(declare-sym not (Fun Prop <- Prop) 
   :val-ob (primitive-function-object not
	     ((fcn-type-invert (self type args)
		 (values true
			 (let ((b (type-as-boolean type empty-env*)))
			   (cond (b
				  (list (new-Vartype
					   (car args)
					   (make-const-type
					      (list
					         (cond ((eq b 'true)
							'false)
						       (t 'true))))
					   false)))
				 (t '()))))))))

(declare-sym null (Fun Boolean <- (Lst ?v))
   :val-ob
   (primitive-function-object null
      ((fcn-type-invert (self type args)
	  (values true
		  (let ((b (type-as-boolean type empty-env*)))
		     (cond (b
			    (list (new-Vartype
				     (car args)
				     (cond ((eq b 'true)
					    empty-tup-type*)
					   (t
					    `(not ,empty-tup-type*)))
				     false)))
			   (t
			    '()))))))))

(defvar pair-type* 
	(nisptype::make-dot-type
	   'Tup
	   univ-type*
	   univ-type*
	   global-env*))

(declare-sym atom (Fun Boolean Obj)
   :val-ob (primitive-function-object atom
	     ((fcn-type-invert (self type args)
		 (let ((b (type-as-boolean type empty-env*)))
		    (cond (b
			   (cond ((eq b 'false)
				  (values true
					  (list (new-Vartype
						   (car args)
						   pair-type*
						   false))))
				  ((not (member ''false cl))
				   (typed-exp-type-narrow
				      (car args) false 
				      pair-type* global-env*))
				  (t
				   (values true '()))))
			  (t
			   (values true '()))))))))

(!= env1
    (make-Env true
	      (list (new-Vartype 'xx
				 (designated-type
				    '(Alt (Dot (Con true) Integer)
				          (Dot (Con false) String))
				    true
				    check-env*)
				 false)
		     opt-type-sys*)))

(!= term1
    '(if (car xx) (cdr xx) 0))

(declare-sym apply (Fun e (f - (Fun e <- (&rest _ -- v))
			     l - (Tup &rest (v) r - v)
			     !& e - (t) v - (tt))))

(declare-sym map (Fun (Lst e) (f - (Fun e <- (&rest (= u)))
			       &rest (u) l - (Lst u)
			       !& e - t u - tt)))

(declare-sym reverse (Fun (Lst er) <- (l - (Lst er) !& er - (t))))

(declare-sym append (Fun (Lst ea) <- (l1 l2 - (Lst ea) !& ea - (t))))

(!= num-type* (designated-type 'Number false global-env*))
(!= str-type* (designated-type 'String false global-env*))

(!= examples6
'(
(term-check-show
   '(let-var ((x 3))
       (+ x x))
   univ-type*)

(term-check-show '(null l) bool-type*)

(term-check-show
   '(if (null l) -2 (if (null (cdr l)) -1 (+ (car l) (car (cdr l)))))
   univ-type*)

(term-check-show '(map + '(1 2 3) '(4 5 6)) univ-type*)p

(term-check-show '(map (\\ (x) (* (+ x 1) (- x 1)))
		       '(1 2 3))
                 univ-type*)

(term-check-show
   '(if (or (null l) (null (cdr l)))
        -1
        (+ (car l) (car (cdr l))))
   univ-type*)



))
