;-*- Mode: Common-lisp; Package: opt; Readtable: nisp; -*-
(in-package :opt)

(defvar opt-env* (place-type-system-env opt-type-sys*))

(defvar check-env* (place-type-system-env opt-type-sys*))

(defun des (d) (designated-type d true check-env*))

;;(defun stk (e) (list (tuple ':polarity true) (context-stack e)))

(defun es-show (&optional (cxt (g context)))
   (expstack-show (nisptype::context-find-expstack cxt false) 5))


(defun var-counters-reset ()
   (!= nisptype::unkno* 100)
   (!= nisptype::tvar-no* 200))

(defvar reset-before-term-check-show* true)

(defun term-check-show (e dest-type &key (env check-env*))
   (cond ((is-Symbol env)
	  (let ((dom (try-domain-with-name env false)))
	     (cond (dom
		    (!= env (empty-vartypes dom)))
		   (t
		    (let ((ts (find-type-system env false)))
		       (cond (ts
			      (!= env (place-type-system-env ts)))
			     (t
			      (signal-problem term-check-show
				 "Can't decipher env " env))))))))
	 ((or (is-Domain env) (is-Type-system env))
	  (!= env (empty-vartypes *-*))))
   (bind ((check-env* env))
      (cond (reset-before-term-check-show*
	     (var-counters-reset)))
      (multi-let (((te _)
		   (term-check e dest-type
			    '()
			    (opt-syn-context e '())
			    check-env*)))
	 (multiple-value-let (lo hi)
			     (type-bounds (Typed-exp-type te) false check-env*)
;;;;	    (dbg-save lo hi te)
;;;;	    (breakpoint term-check-show
;;;;	       "Ready to show: " te)
	    (out t "ANNOTATED EXPRESSION TREE:" t)
	    (show te)
	    (out (q ((equal (Type-desig lo)
			    (Type-desig hi))
		     "Type: " lo)
		    (t
		     "Lo: " lo
		     t "Hi: " hi))
		 t (q ((> (Typed-exp-totbugs te) 0)
		       (Typed-exp-totbugs te) " bug(s)" t)))
	    te))))

(!= num-type* (designated-type 'Number false global-env*))
(!= str-type* (designated-type 'String false global-env*))

(def-type-fun Twolist (u) (Alt Empty-tup (Dot u (Dot u (Twolist u)))))

(defvar builtin-dom* (try-domain-with-name 'builtin false))

(cond ((not builtin-dom*)
       (signal-problem test7 :fatal
	  "Builtin domain not defined")))

(!= easy-env*
    (make-Env true
	      (list (new-Vartype 'xx
				 (designated-type
				    '(Alt (Dot (Con true) Integer)
				          (Dot (Con false) String))
				    true
				    global-opt-env*)
				 false)
		    (new-Vartype 'p
				 (designated-type
				    '(Fun Prop <- Number)
				    true global-opt-env*)
				 false)
		    (new-Vartype 'q
				 (designated-type
				    '(Fun Prop <- Integer)
				    true global-opt-env*)
				 false)
		    (new-Vartype
			    'f1
			    (designated-type
			       '(Fun Number (Number Number))
			       true global-opt-env*)
			    false)
		    builtin-dom*)))

(defvar numdom* (try-domain-with-name 'numbers false))

(!= check-env* (make-Env true
		  (list (new-Vartype 'l
				     (designated-type
					'(Lst Integer)
					true global-opt-env*)
				     false)
			(or numdom*
			    (progn
			       (signal-problem :noplace
				  "Numbers domain not defined"
				  (:continue "Most examples won't work"))
			       opt-type-sys*)))))



(!= examples7
'(




(term-check-show '(f1 3 4) num-type* :env easy-env*)

(term-check-show
    '(if (car xx) (cdr xx) 0)
    num-type* :env easy-env*)

(internalize
   (term-check-show '(forall (x - Number)
			(if (p x) (p 0)))
		    univ-type*
		    :env easy-env*)
   !(Symbol) 'consequent)

(internalize
   (term-check-show '(forall (x - Integer)
			(if (p x) (q x)))
		    univ-type*
		    :env easy-env*)
   !(Symbol) 'consequent)

(internalize
   (term-check-show '(forall (x - Number)
			(if (not (p x)) (q x)))
		    univ-type*
		    :env easy-env*)
   !(Symbol) 'consequent)

(term-check-show
   '(let-var ((x 3))
       (+ x x))
   univ-type*
   :env 'numbers)

;;; The following rely on the declaration of 'l' as (Lst Integer)
;;; above in check-env*, plus the fact that check-env* includes the
;;; numbers domain.

(term-check-show '(null l) prop-type*)

(term-check-show
   '(if (null l) -2 (if (null (cdr l)) -1 (+ (car l) (car (cdr l)))))
   univ-type*)

(term-check-show '(map + '(1 2 3) '(4 5 6)) univ-type* :env 'numbers)

(term-check-show '(map (\\ (x) (* (+ x 1) (- x 1)))
		       '(1 2 3))
                 univ-type*)

(term-check-show
   '(if (or (null l) (null (cdr l)))
        -1
        (+ (car l) (car (cdr l))))
   univ-type*)



))
