;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)

;;; $Id: types.lisp,v 1.40 2006/10/30 21:49:22 dvm Exp $

(depends-on %module/ ytools)

(depends-on %module/ nity)

(depends-on :at-compile-time %nity/ deftyp
	    :at-run-time %lisplang/ typedexp typeconseq %nity/ typeintsect
	                 %langutils/ namespace)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(toggle-web-mode check-web-mode find-domain-bdg place-domain-bdg 
	     Object Prop Fluent Lnk 
	     Step Action Skip Durative-action Slide Process
	     no-op Null-action null-action-type*
	     prop-type* 
	     Either object Subsequent-situation make-Subsequent-situation
	     Fact Occasion
	     odt)))

(end-header :continue-slurping)

(defvar web-mode* false)

;;; Space in which global names (as for domains and problems) are
;;; interned.
(defvar opt-uri-space* (and web-mode* (make-uri-space)))

(defun check-web-mode ()
   (cond (web-mode*
	  (cond ((not opt-uri-space*)
		 (signal-problem check-web-mode
		    "In web mode with 'opt-uri-space* not bound"
		    (:proceed "I will set it to a new uri space"))
		 (!= opt-uri-space* (make-uri-space))))
	  true)
	 (t false)))

(defun toggle-web-mode ()
   (cond (web-mode*
	  (!= web-mode* false))
	 (t
	  (cond ((not opt-uri-space*)
		 (!= opt-uri-space* (make-uri-space))))
	  (!= web-mode* true))))	  

;; Shades of ML
(def-class Ref
   contents
  (:handler
      (print (r srm)
	 (out (:to srm) "#<Ref " (Ref-contents r) ">"))))

;; Grotesque kludge, er,.... I mean, brilliant hack.
(def-class Sym-with-type (:options (:kind :object))
   actual
   type
   (:handler (print (swt srm)
		(out (:to srm) (Sym-with-type-actual swt)
		              "&"))
	     (const-type (s)
		(Sym-with-type-type s))))

(defmacro strip-sym-with-type (v)
   (cond ((not (is-Symbol v))
	  (signal-problem strip-sym-with-type
	     "Stripping " v
	     :novalue)))
   `(cond ((is-Sym-with-type ,v)
	   (!= ,v (Sym-with-type-actual ,v)))))

(defun strip-car (l)
   (cond ((atom l) false)
	 (t
	  (let ((a (car l)))
	     (strip-sym-with-type a)
	     (cond ((is-symbolish a) a)
		   (t false))))))

(defun eq-sym (x sym-maybe-typed)
   (or (eq x sym-maybe-typed)
       (and (is-Sym-with-type sym-maybe-typed)
	    (eq x
		(Sym-with-type-actual sym-maybe-typed)))))

(defvar opt-read-table*)

(def-class Requirement (:options :key)
   (name nil :type symbol)
   (builtins '() :type list)
   (implies '() :type list)

; builtins is a list of builtin domains to be inherited by
; domains declaring this requirement
; implies is a list of requirements implied by this one.

   (:handler
    (print (req srm)
       (format srm "#<Requirement ~s>"
	       (Requirement-name req)))))

(defun any (_) true)

(eval-when (:load-toplevel :slurp-toplevel :compile-toplevel)
   (def-Type-system opt (:var opt-type-sys*)))

(defvar opt-namespace* (Type-system-namespace opt-type-sys*))

(namespace-associate opt-namespace*
                  '(\\ lambda _ &rest &optional &key - --
		    Fluent Prop Num-fluent
                    Either Alt Con Fun Lst Tup Arg Val
                    Object Obj Void
                    Boolean Number Float Integer
                    String Symbol T TT  
                    Skip Skip-action Hop Hop-action Slide Process
                    Step Null-action Void-step Action
                    Lnk))

(in-type-system opt)

(syn-type-former |Either| Alt)
(syn-type-former either Alt)


(def-type Object Obj)

(eval-when (:slurp-toplevel :compile-toplevel :load-toplevel)
   (cond ((or (not (eq (Type-desig univ-type*) 'Obj))
	      (eq (Type-super univ-type*) univ-type*)
	      (not (eq (Type-super univ-type*) false)))
	  (signal-problem opt-types
	     "univ-type* clobbered"))))

(def-type object Obj)

(eval-when (:slurp-toplevel :compile-toplevel :load-toplevel)
   (cond ((or (not (eq (Type-desig univ-type*) 'Obj))
	      (eq (Type-super univ-type*) univ-type*)
	      (not (eq (Type-super univ-type*) false)))
	  (signal-problem opt-types
	     "univ-type* clobbered"))))

(load-typesee opt-type-sys*)

(eval-when (:compile-toplevel :slurp-toplevel :load-toplevel)
   (defvar global-opt-env* (place-type-system-env opt-type-sys*))
)


;(eval-when (:compile-toplevel :load-toplevel :execute)
;    (defparameter opt-type-sys* (find-type-system 'opt true)))

;;; These types should really be in the nisp type-system, which doesn't
;;; exist yet.

(defun global-opt-type (name)
   (globally-defined-type (symbol-env-place name global-opt-env*)
			  opt-type-sys* true))

(def-type Rule-group (Clump :subtype Obj) (:system opt))

(defvar rule-group-type* (global-opt-type 'Rule-group))

(def-type Domain (Clump :subtype Obj) (:system opt))
    
(defvar domain-type* (global-opt-type 'Domain))

(def-type Problem (Clump :subtype Obj) (:system opt))

(defvar problem-type* (global-opt-type 'Problem))

(def-type Requirement (Clump :subtype Obj) (:system opt))

(defvar requirement-type* (global-opt-type 'Requirement))

(defun get-global-opt-sym (s)
   (let ((vt (global-declaration s opt-type-sys* false)))
      (cond ((and vt (is-Vartype vt))
	     (values (Vartype-val vt) true (Vartype-type vt)))
	    (t
	     (values false false false)))))

(defun hoo (s)
   (let ((vt (global-declaration s opt-type-sys* false)))
      (cond ((and vt (is-Vartype vt))
	     (values (Vartype-val vt) true (Vartype-type vt)))
	    (t
	     (values false false false)))))

(defun set-global-opt-sym (s v ty)
   (let ((vt (global-declaration s opt-type-sys* false)))
      (cond (vt
	     (cond ((not (is-Vartype vt))
		    (error-break set-global-opt-sym :fatal
		       "Setting global symbol " s " defined as " vt)))
	     (!= (Vartype-type vt) ty)
	     (!= (Vartype-val vt) v))
	    (t
	     (!= (global-declaration s opt-type-sys*)
		 (new-Vartype s ty v))))))

(defun flush-global-opt-sym (sym)
   (global-type-define sym false opt-type-sys*))

(defun map-global-opt-symbols (fcn)
  (maphash fcn (nisptype::Type-system-global-decl-tab opt-type-sys*)))

(def-type-constructor Set (elt)
   (:system opt))

(def-class Constant
   (name nil :type symbol)
   (type nil)  
   (:handler
     (print (pc srm)
       (format srm "#<Constant ~s - ~s>"
	       (Constant-name pc)
	       (Constant-type pc)))
     :allow-other-ops))

(def-class Functional-constant
   (:options (:include Constant) :key)
   (type-inverter false)
   (internalizer false)
   (callable false)
   (:handler
     (fcn-type-invert (c ty args)
;;;;	(dbg-save c ty args)
;;;;	(breakpoint Functional-constant-type-invert
;;;;	   "About to invert " c
;;;;	   :% " as " ty
;;;;	   :% " applied to " args)
	(let ((inverter (Functional-constant-type-inverter c)))
	   (cond (inverter
		  (funcall inverter c ty args))
		 (t (values true '())))))))

(def-class Predicate
    (:options :key (:include Functional-constant))
    (:handler
      (print (fctr srm)
	(format srm "#<Predicate ~s>"
		(Constant-name fctr))))
   (macro nil)
   (prechain nil) ;; Do backchaining only using rules available
                    ;; when the domain is being defined.
   (rigid nil))    ;; If (pred a b ...) is true in an initial situation,
                   ;; where a,b,... are ground,
                   ;; it will be true in all subsequent situations.

(defun new-Predicate (name predtype &key (type-inverter false)
					 (macro false)
					 (prechain false)
					 (rigid false))
   (make-Predicate
      :name name
      :type predtype
      :macro macro :prechain prechain :rigid rigid
      :type-inverter type-inverter))

(def-class Domain-var (:options :key)
   (name nil :type symbol)
   val
   (type nil)
   (:handler
    (print (dv srm)
       (format srm "#<Domain variable ~s=~s>"
	       (Domain-var-name dv)
	       (Domain-var-val dv)))))

; Rules are facts, axioms, action schemas, :safety-conditions, and :methods.
; Contents of rule-group are rules.
(def-class Rule-group (:options :key)
   (name nil)  ; :type (or symbol domain)
   (domain nil)  ; :type domain
   (generation 0 :type integer)
   (rules '() :type list)
   (:handler
    (print (rg srm)
       (cond ((eq (Rule-group-name rg)
		  (Rule-group-domain rg))
	      (format srm "#<Main rule group for ~s>"
			  (Rule-group-domain rg)))
	     (t
	      (format srm "#<Rule group ~s in ~s>"
		      (Rule-group-name rg)
		      (Rule-group-domain rg)))))))

(def-class Uterm
   term
      (:handler
       (print (occ srm)
	  (out (:to srm) "#/" (Uterm-term occ)))))

(def-class Occasion (:options (:include Uterm))
    (added false)
    (deleted false)
    (:handler
       (print (occ srm)
	  (out (:to srm) "#/" (Occasion-prop occ)
	       (:q ((Occasion-added occ) "+"))
	       (:q ((Occasion-deleted occ) "-"))))))

(defun Occasion-prop (occ) (Uterm-term occ))

;;; Denotes a difference between this situation and the initial situation.
(def-class Signed-occasion
   sign ; Boolean, true if added in this situation, false if deleted
   occ ; Occasion
   (:handler
       (print (so srm)
	  (out (:to srm)
	       "#/"
	       (:q ((Signed-occasion-sign so) "+")
		   (t "-"))
	       (Signed-occasion-prop so)))))

(defun Signed-occasion-prop (so) (Occasion-prop (Signed-occasion-occ so)))

(def-class Back-chainer
           (:options (:include Occasion) :key)
   consequent
   antecedent
;;;; Superseded by Stratified-backchains hash table in Indexed-domain
;;;;   (stratified '*unknown)    
)

;; 'statement' is a Typed-exp
(def-class Fact
   statement
   (internalized false) ;; An Occasion, perhaps a Back-chainer
  (:handler
      (print (fact srm)
	 (out (:to srm) "#<Fact "
	      (Typed-exp-source (Fact-statement fact)) ">"))))

(def-class Axiom (:options :key (:include Fact))
   vars
   antecedent
   consequent
   (:handler
     (print (ax srm)
	    (format srm "#<Axiom ~s>"
		    (Typed-exp-source (Axiom-consequent ax))))))

; "Axiom" defining procedural attachment
(def-class Procedural-axiom
  (:options :key
	   (:include Axiom))
   fcn
  (:handler
     (print (ax srm)
	(format srm "#<Procedural axiom ~s>"
		(Typed-exp-source (Axiom-consequent ax))))))

;;; Actions, methods, durative-actions, and processes
(def-class Causation-defn
   (:options :key)
   (:handler (print (ad srm)
		(format srm "#<Defn ~s>"
			(Causation-defn-function ad))))
   (function nil :type symbol)
   (internalized false)     ; Points to version with fields converted
			    ; to internal form.  (false until that internalized
			    ; version is needed.)
   term
   varbdgs            ; From :parameters and :vars

;;;;   param-constraints    ; Derived from types in :parameters
;;;;   var-constraints    ;   ... and from :vars
   condition
   effect)   ;; Type of value, but may contain variable names.

(def-class Action-defn
   (:options :key (:include Causation-defn))
   (maintain nil)
   has-methods
   only-in-expansions
   value)   ;; Type of value, but may contain variable names.

(defun Action-defn-precond (ad) (Action-defn-condition ad))

(def-class Method-defn
    (:options :key (:include Causation-defn))
    (:handler (print (md srm)
		  (cond ((Method-defn-name md)
			 (format srm "#<Method defn ~s for ~s>"
				     (Method-defn-name md)
				     (Method-defn-function md)))
			(t
			 (format srm "#<Method defn for ~s>"
				     (Method-defn-function md))))))
   name
;;;;   maint
   expansion
)

(defun Method-defn-precond (ad) (Method-defn-condition ad))

(def-class Durative-action-defn
   (:options :key (:include Causation-defn))
   duration)  ;; 

(def-class Process-defn
   (:options :key (:include Causation-defn))
   start-effect stop-effect)

(def-class Causation-function
    (:options :key (:include Functional-constant))
    (:handler (print (fct srm)
		 (format srm "#<Causation function ~s>"
			 (Constant-name fct))))
   defn)  ; duplicate pointer to Action-defn (or Process-defn, ...)

;; (Skip r) is an instance of the execution of an action that returns
;; value of type r.
(def-type-constructor Skip (&rest r - (T))
   (:system opt))

(defun make-skip-type-in-env (res-type desig-env)
   (make-constructed-type Skip-tyfun* (list res-type) desig-env))

;;; It's important that the 'r' slot of Skips, Hops, and Slides is called 'r'.
;;; Given one of these types Y, you can find the result type by doing
;;; (maybe-type-slot-fun false Y 'r 'type undo-stack vartypes)

(defun steptype-restype (ty env)
   (or (multi-let (((rty _ _)
                    (maybe-type-slot-fun false ty 'r ':type !() env)))
          rty)
       (type-local-feature ty 'result-type)
       (signal-problem steptype-restype
          "Step type has no base type: " ty)))
;;;;   (type-must-find-feature ty 'r env)

(def-type Skip-action (Skip))

(def-type-constructor Hop (&rest r - (T))
   (:system opt))

(defun make-hop-type-in-env (res-type desig-env)
   (make-constructed-type Hop-tyfun* (list res-type) desig-env))

;;;;   (designated-constructor-type Hop-tyfun* arg-desigs desig-env))

(def-type Hop-action (Hop) (:system opt))

;; (Slide r) is an instance of a Process that returns value of type r.
(def-type-constructor Slide (&rest r - (T))
   (:system opt))

(defun make-slide-type-in-env (res-type desig-env)
   (make-constructed-type Slide-tyfun* (list res-type) desig-env))

(def-type Process (Slide))
    ;;(Clump :subtype Obj) (:system opt))

(defvar process-type* (global-opt-type 'Process))

(defvar skip-type* (designated-type 'Skip-action true global-opt-env*))

(def-type Null-action :subtype Obj)

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel)

   (defvar null-action-type* (designated-type 'Null-action true global-opt-env*))

   (!= (type-feature null-action-type* 'result-type)
       void-type*))

(global-declare
   'no-op
   (new-Vartype 'no-op null-action-type* false)
   opt-type-sys*
   false)

(def-type-fun Step (r - (T)) (Alt (Skip r) (Hop r)) (:system opt))
;;; This works, if it does, only because Rows are not handled correctly --
;;;;(def-type-fun Step (&rest r - (R)) (Alt Null-action (Skip r) (Hop r)) (:system opt))

(defvar Step-tyfun*
    (Vartype-val (global-declaration 'Step opt-type-sys* true)))

(defun make-step-type-in-env (res-type _)
   (make-Step-type res-type))

(def-type Void-step (Alt Null-action (Skip Void) (Hop Void)))

(defun make-Step-type (res-type)
   (let ((component-types
	    (list (make-Skip-type res-type)
		  (make-Hop-type res-type))))
      (cond ((type-acceptable false res-type void-type* !()
			      global-opt-env* global-opt-env* !())
	     (!= component-types
		 (cons null-action-type* *-*))))
      (let ((step-type 
	       (nity::make-nontrivial-alt-type
		  component-types univ-type* global-opt-env*)))
	 (!= (type-feature step-type 'result-type)
	     res-type)
         (!= (type-feature step-type 'elt-types)
             (multi-let (((etyl found)
                          (type-find-feature
                             res-type 'elt-types global-opt-env*)))
                (cond (found etyl)
                      (t (new-Arglistspec
                            (list (new-Argspec
                                     '_ ':required res-type)))))))
	 step-type)))

(def-type Action (Alt Null-action Skip-action Hop-action))

(defvar action-type* (global-opt-type 'Action))

;;; These are now defined in %lisplang/builtin.lisp
;;;;(defvar num-type* (designated-type 'Number true global-opt-env*))
;;;;(defvar float-type* (designated-type 'Float true global-opt-env*))
;;;;(defvar rational-type* (designated-type 'Rational true global-opt-env*))
;;;;(defvar int-type* (designated-type 'Integer true global-opt-env*))
;;;;(defvar ratio-type* (designated-type 'Ratio true global-opt-env*))
;;;;(defvar boolean-type* (designated-type 'Boolean true global-opt-env*))

(defun fluent-as-boolean (fluent-type env)
   (type-as-boolean (type-find-feature fluent-type 'basetype env)
		    env))

(defun fluents-intersect (ctv sign1 ty1 sign2 ty2 undo-stack
			  env1 env2 intersect-stack)
   (cond ((and (type-find-feature ty1 'is-fluent env1)
	       (type-find-feature ty2 'is-fluent env2))
	  (let ((base1 (type-find-feature ty1 'basetype env1))
		(base2 (type-find-feature ty2 'basetype env2)))
	     (multi-let (((expr base-int undo-stack-1)
			  (types-intersect ctv sign1 base1 sign2 base2
					   undo-stack 
					   env1 env2 intersect-stack)))
		(check-expressibility-and-voidness
		   expr base-int undo-stack undo-stack-1
		   (values true (make-Fluent-type base-int) undo-stack-1)))))
	 (t
	  (values true void-type* undo-stack))))

(def-type-fun Fluent (a)
   (:system opt)
   (Clump :subtype Obj
      (:feature is-fluent :value true)
      (:feature basetype :type a)
      (:feature nisptype::intersector
		:value (nisptype::make-Intersect-handler
			  8 (simple-loadable-function
			       fluents-intersect)))
      (:feature type-as-boolean-checker
		:value (simple-loadable-function fluent-as-boolean))))

(def-type Prop (Fluent Boolean))

(defvar prop-type* (designated-type 'Prop true global-opt-env*))

(defvar fluent-tyfun* (var-val (symbol-env-place 'Fluent global-opt-env*)
			       global-opt-env*))

(defun make-Fluent-type (b)
   (nisptype::make-typeform
       fluent-tyfun* (list (new-Vartype 'a type-type* b))))

(def-type Num-fluent (Fluent Number))

(defvar fluent-type* (make-Fluent-type univ-type*))

(defvar num-fluent-type* (designated-type 'Num-fluent true global-opt-env*))
(defvar float-fluent-type* (designated-type '(Fluent Float)
					    true global-opt-env*))
(defvar int-fluent-type* (designated-type '(Fluent Integer)
					  true global-opt-env*))

;;; This must be defined before requirements.opt is loaded.
(defun fl-v-inverter (_ type args)
   (values true
	  (list (new-Vartype (car args)
			     (make-Fluent-type
				type)
			     nil))))

(def-type-former Lnk (elemtypes typename vartypes)
   (multi-let (((cont-type alspec _)
		(tup-val-former 'Row elemtypes typename
				univ-type* vartypes)))
      (make-type-of-class feat-class
	 `(Lnk ,@(arglistspec-typed-arglist alspec))
	 (Type-freevars cont-type)
	 univ-type*
	 !()
	 (list (tuple 'link-contents-type cont-type)))))

(defun make-link-type (ty env)
    (let ((cont-arg-list
	     (cond ((eq (type-find-feature ty 'medium env) 'Row)
		    (multi-let (((elt-types _ found)
				 (type-find-feature-spread 
				    ty 'elt-types env)))
		       (cond ((not found)
			      (signal-problem make-link-type
				 "Fumbled elt-types of " ty)))
		       (arglistspec-typed-arglist elt-types)))
		   (t
		    `(_ - ,(type-find-designator ty env))))))
       (make-type-of-class feat-class
	  `(Lnk ,@cont-arg-list)
	  (nisptype::type-find-freevars ty env)
	  univ-type*
	  !()
	  (list (tuple 'link-contents-type (new-Type-closure ty env))))))

(defun is-link-type (ty) (type-feature ty 'link-contents-type))

;;;;(def-type-fun Lnk (e) (Tup set - Boolean contents - (Val &rest (= e))))

;;; 'lit' is a constant, such as 3.  This type provides a wrapper
;;; that blocks substitution of equals for equals.  
;;; (E.g., 3 = (cardinality Trinity), 
;;;  but !=3 does not = !=(cardinality Trinity).  For that matter,
;;;  !=(cardinality Trinity) is not well formed.)
(def-class Rigid
    lit
    (:handler
       (print-object (lit srm)
          (out (:to srm)
             "!=" (Rigid-lit lit)))))

(defvar literal-pantheon* '(true false empty-list))

;;; != must still stand for itself, but immediately followed by
;;; an S-expression it means the Rigid object with that expression
;;; as 'lit'.  * BUT * see comment inside --
(yt::def-excl-dispatch #\= (srm _)
   (let ((ch (peek-char false srm)))
      (cond ((is-whitespace ch)
             '|!=|)
            ((member ch '(#\? #\/))
             (read-char srm)
             (build-symbol "!=" (:< ch)))
            (t
             ;; The only non-keyword symbols that count as literals are
             ;; 'true', 'false', and 'empty-list'.  (Perhaps a few others
             ;; can be admitted to the pantheon later.)  So if we read
             ;; another symbol, we should react as though we were reading
             ;; a symbol that happened to start with the characters "!"
             ;; and "=" all along.
             ;; Note that something like !=foo:abc is read all wrong.  If you
             ;; really have a package with the name "!=foo", you must now
             ;; put vertical bars around its name.  Sorry.
             (let ((lit (read srm)))
                (cond ((is-Symbol lit)
                       (cond ((or (memq lit literal-pantheon*)
                                  (is-Keyword  lit))
                              (make-Rigid lit))
                             (t
                              (build-symbol "!=" (:< lit)))))
                      (t
                       (make-Rigid lit))))))))

(def-class Literal
    val   ;; a string whose type is given by 'info'
    info  ;; -- an RDF URI reference to the datatype,
          ;; probably of the form "http://www.w3.org/2001/XMLSchema#<TYPE>"
    (:handler
        (print-object (lit srm)
           (out (:to srm)
              "!*" (Literal-val lit))))
    )
;;; There should be some mechanism for data-driven printing and
;;; reading of Literals whose info is decipherable, but there isn't.

;;;;(defun new-Action-function (name funtype defn)
;;;;   (make-Action-function
;;;;      :name name
;;;;      :type funtype
;;;;      :defn defn))

(def-class Domain (:options :key (:kind :object))
   (name 'unnamed-domain) 
   (uri false)
   (namespace false)
   (generation 0 :type integer)
   ;; -- If < 0, domain is "under construction" and *not fit for use*
   (ancestors '() :type list) 
      ; duplicate-free list of ancestors, including those from reqs.
      ; ** and including this domain itself **
   (parents '() :type list) 
   (requirements '() :type list)
   ;(facts '() :type list)  
   (local-bdgs '())  ; Ref(alist of Vartypes).
   (inherited-bdgs nil)
   (env false)
   (namespace-tab false) ; For Initial-situations defined in this domain
   (:handler
      (print (d s)
	 (format s "#<Domain ~s>" (Domain-name d)))
      (name-lookup (d varname)
	 (find-domain-bdg varname d))
      (name-lookup-or-bind (d varname creator)
	 (find-or-place-domain-bdg varname d creator))
      (get-namespace (d) (Domain-namespace d))
      (short-label (d)
	 (Domain-name d))))

(defun domain-place-env (dom)
   (or (Domain-env dom)
       (let ((newenv (empty-vartypes dom)))
	  (!= (Domain-env dom) newenv)
	  newenv)))

(defun domain-get-local-bdgs (dom)
   (Ref-contents (Domain-local-bdgs dom)))
;   (let ((b (Domain-local-bdgs dom)))
;      (cond ((and (not (null b))
;		  (eq (car b) '*indirect))
;	     (Domain-local-bdgs (cadr b)))
;	    (t b))))

(defun (setf domain-get-local-bdgs) (new-b dom)
   (let ((rb (Domain-local-bdgs dom)))
      (setf (Ref-contents rb) new-b)))

;      (cond ((and (not (null b))
;		  (eq (car b) '*indirect))
;	     (setf (Domain-local-bdgs (cadr b)) new-b))
;	    (t
;	     (setf (Domain-local-bdgs dom) new-b)))))

(defun find-domain-bdg (sym dom)
   (find-or-place-domain-bdg sym dom false))

(defun place-domain-bdg (sym dom)
   (find-or-place-domain-bdg sym dom true))

(defvar syms-to-catch* '())

(defvar unbound-sym-marker* (list 'unbound-symbol)
  "Val of sym until it has a real val")

(defun find-or-place-domain-bdg (sym dom create)
   (strip-sym-with-type sym)
   (let ((inh (place-domain-inherited-bdgs dom)))
      (let ((pb (gethash sym inh)))
	 (or pb
	     (labels ((cache-bdg (b)
			 (setf (gethash (Domain-bdg-sym b) inh)
			       b)
			 b))
		(dolist (a (Domain-ancestors dom)
                           (cond (create
				  (cond ((or (eq syms-to-catch* ':all)
					     (memq sym syms-to-catch*))
					 (breakpoint find-or-place-domain-bdg
					     "Creating binding for " sym
					     " in " dom)))
				  (let ((vt (cond ((eq create true)
						   (make-Domain-bdg
						      :sym sym
						      :val unbound-sym-marker*
						      :domain dom))
						  (t
						   (funcall create sym)))))
				     (let ((pb (store-domain-bdg
						  sym vt dom)))
					(cache-bdg pb))))
                                 (t nil)))
		    (let ((pb (vartypes-lookup sym
					       (domain-get-local-bdgs a))))
		       ;;(out (i> 3) "Lookup: " a  " -> " pb :%)
		       (cond (pb
			      (return (cache-bdg pb)))))))))))

;; Sometimes we have to shadow a global.
(defun create-local-bdg (sym type val dom)
   (let ((vt (store-domain-bdg
	         sym (make-Domain-bdg :sym sym :type type
				      :val val :domain dom)
		 dom)))
      (setf (gethash sym (place-domain-inherited-bdgs dom))
	    vt)
      vt))

(defun store-domain-bdg (sym vt dom)
   (ignore sym)
;;;;   (let ((vt (make-Domain-bdg :sym sym :type type :val val :domain dom)))....)
      (!= (domain-get-local-bdgs dom)
	  (cons vt *-*))
      vt)

(defun place-domain-inherited-bdgs (dom)
   (let ((inh (Domain-inherited-bdgs dom)))
      (cond ((not inh)
             (setq inh (make-hash-table :test #'eq))
             (setf (Domain-inherited-bdgs dom)
                   inh)))
      inh))

(defun same-domain (d1 d2)
   (let ((n1 (Domain-name d1))
	 (n2 (Domain-name d2)))
      (or (eq n1 n2)
	  (and (consp n1) (consp n2)
	       (eq (car n1) (car n2))
	       (eq (cadr n1) (cadr n2))))))

;; We now represent domain bindings with vartypes

(defun make-Domain-bdg (&key sym (type univ-type*) val domain)
   (let ((vt (new-Vartype sym type val)))
      (cond (domain
             (!= (vartype-feat vt 'domain)
                 domain)))
      vt))

(defun Domain-bdg-val (db) (Vartype-val db))

(defun (setf Domain-bdg-val) (v db)
   (setf (Vartype-val db) v))

(defun Domain-bdg-sym (db) (Vartype-var db))

(defun Domain-bdg-type (db) (Vartype-type db))

(defun (setf Domain-bdg-type) (v db)
   (!= (Vartype-type db) v))

(defun Domain-bdg-feat (db n) (vartype-feat db n))

(defun (setf Domain-bdg-feat) (v db)
   (setf (vartype-feat db) v))

(defun Domain-bdg-unbound (bdg) (eq (Vartype-val bdg) unbound-sym-marker*))

(defun Domain-bdg-domain (bdg) (vartype-feat bdg 'domain))

(def-class Situation
   (frozen false) ; Once it becomes true, the situation gets indexed
                  ; and can never be changed again.
   (path '())     ; One series of actions to reach it
   (diff-from-init) ; difference between this situation and initial situation,
                    ; expressed as an index containing Signed-occasions.
   (contents '*uncomputed)       ; index contents as list
   (more false)   ; Not used by Opt; for use by planners built on
                  ; top of Opt.
   (mark 0 :type integer)
   (query-tab false))  ; - (Htb Query-ans-spec); see deduction.lisp

(def-class Initial-situation
    (:options (:include Situation) :key)
   name
   domain       ; This is not a named domain, but a contrived subdomain
                ; ** Its first parent must always be the "real" domain
                ; it was derived from **
		; See Initial-situation-main-parent-domain in basics.nsp
   generation  
   (parent nil)  ; initial-situation this is based on, if any
   delta        ; List of literals giving difference between parent and this
                ; This list is derived from :init args, and are occasions that
                ;; may be deleted by subsequent actions.
                ;; An element of the form (not p) causes p to be deleted
                ;; at the outset; it may be added by later actions.
   (fact-index nil)  ; facts indexed (includes from superdomains).
   (init-index nil)  ; index of assertions that can change truth value in
                ; successor situations.
   ;; These are inherited by all situations reachable from
   ;; here.
   ;; This index is filled from the own-rule-group of domain
   (sit-index nil)   ; setindex of all situations reachable from here.
   (:handler
      (print (sit srm)
         (out (:to srm)
	      "#<" (:q ((not (Situation-frozen sit))
			"Changeable s")
		       (t "S"))
	      "ituation "
	      (Initial-situation-name sit)
	      ">"))))

(def-class Subsequent-situation
   (:options (:include Situation) :key)
   (init nil)  ; :type initial-situation
  (:handler
     (print (sit srm)
	(out (:to srm)
	      "#<" (:q ((not (Situation-frozen sit))
			"Changeable s")
		       (t "S"))
	      "ituation /"
	      (length (Situation-path sit))
	      ">"))))

(defun find-init-situation (sit)
   (cond ((is-Initial-situation sit) sit)
	 (t (Subsequent-situation-init sit))))

;;; Where is this used?
(def-class Plan-step 
   name   ;; CSymbol
   act    ;; Action
   pred succ) ;; two Situations

(def-class Problem
           (:options :key)
	   (:handler
              (print (prob srm)
                   (format srm "#<Problem ~s>"
                               (Problem-name prob))))
   name
   (sit nil)  ; :type initial-situation
   goal    ; Typed-exp
   expansion
   (length 0)  ; :type integer --- or something else
   metric)  ; ([minimize | maximize] <exp>)

(defun Problem-domain (p) (Initial-situation-domain (Problem-sit p)))

(defun Problem-namespace (p) (Domain-namespace (Problem-domain p)))

;; The following calls subroutines defined in later files.  It should probably
;; be moved to one of those files.

; Domain names are always either symbols with global values in opt-type-sys*, or
; of the form (domain <s>), where s is an initial situation.  The
; following procedure hides this complexity by returning two procedures,
; one that sets the value of its name, and one that retrieves it (which normally
; returns the same domain again).

(defun domain-name-procs (dom)
   (let ((domname (Domain-name dom)))
      (cond ((symbolp domname)
	     (let ((vt (global-declaration domname opt-type-sys* false)))
	        (cond ((and vt (is-Vartype vt))
		       (values #'(lambda (new)
				    (setf (Vartype-val vt)
					  new))
			       #'(lambda ()
				    (Vartype-val vt))))
		      (t
		       (error-break Domain-name-procs :fatal
			  "Symbol has improper global declaration: "
			  domname " = " vt)))))
            ((and (consp domname)
                  (eq (car domname) 'domain)
                  (is-Initial-situation (cadr domname)))
			     ; situation subdomain
             (let ((sit (cadr domname)))
                (values #'(lambda (new)
			    ;(dbg-save sit new)
			    ;(breakpoint sit-domain-setter
			    ;   "About to reset domain of " sit)
                            (setf (Initial-situation-domain sit)
                                             new))
                        #'(lambda ()
                             (Initial-situation-domain sit)))))
            (t
             (error "Crazy domain name ~s"
                    domname)))))

(defvar opt-home-web-site* false)

;;; For debugging --
(defun odt (td) (designated-type td true global-opt-env*))