;-*- Mode: Common-lisp; Package: opt; Readtable: ytools; -*-
(in-package :opt)
;;; $Id: walkdom.lisp,v 1.2 2004/02/22 01:05:42 dvm Exp $

;;;;;(no-slurp)

(depends-on %module/ ytools)

(depends-on :at-run-time %opt/ types basics)

(defun walk-domain-bdgs (dom fcn)
   (let ((checked-domains '()))
      (letrec ((walk-component-dom (dom)
		  (let ((already (exists (cdom :in checked-domains)
				    (same-domain cdom dom))))
		     (cond ((not already)
			    (!= checked-domains (cons dom *-*))
			    (domain-walk-immed-ancestors
			        #'walk-component-dom dom)
			    (repeat :for ((bdg :in (domain-get-local-bdgs dom)))
			       (cond ((is-Vartype bdg)
				      (funcall fcn bdg dom)))))))))
	 (repeat :for ((a :in universal-ancestors*))
	    (walk-component-dom a))
	 (walk-component-dom dom))))
