;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: ctldcl.lisp,v 2.12 2006/05/16 14:34:48 dvm Exp $

;;; Copyright 1988 - 2002, Drew McDermott, Yale University

;;; DCL handlers for most control hacks -- COND, AND, OR, SELQ, PROG, RETURN, 
;;; GO, LAMBDA, \\, DECL, LET, LET-FUN, PROG1, PROG2, PROGN, DO, FOR, FORALL,
;;;  EXISTS, FUNCTION, FUNCALL

(depends-on %module/ ytools)

(depends-on :at-run-time %ydecl/ dclmacs hostypes listype plextype)

;(DECLARE (SPECIAL TTYOUT* VARTYPES* RETURN-TYPE* SYMS* UNIV-TYPE*))

(declaim (special vartypes* univ-types* syms*))

(defun clause-redeclarations (e)
  (match-cond e
    ?((and ?@l)
      (repeat :for ((typs '()) (vars '()) (x :in l))
	(multiple-value-let
	    (ntyps nvars)
	    (clause-redeclarations x)
	  (!= typs (nconc typs ntyps))
	  (!= vars (nconc vars nvars)))))
    ?((is ?typ ?var)
      (if (is-Symbol var)
	  (values (list (check-designated-type typ)) (list var))
	  (values '() '())))
    ?((if-is ?typ ?var ?@l)
      (if (is-Symbol var)
	  (multiple-value-let
	      (typs vars)
	      (clause-redeclarations l)
	    (values (cons (check-designated-type typ) typs) (cons var vars)))
	  (clause-redeclarations l)))
    (t (values '() '()))))

;;;--made this smarter and right. --Denys 7/21/89
(datafun decl-compl cond
  (defun (exp dest-type)
    (let ((squiggle-type (squiggle (or dest-type 'Obj))))
      (let-fun
	  ((clause-decl-compl (clause)
	     (cond ((atom clause)
		    (defining-info)
		    (signal-problem cond :continue "Illegal COND clause: " clause))
		   ((cdr clause)
		    (multiple-value-let
			(typs vars)
			(clause-redeclarations (car clause))
		      (let ((test (decl-compile (car clause) 'Boolean))
			    (body (with-declarations vars typs
				    (body-compile (cdr clause) dest-type))))
			(make-Dclcmp (Dclcmp-typ body)
				     `(,(Dclcmp-exp test) ,@(Dclcmp-exp body))))))
		   (t (let ((test (decl-compile (car clause) squiggle-type)))
			(make-Dclcmp (Dclcmp-typ test) (list (Dclcmp-exp test))))))))
	(let ((clauses (<# clause-decl-compl (drop -1 (cdr exp)))))
	  (!= squiggle-type dest-type)
	  (!= clauses (nconc clauses (list (clause-decl-compl (lastelt exp)))))
	  (make-Dclcmp
             (cond ((matchq (t ?@_) (lastelt exp))
                    (</ (\\ (ty dc) (common-supertype ty (Dclcmp-typ dc))) 'Void clauses))
                   (t 'Void))
             `(,(car exp) ,@(<# Dclcmp-exp clauses))))))))

;;;--elegant alternatives to COND. --Denys 7/21/89
(datafun decl-compl when
  (defun (exp dest-type)
    (multiple-value-let
	(typs vars)
	(clause-redeclarations (cadr exp))
      (let ((body (with-declarations vars typs
		    (body-compile (cddr exp) dest-type))))
	(make-Dclcmp (Dclcmp-typ body)
		     `(,(car exp) ,(decl-compile-exp (cadr exp) 'Boolean)
				  ,@(Dclcmp-exp body)))))))

(datafun decl-compl unless when)

(datafun decl-compl if
   (defun (exp dest-type)
      (let ((false-stuff (or (cdddr exp) (list 'nil)   )))
         (decl-compile `(cond (,(cadr exp) ,(caddr exp))
			      (t . ,false-stuff)   )
		       dest-type)   )))

(datafun decl-compl match-cond
    (defun (exp dest-type)
       (multiple-value-let (decls match-vars cond-clauses)
			   (match-cond-analyze (cddr exp))
	  (decl-compile 
	     `(let ((ytools::match-datum (be Sexp ,(cadr exp)))
		    ,@match-vars - Sexp)
		 ,@decls
		 (cond ,@cond-clauses))
	     dest-type))))

;; Changed 9.7.88
(datafun decl-compl and
   (defun (exp dest-type)
      (cond ((null (cdr exp))
             (type-trans 't 'Boolean dest-type))
            (t
             (let ((la (decl-compile (lastelt exp) dest-type)))
                (make-Dclcmp (squiggle (Dclcmp-typ la))
                             `(,(car exp)
                              ,@(<# (\\ (x) (decl-compile-exp x 'Boolean)   )
                                    (drop -1 (cdr exp)))
                              ,(Dclcmp-exp la)))   ))   )))

;; Changed 9.7.88
(datafun decl-compl or
   (defun (exp dest-type)
      (cond ((null (cdr exp))
             (type-trans 'nil 'Null dest-type))
            (dest-type
             (let ((atype (squiggle dest-type)))
                (make-Dclcmp dest-type
                             `(,(car exp)
                                ,@(<# (\\ (x) (decl-compile-exp x atype))
                                      (drop -1 (cdr exp)))
                                ,(decl-compile-exp (lastelt (cdr exp))
                                                  dest-type)))   ))
            ; It would be possible to be more sophisticated here, but
            ; it would be a waste:
            (t (make-Dclcmp 'Obj
                            `(,(car exp)
                              . ,(<# compile-to-notype (cdr exp)))))   )))

(datafun decl-compl case
 (defun :^ (exp dest-type)
   (make-Dclcmp
          'Obj
	  `(case
	      ,(compile-to-notype (cadr exp))
	      . ,(<# (\\ (clause)
			 `(,(car clause)
			   ,@(cond ((null (cdr clause)) `())
				   (t
				    (body-compile-exp
				       (cdr clause) dest-type))))   )
		     (cddr exp))))   ))

(defvar return-type* nil)

(datafun decl-compl prog
(defun (exp dest-type)
   (bind ((return-type* return-type*))
      (let (bvars body source-type)
	 (cond ((is-type-desig (cadr exp))
		(!= source-type (cadr exp))
		(!= bvars (caddr exp))
		(!= body (cdddr exp)))
	       (t
		(!= source-type (or dest-type 'Obj))
		(!= bvars (cadr exp))
		(!= body (cddr exp)))   )
	 (cond ((eq (car exp) 'prog) (!= return-type* source-type))   )
	 (!= bvars (bvars-vartypes nil *-* nil))
	 (with-vartypes bvars
	    (!= bvars (<# Vartype-var bvars))
	    (type-trans
		`(prog ,bvars
		     ,@(var-declarations)
		     ,@(var-setups)
		     . ,(<! (\\ (x)
			      (cond ((atom x) (list x))
				    ((eq (car x) '\;)
				     nil)
				    (t (list (decl-compile-exp x 'Void)))  ))
			   body))
	       source-type
	       dest-type)   )))))

(datafun decl-compl return
(defun (exp dest-type)
   (ignore dest-type)
   (make-Dclcmp 'Void
	 `(return ,(decl-compile-exp (cadr exp) return-type*)))   ))

(datafun decl-compl go
   (defun (exp dest-type)
      (ignore dest-type)
      (make-Dclcmp 'Void exp)   ))

;; 87.9.28: Changed ; 88.5.16: revised for &REST
(datafun decl-compl lambda
  (defun (exp dest-type)
    (multiple-value-let (lmbd args funty body)
			(funclause-analyze exp)
      (declare (ignore lmbd))
      (let ((vtl nil))
         (repeat :for ((typl (fun-argtypes funty) (cdr typl))
		    (argl args (cdr argl))
		    typ arg)
	  :until (null typl)
          :result nil
	    (!= typ (car typl)) (!= arg (car argl))
	  :until (eq arg '&rest)
	    (!= vtl (cons (make-Vartype arg typ 'nil nil) *-*))
          :then :result (!= vtl (cons (make-Vartype
				         (cadr argl)
					 (lstype (cadr typl))
					 'nil nil)
				      *-*)))
         (with-vartypes vtl
	         (let ((body (body-compile body (fun-resulttype funty))))
		    (type-trans
		       `(,(car exp) ,args
			   ,@(var-declarations)
			   ,@(var-setups)
			   ,@(Dclcmp-exp body))
		       (make-Funtype (Dclcmp-typ body)
			             (fun-argtypes funty)
				     (fun-se funty))
		       dest-type)))   ))))

(datafun decl-compl \\ lambda)

;;;;(datafun decl-compl c\\ 
;;;;   (defun (exp dest-type)
;;;;      (let (rtype args body)
;;;;         (cond ((is-type-desig (cadr exp))
;;;;		(!= rtype (list (cadr exp)))
;;;;	        (!= args (caddr exp))
;;;;		(!= body (cddddr exp)))
;;;;	       (t
;;;;		(!= rtype nil)
;;;;		(!= args (cadr exp))
;;;;		(!= body (cdddr exp)))   )
;;;;	 (!= body (for (b in *-*) (when (not (car-eq b 'id\:))) (save b)   ))
;;;;	 (let ((dc (lambda-decl-compl `(lambda ,@rtype ,args . ,body)
;;;;				      dest-type)   ))
;;;;	    (make-Dclcmp (Dclcmp-typ dc) `#',(Dclcmp-exp dc))   ))))

;; Added 9.8.88
(datafun decl-compl progn
  (defun (exp dest-type)
    (let ((dc (body-compile (cdr exp) dest-type)))
      (make-Dclcmp (Dclcmp-typ dc)
        `(,(car exp) ,@(Dclcmp-exp dc))))))
   
(datafun decl-compl block progn)

(datafun decl-compl prog2
  (defun (exp dest-type)
    (cond ((not (>= (length exp) 3))
	   (signal-problem prog2-decl-compl :fatal
		   0 "Too few arguments: " exp))
	  (t
	   (let ((dc (decl-compile (caddr exp) dest-type)))
	     (make-Dclcmp (Dclcmp-typ dc)
		  `(prog2 ,(decl-compile-exp (cadr exp) 'Void)
			    ,(Dclcmp-exp dc)
			  . ,(<# (\\ (x) (decl-compile-exp x 'Void)   )
				 (cdddr exp))))   )))))

(datafun decl-compl prog1
  (defun (exp dest-type)
    (cond ((not (>= (length exp) 2))
	   (signal-problem prog1-decl-compl :fatal
		   0 "Too few arguments: " exp))
	  (t
	   (let ((dc (decl-compile (cadr exp) dest-type)))
	     (make-Dclcmp (Dclcmp-typ dc)
		  `(prog1 ,(Dclcmp-exp dc)
		     . ,(<# (\\ (x) (decl-compile-exp x 'Void)   )
			    (cddr exp))))   )))))

;; Added 11.14.88
(datafun decl-compl unwind-protect prog1)	

(datafun decl-compl dcl !'dcl-expand)

   ;(LET ((SOURCE-TYPE (AND (IS-TYPE-DESIG (CADR EXP)) (CADR EXP))))
   ;   (TYPE-TRANS (DCL-EXPAND EXP (OR SOURCE-TYPE DEST-TYPE))
;		  (OR SOURCE-TYPE DEST-TYPE 'Obj)
;		  DEST-TYPE)    )

(datafun decl-compl decl !'dcl-expand)

(datafun decl-compl let
   (defun (exp dest-type)
      (cond ((is-type-desig (cadr exp))
	     (bind-dcl-expand
		`(decl ,(cadr exp) (alloc . ,(caddr exp))
		     . ,(cdddr exp))
		dest-type (car exp)))
	        ;(TYPE-TRANS (... (CADR EXP)
	;		     (CAR EXP))
	;		 (CADR EXP) DEST-TYPE)
	    (t
	             ;(make-Dclcmp (OR DEST-TYPE 'Obj) ...)
	     (bind-dcl-expand
		`(decl (alloc . ,(cadr exp))
		      . ,(cddr exp)   )
		dest-type (car exp)))   )))

(datafun decl-compl bind let)

(defun bind-dcl-expand (dclexp dest-type binder)
   (let ((ddc (dcl-expand dclexp dest-type)))
      (!= dclexp (Dclcmp-exp ddc))
      (cond ((not (eq (car dclexp) 'let))
	     (signal-problem bind-dcl-expand :continue
		"Crazy DCL-EXPAND: " dclexp))   )
      (make-Dclcmp (Dclcmp-typ ddc)
                   (cons binder (cdr dclexp)))   ))

(def-class Fun-analysis
   name argl funtype body)

;;; Return < compiled fundefs, new vartypes, ftype-declarations >
(defun local-fundefs-decl-compile (fundefs)
   (let ((analyses 
	    (<# (\\ (c)
		   (multiple-value-let (name argl funtype body)
				       (funclause-analyze
					  (cond ((car-eq c ':def) (cdr c))
						(t c)))
		      (make-Fun-analysis name argl funtype body)   ))
		fundefs)))
      (let ((fundef-vartypes
	       (repeat :for ((a :in analyses))
		:collect (initvartype (Fun-analysis-name a)
				      (Fun-analysis-funtype a)
				      '*noinit))))
	 (values
	    (with-vartypes fundef-vartypes 
	       (<# (\\ (a)
		      `(,(Fun-analysis-name a) ,(Fun-analysis-argl a)
			,@(fundecl-expand (Fun-analysis-argl a)
					  (Fun-analysis-funtype a)
                                          false
					  (Fun-analysis-body a)
					  false)))
		   analyses))
	    fundef-vartypes
	    (<# (\\ (v) 
		   `(ftype ,(nisp-funtype->cl (Fun-analysis-funtype v))
			   ,(Fun-analysis-name v)))
		analyses)))))

(datafun decl-compl let-fun
   (defun :^ (exp dest-type)
      (match-cond exp
	 ?( (?_ ?clauses ?@body)
	   (multiple-value-let (clauses body _ actual-wheres)
				(extract-where clauses body)
              (multi-let (((dc-clauses fun-vartypes ftype-decls)
			   (local-fundefs-decl-compile clauses)))
                 (let ((num-wheres (max (- (len actual-wheres) 1)
					0)))
		     (make-Dclcmp 
			   (or dest-type 'Obj)
			   `(let-fun ,(drop (- num-wheres)
					   dc-clauses)
			       ,@(include-if (< debuggability* 0)
				    `(declare ,@ftype-decls))
			       ,@(with-vartypes fun-vartypes
				    (body-compile-exp body dest-type))
			     ,@(cond ((> num-wheres 0)
				      `(:where ,@(take (- num-wheres)
						       dc-clauses)))
				     (t `()))))))))
	 (t (signal-problem let-fun-decl-compl
			    "Ill-formed: " exp)))))

(datafun decl-compl labels let-fun)

;; Changed 3.21.88, 7.7.88
(datafun decl-compl do
   (defun (exp dest-type)
      (match-cond exp
	 ?((do ?varclauses (?test ?@result) ?@body)
	   (multiple-value-let (vclauses types)
                               (types-separate varclauses nil nil)
              (let ((dl (<# (\\ (vc ty)
			       (cond ((or (atom vc)
					  (null (cdr vc)))
				      (make-Dclcmp 'Obj nil))
				     (t
				      (decl-compile (cadr vc) ty))   ))
			    vclauses types)))
                 (cond ((<& null types)
			(!= types (<# (\\ (dc)
				         (cond ((is-subtype (Dclcmp-typ dc)
							    'Null)
						'Obj)
					       (t (Dclcmp-typ dc))   ))
				      dl)))   )
		 (!= vclauses (<# (\\ (vc dc)
				     (cond ((atom vc) `(,vc nil))
					   ((null (cdr vc))
					    `(,(car vc) nil))
					   (t
					    `(,(car vc)
					      ,(Dclcmp-exp dc)
					      ; Third piece must be handled
					      ; inside WITH-DECLARATIONS
					      . ,(cddr vc))
					   )   ))
				  *-*
				  dl))
		 (with-declarations (<# car vclauses) types
		    (!= test (decl-compile-exp *-* 'Boolean))
		    (!= body (cond ((null *-*) nil)
				   (t (body-compile-exp *-* 'Void))   ))
		    (cond ((null result) 
			   (!= result '((values))))   ) 
		    (!= result (body-compile *-* dest-type))
		    (cond ((var-setups)
			   (defining-info)
			   (signal-problem do-in-decl :fatal "Can't handle var setups"))
			  (t
			   (make-Dclcmp
			      (Dclcmp-typ result)
			      `(do ,(<# (\\ (c ty) 
					   `(,(car c) 
					     ,(cadr c)
					     . ,(cond ((null (cddr c)) nil)
						      (t 
						       `(,(decl-compile-exp 
							     (caddr c) ty)))   ))   )
				     vclauses types)
				(,test . ,(Dclcmp-exp result)) 
			     ,@(var-declarations)
			     . ,body)))   )))))
	    (t (signal-problem do :fatal "Illegal syntax: " exp))   )))

; Fixed 93.05 to allow (FORALL (X IN L) (EQL X ...)) when EQL happens
; to be a type-former.
(defun decl-for-analyze (forexp)
   (repeat :for ((l (cdr forexp)) (prefix nil))
    :until (null l)
    :result (signal-problem for :fatal "Meaningless: " forexp)
    :while (or (eq (car l) '-)
	      (and (is-type-desig (car l))
                   (not (null (cdr l))))
	      (matchq (?() ?(:\| :in in) ?()) (car l)))
      (cond ((eq (car l) '-)
	     (!= prefix `(,(cadr l) - . ,*-*))
	     (!= l (cddr l)))
	    (t
	     (!= prefix `(,(car l) . ,*-*))
	     (!= l (cdr l)))   )
    :result (multiple-value-let (varclauses types)
			       (types-separate (dreverse prefix) nil nil)
	      (multiple-value-let (vars lists types)
				  (forvars-analyze varclauses types)
                 (!= lists (<# (\\ (l ty) 
				  (decl-compile l (lstype (or ty 'Obj)))   )
		               lists types))
		 (cond ((<& null types)
			(!= types (<# (\\ (dc) 
					 (type-feature (Dclcmp-typ dc) 
						       'eltype)   )
				      lists)))   )
		 (!= lists (<# Dclcmp-exp *-*))
		 (values vars lists types l)   ))))

(defun forvars-analyze (varclauses tl)
   (repeat :for ((vc :in varclauses) (ty :in tl)
              (vars nil) (lists nil) (types nil)
	      var l)
    :result (values (dreverse vars) (dreverse lists) (dreverse types))
      (cond ((not (matchq (?var ?(:\| :in in) ?l) vc))
	     (matchq (?var ?(:\| :in in) ?l) vc))   )
      (!= vars (cons var *-*))
      (!= lists (cons l *-*))
      (!= types (cons ty *-*))   ))

; 87.10.9: Changed
(datafun decl-compl forall
   (defun :^ (exp dest-type)
;;;;      (out "forall-dc: " exp 1 dest-type :%)
      (multiple-value-let (vars lists types body)
			  (decl-for-analyze exp)
	 (with-declarations vars types
	    (let ((trans-exp
		     `(,(car exp) ,@(<# (\\ (v l) `(,v :in ,l)   )
					vars lists)
				  ,@(var-declarations)
				  ,@(var-setups)
				  ,@(body-compile-exp body 'Boolean))))
;;;;	       (out "trans-exp = " trans-exp :%)
	       (type-trans trans-exp 'Boolean dest-type))))))

(datafun decl-compl exists forall)

(datafun decl-compl funcall
  (defun (exp dest-type)
    (let ((fdc (decl-compile (cadr exp) nil)))
       (funcall-decl-compile fdc (car exp) (cddr exp) exp dest-type))))

;;;;      (cond ((is-Funtype (Dclcmp-typ fdc))
;;;;	     (let ((ft (Dclcmp-typ fdc)))
;;;;	       (type-trans
;;;;		`(,(car exp) ,(Dclcmp-exp fdc)
;;;;			     ,@(coerce-args (cddr exp)
;;;;					    (fun-argtypes ft)
;;;;					    exp))
;;;;		(fun-resulttype ft)
;;;;		dest-type)))
;;;;	    (t (let ((adcl (<# (\\ (a) (decl-compile a nil)) (cddr exp))))
;;;;		 (let ((fdc2 (type-trans (Dclcmp-exp fdc)
;;;;					 (Dclcmp-typ fdc)
;;;;					 (make-Funtype (or dest-type 'Obj)
;;;;						       (<# Dclcmp-typ adcl)
;;;;						       false))))
;;;;		   (make-Dclcmp (if (is-Funtype (Dclcmp-typ fdc2))
;;;;				    (fun-resulttype (Dclcmp-typ fdc2))
;;;;				    'Obj)
;;;;				`(,(car exp) ,(Dclcmp-exp fdc2)
;;;;					     ,@(<# Dclcmp-exp adcl)))))))

(datafun decl-compl function
   (defun (exp dest-type)
      (cond ((symbolp (cadr exp))
	     (type-trans exp (symtype (cadr exp)) dest-type))
	    (t
	     (let ((dc (decl-compile (cadr exp) dest-type)))
		(make-Dclcmp (Dclcmp-typ dc)
		  `(,(car exp) ,(Dclcmp-exp dc)))))   )))

(datafun decl-compl funktion function)

(datafun decl-compl block
   (defun (exp dest-type)
      (let ((tag (cadr exp)))
	 (cond ((is-Symbol tag)
		(with-vartypes (list (make-Vartype tag 'Block-name dest-type !()))
		   (let ((dc (body-compile (cddr exp) dest-type)))
		      (make-Dclcmp (Dclcmp-typ dc)
			 `(block ,(cadr exp) ,@(Dclcmp-exp dc))))))
	       (t
		(signal-problem block
		   "Illegal block name in " exp))))))

(datafun decl-compl return-from
   (defun :^ (exp _)
      (match-cond exp
	 (:? (return-from ?block-name ?@(:|| () (?result)))
	    (let ((vt (var-lookup block-name vartypes*)))
	       (cond ((and vt (eq (Vartype-typ vt) 'Block-name))
		      (let ((dc (decl-compile (or result 'nil)
					      (Vartype-initial vt))))
			 (make-Dclcmp
			    'Void
			    `(return-from ,block-name
				  ,(Dclcmp-exp dc)))))
		     (t
		      (signal-problem return-from-decl-compl
			 "Undefined block name in " exp)))))
	 (t
	  (signal-problem return-from-decl-compl
	     "Ill-formed: " exp)))))

(datafun decl-compl intercept
   (defun :^ (exp dest-type)
      (let ((dc (body-compile (cddr exp) dest-type)))
	 (make-Dclcmp (Dclcmp-typ dc)
	       `(intercept ,(cadr exp) . ,(Dclcmp-exp dc))))   ))

(datafun decl-compl pass
   (defun :^ (exp dest-type)
      (ignore dest-type)
      (make-Dclcmp 'Void
	       `(pass ,(cadr exp)
		      ,(decl-compile-exp (caddr exp) nil)))   ))

(datafun decl-compl catch
   (defun :^ (exp dest-type)
      (match-cond exp
	 (:? (catch ?tag ?@body)
	    (let ((tdc (decl-compile tag 'Symbol)))
	       (let ((bdc (body-compile body dest-type)))
		  (make-Dclcmp
		     (Dclcmp-typ bdc)
		     `(catch ,(Dclcmp-exp tdc)
			 ,@(Dclcmp-exp bdc))))))
	 (t
	  (signal-problem catch-decl-compl
	     "Ill-formed: " exp)))))

(datafun decl-compl throw
   (defun :^ (exp dest-type)
      (match-cond exp
	 (:? (throw ?tag ?res)
	    (let ((tdc (decl-compile tag 'Symbol)))
	       (let ((rdc (decl-compile res dest-type)))
		  (make-Dclcmp
		     'Void
		     `(throw ,(Dclcmp-exp tdc)
			     ,(Dclcmp-exp rdc))))))
	 (t
	  (signal-problem throw-decl-compl
	     "Ill-formed: " exp)))))

(defun cons-Funtype (rtd atdl se)
   (make-Funtype rtd
		 (designated-argtypes atdl)
		 se)   )

;; Here to end is support for LET* (not a released feature of NISP)
(datafun decl-compl dcl*  !'dcl*-expand)
(datafun decl-compl decl* !'dcl*-expand)

(datafun decl-compl let*
  (defun (exp dest-type)
    (cond ((is-type-desig (cadr exp))
	   (bind-dcl*-expand
	    `(decl* ,(cadr exp) (alloc . ,(caddr exp))
	       . ,(cdddr exp))
	    dest-type (car exp)))
	  ;(TYPE-TRANS (... (CADR EXP)
	  ;		     (CAR EXP))
	  ;		 (CADR EXP) DEST-TYPE)
	  (t
	   ;(make-Dclcmp (OR DEST-TYPE 'Obj) ...)
	   (bind-dcl*-expand
	    `(decl* (alloc . ,(cadr exp))
	       . ,(cddr exp)   )
	    dest-type (car exp)))   )))

(defun bind-dcl*-expand (dclexp dest-type binder)
  (let ((ddc (dcl*-expand dclexp dest-type)))
    (!= dclexp (Dclcmp-exp ddc))
    (cond ((not (eq (car dclexp) 'let*))
	   (signal-problem bind-dcl*-expand :continue "Crazy DCL*-EXPAND: " dclexp))   )
    (make-Dclcmp (Dclcmp-typ ddc)
		 (cons binder (cdr dclexp)))   ))

