;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: datadcl.lisp,v 2.15 2006/11/12 04:29:30 dvm Exp $

(depends-on :at-run-time 
	    %ydecl/ dclmacs sysdefs strtype plextype listype tmcdcl)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '()))

;;;; (specdecl is-Fun-name - (Fun Boolean (Obj) ())
;;;; 	  symbol->fun - (Fun Objfun (Symbol) ())
;;;; 	  get-fundef - (Fun Sexp (Symbol) ())
;;;; 	  put-fundef - (Fun Void (Symbol Sexp) ())
;;;; 	  fundef->fun - (Fun Objfun (Sexp) ())
;;;; 	  fundef->lambda - (Fun Sexp (Sexp) ())
;;;; 	  fun-name - (Fun Symbol (Objfun) ())
;;;; 	  is-Macro is-Magic - (Fun Boolean (Obj) ())
;;;; 	  one-macro-expand macro-expand-exp - (Fun Sexp (Sexp) ())
;;;; )

;; 88.4.13 out: the new specs (implemented by BOOLE-SUBTYPER) say 
;; only types for which NIL is a legal value are now allowed where
;; a boolean is expected.
;(DECLARE-TYPE-ACCEPTABLE NIL 'boolean)

(repeat :for ((ty :in '(Rational Fixnum Integer Float Char Number)))
   (declare-type-acceptable 'Sexp ty)   )

(declare-type-acceptable 'Sexp 'Form)
(declare-type-acceptable 'Sexp 'Symbol)
;;(declare-type-acceptable 'Qvar 'Sexp)

(bind ((allow-ftype* false))
; These functions have more general definitions in Lisp, so we suppress
; generating FTYPE declarations for them.
(specdecl = - (Fun Boolean (Number Number) ())
          _ - Void
	  char= char> char< char>= char=< 
	     - (Fun Boolean (Char Char) ())
	  gensym - (Fun Symbol () ())
	  get - (Fun Obj (Symbol Symbol) ())
	  make-Array - (Fun (Ary Obj *) ((Lst Fixnum)) ())
	  string-upcase string-downcase 
	      - (Fun String (String) ())
))	      


(specdecl cr - (Fun (*Typevar T) ((*Typevar T)) ())
          eq equal eql - (Fun Boolean (Obj Obj) ())
	  
	  not - (Fun Boolean (Boolean) ())
	  is-Number numberp is-Integer is-Float 
	  is-Ratio is-Rational is-Fixnum
	  is-Char is-Symbol symbolp
	  is-Vector is-Array is-String is-Hash-table
	     - (Fun Boolean (Obj) ())
)

(specdecl ch= ch> ch< ch=< ch>=
	     - (Fun Boolean (Char Char) ())
	  char- ch- - (Fun Fixnum (Char Char) ())
	  char+ ch+ - (Fun Char (Char Fixnum) ())
	  is-Alphabetic is-Whitespace is-Upper-case is-Lower-case
	      - (Fun Boolean (Char) ())
	  is-Digit - (Fun Boolean (Char Fixnum) ()) 
	  char-upcase char-downcase - (Fun Char (Char) ())
	  char->ascii - (Fun Fixnum (Char) ())
	  ascii->char - (Fun Char (Fixnum) ())
	  charfloor* charceil* - Fixnum

	  prop - (Fun Obj (Symbol Symbol) ())
	  remprop - (Fun Void (Symbol Symbol) T)
	  plist - (Fun (Lst Obj) (Symbol) ())

	  ;; Nov.4.87 modified
	  make-Vector - (Fun (Vct Obj) (Fixnum) ())
	  vector - (Fun (Vct (*Typevar E)) (*Typevar E) ())
	  vector-elt vref - (Fun (*Typevar E) ((Vct (*Typevar E)) Fixnum) ())
	  vector-length - (Fun Fixnum ((Vct Obj)) ())
	  vector-copy - (Fun (*Typevar V) ((*Typevar V (Vct (*Typevar E)))) ())
;;;;	  vector-subseq - (Fun (*Typevar V)
;;;;			       ((*Typevar V (Vct (*Typevar T))) Fixnum Fixnum)
;;;;			       ())
	  vector-concat - (Fun (*Typevar V) (*Typevar V (Vct (*Typevar E))) ())

	  array-dimensions - (Fun (Lst Fixnum) ((Ary Obj)) ())
	  array-dimension - (Fun Fixnum ((Ary Obj) Fixnum) ())

	  ;; Nov.4.87 added
	  list->vector - (Fun (Vct (*Typevar E)) ((Lst (*Typevar E))) ())
	  vector->list - (Fun (Lst (*Typevar E)) ((Vct (*Typevar E))) ())
	  initialized-array - (Fun (Ary (*Typevar E) *) ((Lst Fixnum) (*Typevar E)))
)

(datafun decl-compl aref
   (defun (exp dest-type)
      (let ((adc (decl-compile (cadr exp) 'Objarray))) 
	 (let ((r (type-feature (Dclcmp-typ adc) 'array-rank))
	       args)
	    (cond ((and type-check* (is-Number r))
		   (cond ((not (= (len (cddr exp)) r))
			  (out (:to *error-output*)
			       "Wrong number of arguments to AREF: " exp :%))
		   ))   )
	    (!= args (coerce-args (cddr exp) '(dot Fixnum) exp))
	    (type-trans 
	       `(aref ,(Dclcmp-exp adc) . ,args)
	       (or (type-feature (Dclcmp-typ adc) 'eltype)
		   'obj)
	       dest-type)   ))))

(specdecl string-copy - (Fun String (String) ())
;;;;	  string-subseq - (Fun String (String Fixnum Fixnum) ())
	  string-elt - (Fun Char (String Fixnum) ())
	  string-length - (Fun Fixnum (String) ())
	  string-concat - (Fun String String ())
	  subseq - (Fun (*Typevar E) ((*Typevar E) Integer Integer))

	  symbol->list - (Fun (Lst Char) ((Either Symbol Number)) ())
	  symbol->string - (Fun String ((Either Symbol Number)) ())
	  string->list - (Fun (Lst Char) (String) ())
	  intern1 string->symbol - (Fun Symbol (String) ())
	  concatenate-symbol - (Fun Symbol Obj ())
	  list->symbol - (Fun Symbol ((Lst Char)) ())
	  list->string - (Fun String ((Lst Char)) ())
	  number->string - (Fun String (Number) ())
	  string->number - (Fun Number (String) ())
	  char->string - (Fun String (Char) ())

	  ;; Changed 11.4.87, WALK-TABLE added 6.3.88, changes & FRESH-TABLE
	  ;; added 7.7.88
	  make-Eq-hash-table - (Fun (Htb Obj) ())
	  table-entry - (Fun (~ (*Typevar E)) ((Htb (*Typevar E)) Obj) ())
	  walk-table - (Fun Void ((Fun Void (Obj (*Typevar E)) T)
				  (Htb (*Typevar E)))
			         T)
	  fresh-table - (Fun (Htb (*Typevar E)) ((Htb (*Typevar E))) t)
)


; Avoid generating Lisp declarations for these constants.
(!= (prop 'type 't) (designated-type 'Boolean))
(!= (prop 'type 'true) (designated-type 'Boolean))
(!= (prop 'type 'nil) (designated-type 'Null))
(!= (prop 'type 'false) (designated-type 'Boolean))
(!= (prop 'type 'host-sys*) (designated-type 'Symbol))

(specdecl ;T - boolean 
	  ;NIL - null   
          _ - Null
	  host-dialect* ;HOST-SYS*
;; No longer appropriate because it's a symbol macro, not a global variable --
;;;;	  fload-compile* - Symbol
	  subr-synonyms* - (Lst (Lrcd Symbol Symbol))
	  chrfloor* chrceil* - Fixnum
	  compile-sw* - Boolean
	  fload-indent*  - Fixnum
	  now-loading* now-slurping* - Pathname
	  obj-suffix* source-suffix* - String
	  object-suffixes* source-suffixes* - (Lst String)
	  can-get-write-times* niscom-always* - Boolean
	  *query-io* *error-output* - Stream
;;;;	  slurping-stack* loading-stack* syms* - (Lst Symbol)
	  yt::post-file-transduce-hooks* - (Lst (Fun Void () t))
	  nisp-package* - Obj
	  warn-about-postponed-file-chunks* - Boolean)

(specdecl cons-if-new - (Fun (*Typevar X) (Obj (*Typevar X) (*Typevar X))))

(declare-func shorter - (~ Fixnum) (l - (Lst Obj) n - Fixnum))

(datafun decl-compl href
   (defun :^ (exp dest-type)
      (match-let (href ?htab ?key ?@maybe-default)
		 exp
	 (cond ((> (len maybe-default) 1)
		(signal-problem href
		   "Redundant args to 'href': " exp
		   (:proceed "I will ignore them"))))
	 (let ((tab-dc (decl-compile htab (htbtype ;;;;(or dest-type 'Obj)
					           'Obj)))
	       (key-exp (decl-compile-exp key false))
	       (def-dc-l (<# (\\ (d) (decl-compile d false))
			     maybe-default)))
	    (type-trans
	       `(href ,(Dclcmp-exp tab-dc)
		      ,key-exp
		      ,@(<# Dclcmp-exp def-dc-l))
	       (let ((ht-type (or (type-feature (Dclcmp-typ tab-dc) 'eltype)
				  'Obj)))
		  (cond ((eq ht-type 'Obj)
			 'Obj)
			((null maybe-default)
			 (squiggle ht-type))
			(t
			 (make-either-type
			    ht-type (Dclcmp-typ (car def-dc-l))))))
	       dest-type)))))

(defun make-either-type (&rest alternatives)
   (cond ((null alternatives) void-type*)
	 ((null (cdr alternatives)) (car alternatives))
	 (t
	  (let ((alt-desigs (<# Type-desig alternatives)))
	     (make-Type `(Either ,@(<# Type-desig alternatives))
			'Obj
			!()
			(list (tuple 'either-type-desigs alt-desigs)
			      (tuple 'either-types alternatives)
			      (tuple 'initexp
				     (tuple '*feature-fcn
					    !'compute-either-initexp))
			      (list 'slot-filler-fcn !'either-slot-filler)
			      (list 'subtype-fcn !'either-subtyper)
			      (list 'is-builder !'either-is-builder)))))))

(datafun decl-compl val-or-initialize
   (defun :^ (exp dest-type)
      (match-let (val-or-initialize ?e ?@keys)
		 exp
	 (let ((key-alist (yt::keyword-args->alist
			      keys '(:init :missing-if)
			      :offset 3))
	       (missing-marker (list 'missing))
               (val-dc (decl-compile e dest-type)))
            (multi-let (((itemp-vars ivals istore-vars iset iacc)
			 (bind ((setf-in-decl* true))
			    (get-setf-expansion (Dclcmp-exp val-dc)))))
	       (let ((curval-var (car istore-vars)))
		  (with-vartypes (bvars-vartypes*
				    false 
				    (<# tuple itemp-vars ivals)
				    true)
		     (let ((init-exp (alref key-alist ':init missing-marker))
			   (missing-exp
			      (alref key-alist ':missing-if missing-marker)))
			(let ((init-dc  (cond ((eq init-exp missing-marker)
					       (signal-problem
						  var-or-initialize-decl-compl
						  "'val-or-initialize' with no"
						  " :init arg"))
					      (t
					       (decl-compile
						  init-exp
						  dest-type))))
;;;;			      (acc-dc (decl-compile iacc false))
			      (missing-exp (cond ((eq missing-exp
						      missing-marker)
						  'false)
						 (t
						  (Dclcmp-exp
						     (decl-compile
							missing-exp
							false))))))
;;;;			   (out "missing-exp = " missing-exp :%)
			   (type-trans
			      `(let* ,(vartypes-bvars local-vartypes)
				  (let ((,curval-var ,iacc ;;;;(Dclcmp-exp acc-dc)
                                                           ))
				     (cond ((eq ,curval-var ,missing-exp)
					    (!= ,curval-var
						,(Dclcmp-exp init-dc))
					    ,iset))
				     ,curval-var))   
                              (Dclcmp-typ val-dc)
			      dest-type))))))))))

(datafun decl-compl memoize-val
   (defun :^ (exp dest-type)
      (match-let (memoize-val ?v ?@keys)
		 exp
	 (let ((key-alist (yt::keyword-args->alist
			      keys '(:store-as :missing-if)
			      :offset 3))
	       (missing-marker (list 'missing)))
	    (let ((store-exp (alref key-alist ':store-as missing-marker))
                  (missing-exp
                     (alref key-alist ':missing-if missing-marker)))
               (cond ((eq store-exp missing-marker)
                      (signal-problem
			 memoize-val-decl-compl
			 "'memoize-val' with no :store-as arg")))
               (multi-let (((itemp-vars ivals istore-vars iset iacc)
                            (bind ((setf-in-decl* true))
                               (get-setf-expansion store-exp))))
	          (let ((curval-var (car istore-vars)))
		     (with-vartypes (bvars-vartypes*
                                       false 
                                       (<# tuple itemp-vars ivals)
                                       true)
			(let ((val-dc (decl-compile v dest-type))
			      (acc-dc (decl-compile iacc false))
			      (missing-exp (cond ((eq missing-exp
						      missing-marker)
						  'false)
						 (t
                                                  (decl-compile-exp
							missing-exp
							false)))))
			   (type-trans
			      `(let* ,(vartypes-bvars local-vartypes)
				  (let ((,curval-var ,(Dclcmp-exp acc-dc)))
				     (cond ((eq ,curval-var ,missing-exp)
					    (!= ,curval-var
						,(Dclcmp-exp val-dc))
					    ,iset))
				     ,curval-var))   
                              (Dclcmp-typ val-dc)
			      dest-type))))))))))

(datafun decl-compl dbg-out-indent
   (defun :^ (exp dest-type)
      (match-let (dbg-out-indent ?gate ?space ?@body)
		 exp
	 (let ((g-exp (decl-compile-exp gate 'Boolean))
	       (sp-exp (decl-compile-exp space 'Integer))
	       (bdc (body-compile body dest-type)))
	    (type-trans
	       `(dbg-out-indent ,g-exp ,sp-exp
		   ,@(Dclcmp-exp bdc))
	       (Dclcmp-typ bdc)
	       dest-type)))))
