;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)
;$Id: dclchk.lisp,v 2.12 2006/05/18 23:25:26 dvm Exp $

(depends-on %module/ ytools)
(depends-on :at-run-time %ydecl/ types)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(*>* \?>* dclstack type-check* defining*)))

(defvar vartypes* nil)

;;; Moved to ydecl.lsy
;;;;(def-file-segment nisp-types-handlers ()
;;;;
;;;; ;;; Generates slurp task :nisp-types 
;;;; (def-sub-file-type :nisp-types)
;;;;)

;; A VARTYPE is a record of a bound variable.  INITIAL is its initial
;; value;  SETUPS is a list of expressions to initialize it (not often
;; used).
(def-class Vartype 
	  (:handler
	     (print (vt s) 
	      (out (:to s) 
		   "#{Vartype " (Vartype-var vt)
				 " - " (type-pname (Vartype-typ vt))
				 " - " (Vartype-initial vt) "}")   ))
   var typ initial setups)

(defun var-lookup (v vartypel)
   (repeat :for ((vt :in vartypel))
    :result nil
    :until (eq (Vartype-var vt) v)
    :result vt   ))

;; A dclcmp is the result of a DECL-COMPILE of an expression with a given
;; target type.  The TYP is the actual type of the expression.  The
;; EXP is the transduced expression.  
(def-class Dclcmp 
	  (:handler
	    (print (dc s)
	      (out (:to s)
		   "#{/" (type-pname (Dclcmp-typ dc)) "/ " (Dclcmp-exp dc) 
		    "}")))
   typ exp)


;; Find the type of an atomic entity
(defun atomtype (exp)
   (cond ;((NULL EXP) 'Obj)
	 ((is-Symbol exp) (symtype exp))
	 ((is-Number exp)
	  (numtype exp))
	 ((is-String exp) 'String)
	 ((is-Char exp) 'Char)
	 ((atom exp) 'Obj)
	 (t (signal-problem atomtype "Can't decipher type of nonatom " exp
			    :continue)
	     'Obj)   ))

;; Nov.4.87 modified
(defun symtype (sym)
   (cond ((eq sym 'nil) 'Null)
	 (t
	  (let ((vart (var-lookup sym vartypes*)))
	     (cond (vart (or (Vartype-typ vart) 'Obj))
		   (t
		    (!= vart (prop 'type sym))
		    (cond ((null vart) 'Obj)
			  ((is-type-desig vart)
			   (!= (prop 'type sym) (designated-type vart))
			   (prop 'type sym))
			  (t vart)   ))   )))  ))
	    ;((IS-TYPE-DESIG SYM) 'type)

;; Convert expression X from one type to another.  Return dclcmp (type result)
;; If DEST-TYPE = *NOTRANS, then the type is found and that's that.  So
;; (TYPE-TRANS 'X 'real '*NOTRANS) => (real X).
;; Else, figure out how to coerce the type, by using the type's coercion
;; function.  e.g, (type-trans 'x 'Real 'Integer) => (floor x)
;; dest-type = false usually means the same as '*notrans', but
;; the coercion function gets to look at it, and may decide to do
;; something with it.
(defun type-trans (x source-type dest-type)
  (if (or (eq dest-type '*notrans)
	  (equal source-type dest-type))
      (make-Dclcmp source-type x)
      (let ((new (type-coerce x source-type dest-type)))
	(if (eq new '*noway)
	    (cond ((and (not (null dest-type))
			(eq (Type-desig source-type) 'Obj))
		   (make-Dclcmp (typevar-obj-subst dest-type) x))
		  ((or (null dest-type)
		       (subtype source-type dest-type t))
		   (make-Dclcmp source-type x))
		  ((const-of-type x dest-type)
		   (make-Dclcmp (typevar-obj-subst dest-type) x))
		  (t (wrong-type x source-type 
				 (typevar-obj-subst dest-type))))
	    (make-Dclcmp dest-type new)))))

;; 87.9.28: Added for use above
(defun typevar-obj-subst (type)
  (let-fun ((contains-typevars (x)
                (and (not (atom x))
                     (or (eq (car x) '*typevar)
                         (contains-typevars (car x))
                         (contains-typevars (cdr x))))   )
	    (dosubst (tdes)
		 (cond ((atom tdes) tdes)
		       ((eq (car tdes) '*typevar)
			(cond ((cddr tdes) (dosubst (caddr tdes)))
			      (t 'Obj)   ))
		       (t
			(cons (dosubst (car tdes))
			      (dosubst (cdr tdes))))   )))
      (cond ((contains-typevars (Type-desig type))
	     (designated-type (dosubst (Type-desig type))))
	    (t type)   )))

;; Can X be determined to be a constant of appropriate type at
;; compile time?
(defun const-of-type (x ty)
   (multiple-value-let (is-const val)
		       (cond ((memq x '(t true)) (values t t))
			     ((memq x '(nil false)) (values t nil))
			     ((car-eq x 'quote) (values t (cadr x)))
			     ((or (is-Number x) (is-String x))
			      (values t x))
			     (t (values nil nil))   )
       (cond (is-const
	      (let ((istestfname (get-is-tester ty t)))
		 (cond (istestfname
			(funcall (cond ((symbolp istestfname)
					(symbol-function istestfname))
				       (t (eval istestfname)))
				 val))
		       (t
			(and (not val)
			     (type-feature ty 'nil-acceptable))))))
	     (t nil))))

(defun vartypes-bvars (vartypes)
   (<! (\\ (vart)
	 (cond ((eq (Vartype-initial vart) '*noalloc) nil)
	       (t
		(list `(,(Vartype-var vart) 
			,(cond ((eq (Vartype-initial vart) '*noinit)
                                (var-initial-exp
                                   (Vartype-var vart)
                                   (Vartype-typ vart)))
			       (t (Vartype-initial vart))   ))))   ))
       vartypes))

(defun var-initial-exp (var type)
   (let ((init-exp
            (and type
                 (type-feature type 'initexp))))
      (cond (init-exp init-exp)
            ((is-subtype univ-type* type)
             'nil)
            (t
             (signal-problem var-initial-exp
                "Variable " var " declared to be of type " type
                :% " has no legal initial value"
                (:prompt-for "Initial-value expression" ''nil))))))

(defvar implicit-ob* nil) ;Implicit object in !>slot constructions inside WITH
;;; See tmcdcl.lisp and objdcl.lisp

(defvar freeslots* '())
;;; A list of triples (slotname slotexp type) that records the 
;;; types of expected slots.  The slotexp is just (SLOT slotname), and
;;; could be dispensed with.
;;; This variable isn't used until file objdcl.lisp

;; Check if type and slot make sense for expression.
;; Return corrected list (exp type slot contents)
(defun must-type-slot (exp ty slot wanted)
   (repeat :for ((r false))
      (!= r (and (eq exp implicit-ob*)
		 (assq slot freeslots*)))
    :until r
    :result (tuple (second r) '*abort nil nil)
       (!= r (type-slot-fun ty slot wanted nil))
    :until r
    :result (tuple exp ty slot r)
      (defining-info)
      (out (:to *query-io*) :% "ERROR: " exp " has no " )
      (selq wanted
	 ((acc access) (out (:to *query-io*) "accessor for"))
	 (set (out (:to *query-io*) "setter for"))
	 (type (out (:to *query-io*) "type for"))
	 (t nil)   )
      (out (:to *query-io*) " slot !_(" (type-pname ty) 1 slot ")"
	      :% "Either type RETURN '<exp to use in place of (!_ ...)>,"
	      :% "or fix the type (with AUGTYPE) and type OK, "
	      :% "or type RETURN '(<intended-type> <intended-slot>)")
      (!= r (progn (signal-problem "DECL OR FUNC OR PROC" :continue) '*ok))
    :while (or (eq r '*ok)
	      (and (consp r) (is-type-desig (car r))))
    else :result `(,r *abort nil nil)
      (cond ((not (eq r '*ok))
	     (!= ty (car r))
	     (!= slot (cadr r))
	     (cond ((and (symbolp exp) (not (var-lookup exp vartypes*)))
		    (declare-on-fly exp ty))   ))   )))

(defun declare-on-fly (var ty)
   (!= vartypes* (cons (make-Vartype var ty '*noalloc nil)
		       *-*))   )

(defvar defining* nil)     (defvar expstack* nil)

;; Make following error message more useful
(defun defining-info ()
   (cond (defining*
	  (out (:to *query-io*)
               :% "While defining " defining* :% "-- compiling "))
	 (expstack*
	  (out (:to *query-io*) :% "While compiling " ))   )
   (expstack-short expstack*)
   (out (:to *query-io*) " --" :%)   )

(defun expstack-short (stack)
   (pdclstack (cond ((atom (car stack)) 2) (t 1)   ))   )
	  

;; Debugging aid-- (DCLSTACK [n 3]) prints out current stack of
;; expressions being massaged by DCL.
(defun dclstack (&rest a)
   (cond (defining* (out (:to *query-io*) "While defining " defining* " --" :%))   )
   (pdclstack (cond ((null a) 3) (t (car a))   ))
   (out (:to *query-io*) :%)
   (len expstack*)   )

(defun pdclstack (n)
      (repeat :for ((x (showdclstack (reverse (cond ((> (len expstack*) n)
						  (take n expstack*))
						 (t expstack*)   )))))
	 (out (:to *query-io*) (:pp (car x)))
	 (!= x (cdr x))
       :while x
	 (out (:to *query-io*) :%)   ))

(defvar found* nil)

(defun showdclstack (rstack)
   (bind ((found* nil))
      (cond ((cdr rstack)
	     (let ((e (showdclsubst (car rstack) (cdr rstack))))
		(cond ((not found*)
		       (list (car rstack) '\?>*
			     (showdclstack (cdr rstack))))
		      (t (list e))   )))
	    (t (list (showdclsubst (car rstack) (list (list nil)))))   )))

(defun showdclsubst (e rstack)
   (cond ((eq e (car rstack))
	  (!= found* t)
	  (cons '*>* (showdclstack rstack)))
	 ((atom e) e)
	 ((eq (car e) '*typequote)
	  (Type-desig (cadr e)))
	 ((eq (car e) '*dc)
	  (showdclsubst (Dclcmp-exp (cadr e)) rstack))
	 (t (cons (showdclsubst (car e) rstack)
		  (showdclsubst (cdr e) rstack)))   ))

(defvar type-check* 'barf)

(defun wrong-type (exp source-type dest-type)
   (cond (type-check*
	  (defining-info)
	  (out (:to *query-io*)
	    (:pp-block (:pp-ind :block 3)
		       "Expression " exp
		       1 (:pp-nl :fill)
		       "cannot be coerced from "
		       1 (:pp-nl :fill)
		       (type-pname source-type)
		       1 (:pp-nl :fill)
		       "to " (type-pname dest-type) :%))
	  (cond ((eq type-check* 'barf)
		 (let ((r (signal-problem decl 
			      (:prompt-for "Correct coercion (default *)> "
			       '*ok))))
		    (cond ((eq r '*ok)
			   (make-Dclcmp source-type exp))
			  (t (decl-compile r dest-type))   )))
		(t (make-Dclcmp source-type exp))   ))
	 (t (make-Dclcmp source-type exp))   ))  ; A case could be made for DEST-TYPE

(defun wna-msg (which exp)
   (cond (type-check*
          (defining-info)
          (out (:to *error-output*) (:q ((eq which 'toomany) "Too many")
                                (t "Too few")   )
                             " arguments in " exp :%)
          (cond ((eq type-check* 'barf)
                 (signal-problem type-checker :continue
                    "If you proceed, a run-time error will probably occur"))
		(t nil)))
	 (t nil)))
