;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: dclmacs.lisp,v 2.12 2006/05/16 14:34:48 dvm Exp $

;;; Copyright 1988 - 2005, Drew McDermott, Yale University

(depends-on %module/ ytools %ytools/ nilscompat)
(depends-on :at-run-time %ydecl/ typvarsyn types dclchk hostypes)   ;LISTYPE

(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(decl deffunc defopfunc defopproc defproc specdecl
	     declare-func declare-proc)))

;; VARTYPES* is a list of symbols and their associated types
(declaim (special vartypes* defining*))

(defmacro decl (&rest exp) (Dclcmp-exp (dcl-expand `(decl ,@exp) nil)))

;; 11.Nov.87 Changed
(defmacro with-declarations (vars types &body body)
   `(let ((local-vartypes (<# (\\ (v ty) (initvartype v ty '*noinit))
			      ,vars ,types)))
      (bind ((vartypes* (append local-vartypes vartypes*)))
	  ,@body)))

(defmacro with-vartypes (vartypes &body body)
   `(let ((local-vartypes ,vartypes))
       (bind ((vartypes* (append local-vartypes vartypes*)))
          ,@body)))

(defmacro var-setups () `(<$ Vartype-setups local-vartypes))

(defmacro var-declarations ()
   `(vartypes-declarations local-vartypes))

(defun dcl-expand (exp source-type)
   (bind ((vartypes* vartypes*))
     (let (bvars body)
      (cond ((is-type-desig (cadr exp))
	     (cond (source-type
		    (signal-problem decl :continue
		       "Body type specified redundantly in " exp)))
             (!= source-type (cadr exp))
             (!= bvars (caddr exp))
             (!= body (cdddr exp)))
            (t
             (!= bvars (cadr exp))
             (!= body (cddr exp))))
      (with-vartypes (bvars-vartypes nil bvars nil)
	 (!= body (body-compile *-* source-type))
	 (make-Dclcmp (Dclcmp-typ body)
		      `(let ,(vartypes-bvars local-vartypes)
			  ,@(var-declarations)
			  ,@(var-setups)
			  ,@(Dclcmp-exp body)))))))

(datafun :slurp-macros deffunc #'slurp-ignore)
(datafun :slurp-macros defproc #'slurp-ignore)
(datafun :slurp-macros defopfunc #'slurp-ignore)
(datafun :slurp-macros defopproc #'slurp-ignore)
(datafun :slurp-macros declare-func #'slurp-ignore)
(datafun :slurp-macros declare-proc #'slurp-ignore)

(defmacro deffunc (&rest def) (func-expand def nil nil))
(defmacro defproc (&rest def) (func-expand def t nil))
(defmacro defopfunc (&rest def) (func-expand def nil t))
(defmacro defopproc (&rest def) (func-expand def t t))

; Handy macro for declaring the types of existing functions in a pleasing way:
; Works for operations as well as ordinary function
(defmacro declare-func (&rest defin)
   (multiple-value-let (name argl ft body)
                       (funclause-analyze defin)
      (ignore argl body)
      `(typedecl ',name
		 ,(type-loader (Type-desig ft) false)
		 '*fundef)))

(defmacro declare-proc (&rest defin)
   (multiple-value-let (name argl ft body)
                       (funclause-analyze defin)
      (ignore argl body)
      (!= (type-feature ft 'side-effects) true)
      `(typedecl ',name
		 ,(type-loader (nisp::Type-desig ft) false)
		 '*fundef)))

(defun func-expand (defin se-sw op-sw)
   (multi-let (((name argl ft body)
                (funclause-analyze defin)))
      (func-expand-expansion name se-sw op-sw argl ft body)))

(defun func-expand-expansion (name se-sw op-sw argl ft body)
	   `(progn
	      ,@(cond (op-sw '())
		      (t
		       (type-proclaimer name 
			       (designated-type   
				   `(Fun ,(Type-desig (fun-resulttype ft))
					 ,(argtype-desigs (fun-argtypes ft))
					 ,se-sw))
			       '*fundef)))
	      (nisp-define
	       ,(cond (op-sw 'def-op) (t 'defun)) ,name ,argl ,ft
	       ,@body)))

(defmacro nisp-define (definer name argl funtype &body body)
   (cond ((and (null body) (eq definer 'def-op))
	  `(,definer ,name ,argl))
	 (t
	  `(,definer ,name ,argl ,@(fundecl-expand argl funtype false body name)))))
	  
(datafun :slurp-macros nisp-define
   (defun :^ (_ _)
      false))

(def-file-segment dclmacs-nt-slurpers-1 (nisp-types-handlers)

 (datafun :slurp-nisp-types nisp-define
    (defun :^ (_ _)
       false))

)

(defun fundecl-expand (argl funtype resulttype body name)
   (cond ((not resulttype)
          (!= resulttype (fun-resulttype funtype))))
   (bind ((defining* (or name defining*)))
      (with-vartypes (atypes-vartypes argl (fun-argtypes funtype))
	 (let ((b (body-compile-exp body resulttype)))
	    (multiple-value-let (d b) (declarations-separate b)
	       `(,@(var-declarations) ,@d ,@(var-setups) ,@b))))))

(defmacro in-order-to-define (name macroform)
   (bind ((defining* name))
      (macroexpand-1 macroform)))

(def-file-segment dclmacs-nt-slurpers-2 (nisp-types-handlers)

 (datafun :slurp-nisp-types specdecl
   (defun :^ (sd _)
      (multiple-value-let (vars types)
			  (types-separate (cdr sd) '(alloc noalloc) nil)
	(repeat :for ((vv :in vars) (tt :in types))
	   (let ((var (match-cond vv
			 ((symbolp vv) vv)
			 (:? (be ?_ ?v) v)
			 (:? (?v ?_) v)
			 (t (signal-problem specdecl-slurp-nisp-types :fatal
			       "Unrecognized binding " vv))))
		 (ty (cond ((null tt) univ-type*)
				 ;--no type declaration for VV
			   (t (type-or-desig tt)))))
 ;;;;	    (out (:to *query-io*)
 ;;;;		 "Declaring " var " to be of type " ty :%)
	      (cond ((and (or (not (is-Funtype ty))
                              (car-eq vv var))
                          (not (eq (symbol-package var)
                                   lisp-package*)))
		     (proclaim `(special ,var))))
	      (!= (prop 'type var) ty))))
     false))
)

;;; Ignore when slurping macros --
(datafun :slurp-macros specdecl
   (defun :^ (_ _)
      false))

(defmacro specdecl (&rest decls)
   (let ((vtl (bvars-vartypes nil decls nil)))
      `(progn
            ,@(<! (\\ (vt)
		     (let ((var (Vartype-var vt))
			   (typ (Vartype-typ vt))
			   (init (Vartype-initial vt)))
		       `(,@(include-if 
				(not (eq init '*noalloc))
				`(defvar ,var ,init))
                         ,@(include-if
				(and (eq init '*noalloc)
				     (not (is-Funtype typ))
                                     (not (eq (symbol-package var)
                                              lisp-package*)))
				`(declaim (special ,var)))
			  ;; 8.25.87: TYP below was (AND TYP (TYPE-DESIG TYP))
                         ,@(type-proclaimer var typ init))))
                  vtl)
            ,@(<$ Vartype-setups vtl))))

(defvar allow-ftype* true)
(defvar allow-builtin-ftype* #+sbcl false #-sbcl true)

(defun type-proclaimer (var typ init)
   `((typedecl ',var 
	       ,(cond (typ (type-loader (Type-desig typ) nil))
		      (t ''Obj))
	       ',init)
     ,@(include-if (and (not (macro-function var))
			(not (special-operator-p var))
                        (not (eq (symbol-package var)
                                 lisp-package*)))
	  (cond ((and (memq init '(*noalloc *fundef))
		      (is-Funtype typ))
		 `(if allow-ftype*
		      (declaim (#+:lucid lcl:restrictive-ftype
				  #-:lucid ftype
				  ,(nisp-funtype->cl typ)
				  ,var))))
		(t
		 `(declaim (type ,(nisp->hostype typ) ,var)))))))

(defun bvars-vartypes (bindtype bvars alloc-sw)
   (ignore bindtype)
   (let-fun (

 (getem (bvars bindtypes alloc-sw)
   (cond ((null bvars) nil)
         ((memq (car bvars) '(alloc noalloc))
          (getem (cdr bvars) (cdr bindtypes) (eq (car bvars) 'alloc)))
         (t
          ; (CAR BVARS) is a variable binding, either var or (var val).
          (let (var initial vtype forward)
             (cond ((atom (car bvars))
                    (!= var (car bvars))
                    (!= initial '*noinit))
                   (t (!= var (caar bvars))
                      (!= initial (lastelt (car bvars)))))
             (!= vtype (car bindtypes))
	     (!= forward (is-Forward-defined vtype))
             (cons (cond ((and forward alloc-sw)
			  (defining-info)
			  (signal-problem bvars-vartypes 
				"Attempt to bind variable " var " of type " vtype
				", which is not yet defined."
				(:continue "If continued, it will be bound to ()"))
			  (make-Vartype var vtype 'nil nil))
                         (t
			  (initvartype var vtype 
				       (cond ((or alloc-sw 
						  (not (eq initial '*noinit)))
					      initial)
					     (t '*noalloc)))))
                   (getem (cdr bvars) (cdr bindtypes) alloc-sw))))))
)
      (multiple-value-let (vars types)
                          (types-separate bvars '(alloc noalloc) nil)
         (getem vars types alloc-sw))))


;;; --Drew 88.1.21
(defun initvartype (var vtype initial)
   (let ((adc (cond ((not (memq initial '(*noalloc *noinit))) 
		     (decl-compile initial vtype))
		    (t nil))))
     (make-Vartype var 
		   (or vtype 
		       (cond (adc 
			      (let ((ty (Dclcmp-typ adc)))
				 (cond ((eq (Type-desig ty) 'Null)
					'Obj)
				       (t ty))))
			     (t 'Obj)))
		   (cond (adc (Dclcmp-exp adc)) 
			 (t initial))
                   nil)))

; ;; Changed 3.21.88
; (DEFUN INITVARTYPE (VAR VTYPE INITIAL)
;    (LET ((ADC (COND ((NOT (MEMQ INITIAL '(*NOALLOC *NOINIT))) 
; 		     (DECL-COMPILE INITIAL VTYPE))
; 		    (T NIL))))
;      (make-Vartype VAR 
; 		   (OR VTYPE 
; 		       (COND ((AND ADC (NOT (MEMQ INITIAL '(NIL ())))) 
; 			      (Dclcmp-typ ADC))
; 			     (T 'Obj)))
; 		   (COND (ADC (Dclcmp-exp ADC)) 
; 			 (T INITIAL))
;                    NIL)))

(defun compile-to-notype (exp) (decl-compile-exp exp nil))

(defun decl-compile-exp (e dt) (Dclcmp-exp (decl-compile e dt)))

(defun body-compile-exp (body dest-type)
   (Dclcmp-exp (body-compile body dest-type)))

;; 87.9.28: Changed
(defun body-compile (body dest-type)
   (cond ((null body)
	  (defining-info)
	  (signal-problem body-compile :continue "Empty body")
	  (make-Dclcmp 'Obj nil))
	 (t
	  (let ((lastdc (decl-compile  (lastelt body) dest-type)))
	     (make-Dclcmp (Dclcmp-typ lastdc)
		   (nconc (<! (\\ (x)
				 (cond ((and (not (atom x)) (eq (car x) '\;))
					nil)
				       (t
					(list (decl-compile-exp x 'Void)))))
			      (drop -1 body))
			  (list (Dclcmp-exp lastdc))))))))

;; Stack of things being compiled

(defvar undecl-var-trap* false)

;;; Make a (the ty e) form for every nontrivial type discovered.
(defvar expose-the-types* true)

(datafun-from-plist decl-compl)
;;;; (datafun attach-datafun decl-compl #'yt::datafun-on-plist)

(defvar type-check*)

;; DECL-COMPILE is the data-driven main loop of DECL.  If a form's CAR
;; atom has a DECL-COMPL property, it is a
;; function to be used for two things: translating the form to a destination
;; type, and figuring out what the type is to begin with.  So this function
;; must take two args: the form and the destination type.  It returns a
;; "dclcmp,"
;; a list (type exp).  In addition to looking on the CAR symbol, DECL-COMPILE
;; also looks for a DECL-COMPL feature on the type of the CAR expression.
;; ** added Common Lisp clause to catch keywords. --Denys 7/21/89
(defun decl-compile (exp dest-type)
;;;;   (cond ((eq exp 'optop::old-potential-processes)
;;;;	  (dbg-save dest-type)
;;;;	  (breakpoint decl-compile
;;;;	     "Compiling to " dest-type)))
;;;;   (out "vartypes* = " vartypes* :%)
;;;;(trace-around decl-compile
;;;;   (:> "(decl-compile: " exp 1 " -> " dest-type 1 vartypes*")")
   (bind ((expstack* (cons exp expstack*)))
      (maybe-wrap-the
	 (cond ((atom exp)
		;;;;(out "undecl-var-trap* = " undecl-var-trap* :%)
		(cond ;((EQ EXP 'NIL)
		      ; (TYPE-TRANS EXP 'void DEST-TYPE))
		      ((keywordp exp)
		       (type-trans exp 'Symbol dest-type))
		      ((and (or defining* undecl-var-trap*)
			    type-check*
			    exp (symbolp exp)
			    (not (or (var-lookup exp vartypes*)
				     (prop 'type exp))))
;;;;		       (out "Looking for undecl-var-trap" :%)
		       (or (and undecl-var-trap*
				(let ((dc (funcall undecl-var-trap* exp)))
;;;;				   (cond (dc
;;;;					  (out "Got " dc :%)))
				   (and dc
					(type-trans
					   (Dclcmp-exp dc)
					   (Dclcmp-typ dc)
					   dest-type))))
			   (progn
			      (cond (defining* (defining-info)))
			      (out (:to *error-output*)
				       :% " undeclared or mistyped free"
					 " variable " exp :%)
			      (cond ((eq type-check* 'barf)
				     (ask-user-about-undecl-var exp dest-type))
				    (t
				     (declare-on-fly exp 'Obj)
				     (type-trans exp 'Obj dest-type))))))
		      (t
		       (let ((dc (type-trans exp (atomtype exp) dest-type)))
   ;;;;		       (cond (optop::break-again*
   ;;;;			      (dbg-save dc)
   ;;;;			      (breakpoint decl-compile
   ;;;;				 "dc = " dc)))
			  dc))))
	       (t (l-decl-compile exp dest-type)))
         false
         dest-type))
;;;;   (:< (val &rest _) "decl-compile: " val))
)

(defun maybe-wrap-the (dc the-type dest-type)
   (let ((typ (or the-type (Dclcmp-typ dc)))
         (exp (Dclcmp-exp dc)))
      (cond ((and expose-the-types*
		  (not (atom exp))
		  (not (eq (car exp) 'lambda))
		  (not (subtype univ-type* typ false))
                  (or (not dest-type)
                      (not (subtype dest-type void-type* false))))
	     (let ((hostype (nisp->hostype typ)))
		(cond ((or (memq hostype '(t nil))
			   (car-eq hostype 'function)
			   (matchq (the ?,hostype ?_)
				   exp)
                           ;;;; Workaround for bug in cmucl
;;;;                           #+cmu (matchq (values ?@_) hostype)
                           )
		       dc)
		      (t (make-Dclcmp typ
				      `(the ,hostype ,exp))))))
	    (t dc))))

(defun ask-user-about-undecl-var (exp dest-type)
   (let ((new
          (signal-problem decl-compile
	     (:prompt-for "symbol to use instead, or type to declare it with"
                          :% " (default: Obj, unless you declare it in the"
                             "  break loop"
                     '*try-again))))
      (cond ((is-type-desig new)
             (let ((ty (type-or-desig new)))
                (declare-on-fly exp ty)
                (type-trans exp ty dest-type)))
            ((eq new '*try-again)
             (cond ((not (or (var-lookup exp vartypes*) (prop 'type exp)))
                    (declare-on-fly exp 'Obj)))
             (decl-compile exp dest-type))
            (t (decl-compile new dest-type)))))


;; Version for something found in functional position.
(defun fun-decl-compile (fcn dest-type)
   (bind ((expstack* (cons fcn expstack*)))
      (cond ((atom fcn)
             (type-trans fcn (atomtype fcn) dest-type))
            (t (l-decl-compile fcn dest-type)))))
;; Could given an undefined function message, if there were a way to
;; suppress it for CAR, CONS, etc.

;;;-must do something special for explicit lambdas found in functional
;;;-position: must determine the types of the formal parameters from the
;;;-types of the actual parameters.

(defun l-decl-compile (exp dest-type)
  (cond ((and (symbolp (car exp)) (prop 'decl-compl (car exp)))
	 (funcall (prop 'decl-compl (car exp)) exp dest-type))
	((and (symbolp (car exp))
	      (macro-function (car exp)))
	 (decl-compile (macroexpand-1 exp) dest-type))
	((and (symbolp (car exp)) (special-operator-p (car exp)))
	 (make-Dclcmp 'Obj exp))
	(t
	 (multiple-value-let (explicit-lambda bvars body rtype)
			     (funarg-analyze `(function ,(car exp)))
            (cond ((and explicit-lambda (not (types-in-arglist bvars)))
		   (explicit-lambda-call-compile bvars body exp
						 rtype dest-type))
		  (t (let ((fundc (fun-decl-compile (car exp) nil))
			   funty compilefn)
			(!= funty (Dclcmp-typ fundc))
			(!= compilefn (type-feature funty 'decl-compl))
			(cond (compilefn
			       (funcall compilefn funty (Dclcmp-exp fundc)
					exp dest-type))
			      ((consp (car exp))
			       (funcall-decl-compile
				   fundc 'funcall (cdr exp) exp dest-type))
			      ((is-Funtype funty)
			       (form-decl-compile 
				  funty (Dclcmp-exp fundc) exp dest-type))
			      (t
			       (type-trans
				`(,(Dclcmp-exp fundc)
				   ,@(<# compile-to-notype (cdr exp)))
				'Obj dest-type))))))))))

(defun explicit-lambda-call-compile (bvars body exp rtype dest-type)
   (let ((actual-dcl (<# (\\ (a) (decl-compile a nil)) 
			 (cdr exp)))
	 (typel nil) atypes)
      (!= atypes (<# Dclcmp-typ actual-dcl))
      (repeat :for ((v :in bvars) (atypes atypes))
       :result (cond (atypes (wna-msg 'toomany exp)))
       :until (eq v '&rest)
       :result (!= typel (nconc *-* 
			       (list 'dot (</ common-supertype 
					      void-type* atypes))))
       :while atypes
       :result (wna-msg 'toofew exp)
         (!= typel (nconc *-* (list (car atypes))))
	 (!= atypes (cdr *-*)))
      (let ((fundc (explicit-lambda-compile
		      (or rtype univ-type*) bvars typel body exp))
	    compilefn funty)
	 ;; FUNDC is dclcmp <funtype, (FUNCTION (LAMBDA ...))>
	 (!= funty (Dclcmp-typ fundc))
	 (!= compilefn (type-feature funty 'decl-compl))
	 (cond (compilefn
		(funcall compilefn funty (unfquot (Dclcmp-exp fundc))  
			           exp dest-type))
	       (t
		(type-trans `(,(unfquot (Dclcmp-exp fundc))
			      ,@(<# Dclcmp-exp actual-dcl))
			    (fun-resulttype (Dclcmp-typ fundc)) 
			    dest-type))))))


;; 87.9.28: Moved EXPLICIT-LAMBDA-COMPILE from MGCDCL
(defun explicit-lambda-compile (rtype bvars atypes body exp)
   (let ((argvartypes 
	    (explicit-lambda-vartypes bvars atypes exp)))
      (with-vartypes argvartypes 
	 (!= body 
	      (body-compile body (or rtype univ-type*)))
	 (make-Dclcmp (make-Funtype (Dclcmp-typ body) atypes nil)
		      `#'(lambda ,bvars 
			    ,@(var-setups)
			    ,@(Dclcmp-exp body))))))


;;; Used for both explicit and implicit funcalls.
;;; 'fcn' is usually 'funcall' itself.
(defun funcall-decl-compile (fdc fcn args exp dest-type)
      (cond ((is-Funtype (Dclcmp-typ fdc))
	     (let ((ft (Dclcmp-typ fdc)))
	       (type-trans
		`(,fcn ,(Dclcmp-exp fdc)
                       ,@(coerce-args args
                                      (fun-argtypes ft)
                                      exp))
		(fun-resulttype ft)
		dest-type)))
	    (t (let ((adcl (<# (\\ (a) (decl-compile a nil)) args)))
		 (let ((fdc2 (type-trans (Dclcmp-exp fdc)
					 (Dclcmp-typ fdc)
					 (make-Funtype (or dest-type 'Obj)
						       (<# Dclcmp-typ adcl)
						       false))))
		   (make-Dclcmp (if (is-Funtype (Dclcmp-typ fdc2))
				    (fun-resulttype (Dclcmp-typ fdc2))
				    'Obj)
				`(,fcn ,(Dclcmp-exp fdc2)
                                       ,@(<# Dclcmp-exp adcl))))))))

(defun form-decl-compile (ft fcn e dest-type)
   (multiple-value-let (args tsub)
                       (matchargs (cdr e) (fun-argtypes ft) e nil)
      (type-trans
         `(,fcn  ,@(<# Dclcmp-exp args))
         (type-subst tsub (fun-resulttype ft))
         dest-type)))

(defun coerce-args (args types exp)
   (<# Dclcmp-exp (one-value (matchargs args types exp nil))))

;; Compile each to the appropriate types.  Return compiled args and
;; substitution showing bindings of typevars (if any) from designators
;; of TYPES.
(defun matchargs (args types exp tsub)
   (cond (args
          (cond ((null types)
                 (wna-msg 'toomany exp)
                 (values (<# (\\ (a) (decl-compile a nil))
			     args) tsub))
                ((eq (car types) 'dot)
                 (multiple-value-let (a s)
                                     (match-arg-to-type (car args)
                                                        (cadr types)
                                                        tsub)
                    (multiple-value-let (r s)
                                        (matchargs (cdr args) types exp s)
                       (values (cons a r) s))))
                (t
                 (multiple-value-let (a s)
                                     (match-arg-to-type (car args)
                                                        (car types)
                                                        tsub)
                    (multiple-value-let (r s)
                                        (matchargs (cdr args) (cdr types)
                                                   exp s)
                       (values (cons a r) s))))))
         (t
          (cond ((and types (not (eq (car types) 'dot)))
                 (wna-msg 'toofew exp)))
          (values nil tsub))))

(defun match-arg-to-type (a ty sub)
   (let ((dc (decl-compile a ty)))
      (values dc
              (type-match ty (Dclcmp-typ dc) sub))))

;; Match two types.  If the match fails, c'est la vie; this is just
;; a hackish convenience.  Return a substitution of the form
;; (typevar type).
;; "Match" is perhaps the wrong word here.  We already know that
;; T2 is a subtype of T1 (or at least acceptable).  All we want to
;; know is, if T1 is, e.g., (LST (*TYPEVAR E)), what does E stand for?
;; The assumed answer is, since (*TYPEVAR E) occurs as the ELTYPE
;; feature of T1, E must be the ELTYPE of T2.  No claim is made that
;; this works in general, but this is all a secret anyway.
(defun type-match (t1 t2 sub)
   (let-fun ((contains-typevars (x)
                (and (not (atom x))
                     (or (eq (car x) '*Typevar)
                         (contains-typevars (car x))
                         (contains-typevars (cdr x)))))
             (explore-type-features (t1 t2 sub)
		(cond ((car-eq (Type-desig t1) '*Typevar)
		       (!= sub (aug-sub (cadr (Type-desig t1)) t2 *-*))
		       (cond ((cddr (Type-desig t1))
			      (explore-type-features (Type-super t1) t2 sub))
			     (t sub)))
		      (t
		       (repeat :for ((feat :in (Type-features t1)) ft1 ft2)
			  (!= ft1 (cadr feat))
			  (cond ((is-Type ft1)
				 (!= ft2 (type-feature t2 (car feat)))
				 (cond ((and ft2 (is-Type ft2))
					(!= sub
					    (explore-type-features
					        ft1 ft2 *-*))))))
			:result sub))))
             (aug-sub (v ty sub)
                (let ((p (assq v sub)))
                   (cond (p
                          (!= (cadr p) (common-supertype *-* ty))
                          sub)
                         (t (cons (list v ty) sub)))))
)
       (cond ((contains-typevars (Type-desig t1))
              (explore-type-features t1 t2 sub))
             (t sub))))

;; Substitute bogus types in.
(defun type-subst (tsub type)
   (cond (tsub
          (let-fun ((dosubst (tdes)
                       (cond ((atom tdes) tdes)
                             ((eq (car tdes) '*Typevar)
                              (let ((p (assq (cadr tdes) tsub)))
                                 (cond (p
                                        (Type-desig (cadr p)))
                                       (t 'Obj))))
                             (t
                              (cons (dosubst (car tdes))
                                    (dosubst (cdr tdes)))))))
               (designated-type
                  (dosubst (Type-desig type)))))
         (t type)))

(defun explicit-lambda-vartypes (bvars atypes exp)
   (cond (bvars
          (cond ((null atypes) (wna-msg 'toofew exp))
                ((eq (car atypes) 'dot)
                 (cons (initvartype (car bvars) (cadr atypes) '*noalloc)
                       (explicit-lambda-vartypes (cdr bvars) atypes exp)))
                (t
                 (cons (initvartype (car bvars) (car atypes) '*noalloc)
                       (explicit-lambda-vartypes (cdr bvars) (cdr atypes)
                                                 exp)))))
         ((and atypes (not (eq (car atypes) 'dot)))
          (wna-msg 'toomany exp))
         (t nil)))

;; The system tries hard to look at every subexpression only once.  Occasionally
;; this gets difficult, as when it needs to look at E once to find out its
;; type, and then again as part of some larger expression.  The solution is
;; to transform E into (*DC [dclcmp: typ compiled-version]).  Then anyone
;; looking at it can immediately extract the compiled-version without
;; looking at it again.
(datafun decl-compl *dc
   (defun (exp dest-type)
      (type-trans (Dclcmp-exp (cadr exp))
                  (Dclcmp-typ (cadr exp))
                  dest-type)))

;; *DCs seen outside of DECLs must just go away
(defmacro *dc (dc)
  ;; Wait a minute -- how could we ever see one outside a DECL?
  (out (:to *error-output*)
       :% "Wait a minute -- how can I be seeing a *DC outside a DECL?" 
       :% 5 dc :%)
  (Dclcmp-exp dc))

;; Given a clause of the form (name -declified-fundef-), return values
;; <name args funtype body>
;; Various deviant syntaxes are permissible.
;; (name - type [-] (-types-n-vars-) ...)
;; (name type (-types-n-vars-) ...)
;; (name (-types-n-vars-) - type [-] ...)
;; or even (type name (-types-n-vars-) ...)
(defun funclause-analyze (c)
   (multiple-value-let (name type args body) (funclause-dissect c)
      (multiple-value-let (vars types argl declist)
			  (types-vars-analyze args)
	 (declare (ignore vars declist))
	 (multiple-value-let (argl body)
			     (ignore-smooth argl body)
	    (values name argl (make-Funtype (type-or-desig type)
					    (designated-argtypes types)
					    nil)
			      body)))))

(defun funarg-analyze (a)
      (repeat :for (bvars body rtype)   ; LAM
	 ;can't win on this, so leave out: (IGNORE LAM)
	 (!= a (unfquot a))
       :until (matchq (?(:\| \\ lambda) ?@_) a)
       :result (progn
		 (!= < _ rtype bvars body > (funclause-dissect a))
;;;;		 (dbg-save bvars body)
;;;;		 (breakpoint funarg-analyze
;;;;		    "Ready with " bvars 1 body)
		 (!= < bvars body > (ignore-smooth bvars body))
		 (values true bvars body rtype))
       :while (and (is-Pair a)
		   (is-Symbol (car a))
		   (fboundp (car a))
		   (macro-function (car a)))
	 (!= a (macroexpand-1 a))
       :result (values false nil nil nil)))

(defun funclause-dissect (c)
   (let (name type args body)
      (or (matchq (?name - ?type - ?args ?@body) c)
	  (matchq (?name - ?type ?args ?@body) c)
	  (matchq (?name ?args - ?type - ?@body) c)
	  (matchq (?name ?args - ?type ?@body) c)
	  (cond ((matchq (?name ?type ?args ?@body) c)
		 (or (is-type-desig type)
		     (cond ((is-type-desig name)
			    (switch name type))
			   ((or (null type) (consp type))
			    (!= body (cons args *-*))
			    (!= args type)
			    (!= type 'Obj))
			   (t
			    (signal-problem funclause-analyze :continue
			       "Undefined result type in function definition: "
			       c)))))
		((matchq (?name ?args ?@body) c)
		 (!= type 'Obj))
		(t
		 (signal-problem funclause-dissect :continue
		    "Illegal function definition: " c))))
	(cond ((and args (not (is-Pair args)))  ;was (OR (NOT (is-Symbol NAME)) ...)
	       (signal-problem funclause-dissect :continue
		  "Illegal function definition: " c)))
	(values name type args body)))

(defun atypes-vartypes (args atypes)
   (cond ((null args)
	  (cond ((null atypes) nil)
		(t (signal-problem atypes-vartypes :continue "Inconsistent")
		   nil)))
	 ((null atypes)
	  (signal-problem atypes-vartypes :continue "Inconsistent")
	  nil)
	 ((eq (car args) '&rest)
	  (cond ((eq (car atypes) 'dot)
		 (list (make-Vartype (cadr args) (lstype (cadr atypes))
						;; LISTYPE must be loaded.
				     '*noinit nil)))
		(t (signal-problem atypes-vartypes :continue "Inconsistent")
		   nil)))
	 ((eq (car atypes) 'dot)
	  (signal-problem atypes-vartypes :continue "Inconsistent")
	  nil)
	 ((eq (car args) '_)
	  (atypes-vartypes (cdr args) (cdr atypes)))
	 (t (cons (make-Vartype (car args) (car atypes) '*noinit nil)
		  (atypes-vartypes (cdr args) (cdr atypes))))))

;; 87.9.28: Changed
(defun vartypes-declarations (vartypes)
	  (let ((decls
		  (repeat :for (vt :in vartypes)
		     :nconc
			  (cond ((or (eq (Vartype-initial vt) '*noalloc)
				     (eq (Vartype-typ vt) 'nil))
				 !())
				(t
				 (let ((ht (nisp->hostype 
					      (Vartype-typ vt))))
				    (cond ((eq ht 't) !())
					  (t 
					   (list `(type ,ht
							,(Vartype-var 
							    vt)))))))
))))
	      (cond (decls `((declare ,@decls)))
		    (t nil))))

;; Here to end is support for LET* (not a released feature of NISP)
(defmacro decl* (&rest exp) (Dclcmp-exp (dcl*-expand `(decl* ,@exp) nil)))

(defun bvars-vartypes* (bindtype bvars alloc-sw)
  (ignore bindtype)
  (let-fun
      ((getem (bvars bindtypes alloc-sw)
	 (cond ((null bvars) nil)
	       ((memq (car bvars) '(alloc noalloc))
		(getem (cdr bvars) (cdr bindtypes) (eq (car bvars) 'alloc)))
	       (t
		;; (CAR BVARS) is a variable binding, either var or (var val).
		(let (var initial vtype forward)
		  (cond ((atom (car bvars))
			 (!= var (car bvars))
			 (!= initial '*noinit))
			(t (!= var (caar bvars))
			   (!= initial (lastelt (car bvars)))))
		  (!= vtype (car bindtypes))
		  (!= forward (is-Forward-defined vtype))
		  (let ((vt (cond ((and forward alloc-sw)
				   (defining-info)
				   (signal-problem bvars-vartypes* :continue
				     "Attempt to bind variable " var " of type " vtype
				     ", which is not yet defined."
				     :% "If continued, it will be bound to ()")
				   (make-Vartype var vtype 'nil nil))
				  (t
				   (initvartype var vtype 
						(cond ((or alloc-sw 
							   (not (eq initial '*noinit)))
						       initial)
						      (t '*noalloc)))))))
		    (cons vt
			  (with-vartypes (list vt)
					 (getem (cdr bvars) (cdr bindtypes) alloc-sw)))))))))
    (multiple-value-let (vars types)
	(types-separate bvars '(alloc noalloc) nil)
      (getem vars types alloc-sw))))

(defun dcl*-expand (exp source-type)
  (bind ((vartypes* vartypes*))
    (let (bvars body)
      (cond ((is-type-desig (cadr exp))
	     (cond (source-type
		    (signal-problem decl* :continue
		      "Body type specified redundantly in " exp)))
             (!= source-type (cadr exp))
             (!= bvars (caddr exp))
             (!= body (cdddr exp)))
            (t
             (!= bvars (cadr exp))
             (!= body (cddr exp))))
      (with-vartypes (bvars-vartypes* nil bvars nil)
		     (!= body (body-compile *-* source-type))
		     (make-Dclcmp (Dclcmp-typ body)
				  `(let* ,(vartypes-bvars local-vartypes)
				     ,@(var-declarations)
				     ,@(var-setups)
				     ,@(Dclcmp-exp body)))))))

(defun unfquot (ff)
   (cond ((atom ff) ff)
	 ((memq (car ff) '(function funktion quote)) 
	  (cadr ff))
	 (t ff))) 