;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: decl-debug-new.lisp,v 2.3 2006/11/20 04:45:19 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)

(depends-on :at-run-time %ytools/ debug)

(depends-on %module/ nisp)

(eval-when (:slurp-toplevel :load-toplevel)
   (import '(yt::absent-dbg-entry*
	     yt::Dbg-entry-label yt::Dbg-entry-object yt::Dbg-entry-type
	     yt::dbg-save-var-val-analyze yt::dbg-save-analyze yt::nth-dbg-entry
	     yt::ev-process))
   (export '(d =ty evd)))

(datafun decl-compl g
   (defun :^ (exp dest-type)
      (multi-let (((sym occno)
		   (cond ((null (cdr exp))
			  (values '* 0))
			 ((null (cddr exp))
			  (values (cadr exp) 0))
			 (t
			  (values (cadr exp) (caddr exp))))))
	 (let ((e (nth-dbg-entry dbg-stack* sym occno)))
	    (cond (e
		   (type-trans
		      exp
		      (cond ((Dbg-entry-type e)
			     (designated-type (Dbg-entry-type e)))
			    (t
			     'Obj))
		      dest-type))
		  (t
		   (signal-problem g-decl-compl
		      "No entry for " sym " [" occno "] on dbg-stack*")))))))

(datafun decl-compl dbg-save
   (defun :^ (exp dest-type)
      (multi-let (((pkg-name comp-loud run-loud vars-n-vals)
		   (dbg-save-analyze (cdr exp))))
         (type-trans
	    `(dbg-save
	        ,@(include-if pkg-name `(:package ,pkg-name))
		,@(include-if comp-loud ':comp-loud)
		,@(include-if run-loud ':run-loud)
		,@(repeat :for ((vv :in vars-n-vals))
		   :collect
		      (multi-let (((var val td)
				   (dbg-save-var-val-analyze vv)))
			 (let ((vdc (decl-compile val
						  (cond (td (designated-type
							      td))
							(t
							 'Obj)))))
			    `(,var
			      ,(Dclcmp-exp vdc)
			      ,(Type-desig (Dclcmp-typ vdc)))))))
	    void-type* dest-type))))
				    
(defmacro =ty (label &optional td (n 0))
   (cond ((null td)
	  (!= td label)
	  (!= label '*)))
   (cond ((not (is-type-desig td))
	  (out (:to *query-io*) "Not a type-designator: " td :%)))
   `(dbg-entry-type-change ',label ,n ',td))

(defun dbg-entry-type-change (label n td)
   (let ((e (nth-dbg-entry dbg-stack* label n)))
      (cond ((and e (not (eq e absent-dbg-entry*)))
	     (!= (Dbg-entry-type e) td))
	    (t "?"))))
	    
(defmacro evd (form &rest types-n-vars)
   `(ev (d ,form) ,@types-n-vars))

(defmacro d (&body b) `(decl () ,@b))

(declaim (special undecl-var-trap*))

(datafun ev-process decl
   (defun :^ (form types-n-vars)
;;;;      (trace-around decl-ev-process
;;;;         (:> "(decl-ev-process: " form ")")
;;;;      (cond ((null types-n-vars)
;;;;             (!= types-n-vars '(* - Obj))))
      (let-fun ()
         (multi-let (((vars type-desigs _)
                      (vars-types-separate types-n-vars)))
            (bind ((undecl-var-trap*
                      (\\ (v)
                         ;;;;(out "Calling undecl-var-trap on " v :%)
                         (let ((e (nth-dbg-entry dbg-stack* v 0)))
                            (cond (e (make-Dclcmp
                                        (dbg-entry-place-type e)
                                        `(g ,v)))
                                  (t false))))))
               (declare (special undecl-var-trap*))
               (let ((types (<# designated-type type-desigs)))
                  (let ((fdc (decl-compile form false
;;;;                                           (mlv-type types)
                                           )))
                     (let ((vals (values->list (eval (Dclcmp-exp fdc)))))
                        (let ((extra-vars
                                 (yt::extra-ev-labels vals vars)))
                           (cond ((not (null extra-vars))
                                  (!= vars `(,@*-* ,@extra-vars))
                                  (!= types `(,@*-* ,@(<# (\\ (_) 'Obj)
                                                          extra-vars))))))
;;;;                        (cond ((shorter vars (len vals))
;;;;                               (let ((tokel (series (- (len vals)
;;;;                                                       (len vars)))))
;;;;                                  (!= vars `(,@*-* ,@(<# (\\ (_) '_)
;;;;                                                         tokel)))
;;;;                                  (!= types `(,@*-* ,@(<# (\\ (_) 'Obj)
;;;;                                                          tokel))))))
                        (let ((inferred-types
                                 (mlv-component-types (Dclcmp-typ fdc))))
                           (cond ((shorter inferred-types (len types))
                                  (!= inferred-types
                                      (append *-* (drop (len inferred-type)
                                                        types)))))
                           (!= < vals types >
                               (repeat :for ((v :in vals)
                                             (got-type :in inferred-types)
                                             (want-type :in types)
                                             :collectors new-vals new-types)
                                :within
                                   (let ((tdc (type-trans `',v
                                                           got-type
                                                           want-type)))
                                      (:continue
                                       :collect (:into new-vals
                                                       (eval (Dclcmp-exp
                                                                tdc)))
                                       :collect (:into new-types
                                                       (Dclcmp-typ tdc))))
                                :result (values new-vals new-types)))
                           (values vals vars types)))))))

       :where

         (:def vars-types-separate (vtl)
             (cond ((null vtl)
                    (values !() !() 'Obj))
                   ((eq (car vtl) '-)
                    (multi-let (((rest-vars rest-types _)
                                 (vars-types-separate (cddr vtl))))
                       (values rest-vars rest-types (cadr vtl))))
                   (t
                    (multi-let (((rest-vars rest-types type)
                                 (vars-types-separate (cdr vtl))))
                       (values (cons (car vtl) rest-vars)
                               (cons type rest-types)
                               type))))))
;;;;         (:< (vals vars types) "decl-ev-process: " vals 1 vars 1 types))
      ))

(datafun ev-process d decl)
      
(defun dbg-entry-place-type (e)
   (let ((td (Dbg-entry-type e)))
      (cond ((null td)
	     (out (:to *query-io*)
		  "Warning: (g " (Dbg-entry-label e) ") has type nil"
		  :% " -- changing to Obj" :%)
	     (!= (Dbg-entry-type e) 'Obj)
	     'Obj)
	    ((is-type-desig td)
	     (designated-type td))
            ((is-Type td)
             td)
	    (t
	     (repeat 
	        (!= td
		    (signal-problem dbg-entry-place-type
		       "(g " (Dbg-entry-label e) ") has meaningless type"
		       :%  td
		       (:prompt-for "Correct type designator" :unspec)))
	      :until (is-type-desig td)
	         (out (:to *query-io*) "Type a replacement type designator"
		      :%)
	      :result (progn (!= (Dbg-entry-type e) td)
			     (designated-type td)))))))

(datafun decl-compl get-frame-args
   (defun :^ (gfa-exp dest-type)
      (multi-let (((vars tds _ _)
		   (types-vars-analyze (cdr gfa-exp))))
	 (type-trans
	    `(progn (get-frame-args ,@vars)
		    ,@(repeat :for ((v :in vars) (td :in tds))
		       :when (not (eq v '_))
		       :collect `(=ty ,v ,td)))
	    'Void dest-type))))

