;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: decl-trace.lisp,v 2.11 2006/11/13 00:46:59 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (import '(yt::trace-around)))

#+(and :allegro-version>= (:version>= 6 0))
   (cond ((and (find-package ':excl)
	       (href yt::ytools-logical-names-table*
		     'hacks))
	  (fload %hacks/ "ftrace")))

(depends-on %ytools/ tracearound)

(specdecl trace-around-level* - Fixnum)

(datafun decl-compl trace-around
   (defun :^ (exp dest-type)
      (match-cond exp
	 ?( (trace-around ?name ?@args)
	   (multi-let (((conds start-out forms end-vars end-out
			 _     _         _     _        _)
			(yt::trace-around-analyze name args)))

	      (multi-let (((_ end-args end-fntype _)
			   (funclause-analyze 
			      `(lambda ,end-vars ,@end-out))))
		 (let ((end-vartypes
			  (funtype-arg-vartypes
			     end-fntype end-args)))
		    (let ((cond-dc (and (not (null conds))
					(body-compile conds 'Boolean)))
			  (s-out-exps (out-dc start-out))
			  (forms-dc (body-compile forms dest-type))
			  (e-out-exps
			      (with-vartypes end-vartypes
				  (out-dc end-out))))
		       (type-trans
			  `(trace-around ,name
			      ,@(cond ((null conds) '())
				      (t `((:if ,@(Dclcmp-exp cond-dc)))))
			      (:> ,@s-out-exps)
			      ,@(Dclcmp-exp forms-dc)
			      (:< ,end-vars ,@e-out-exps))
			  (Dclcmp-typ forms-dc)
			  dest-type))))))
	 (t
	  (signal-problem trace-around :fatal
	     "Ill-formed: " exp)))))

(defun funtype-arg-vartypes (funty args)
   (let ((vtl !()))
      (repeat :for ((typl (fun-argtypes funty) :then (cdr typl))
		    (argl args :then (cdr argl))
		    typ arg)
       :until (null typl)
       :result (values)
	 (!= typ (car typl))
	 (!= arg (car argl))
       :until (eq arg '&rest)
	 (!= vtl (cons (make-Vartype arg typ 'nil nil) *-*))
       :when :result
	 (!= vtl (cons (make-Vartype (cadr argl) (lstype (cadr typl)) 'nil nil)
		       *-*)))
      vtl))
