;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: deftyp.lisp,v 2.11 2005/12/26 03:28:53 dvm Exp $

;;;NISP Data type definitions
;;; Copyright (C) 1988 - 2002, Drew McDermott, Yale University 

(depends-on %module/ ytools %ytools/ nilscompat)
(depends-on :at-run-time %ydecl/ dclmacs)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(access all augtype both conser defnisptype forward *integrable
	     nispdeftype)))

(declaim (special now-loading* now-compiling* defining*))
  
(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(^^)))

;; What's tricky here:
;; Conceptually there are three phases that a Nisp file must undergo:
;; slurping, compiling, and loading.
;; As far as DEFTYPE is concerned, what must happen at each phase is
;; as follows--
;;   Slurping: Set up type structure and declarations.
;;   Compiling:  Type structure and declarations must already be set up.
;;      Compile auxiliary functions.
;;   Loading: Set up type structure and load functions

;; But the three phases can be scrambled up--
;;   Typing at terminal (or loading JJ file): slurping, compiling, and
;;      loading happen all at once
;;   Loading source file: slurping happens, then compiling and loading
;;   Compiling & loading file: slurping happens, then compiling; later loading

;; Tentatively we arrange for all this as follows.  SLURP handles DEFTYPEs
;; by finding the type structure they specify and setting it up.
;; During compiling, type-structure setups are generated for later use
;; by loading.
;; During loading, both type-structure setups and function definitions are
;; executed, *unless* the type-structure setups think they're coming from a source
;; file, when they do nothing, on the assumption that SLURP already did it.


(defvar deftype-slurping* nil)  ; T if type loaders are running in slurp mode

(defvar deftype-funs* nil) ; List of functions defined by CLUSTER et al.

;;; This is necessary only because the macro expander for 'deftype'
;;; violates one of Pitman's Rules: It has side effects instead of 
;;; expanding into an 'eval-when' with side effects.  This hack
;;; spares us the trouble of fixing that violation.  (The violation
;;; is bad because it means that for _any_ slurp task except
;;; :slurp-nisp-types the slurper will expand the macro looking
;;; for a slurp handler, thus producing the side effects in
;;; inappropriate circumstances.)
(datafun :slurp-macros deftype #'slurp-ignore)

(def-file-segment deftyp-nt-slurpers-1 (nisp-types-handlers)

 (datafun :slurp-nisp-types deftype
    (defun (d _)
       (let ((typename (cadr d))
	     (supdesig (caddr d))
	     (patches (cdddr d)))
	  (let ((old (prop 'defined typename)))
	     (cond ((and old (not (eq old 'forward))
			 (not (memq supdesig '(forward :forward))))
		    (out (:to *error-output*) :% "Warning: Type " typename
				      " being redefined" :%))   ))
	  (cond ((memq supdesig '(forward :forward))
		 (forward-define typename))
		(t
		 (multiple-value-let (supdesig patches)
				     (sup-n-patches supdesig patches)
		   (bind ((defining* typename) (deftype-slurping* true))
		      (forward-define typename)
		      (load-type typename
				 (eval (cluster-loader
					  typename supdesig patches)))   )))))
       false))
)

(defmacro nispdeftype (&rest stuff) `(deftype ,@stuff)   )
(defmacro defnisptype (&rest stuff) `(deftype ,@stuff)   )

(with-packages-unlocked

(defmacro deftype (typename &rest def)
   (cond ((eq (car def) '(forward :forward))
          `(forward-define-after-compile ',typename))
         (t
          (multiple-value-let (supdesig patches)
                              (sup-n-patches (car def) (cdr def))
             (cond ((not (prop 'defined typename))
                    ; Everything should already be defined.
                    (cond (now-loading*
                           (out (:to *error-output*)
                              "Warning-- DEFTYPE apparently unslurped" :%))  )
                    (bind ((deftype-slurping* t))
                       (!= (prop 'defined typename)
                            (named-designated-type
                               `(cluster ,supdesig ,@patches)
                                typename))   ))   )
             (bind ((deftype-slurping* nil)
                    (deftype-funs* nil))
                ; CLUSTER-LOADER will set DEFTYPE-FUNS*
                (let ((loader (cluster-loader typename supdesig patches)))
                   `(progn ,@(reverse deftype-funs*)
                           (load-type-after-compile
                              ',typename
                              ,loader))   ))))   ))
)

(defun sup-n-patches (supdesig patches)
   (cond ((not (is-type-desig supdesig)) (values 'Obj patches))
         ((and (is-Pair supdesig) (eq (car supdesig) 'cluster))
          (multiple-value-let (supsup suppatches)
                              (sup-n-patches (cadr supdesig)
                                             (cddr supdesig))
             (values supsup (append suppatches patches))   ))
         (t
          (values supdesig patches))   ))

(datafun :slurp-macros augtype #'slurp-ignore)

(def-file-segment deftyp-nt-slurpers-2 (nisp-types-handlers)

;Add slots to type modularly.  Format:
;(AUGTYPE typename -patches-)  where patches are in CLUSTER format.
; At slurp time,
(datafun :slurp-nisp-types augtype
   (defun (aug _)
      (let ((typename (cadr aug)) (patches (cddr aug)))
	 (cond ((and (is-Symbol typename) (is-type-desig typename))
		(bind ((deftype-slurping* t))
		   (merge-slots typename
				(<# eval (def-patches patches typename)))   ))
	       (t (signal-problem augtype :continue
		     "Meaningless AUGTYPE " aug))))
      false))
)

(defmacro augtype (typename &rest patches)
   (bind ((deftype-slurping* nil)
          (deftype-funs* nil))
      ; DEF-PATCHES will set DEFTYPE-FUNS*
      (let ((deffer (def-patches patches typename)))
         `(progn ,@(reverse deftype-funs*)
                 (merge-slots-after-compile
                     ',typename
                     (list ,@deffer)))   )))

; The following macros expand into corresponding calls without
; -AFTER-COMPILE when compiling.  When loading source, they become
; no-ops.  That's because the action they would take was already
; taken at SLURP time, and doing it again might flush AUGTYPEd structure.

(defmacro forward-define-after-compile (&rest l)
   (cond ((or now-compiling* (not now-loading*))
          `(forward-define ,@l))
         (t ''forward-define)   ))

(defmacro load-type-after-compile (&rest l)
   (cond ((or now-compiling* (not now-loading*))
          `(load-type ,@l))
         (t `'(load-type ,(car l)))   ))

(defmacro merge-slots-after-compile (&rest l)
   (cond ((or now-compiling* (not now-loading*))
          `(merge-slots ,@l))
         (t ''merge-slots)   ))

;(CLUSTER coretype -patches-) defines a type that is like coretype,
; except as overridden by the patches.  Doesn't really work except
; inside a DEFTYPE, but supplied here for completeness.
(datafun type-former cluster
   (defun (cdef typename)
      (multiple-value-let (supdesig patches)
                          (sup-n-patches (cadr cdef) (cddr cdef))
         (eval (cluster-loader typename supdesig patches))   )))

(defun cluster-loader (typename supdesig patches)
   (let ((sup-builder (type-loader supdesig typename)))
      (let ((patch-builders (def-patches patches typename)))
	 (multi-let (((is-patches is-features)
		      (cond ((exists (p in patch-builders)
			       (matchq (make-Slot 'is ?@_) p))
			     ;; IS defined by user; breathe sigh of relief
			     (values !() !()))
			    (deftype-slurping* ; Define IS by inheritance
			     (values !()
				     (list `(tuple 'is-builder
						   (\\ (typ must)
						      (cluster-inherit-is 
							   typ must ',typename))))))
			    (t
			     ;; And at load time attempt actually to define
			     (values (cond (typename
					    (include-is typename sup-builder))
					   (t !()))
				     !())))))
	    (let ((cluload
		     `(make-Type '(cluster ,supdesig ,@patches)
				 ,sup-builder
				 (list ,@patch-builders ,@is-patches)
				 (list ,@is-features))))
		(!= cluload `(progn
				(!= (table-entry nisp->cl-tab* ',typename)
				    nil)
				,*-*))
		cluload)))))

;; If there is no IS patch, put one in.
(defun include-is (typename sup-builder)
   (let ((tester (get-is-tester (eval sup-builder) nil)))
      (cond (tester
	     (cond ((matchq (lambda ?@_) tester)
		    (!= tester (make-Slotfundecl (build-symbol is/ (< typename))
			          (cdr *-*))))
		   ;; Define this just in case someone used it:
		   (t (make-Slotfundecl (build-symbol is/ (< typename))
				  `((x) (,tester x))))   )
	     (list `(make-Slot 'is ',tester nil 'Boolean nil)))
	    (t nil)   )))

;;At slurp time, IS is inherited by defined types
(defun cluster-inherit-is (typ must-be-defined typename)
   (let ((tester (get-is-tester (Type-super typ) must-be-defined)))
      (cond (tester
	     (let ((s (assq 'is (Type-slotfns typ))))
		(cond ((null s)
		       (!= s (make-Slot 'is nil nil 'boolean nil))
		       (!= (Type-slotfns typ) (cons s *-*)))   )
                (cond ((null (Slot-acc s))
		       (!= (Slot-acc s) (build-symbol is/ (< typename))))   )))   )
      tester   ))

;; Return a list of MAKE-SLOT expressions.
;; Changed 7.7.88
(defun def-patches (patches typename)
   (let ((slotspecs nil) slotspec)
     ;; SLOTSPECS are for convenience fantasized to be slots in what
     ;; follows.  But at the end it is revealed that they are lists of
     ;; arguments to MAKE-SLOT, and hence all good S-expressions.
     ;; The TYPE field is just a type designator; the ATYPES field is
     ;; a list of type designators.  The others are expressions
     ;; that evaluate to the proper MAKE-SLOT argument.  (Actually,
     ;; in case of indirection or nullity, TYPE and ATYPES are also
     ;; just evaluable expressions.
     ;; Note: *NONE is nothing but a special version of ()
     ;;   to be distinguishable from "unknown argtypes.")
      (repeat :for ((p :in patches))
         (selq (car p)
            ((:is is-Tester is-Test)
	     (!= p `(access is ,@(cdr p))))
            ((:conser make Maker) (!= p `(access conser ,@(cdr p))))
            ((access type all set both))
	    ((:access :type :all :set :both)
	     (!= p `(,(intern (symbol-name (car p)) :nisp)
		     ,@(cdr *-*))))
;;;;	    ((:conser)
;;;;	     (!= p (cons 'access (cons 'conser (cdr p)))))
            (t
             (!= p (cons 'access *-*)))   )
         (!= slotspec (assq (cadr p) slotspecs))
         (cond ((null slotspec)
                (!= slotspec (make-Slot (cadr p) nil nil nil nil))
                (!= slotspecs (cons slotspec *-*)))   )
         (cond ((eq (car p) 'type)
		(let ((findtype (memq '- p)))
		   (cond ((not findtype)
			  (!= findtype (caddr p))) ; Dead reckoning
			 (t (!= findtype (cadr *-*)))   )
		   (!= (Slot-type slotspec)
		       (slotspec-combine *-* findtype (cadr p) ':type typename))))
               (t (def-slot p typename slotspec))   )
       :result (<# (\\ (s)
;;;;		     (cond ((equal (Slot-atypes s) '(Obj))
;;;;			    (dbg-save slotspecs)
;;;;			    (breakpoint def-patches
;;;;			       "slotspecs = " slotspecs)))
                         `(make-Slot ',(Slot-name s)
                                     ',(Slot-acc s)
                                     ',(Slot-set s)
                                     ,(undesig-or-indirect
                                         (Slot-type s)
                                         (\\ (d) (type-or-desig-loader d nil)))
                                     ,(undesig-or-indirect
                                         (Slot-atypes s)
                                         #'argtypes-loader))   )
                  slotspecs)   )))

(defun undesig-or-indirect (e how-undesig)
   (cond ((null e) `nil)
         ((eq e '*none) `'*none)
         ((and (consp e)
	       (memq (car e) '(*indirect :indirect)))
	  `'(:indirect ,(cdr e)))
         (t (funcall how-undesig e))   ))

; Process slot definition P for type TYP, augmenting the expressions
; SLOTSPEC which will eventually build the slot.
; (CAR P) = SET, ACCESS, BOTH, or ALL.
;; Changed: Nov.4.87 11.14.88
(defun def-slot (p typename slotspec)
   (let ((n (Slot-name slotspec)) stored-atypeds)
      (multiple-value-let (tdes fundef vars atypeds)
                          (decipher-slot (cadr p) (cddr p) typename)
         (!= tdes (slotspec-combine (Slot-type slotspec) *-* n ':type typename))
         (!= (Slot-type slotspec) tdes)
	 (cond ((null tdes) (!= tdes 'Obj))   )
         (!= stored-atypeds (argtypes-mung atypeds n (car p)))
         (case (car p)
            (set
             (!= (Slot-set slotspec)
		 (slotspec-combine
		    *-* 
		    (make-Slot-fun typename n 'set 'Void  ; was TDES
				   fundef
				   vars atypeds) 
		    n ':set typename))
             (!= (Slot-atypes slotspec) (or *-* stored-atypeds '*none)))
            ((access both all)
             (!= (Slot-acc slotspec)
                  (slotspec-combine
                     *-* 
		     (make-Slot-fun typename n 'acc tdes fundef
                                    vars atypeds)
		     n ':access typename))
             (cond ((memq (car p) '(both all))
                    (!= (Slot-set slotspec)
                         (slotspec-combine *-*
                                           (all-set-hack typename n fundef
                                                         vars atypeds)
					   n ':set typename)))   )
             (!= (Slot-atypes slotspec) (or  *-* stored-atypeds '*none)))   )
         slotspec   )))

(defun argtypes-mung (argtypeds slot mode)
  ; Most slotfuns don't have interesting argtypes.  Exceptions are
  ; the consers, and accessor/setters with multiple arguments
   (cond ((and (is-Pair argtypeds)
	       (memq (car argtypeds) '(*indirect :indirect))) 
	  `(:indirect ,@(cdr argtypeds)))
         ((memq slot '(conser is))
          argtypeds)
         ((eq mode 'set)
          (argtype-desigs-butlast (argtype-desigs-butfirst argtypeds)))
         (t
          (argtype-desigs-butfirst argtypeds))   ))

;(DEFUN ARGTYPEDS-DENULLIFY (ATL)
;   (COND ((IS-TYPE-DESIG ATL) ATL)
;	 ((NULL ATL) NIL)
;	 (T (CONS (OR (CAR ATL) 'Obj)
;		  (ARGTYPEDS-DENULLIFY (CDR ATL))))   ))

; ARGTYPE-DESIG lists might end in ". desig".  If they do, getting last
; could be tricky.
(defun argtype-desigs-butlast (a)
   (cond ((is-type-desig a) a)
         ((null (cdr a)) nil)
         (t (cons (car a) (argtype-desigs-butlast (cdr a))))   ))

; For that matter, getting the first is nontrivial
(defun argtype-desigs-butfirst (a)
   (cond ((is-type-desig a) a)
         (t (cdr a))   ))

; DEF is of form ([type] [-fundef-]), with various colons and dots allowed
; to generally screw things up.
; Return < type fundef argvars argtype-desigs >
; If the indirect ":"/"!_" notation occurs, the second and fourth values will
; be of the form (:indirect <where>), and the argvars will be ().
(defun decipher-slot (name def typename)
   (let (typ)
      (cond ((and (consp def) (eq (car def) '-))
	     (!= typ (cadr def))
	     (!= def (cddr def))
	     (cond ((eq (car def) '-) (!= def (cdr *-*)))   ))
            ((and (consp def) (is-type-desig (car def)))
             (!= typ (car def))
             (!= def (cdr *-*)))
            ((memq name '(is =))
             (!= typ 'Boolean))   )
      (cond ((atom def)
	     (cond ((null def) 
		    (signal-problem deftype :continue 
			"Empty slot " name " in definition of " typename))
		   (t
		    (out (:to *error-output*)
		       "Obsolete slot syntax for " name 
		       " in definition of " typename :%)
		    (values typ `(:inline (x) (,def x)   ) 'x nil))   )) 
            ((memq (car def) '(\: \!_))
             (let ((i (indirect-slot-ref (cadr def) typename)))
                (values typ i nil i)   ))
            (t
             (cond ((not (memq (car def) '(*integrable :integrable :inline)))
                    (!= def `(lambda ,@def)))   )
             (multiple-value-let (vars types argl dl)
                                 (types-vars-analyze (cadr def))
                (declare (ignore dl))
                (values typ
                        `(,(car def) ,argl ,@(cddr def))
                        vars types)   ))   )))

(defun slotspec-combine (slotslot new name which tyname)
   (cond ((or (null slotslot)
	      (equal slotslot new))
	  new)
         ((null new) slotslot)
         (t
          (signal-problem slotspec-combine
	     "Warning-- In definition of type " tyname
	     "Slot " name " has " (:a which) " overspecified: "
	     :% " previous filler: " slotslot "    new filler: " new
	     (:proceed "I will use the new filler"))
          new)   ))

; Given information extracted from an ALL spec as if it were an ACCESS,
; extract the corresponding SET function definition.
;; Nov.4.87 modified
;; Nov.12.87 modified (badly, cut TDES from args Nov.13)
(defun all-set-hack (typename n fundef vars atypeds)
   (cond ((memq (car fundef) '(*indirect :indirect))
          (indirect-slot-ref (cadr fundef) typename))
         ((memq '&rest (cadr fundef))
          (signal-problem "Making ALL slot" :continue
             "Can't make setter for slot " n " for type " typename
             :% " -- a &REST arg occurs in " fundef))
         (t
          (make-Slot-fun typename n 'set 'Void   ;TDES
             `(,(case (car fundef)
		  ((*integrable :integrable :inline)
		   ':inline)
		  ((lambda)
		   'lambda)
		  (t
		   (signal-problem all-set-hack
			  "Meaningless function spec: " (car fundef))))
               (,@(cadr fundef) newval)
               ,@(drop -1 (cddr fundef))
               (!= ,(lastelt fundef) newval))
             `(,@vars newval)
             `(,@atypeds Obj)))   ))

(defun make-Slot-fun (typename slot mode rtypedes def vars atypeds)
   (match-cond def
      ((memq (car def) '(*indirect :indirect))
       `(:indirect ,@(cdr def)))
      ?( (?(:\| *integrable :integrable :inline)
	  ?bva (?fun ?,@bva))
	 fun)
      (t
       (let ((b (slotfun-body (cddr def)
			      rtypedes vars atypeds typename)))
          (cond ((is-Integrable-slotfun def slot typename)
		 `(lambda ,(cadr def) ,@b   ))
		((eq (car def) 'lambda)
		 (let ((fnam (slot-fun-name typename slot mode)))
		    `,(make-Slotfundecl fnam `(,(cadr def) ,@ b))   ))
		(t (signal-problem make-Slot-fun :continue
			   "Meaningless function def " def)))))))

(defun is-Integrable-slotfun (def slot typename)
   (or (memq (car def) '(*integrable :integrable :inline))
       (cond ((null typename)
              (out (:to *error-output*)
                 "Warning: Non-inline patch " slot
                 " in anonymous CLUSTER."
                 " -- Assuming :inline" :%)
              t)
             (t nil)   )))

(defun slot-fun-name (typename slot mode)
   (cond ((memq slot '(conser constructor))
          (build-symbol make- (< typename)))
         ((memq slot '(is Is-test is-Tester))
          (build-symbol Is- (< typename)))
         (t
          (build-symbol (< typename)
                  - (< slot) - (< mode)))   ))

(defun make-Slotfundecl (name def)
   (cond ((not deftype-slurping*)
          (!= deftype-funs*
               (cons `(defun ,name ,@def)
                     *-*)))   )
   name   )

(defun slotfun-body (body rtypedes vars atypeds typename)
   (cond (deftype-slurping*
          `((in-order-to-define ,typename
	       (decl ,rtypedes ,(<! (\\ (v d) (list v '- d)   )
				    vars 
				    (argtype-desigs-list atypeds))
		  (type^^ ,typename
		     ,@body)))))
         (t
          (bind ((defining* typename)
		 (vartypes* (nconc (<# (\\ (v a)
                                         (make-Vartype v a nil nil)   )
                                       vars
                                       (argtype-desigs-list atypeds))
                                   vartypes*))
                 (local-types*
                    (cons (list '^^
                                (cond (typename (Type-super typename))
                                      (t (signal-problem slotfun-body :continue
                                                 "Use of ^^ in illegal place")
					 'Obj
                                      )))
                          local-types*)))
            (body-compile-exp body (designated-type rtypedes))   ))   ))

; DEF is form ((-args-) -body-).  Make args presentable and
; insert ^^ hack.
;(DEFUN DECLBOD (TYPENAME DEF)
;   `(DECL ,(REM1Q '&REST (CAR DEF))
;       (TYPE^^ ,TYPENAME ,@(CDR DEF))   ))

(datafun decl-compl type^^
   (defun (e dest-type)
      (let ((ty (cadr e)) (bod (cddr e)))
         (bind ((local-types*
                 (cons (list '^^ (Type-super (designated-type ty)))
                       local-types*)))
            ;(OUT (TO *ERROR-OUTPUT*) "Warning: Function def for slot of " TY
            ;                   :% "   produced at slurp time" :%)
	    (let ((bdc (body-compile bod dest-type)))
	       (make-Dclcmp (Dclcmp-typ bdc)
			    `(progn ,@(Dclcmp-exp bdc)))   )))))

(defun indirect-slot-ref (d typename)
   `(:indirect
      ,@(cond ((atom d) (list typename d))
               (t d)   ))   )

