;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: hostypes.lisp,v 2.11 2005/12/26 03:28:53 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)
(depends-on %ydecl/ types)

(self-compile-dep :macros)

(needed-by-macros
(defvar nisp->cl-tab* (make-eq-hash-table))
)

;;; This file defines translations from Nisp types to Lisp ("host")
;;; types based on their designators (i.e., their names).  So it 
;;; gets away with specifying the translations before the types
;;; with those names are actually defined.

(defun nisp->hostype (nispty) (nisp->cltype nispty)   )

; Fixed 1991.2.8 to check for infinite recursions
(defvar types-being-coerced* '())

(defun nisp->cltype (nispty)
   (!= nispty
       (cond ((and (is-Symbol nispty)
		   (eq (prop 'defined nispty) 'forward))
	      univ-type*)
	     (t (coerce-to-nisptype *-*))))
   (cond ((not (memq nispty types-being-coerced*))
	  (bind ((types-being-coerced*
		    (cons nispty
			  types-being-coerced*)))
	     (repeat :for (td)
	      :while nispty
		(!= td (Type-desig nispty))
	      :until (type-feature nispty 'suppress-declaration)
	      :result 't
	      :until (and (is-Symbol td)
			 (not (null (table-entry nisp->cl-tab* td))))
	      :result (funcall (table-entry nisp->cl-tab* td)
		              nispty)
	      :until (and (consp td)
			 (not (null (table-entry nisp->cl-tab* 
						 (car td)))))
	      :result (funcall (table-entry nisp->cl-tab* (car td))
			      nispty)   
		(!= nispty (Type-super *-*))   )))
	 (t 't)   ))

(needed-by-macros
(datafun attach-datafun nisp->cltype
   (defun (ind sym fname)
      (ignore ind)
      (!= (table-entry nisp->cl-tab* sym)
	  (symbol->fun fname))   ))
)

(defmacro declare-nisp-cltype (nisp-name cl-name)
   `(datafun nisp->cltype ,nisp-name
       (defun :^ (_) ',cl-name)))

;; Note: (function ...) can't be used in defstruct slot :type specs
(defun type-ok-for-slot (spec)
   (cond ((car-eq spec 'function) 'function)
	 (t spec)   ))

(datafun nisp->cltype Ary
   (defun (ty)
      `(simple-array ,(nisp->cltype (type-feature ty 'eltype))
		     ,(or (type-feature ty 'array-dims)
			  (type-feature ty 'array-rank)
			  '*))   ))

(datafun nisp->cltype Vct
   (defun (ty)
      `(simple-array ,(nisp->cltype (type-feature ty 'eltype))
		     ,(or (type-feature ty 'array-dims)
			  (type-feature ty 'array-rank)
			  '(*)))))

(datafun nisp->cltype Lrcd
   (defun (ty) (ignore ty) 'cons   ))

(datafun nisp->cltype Fun
   (defun (ty) (nisp-funtype->cl ty)  ))

(defun nisp-funtype->cl (ty)
      (let-fun ((nisp->cl-argtypes (atl)
		   (cond ((null atl) nil)
			 ((eq (car atl) 'dot)
			  `(&rest ,(nisp->cltype (cadr atl))))
			 (t
			  `(,(nisp->cltype (car atl))
			    . ,(nisp->cl-argtypes (cdr atl))))   )))
	 `(function ,(cond ((and (null (type-feature ty `argtypes))
                                 (memq ':harlequin-common-lisp *features*)
				 (not (memq ':lispworks3.2 *features*)))
                            '(&rest t))
                           (t
                            (nisp->cl-argtypes (type-feature ty 'argtypes))))
		    ,(nisp->cltype
		        (or (type-feature ty 'resulttype)
			    'Obj)))   ))

(datafun nisp->cltype Htb
   (defun (ty) (ignore ty) 'hash-table   ))

(datafun nisp->cltype Mlv 
  (defun :^ (ty)
;;;;     #+cmu `(values &rest t)
;;;;     #-cmu
     (let-fun ((:def unwrap (valtypes)
                   (cond ((null valtypes)
                          '())
                         ((eq (head valtypes)
                              'dot)
                          `(&rest ,(nisp->cltype (head (tail valtypes)))))
                         (t
                          `(,(nisp->cltype (head valtypes))
                            ,@(unwrap (tail valtypes)))))))
        `(values
            ,@(unwrap (type-feature ty 'valtypes))
;;;;            ,@(<# nisp->cltype (type-feature ty 'valtypes))
         ))))

;; Nov.4.87 modified
(datafun nisp->cltype Lst
   (defun (ty) (ignore ty) 'list   ))

(datafun nisp->cltype Void
   (defun (ty) (ignore ty) 't   ))

(datafun nisp->cltype Obj 
   (defun (ty) (ignore ty) 't   ))

(datafun nisp->cltype Either
   (defun (ty)
      (let ((etl (type-feature ty 'either-types)))
         (let ((cltl (<# (\\ (et) (sedate-hysterical-cl-type (nisp->cltype et))   )
			 etl)))
	    (cond ((memq 't cltl) 't)
		  (t `(or . ,cltl))   )))))

(datafun nisp->cltype Alt Either)

(datafun nisp->cltype ~
   (defun (ty)
      (let ((clty (sedate-hysterical-cl-type (nisp->cltype (Type-super ty)))))
	 (cond ((eq clty 't) 't)
	       (t `(or ,clty null))   ))))


(defun sedate-hysterical-cl-type (ty)
   (cond ((car-eq ty 'function) 't)
	 (t ty)   ))

(datafun nisp->cltype Null
   (defun (ty) (ignore ty) 'null   ))
