;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: intypes.lisp,v 2.11 2005/12/26 03:28:53 dvm Exp $

(depends-on :at-run-time %ydecl/ typekern types sysdefs)

(self-compile-dep :nisp-types)

(depends-on (:at :compile-time :slurp-time :run-time)
	    %ydecl/
	    deftyp typekern strtype listype plextype sysdefs
	    datadcl lisdcl1 lisdcl2 ctldcl mgcdcl tmcdcl numdcl iodcl)

(end-header :continue-slurping)

(deftype Slot forward)

(deftype Type Obj
   (conser *integrable
           (desig - Sexp super - Type
            slots - (Lst Slot)
            features - (Lst (Lrcd Symbol . Obj)))
      (make-Nisptype desig super slots features)   )
   (is *integrable (x) (is-Type x)   )
   (all desig - Sexp *integrable (ty) (Type-desig ty)   )
   (super - Type *integrable (ty) (Type-super ty)   )
   (im-super - Type *integrable (ty) (Type-im-super ty)   )
   (all slots - (Lst Slot) *integrable (ty) (Type-slotfns ty)   )
   (allslots - (Lst Slot) *integrable (ty) (type-allslots ty)   )
   (all features - (Lst (Lrcd Symbol Obj))
        *integrable (ty) (Type-features ty)    ) )

(deftype Slot (lstructure ()
			  name - Symbol
                          acc set - Sexp
                          type - Type
                          atypes - (Lst Type)))

(eval-when (:slurp-toplevel :load-toplevel)
           (:slurp-filter :slurp-nisp-types)

   (deftype Type-desig Sexp
      (is *integrable (x) (is-type-desig x)))
)

(declare-type-acceptable 'Symbol 'Type-desig)
(declare-type-acceptable 'Sexp 'Type-desig)

; Actually, these two are needed only when the dcl stuff is running. Hmmm...
(deftype Dclcmp Struc
   (conser *integrable (ty e) (make-Dclcmp ty e)   )
   (typ - Type *integrable (dc) (Dclcmp-typ dc)  )
   (exp - Sexp *integrable (dc) (Dclcmp-exp dc)  ))

(deftype Vartype Struc
   (conser *integrable (var typ initial setups)
      (make-Vartype var typ initial setups)   )
   (is *integrable (x) (is-Vartype x)   )
   (var - Symbol *integrable (vt) (Vartype-var vt)   )
   (all typ - Type *integrable (vt) (Vartype-typ vt)   )
   (initial - Sexp *integrable (vt) (Vartype-initial vt)   )
   (setups - (Lst Sexp) *integrable (vt) (Vartype-setups vt)   ))

(deftype Funtype Type
    (conser *integrable (rtype - Type atypes - (Lst Type) se-sw - Boolean)
            (make-Funtype rtype atypes se-sw)   )
    (is *integrable (x) (is-Funtype x)  )
    (resulttype - Type *integrable (ft) (fun-resulttype ft)   )
    (argtypes - (Lst Type) *integrable (ft) (fun-argtypes ft)   )
    (has-side-effects - Boolean *integrable (ft) (fun-se ft)   ))


