;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: iodcl.lisp,v 2.10 2005/12/26 00:46:17 dvm Exp $

;;; Declarations concerning io and file functions.

;;; Copyright (C) 1988 - 2002, 
;;; Drew McDermott, Yale University

(depends-on :at-run-time %ydecl/ dclmacs sysdefs
			      strtype plextype listype typekern)

(specdecl readmac - (Fun Void (Char (Fun Sexp (Stream) t)) t)
	  eof* - Obj
          ;;;;is-eof - (Fun Boolean (Obj) ())
	  stdin stdout errout - (Fun Stream () ())
	  *standard-input* *standard-output* *error-output* *trace-output*
	  *debug-io* *query-io*
	  *query-io* *query-io* - Stream
	  stdin-set stdout-set errout-set - (Fun Void (Stream) t)
	  open-streams* - (Lst Stream)
	  openo openi - (Fun Stream (Pathname) t)
	  closeo closei - (Fun Void (Stream) t)
)

(datafun decl-compl with-open-file
   (defun :^ (exp target-type)
      (match-cond exp
	 ?( (with-open-file (?(:+ ?srmvar is-Symbol)
			     ?filespec ?@open-args)
	       ?@body)
	   (let ((fs (decl-compile-exp filespec 'Filespec))
		 (opens (repeat :for ((al = open-args :then (cddr al)))
			 :until (null al)
			    (cond ((not (is-Keyword (car al)))
				   (signal-problem with-open-file
				      "Non-keyword argument " (car al)
				      " in " :% exp)))
			 :append `(,(car al)
				   ,(decl-compile-exp (cadr al) univ-type*)))))
	     (bind ((vartypes* (cons (make-Vartype srmvar 'Stream nil nil)
				     vartypes*)))
		(let ((body-dc (body-compile body target-type)))
		   (type-trans
		      `(with-open-file (,srmvar ,fs ,@opens)
			  ,@(Dclcmp-exp body-dc))
		      (Dclcmp-typ body-dc)
		      target-type)))))
	 (t
	  (signal-problem with-open-file
	     "Ill-formed: " exp
	     (:continue "I'll take it as is"))
	  (make-Dclcmp target-type exp)))))

#|
(datafun decl-compl with-input-from-file
  (defun (exp dest-type)
      (cond ((not (>= (length exp) 4))
	     (signal-problem with-input-from-file-decl-compl :fatal
	       0 "Too few arguments: " exp))
            (t
	     (let (var pn body)
	       (matchq (?() ?var ?pn . ?body) exp)
	       (let ((body-dc
		      (bind ((vartypes* (cons (make-Vartype var 'Stream nil nil)
					      vartypes*)))
			 (body-compile body dest-type))))
		  (make-Dclcmp
		     (Dclcmp-typ body-dc)
		     `(,(car exp) ,var
			     ;;--don't compile to 'pathname because ->PATHNAME
			     ;;--is applied anyway and signals a runtime error
			     ;;--if its argument cannot be coerced to a pathname
			,(decl-compile-exp pn nil)
			,@(Dclcmp-exp body-dc)))))))))
|#

;;;;(datafun decl-compl with-output-to-file with-input-from-file)

(datafun decl-compl with-input-from-string
   (defun (exp dest-type)
      (let (var string body)
	 (matchq (?() (?var ?string) . ?body) exp)
	 (make-Dclcmp
	    dest-type
	    `(,(car exp) (,var ,(decl-compile-exp string 'String))
	       . ,(bind ((vartypes* (cons (make-Vartype var 'Stream nil nil)
					  vartypes*)))
		     (body-compile-exp body dest-type)   )))   )))

(datafun decl-compl with-output-to-string
   (defun (exp dest-type)
      (let ((var (cadr exp)) (body (cddr exp)))
	 (cond ((is-Pair var) (!= var (car var)))   )
	 (type-trans
	    `(with-output-to-string (,var)
		. ,(bind ((vartypes* (cons (make-Vartype var 'Stream nil nil)
					   vartypes*)))
                      (body-compile-exp body 'Void)   ))
	    'String dest-type)   )))
	    
(bind ((allow-ftype* false))
; See comment about ALLOW-FTYPE* in datadcl
(specdecl clear-input - (Fun Void (Stream) t)
	  listen - (Fun Boolean (Stream) ())
	  force-output - (Fun Void (Stream) t)
	  merge-pathnames - (Fun Pathname (Pathname Pathname) ())
	  get-output-stream-string - (Fun String (Stream) t)
))

(specdecl srmread - (Fun Sexp (Stream) t)
	  stdread - (Fun Sexp () t)
	  srmreadc - (Fun Char (Stream) t)
	  stdreadc - (Fun Char () t)
	  srmpeekc - (Fun Char (Stream) ())
	  stdpeekc - (Fun Char () ())
          srmlineread - (Fun (Lst Sexp) (Stream) t)
	  stdlineread - (Fun (Lst Sexp) () t)
	  srmread-line - (Fun String (Stream) t)
	  stdread-line - (Fun String () t)
	  read-objects-from-string - (Fun (Lst Sexp) (String) ())

	  srmprint srmdisplay srmbprint - (Fun Void (Obj Stream) t)
	  stdprint stddisplay stdbprint - (Fun Void (Obj) t)
	  srmprinlev - (Fun Void (Obj Integer Stream) t)
	  stdprinlev - (Fun Void (Obj Integer) t)
	  srmprintc - (Fun Void (Char Stream) t)
	  stdprintc - (Fun Void (Char) t)
	  srmnewline - (Fun Void (Stream) t)
	  stdnewline - (Fun Void () t)
	  srmspaces srmtab srmlines - (Fun Void (Integer Stream) t)
	  stdspaces stdtab stdlines - (Fun Void (Integer) t)
	  srmcurrcol srmlinelength - (Fun Fixnum (Stream) ())
	  stdcurrcol stdlinelength - (Fun Fixnum () ())
	  printwidth displaywidth - (Fun Fixnum (Obj) ())
)

; Not part of Nisp, but MSG may expand into it in some dialects.
(specdecl format - (Fun Void ((Either Stream Boolean) String . Obj) t))

(specdecl **value-of-msg** - Void
	  out-vals* - (Lst Obj))

(specdecl pathname-host - (Fun Obj (Pathname) ())
	  pathname-device - (Fun Obj (Pathname) ())
	  pathname-directory - (Fun Sexp (Pathname) ())
	  pathname-name pathname-type - (Fun (~ String) (Pathname) ())
	  pathname-version - (Fun Integer (Pathname) ())
	  obj-suffix* source-suffix* - String
	  cons-pathname - (Fun Pathname Obj ())
	  ->pathname - (Fun Pathname (Obj) ())
	  is-Pathname - (Fun Boolean (Obj) ())
	  pathname->string - (Fun String (Pathname) ())
	  probef - (Fun Boolean (Pathname) ())
	  evalfile loadoreval - (Fun Void (Pathname) t)
	  specified-files - (Fun (Lst Pathname) 
				 ((Lst Sexp) (Lst String) Symbol (Lst Symbol)) 
				 ())
	  dsklap-x - (Fun Void ((Lst Sexp)) t)
)
   
;;; Updated 00.11.02 to handle TR
(defvar out-dest-type* nil)

(datafun-table out-decl-tab* out-decl-compl)

(defun out-dc (things)
   (<# (\\ (exp)
	  (cond ((or (is-Number exp) (is-String exp)
		     (memq exp '(:% :t t)))
		 exp)
		((and (consp exp)
		      (is-Symbol (car exp)))
		 (let ((op (car exp)))
		    (let ((decl-out-handler
			     (table-entry out-decl-tab* op)))
		       (cond (decl-out-handler
			      (funcall decl-out-handler exp))
			     ((get-out-operator exp)
			      (out (:to *error-output*)
				   "Warning-- 'out' operator "
				   op " not known to 'decl'" :%)
			      (decl-compile-exp exp 'Void))
			     (t
			      (decl-compile-exp exp 'Void))))))
		(t (decl-compile-exp exp 'Void))   ))
       things)   )

(datafun out-decl-compl :e
   (defun :^ (exp)
      (let-fun ()
	 (match-cond exp
	    (:? (?_ (:stream ?srm) ?@args)
	       (cond ((is-Symbol srm)
		     `(:e (:stream ,srm)
			 ,@(with-declarations (list srm) (list 'Stream)
			      (body-compile-exp args 'Void))))
		     (t
		      (signal-problem :e-out-decl-compl
			 "Illegal stream variable " srm " in"
			 :% exp))))
	    (t
	     `(:e ,@(body-compile-exp (cdr exp) 'Void)))))))

(datafun out-decl-compl e :e)

(datafun out-decl-compl :v
   (defun (exp)
      `(:v ,(decl-compile-exp (cadr exp) 'Void))))

(datafun decl-compl :o
   (defun (exp dest-type)
      (type-trans
	 `(:o ,@(out-dc (cdr exp)))
         'Obj
         dest-type)))

;;;;(datafun decl-compl o :o)

(datafun out-decl-compl :t
    (defun (exp)
       `(:t ,(decl-compile-exp (cadr exp) 'Integer))   ))

(datafun out-decl-compl t :t)

(datafun out-decl-compl :q
    (defun (exp)
       `(:q . ,(<# (\\ (c) `(,(decl-compile-exp (car c) 'Boolean)
			    . ,(out-dc (cdr c)))   )
		  (cdr exp)))   ))

(datafun out-decl-compl q :q)

(datafun out-decl-compl :pp
   (defun (exp)
      `(:pp ,(decl-compile-exp (cadr exp) 'Obj))   ))  ;was sexp

(datafun out-decl-compl pp :pp)

(datafun out-decl-compl :pp-block
   (defun (exp)
      (multiple-value-let (prefix cmd suffix)
                          (pp-block-analyze (cdr exp))
	 `(:pp-block ,@(include-if prefix
			 `(:pre ,(decl-compile-exp prefix 'String)))
		    ,@(out-dc cmd)
		    ,@(include-if suffix
			 `(:suf ,(decl-compile-exp suffix 'String)))))))

(datafun out-decl-compl pp-block :pp-block)

(datafun out-decl-compl :pp-nl
   (defun (exp) exp))

(datafun out-decl-compl pp-nl :pp-nl)

(datafun out-decl-compl :pp-ind
   (defun :^ (exp)
      `(:pp-ind ,(cadr exp) ,(decl-compile-exp (caddr exp) 'Integer))))

(datafun out-decl-compl :to 
   (defun (exp)
      `(:to ,(decl-compile-exp (cadr exp) 'Stream))   ))

(datafun out-decl-compl to :to)

(datafun out-decl-compl :a
   (defun (exp)
      `(,(car exp)
	 . ,(<# (\\ (e) (decl-compile-exp e 'Obj)   )  ;was sexp
	        (cdr exp)))   ))

(datafun out-decl-compl :d :a)
(datafun out-decl-compl d :a)

(datafun out-decl-compl :_
   (defun (exp)
      `(,(car exp)
	,(decl-compile-exp (cadr exp) 'Integer))))

(datafun out-decl-compl :s :_)

(datafun out-decl-compl :i> :_)
(datafun out-decl-compl :i< :_)

(datafun out-decl-compl :f
   (defun (exp)
      `(:f ,(decl-compile-exp (cadr exp) 'String)
	  ,@(<# (\\ (e) (decl-compile-exp e 'Obj))
		(cddr exp)))))

;;; Superseded by extra/trace.nsp
;;;;(datafun out-decl-compl tr
;;;;   (defun (exp)
;;;;      (multiple-value-let (gate cmd)
;;;;			  (cond ((and (cadr exp) (symbolp (cadr exp)))
;;;;				 (values `(,(cadr exp))
;;;;					 (cddr exp)))
;;;;				(t
;;;;				 (values '() (cdr exp))))
;;;;	 (let ((beg-msg (car cmd))
;;;;	       (form (cadr cmd))
;;;;	       (end-msg (caddr cmd)))
;;;;	    `(tr ,@gate
;;;;	      ,(out-dc beg-msg)
;;;;	      ,(decl-compile-exp form out-dest-type*)
;;;;	      ,(out-dc end-msg))))))

(datafun decl-compl out
   (defun (exp dest-type)
      (bind ((out-dest-type* dest-type))
         (let ((srm-arg ':absent) (out-direcs (cdr exp)))
	    (match-cond exp
	       ?( (out (?(:\| :to to) ?srm) ?@rest)
		 (cond ((memq srm '(t :string))
			(!= srm-arg srm))
		       (t
			(!= srm-arg (decl-compile-exp srm 'Stream))))
		 (!= out-direcs rest)))
	    (type-trans `(,(car exp)
			  ,@(include-if (not (eq srm-arg ':absent))
			       `(:to ,srm-arg))
			  ,@(out-dc out-direcs))
			'Obj
			dest-type)))))

(datafun decl-compl msg out)
(datafun decl-compl stdmsg out)

(datafun decl-compl srmmsg
   (defun (exp dest-type)
      (bind ((out-dest-type* dest-type))
	 (type-trans `(srmmsg ,(decl-compile-exp (cadr exp) 'Stream)
			 . ,(out-dc (cddr exp)))
		     'Void
		     dest-type)   )))

(datafun decl-compl out-indent
   (defun (exp dest-type)
      (match-cond exp
	 ?( (out-indent ?srm ?amt ?@(:& (?_ ?@_) ?body))
	   (let ((srm (cond ((eq srm 't) 't)
			    (t (decl-compile-exp srm 'Stream))))
		 (i (decl-compile-exp amt 'Integer))
		 (body (body-compile body dest-type)))
	      (type-trans
		 `(out-indent ,srm ,i ,@(Dclcmp-exp body))
		 (Dclcmp-typ body)
		 dest-type)))
         (t 
	  (signal-problem out-indent-decl-compl
	     "Ill-formed: " exp
	     (:novalue "I'll take it as is"))
	  (make-Dclcmp dest-type exp)))))

;; Nov.4.87 added
(datafun decl-compl in
   (defun (exp dest-type)
      (multi-let (((srmarg realargs)
		   (cond ((and (not (shorter exp 2))
			       (car-eq (cadr exp) ':from))
			  (values (decl-compile-exp (second (cadr exp)) 'Stream)
				  (cddr exp)))
			 (t
			  (values false (cdr exp))))))
	 (repeat :for ((e :in realargs)
		       :collector transed)
	  :collect
	    (cond ((is-Symbol e)
		   (let ((in-type
			    (case e
			       ((:obj :read :object t) 'Sexp)
			       ((:char :peek) 'Char)
			       ((:string :linestring) 'String)
			       (:linelist (lstype 'Sexp))
			       (:keyword 'Keyword)
			       (t 'Obj))))
		      (make-Dclcmp in-type e)))
		  (t
		   (make-Dclcmp 'Void e)))
	    :result (type-trans `(in ,@(include-if srmarg `(:from ,srmarg))
				     ,@(<# Dclcmp-exp transed))
				(mlv-type (<# Dclcmp-typ transed))
				dest-type)))))

(datafun decl-compl signal-problem
   (defun (exp dest-type)
      (multiple-value-let (simple place-string who-prints 
			   condspec 
			   proceedspec)
			  (signal-problem-analyze (cdr exp))
	 (let ((pre-hook-dc
		  (build-error-dclcmp simple condspec proceedspec dest-type)))
	    (make-Dclcmp
	       (Dclcmp-typ pre-hook-dc)
	       (maybe-wrap-debugger-hook
		  (Dclcmp-exp pre-hook-dc) place-string who-prints 
		  ))))))

(defun build-error-dclcmp (simple condspec proceedspec dest-type)
   (cond ((and simple (memq proceedspec '(:proceed :novalue)))
	  (make-Dclcmp (or dest-type 'Void)
		       `(cerror "I will try to proceed"
				,(decl-compile-exp (car condspec) false)
				,@(null-body-compile-exp (cdr condspec)))))
	 ((or (not proceedspec) (eq proceedspec ':fatal))
	  (make-Dclcmp (or dest-type 'Void)
		       `(error ,(decl-compile-exp (car condspec)
						  false)
			       ,@(null-body-compile-exp (cdr condspec)))))
	 (t
	  (let ((cond-exp (body-compile-exp condspec 'Void))
		(report-exp (cond ((atom proceedspec)
				   '"I will attempt to continue")
				  (t
				   (let ((srmvar (gen-var 'srm)))
				      (decl-compile-exp
					 `(lambda (,srmvar)
					     (out (:to ,srmvar)
						,@(cond ((car-eq proceedspec
								 'prompt-for)
							 (butlast (cdr proceedspec)))
							(t (cdr proceedspec)))))
					 false))))))
	     (cond ((car-eq proceedspec ':prompt-for)
		    (let ((supplied-var (gensym))
			  (value-var (gensym)))
		       (let ((restart-dc
				(with-declarations
					  `(,supplied-var ,value-var)
					  (list 'Boolean 'Obj)
				   (decl-compile
				      `(cond (,supplied-var ,value-var)
					     (t ,(lastelt proceedspec)))
				      false))))
			  (type-trans
			     `(restart-case (error ,@cond-exp)
				 (prompt-for-restart-val (,supplied-var
							  ,value-var)
				    :report ,report-exp
				    :interactive prompt-for-restart-val
				    ,(Dclcmp-exp restart-dc)))
			     (Dclcmp-typ restart-dc)
			     dest-type))))
		   (t
		    (type-trans
		       `(restart-case (error ,@cond-exp)
			   (continue ()
			    :report ,report-exp))
		       'Void dest-type)))))))

(defun null-body-compile-exp (b)
   (cond ((null b)
	  '())
	 (t
	  (body-compile-exp b 'Void))))
