;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: lisdcl1.lisp,v 2.11 2005/12/26 03:28:53 dvm Exp $

(depends-on :at-compile-time %ydecl/ tmcdcl)

(depends-on :at-run-time %ydecl/ dclmacs sysdefs
			      strtype plextype listype)

(declaim (special univ-type* void-type*))


(specdecl is-Pair atom consp - (Fun Boolean (Obj) ()))

;; Nov.4.87 modified
(specdecl null - (Fun Boolean (Boolean) ()))  ; Or should it be like NOT?


;; Nov.4.87 modified
(datafun decl-compl lrecord
   (defun (exp dest-type)
      (cond ((null (cdr exp))  ; trivial
	     (make-Dclcmp 'Null 'nil))
	    (t
	     (let ((dcs (<# (\\ (x) (decl-compile x nil)   )
			     (cdr exp))))
		(type-trans
		   `(list . ,(<# Dclcmp-exp dcs))
		   (lrecord-type dcs)
		   dest-type)   ))   )))

(datafun decl-compl tuple lrecord)

;; Nov.4.87 modified
(defun lrecord-type (dcs)
   (cond ((null dcs) 'Null)
	 (t
	  (lrcdtype (Dclcmp-typ (car dcs))
		    (lrecord-type (cdr dcs))))   ))

;; Nov.4.87 modified
;;--Denys, Dec 1990--changed LIST to (CAR EXP) for use with BQ-LIST*
(datafun decl-compl list
   (defun (exp dest-type)
      (cond ((null (cdr exp))  ; trivial
	     (make-Dclcmp 'Null 'nil))
	    (t
	     (let ((dcs (<# (\\ (x) (decl-compile x nil)   )
			    (cdr exp))))
		(!= dcs (listdcs-combine *-* false))
		(type-trans
		   `(,(car exp) . ,(Dclcmp-exp dcs))
		   (Dclcmp-typ dcs)
		   dest-type)   ))   )))

(datafun decl-compl list*
   (defun :^ (exp dest-type)
      (cond ((null (cdr exp))
	     (signal-problem list*-decl-compl
		"Wrong number of arguments: " exp))
	    (t
	     (let ((tail-arg (lastelt (cdr exp)))
		   (list-args (butlast (cdr exp))))
		(let ((dcs (<# (\\ (x) (decl-compile x nil)   )
			       list-args))
		      (tail-dc (decl-compile tail-arg nil)))
		   (!= dcs (listdcs-combine *-* tail-dc))
		   (let ()
		      (type-trans
			 `(,(car exp) ,@(Dclcmp-exp dcs))
                         (Dclcmp-typ dcs)
			 dest-type))))))))

;;; Given a list of dclcmps, return a single dclcmp whose exp is a list
;;; of exps, and whose type is the type of 'list' or 'list*' applied
;;; to those exps.  ('list*' <-> final-dc is non-false)
;;; If 'final-dc' is non-false, it is the type of the dotted thing
;;; at the end that takes the place of () in an improper list.
;;; 'dcs' is known to be non-null.
(defun listdcs-combine (dcs final-dc)
   (cond ((and (not final-dc)
               (null (cdr dcs)))
          ;; This special case is probably unnecessary, but I don't
          ;; feel adventurous today.
	  (make-Dclcmp (lstype (Dclcmp-typ (car dcs)))
		       (list (Dclcmp-exp (car dcs)))))
         ((null dcs)
          (cond (final-dc
                 (make-Dclcmp (Dclcmp-typ final-dc)
                              (list (Dclcmp-exp final-dc))))
                (t
                 (make-Dclcmp 'Null '(nil)))))
	 (t
	  (let ((r (listdcs-combine (cdr dcs) final-dc)))
	     (make-Dclcmp (cons-Types (Dclcmp-typ (car dcs))
				      (Dclcmp-typ r))
			  (cons (Dclcmp-exp (car dcs))
				(Dclcmp-exp r)))))))

(datafun decl-compl pop
   (defun (e dt)
      (let ((at (decl-compile (cadr e) (lstype (or dt 'Obj)))))
        (type-trans
	   `(pop ,(Dclcmp-exp at))
	   (type-feature (Dclcmp-typ at) 'eltype) ;last arg was NIL
	   dt))))

;; 9.26.88 added test for number of arguments
(datafun decl-compl conset
  (defun (e dt)
    (cond ((not (= (length e) 3))
	   (signal-problem conset-decl-compl :fatal
	     0 "Wrong number of arguments: " e))
	  (t
	   (let* ((at1 (decl-compile (cadr e) 'Objlist))
		  (at2 (decl-compile (caddr e) (type-feature (Dclcmp-typ at1) 'eltype))))
	     (type-trans
	      `(conset ,(Dclcmp-exp at1) ,(Dclcmp-exp at2))
	      (conset-types (Dclcmp-typ at1) (Dclcmp-typ at2))
	      dt)))) ))

(datafun decl-compl push
   (defun :^ (exp dest-type)
      (match-cond exp
	 ?( (push ?val ?lst)
	   (let ((ldc (decl-compile lst 'Objlist)))
	      (let ((vdc (decl-compile val (type-feature (Dclcmp-typ ldc)
							 'eltype))))
		 (type-trans
		    `(push ,(Dclcmp-exp vdc) ,(Dclcmp-exp ldc))
		    (conset-types (Dclcmp-typ ldc) (Dclcmp-typ vdc))
		    dest-type))))
	 (t
	  (signal-problem push-decl-compl
	     "Ill-formed: " exp)))))

(defun conset-types (t1 t2) (cons-Types t2 t1))

;; 9.26.88 added test for number of arguments
;;--Denys, Dec 1990--changed CONS to (CAR EXP) for use with BQ-CONS
;; DVM, Aug 1995 -- decl compile args to cartype and cdrtype of DT
(datafun decl-compl cons
   (defun (e dt)
      (cond ((not (= (length e) 3))
	     (signal-problem cons-Decl-compl :fatal
	       0 "Wrong number of arguments: " e))
            (t
	     (let ((at1 (decl-compile (cadr e)
                                      (and dt (type-feature dt 'cartype))))
		   (at2 (decl-compile (caddr e)
                                      (and dt (type-feature dt 'cdrtype)))))
	       (type-trans
		`(,(car e) ,(Dclcmp-exp at1) ,(Dclcmp-exp at2))
		(cons-Types (Dclcmp-typ at1) (Dclcmp-typ at2))
		dt))))))

;; Produce type of object whose CAR is of type T1 and whose CDR is of type T2.
(defun cons-Types (t1 t2)
   (cond ((is-subtype t2 'Objlist)
	  (lstype (common-supertype t1 (type-feature t2 'eltype))))
	 (t (lrcdtype t1 t2))))

;;;;   (cond ((and (some-list-type t2)
;;;;	       (equivalent-types t1 (type-feature t2 'eltype)))
;;;;	  (lstype 
;;;;	  (same-list-type t2 t1))
;;;;	 (t (lrcdtype t1 t2))   ))

(defun same-list-type (ty eltype)
   (cond ((is-subtype ty 'Objgenlist) (glstype eltype))
	 (t (lstype eltype))   ))

(datafun decl-compl append
   (defun (exp dest-type)
      (let ((dcs (<\# (\\ (x) (decl-compile x nil)   )
		      (cdr exp)))
	    (eltype void-type*) (typ 'Sexp))
	 (repeat :for ((a :in dcs))
	    (let ((at (Dclcmp-typ a)))
	       (cond ((eq (Type-desig at) 'Sexp)
		      (cond ((eq typ 'Sexp)
			     (!= eltype 'Sexp))   ))
		     ((is-subtype at 'Objgenlist)
		      (!= typ 'glst)
		      (!= eltype
			  (common-supertype *-* (type-feature at 'eltype))))
		     ((is-subtype at 'Objlist)
		      (cond ((not (eq typ 'glst))
			     (!= typ 'lst))   )
		      (!= eltype
			  (common-supertype *-* (type-feature at 'eltype))))
	     ;; No type checking on args at all
	      )))
	 (type-trans
	    `(,(car exp) . ,(<\# Dclcmp-exp dcs))
	    (selq typ
	       (glst (glstype eltype))
	       (lst (lstype eltype))
	       (t typ)   )
	    dest-type)   )))

(specdecl nconc - (Fun (Lst (*Typevar E)) (Lst (*Typevar E)) t))

(datafun decl-compl list-concat append)

;; Changed 4.1.88
; Fixed 1991.2.1 to avoid making symbols out of characters #\A and #\D
(defun car-cdr-decl-compl (exp dest-type)
   (let ((p (cdr (dreverse (cdr (coerce (symbol-name (car exp)) 'list))))))
     (a-d-composition-decl-compl p exp dest-type)))

(defun a-d-composition-decl-compl (p exp dest-type)
   (let ((e (decl-compile (cadr exp) nil))
	 et slot-type which q adtype)
      (!= et (Dclcmp-typ e))
      (repeat :for (is-car)
       :while p
	 (!= q (car p))
	 (!= p (cdr p))
	 (!= is-car (member q '(#\a #\A) :test #'char=))
	 (!= adtype (type-feature et (cond (is-car 'cartype)
					   (t 'cdrtype)   )))
       :within
	 (cond (adtype
		(!= et adtype))
	       (t
		(:continue
		 :until (matchq ?(:|| Obj Sexp (*Typevar ?_))
				(Type-desig et))
		   (!= which (cond (is-car 'car) (t 'cdr)   ))
		   (!= slot-type (type-slot-fun et which 'type nil))
		   (cond (slot-type
			  (!= et slot-type))
			 (t
			  (cond (type-check*
				 (defining-info)
				 (out (:to *query-io*) :% "Can't take "
				      (:a :c) (:a q) (:a :r)
				      " of object of type " (Type-desig et))
				 (cond ((eq type-check* 'barf)
					(signal-problem decl :continue))   ))   )
			  (!= et univ-type*))))))
       :result (type-trans `(,(car exp) ,(Dclcmp-exp e))
			   (match-cond (Type-desig et)
			      (:? ?(:|| Obj Sexp :& ?td)
				  td)
			      (:? (*Typevar ?_) 'Obj)
			      (t et))
			   dest-type))))

(repeat :for ((fname :in
		     '(car caar caaar caaaar
				      caaadr
				caadr caadar
				      caaddr
			   cadr cadar cadaar
				      cadadr
				caddr caddar
				      cadddr caddddr cadddddr 
				      caddddddr cadddddddr
		       cdr cdar cdaar cdaaar
				      cdaadr
				cdadr cdadar
				      cdaddr
			   cddr cddar cddaar
				      cddadr
				cdddr cdddar
				      cddddr)))
   (!= (prop 'decl-compl fname) !'car-cdr-decl-compl)   )

(datafun decl-compl first
   (defun :^ (exp dest-type)
     (a-d-composition-decl-compl '(#\a) exp dest-type)))

(datafun decl-compl head first)

(datafun decl-compl second
   (defun :^ (exp dest-type)
     (a-d-composition-decl-compl '(#\d #\a) exp dest-type)))

(datafun decl-compl third
   (defun :^ (exp dest-type)
     (a-d-composition-decl-compl '(#\d #\d #\a) exp dest-type)))

(datafun decl-compl fourth
   (defun :^ (exp dest-type)
     (a-d-composition-decl-compl '(#\d #\d #\d #\a) exp dest-type)))

(bind ((allow-ftype* false))

; See comment in datadcl regarding ALLOW-FTYPE*
(specdecl sort - (Fun (Lst (*Typevar E))
		      ((Lst (*Typevar E))
		       (Fun Boolean ((*Typevar E) (*Typevar E)) ()))
		      T)
	  subst - (Fun Sexp (Sexp Sexp Sexp) ())
	  member adjoin
	    - (Fun (Lst (*Typevar E))
			((*Typevar E) (Lst (*Typevar E)) . Obj) ())
))

(specdecl copy-list list-copy reverse dreverse lasttail
		- (Fun (*Typevar L) ((*Typevar L (Lst (*Typevar T)))) ())
	  list-subseq - (Fun (Lst (*Typevar T))
			     ((Lst (*Typevar T)) Integer Integer)
			     ())
	  list-elt - (Fun (*Typevar T)
			  ((Lst (*Typevar T)) Integer)
			  ())
	  list-length length len
	        - (Fun Fixnum ((Lst Obj)) ()) ; 87.9.28: Changed
	  nthelt nthelem - (Fun (*Typevar E) (Integer (Lst (*Typevar E))) ())
	  nthtail take drop 
		- (Fun (Lst (*Typevar E))
		       (Integer (Lst (*Typevar E))) ())
	  lastelt lastelem - (Fun (*Typevar E) ((Lst (*Typevar E))) ())
	  is-tail - (Fun Boolean ((Lst Obj) (Lst Obj)) ())
	  ldiff - (Fun (Lst (*Typevar E))
		       ((Lst (*Typevar E)) 
			(Lst (*Typevar E)))
		       ())
	  copy-tree - (Fun Sexp Sexp ())
	  substq - (Fun Sexp (Sexp Sexp Sexp) ())
	  series - (Fun (Lst Integer) Integer ())

	  memq adjoinq remove delete
		- (Fun (Lst (*Typevar E))
		   ((*Typevar E) (Lst (*Typevar E)) . Obj) ())
	  remove1q
		- (Fun (Lst (*Typevar E))
		   ((*Typevar E) (Lst (*Typevar E))) ())
	  dremove1 dremove1q 
		- (Fun (Lst (*Typevar E))
		       ((*Typevar E) (Lst (*Typevar E))) T)
	  remove-if 
		- (Fun (Lst (*Typevar E))
		       ((Fun Boolean ((*Typevar E)) ())
			(Lst (*Typevar E))
			. Obj) 
		       ())
)

(typedecl 'true 'Boolean nil)
(typedecl 'false 'Null nil)
