;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: lisdcl2.lisp,v 2.12 2006/05/16 14:34:48 dvm Exp $

(depends-on :at-compile-time %ydecl/ tmcdcl)

(depends-on :at-run-time %ydecl/ dclmacs sysdefs
			      strtype plextype listype lisdcl1)

(bind ((allow-ftype* false))
; See comment in datadcl about ALLOW-FTYPE*
(specdecl assoc - (Fun (~ (*Typevar L))
		       ((*Typevar A) 
			(Lst (*Typevar L (Lrcd (*Typevar A) . (*Typevar D)))))
		       ())
          rassoc - (Fun (~ (*Typevar L))
		       ((*Typevar D) 
			(Lst (*Typevar L (Lrcd (*Typevar A) . (*Typevar D)))))
		       ())

	  union intersection
		- (Fun (Lst (*Typevar E))
		       ((Lst (*Typevar E))
			(Lst (*Typevar E)))
		       ())

))

(specdecl dremove1-if dremove-every-if
		- (Fun (Lst (*Typevar E))
		       ((Fun Boolean ((*Typevar E)) ())
			(Lst (*Typevar E))) 
		       T)
	  assocq assq 
		- (Fun (~ (*Typevar L))
		       ((*Typevar A) 
			(Lst (*Typevar L (Lrcd (*Typevar A) . (*Typevar D)))))
		       ())
	  unionq intersectionq complement complementq cmplq
		- (Fun (Lst (*Typevar E))
		       ((Lst (*Typevar E))
			(Lst (*Typevar E)))
		       ())
	  is-Sublist is-Sublistq
		- (Fun Boolean ((Lst Obj) (Lst Obj)) ())
	  nodup nodupq
		- (Fun (Lst (*Typevar E)) ((Lst (*Typevar E))) ())
	  dnodup dnodupq
		- (Fun (Lst (*Typevar E)) ((Lst (*Typevar E))) T)
)

;; Nov.12.87 modified to make fewer, correct assumptions
(specdecl subst= - (Fun Sexp 
			((Fun Boolean (Obj Obj) ()) Sexp Sexp Sexp)
			())
	  member=
	         - (Fun (~ (Lst (*Typevar E)))
			((Fun Boolean ((*Typevar E) (*Typevar E)) ())
			  (*Typevar E) 
			  (Lst (*Typevar E)))
			 ())
	  remove1= remove-every= dremove1= dremove-every=
	  adjoin=
		  - (Fun (Lst (*Typevar E))
			 ((Fun Boolean ((*Typevar E) (*Typevar E)) ())
			  (*Typevar E) 
			  (Lst (*Typevar E)))
			 ())
	  assoc=  - (Fun (~ (*Typevar L))
			 ((Fun Boolean ((*Typevar A) (*Typevar A)) ())
			  (*Typevar A) 
			(Lst (*Typevar L (Lrcd (*Typevar A) . (*Typevar D)))))
		       ())
	  union= intersection= is-Sublist= complement=
	      - (Fun (Lst (*Typevar E))
		     ((Fun Boolean ((*Typevar E) (*Typevar E)) ())
		      (Lst (*Typevar E))
		      (Lst (*Typevar E)))
		     ())
	  nodup= - (Fun (Lst (*Typevar E))
			((Fun Boolean ((*Typevar E) (*Typevar E)) ())
			 (Lst (*Typevar E)))
			())
	  dnodup= - (Fun (Lst (*Typevar E))
			 ((Fun Boolean ((*Typevar E) (*Typevar E)) ())
			  (Lst (*Typevar E)))
			 T)
	  classify - (Fun (Mlv (Lst (*Typevar E)) (Lst (*Typevar E)))
			  ((Lst (*Typevar E))
			   (Fun Boolean ((*Typevar E)))))
	  pop - (Fun (*Typevar E) ((Lst (*Typevar E))) T)
	  off-list - (Fun (*Typevar E) ((Lst (*Typevar E))) T)
	  conset - (Fun Void ((Lst Obj) Obj) T)
	  on-list - (Fun (Lst (*Typevar E)) ((*Typevar E) (Lst (*Typevar E)))))

(specdecl sar - (Fun (*Typevar T) ((Glst (*Typevar T))) ())
          sdr - (Fun (*Typevar L) ((*Typevar L (Glst (*Typevar T)))) ())
          normalize - (Fun (*Typevar L) ((*Typevar L (Glst (*Typevar T)))) ())
)


(datafun decl-compl lazylist
   (defun (x dest-type)
      (!= x (macroexpand-1 *-*))
      ;; X is now of form (LIST (MAKE-*GEN ...))
      (let ((dc (decl-compile (cadr (cadr x))
			      (make-Funtype 'objgenlist
					    nil
					    nil))))
	 (type-trans `(list (make-*gen ,(Dclcmp-exp dc)))
		     (let ((apparent
			      (type-feature (Dclcmp-typ dc) 'resulttype)))
			(cond ((is-subtype apparent 'objlist)
			       (glstype (type-feature apparent 'eltype)))
			      (t apparent)   ))
		     dest-type)   )))

(specdecl one-collect
	    - (Fun Void ((Collector (*Typevar T))
				 (*Typevar T)))
	  list-collect
	    - (Fun Void ((Collector (*Typevar T))
				 (Lst (*Typevar T)))))

(datafun decl-compl collector
   (defun :^ (exp dest-type)
      (let ((coltyp (make-collector-type
		       (cond ((cdr exp) (designated-type (cadr exp)))
			     (t 'obj)))))
	 (type-trans
	    exp coltyp dest-type))))

(datafun decl-compl empty-list
   (defun :^ (exp dest-type)
      (match-cond exp
         ?( ?(:\| (empty-list) (empty-list nil))
	   (type-trans ''() 'Null dest-type))
	 ?( (empty-list ?td)
	   (cond ((eq td '*)
		  (make-Dclcmp (or dest-type 'Null) ''()))
		 (t
		  (let ((ty (check-designated-type td)))
		     (type-trans ''() (lstype ty) dest-type)))))
	 (t
	  (signal-problem empty-list-decl-compl
			  "Ill-formed: " exp)))))

(datafun decl-compl alist-entry
   (defun :^ (exp dest-type)
      (match-cond exp
	 ?( (alist-entry ?ind ?l ?@initial)
	   (let ((l-dc (decl-compile l (designated-type
					  '(Lst (Lrcd Obj Obj))))))
	      (let ((l-type (Dclcmp-typ l-dc)))
		 (let ((pair-type (type-feature l-type 'eltype)))
		    (let ((ind-type (type-feature pair-type 'cartype))
			  (val-type (type-feature
				       (type-feature pair-type 'cdrtype)
				       'cartype)))
		       (let ((ind-dc (decl-compile ind ind-type)))
			  (let ((init-dc
				   (cond ((or (null initial)
					      (memq (car initial)
						    '(false nil)))
					  (type-trans
					     'false 'Boolean val-type))
					 (t
					  (decl-compile
					     (car initial)
					     val-type)))))
			     (type-trans
				`(alist-entry ,(Dclcmp-exp ind-dc)
					      ,(Dclcmp-exp l-dc)
					      ,(Dclcmp-exp init-dc))
				val-type dest-type))))))))
	 (t
	  (signal-problem alist-entry-decl-compl
	     "Ill-formed: " exp)))))
				   
(datafun decl-compl alref.						     
   (defun :^ (exp dest-type)
      (match-cond exp
	 (:? (alref. ?al ?key ?@optionals)
	    (multi-let (((default test acc new-entry)
			 (cond ((null optionals)
				(values 'false '#'eq '#'right 'false))
			       (t
				(let ((optionals-al (keyword-args->alist
						     (rest optionals)
						     '(:test :acc :new-entry)
						     :offset 5)))
				   (values (first optionals)
					   (alref optionals-al ':test '#'eq)
					   (alref optionals-al ':acc '#'right)
					   (alref optionals-al
						  ':new-entry
						  'false)))))))
	       (let ((al-dc (decl-compile
				  al
				  (lstype (lrcdtype 'Obj 'Obj))))
		     (key-dc (decl-compile key false))
		     (def-dc (decl-compile default false))
		     (new-entry-dc (decl-compile new-entry false))
		     )
		  (let-fun ()
		     (let ((test-dc (decl-compile
				       test
				       (make-Funtype 'Boolean
						     (list (Dclcmp-typ key-dc)
							   (Dclcmp-typ key-dc))
						     false)))
			   (acc-dc (acc-analyze)))
		        (type-trans
			    `(alref. ,(Dclcmp-exp al-dc)
				     ,(Dclcmp-exp key-dc)
				     ,(Dclcmp-exp def-dc)
				     :test ,(Dclcmp-exp test-dc)
				     :acc ,(Dclcmp-exp acc-dc)
                                     :new-entry ,(Dclcmp-exp new-entry-dc))
			    (fun-resulttype (Dclcmp-typ acc-dc))
			    dest-type))
		   :where
		      (:def acc-analyze ()
			 (let*  ((elt-type
				    (or (type-feature (Dclcmp-typ al-dc)
						      'eltype)
					'Obj))
				 (ent-type (or (type-feature elt-type
							     'cdrtype)
					       'Obj))
				 (res-type
				    (common-supertype-for-alref
					(match-cond acc
					   (:? ?(:|| #'right #'tail #'cdr)
					      ent-type)
					   (:? ?(:|| #'second #'cadr)
					      (or (type-feature ent-type
								'cartype)
						  'Obj))
					   (t 'Obj))
					(Dclcmp-typ def-dc))))
			    (decl-compile
			       acc
			       (make-Funtype res-type
					     (list (Dclcmp-typ al-dc))
					     false))))))))
      (t
       (signal-problem alref.-decl-compl
	  "Ill-formed: " exp)))))

(defun common-supertype-for-alref (elt-type default-type)
   (cond ((or (null default-type)
	      (memq (Type-desig default-type)
		    '(Null Boolean)))
	  (squiggle elt-type))
	 (t
	  (let ((ctype (common-supertype elt-type default-type)))
	     (cond ((eq (Type-desig ctype)
			'Obj)
		    (designated-type
		       `(Either ,(Type-desig elt-type)
				,(Type-desig default-type))))
		   (t ctype))))))
