;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: listype.lisp,v 2.11 2005/12/26 03:28:53 dvm Exp $

(depends-on :at-run-time %ydecl/ typekern)
(depends-on (:at :compile-time) %ydecl/ deftyp)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(Collector Glst Lrcd Lst elements)))

(!= (type-feature 'Sexp 'eltype) 'Sexp)

;; Nov.4.87 modified
;; (LRCD atype . dtype) is type of dot-pair whose CAR is of atype and CDR is of dtype.
;; (LRCD -type-sexp-) is like LSTRUCTURE, with anonymous fields
;; 5.16.88 Modified LRCD features (IS-builders can't be inherited):
;; 5.27.88 changed #'LST- and #'LRCD-IS-BUILDER to !' to fend off evaluation until available
(datafun type-loader Lrcd
   (defun (def typename)
      (ignore typename)
      (let ((at (cadr def))
	    (dt (lrcd-normalize (cddr def))))
	 `(make-Type (lrcd-massage '(Lrcd ,at . ,dt))
	    'Objlrcd nil
	    (list (list 'cartype ,(type-or-desig-loader at nil))
		  (list 'cdrtype ,(type-or-desig-loader dt nil))
		  (list 'eltype (list '*feature-fcn !'lrcd-eltype-feature))
		  (list 'is-builder !'lrcd-is-builder)
	    ))   )))

(datafun type-loader Tup Lrcd)

;; D is the CDR of an LRCD.  Fix it up if necessary.
;; Nov.4.87 modified
(defun lrcd-normalize (d)
   (cond ((null d) 'Null)       ;was constnil
	 ((is-type-desig d) d)
	 (t `(Lrcd ,(car d) . ,(lrcd-normalize (cdr d))))   ))

;; Nov.4.87 modified
;; 5.16.88 Modified (IS-builders can't be inherited):
(defun lrcdtype (cartype cdrtype)
   (make-Type
      (lrcd-massage `(Lrcd ,(Type-desig cartype) . ,(Type-desig cdrtype)))
      'Objlrcd
      nil
      (list (list 'cartype cartype) 
	    (list 'cdrtype cdrtype)
	    (list 'eltype (lrcd-eltype cartype cdrtype))
	    (list 'is-builder !'lrcd-is-builder)
	    ))   )

;; 5.16.88 added
(defun lrcd-is-builder (ty must-be-defined)
   (let ((at (type-feature ty 'cartype))
	 (dt (type-feature ty 'cdrtype)) 
	 atst dtst)
      (cond ((and at dt)
	     (!= atst (get-is-tester at must-be-defined))
	     (!= dtst (get-is-tester dt must-be-defined))
	     (cond ((and atst dtst)
		    `(lambda (x) 
			(and (is-Pair x)
			     (,atst (car x))
			     (,dtst (cdr x))   )))
		   (t nil)   ))
	    (t nil)   )))

;; (5.27.88 moved LRCD-MASSAGE from listype to types because type-loaders
;;   include calls needed at run-time)

;; Nov.4.87 added (wasn't in fix file, but in Drew's original)
(defun lrcd-eltype-feature (ty feat)
   (ignore feat)
   (lrcd-eltype (type-feature ty 'cartype)
	        (type-feature ty 'cdrtype))   )

;; Nov.4.87 modified
(defun lrcd-eltype (cartype cdrtype)
   (cond ((and cdrtype (not (eq (Type-desig cdrtype) 'Null)))
	  (!= cdrtype (type-feature *-* 'eltype))
	  (cond (cdrtype (common-supertype cartype cdrtype))   
		(t cartype)   ))
	 (t cartype)   ))

;; Added 11.4.87, Changed 7.7.88
(defun null-subtyper (t1 t2 accep)
   (ignore accep)
   (cond ((eq t2 '*im-super) 'Obj)
	 (t
	  (let-fun ((nil-okay (ty)
		       (or (is-subtype ty 'Boolean)
			   (eq (Type-desig ty) 'Sexp)
			   ;(SUBTYPE TY 'Objlrcd NIL)
			   (is-subtype ty 'Objlist)
			   (is-subtype ty 'Objgenlist)
			   (type-feature ty 'null-okay))   ))
	     (cond ((is-subtype t1 'Null)
		    (nil-okay t2))
;		   ((IS-SUBTYPE T2 'Null)
;		    (AND ACCEP (NIL-OKAY T1)))
		   (t nil)   )))   ))

(!= (type-feature 'Null 'subtype-fcn) !'null-subtyper)

;; Nov.12.87 added
(!= (type-feature 'Objlrcd 'initexp) ''(()))

;; (LST type) Changed 4.1.88, 5.16.88
(datafun type-loader Lst
   (defun (def typename)
      (ignore typename)
      `(make-Type ',def 'Objlist nil
                  (list (list 'eltype ,(type-or-desig-loader (cadr def) 
							     nil))
			(list 'is-builder !'lst-is-builder)))
   ))

(defun lstype (eltype)
   (make-Type `(Lst ,(Type-desig eltype)) 'Objlist nil
              (list (list 'eltype eltype)
		    (list 'is-builder !'lst-is-builder)))   )

;; 5.16.88 Added
(defun lst-is-builder (ty must-be-defined)
   (let ((et (type-feature ty 'eltype)) eltst)
      (cond (et
	     (!= eltst (get-is-tester et must-be-defined))
	     (cond (eltst
		    `(lambda (x) (is-list-of x #',eltst)   ))
		   (t nil)   ))
	    (t nil)   )))

;; (GLST type) -- generated list of type.
(datafun type-loader Glst
   (defun (definition typename)
      (ignore typename)
      `(make-Type ',definition 'Objgenlist nil
		 (list (list 'eltype
			      ,(type-or-desig-loader (cadr definition)
						     nil))))   ))

(defun glstype (eltype)
   (make-Type `(Glst ,(Type-desig eltype))
	      'Objgenlist nil
	      (list (list 'eltype eltype)))   )

(defun sexp-subtyper (t1 t2 accep)
   (cond ((eq t2 '*im-super) nil)
         (t (lst-lrcd-subtyper t1 t2 accep))   ))

(defun lst-subtyper  
    (t1 t2 accep)
      (cond ((eq t2 '*im-super)
             (and (!= t2 (Type-im-super (type-feature t1 'eltype)))
                  (make-Type `(Lst ,(Type-desig t2))
                        'Objlist
                        nil
                        (list (list 'eltype t2)))))
            (t
             (lst-lrcd-subtyper t1 t2 accep))   ))

(defun lrcd-subtyper (t1 t2 accep)
      (cond ((eq t2 '*im-super) nil)
            (t (lst-lrcd-subtyper t1 t2 accep))   ))


(defun glst-subtyper (t1 t2 accep)
   (cond ((eq t2 '*im-super)
	  (and (!= t2 (Type-im-super (type-feature t1 'eltype)))
	       (make-Type `(Glst ,(Type-desig t2))
		     'Objgenlist
		     nil
		     (list (list 'eltype t2)))))
	 (t (lst-lrcd-subtyper t1 t2 accep))   ))

(defun lst-lrcd-subtyper (t1 t2 accep)
   (cond ((memq (Type-desig t2) '(Sexp Form))
	  (cond ((is-subtype t1 'Objlist)
		 (subtype (type-feature t1 'eltype)
			  'Sexp accep))
		((is-subtype t1 'Objlrcd)
		 (and (subtype (type-feature t1 'cartype)
			       'Sexp accep)
		      (subtype (type-feature t1 'cdrtype)
			       'Sexp accep)))
		(t nil)   ))
	 ((memq (Type-desig t1) '(Sexp Form))
	  (cond ((not accep) nil)
		((some-list-type t2)
		 (subtype (type-feature t2 'eltype) t1 t))
		(t nil)   ))
	 ((is-subtype t1 'Objgenlist)
	  (cond ((is-subtype t2 'Objgenlist)
		 (subtype (type-feature t1 'eltype)
			  (type-feature t2 'eltype)
			  accep))
		((is-subtype t2 'Objlist)
		 (subtype univ-type*
			  (type-feature t2 'eltype)
			  accep))
		(t nil)   ))
	 ((is-subtype t1 'Objlist)
	  (cond ((some-list-type t2)
		 (subtype (type-feature t1 'eltype)
			  (type-feature t2 'eltype)
			  accep))
		((is-subtype t2 'Objlrcd)
		 (and (subtype (type-feature t1 'eltype)
			       (type-feature t2 'cartype)
			       accep)
		      (let ((t2 (type-feature t2 'cdrtype)))
			 (or (null t2)
			     (subtype t1 t2 accep))   )))
		(t nil)   ))
	 ((is-subtype t1 'Objlrcd)
	  (cond ((some-list-type t2)
		 (and (subtype (type-feature t1 'cartype)
			       (type-feature t2 'eltype)
			       accep)
		      (let ((t1 (type-feature t1 'cdrtype)))
			 (or (null t1)
			     (subtype t1 t2 accep))   )))
		((is-subtype t2 'Objlrcd)
		 (or (is-subtype t1 t2)
		     (and (subtype (type-feature t1 'cartype)
				   (type-feature t2 'cartype)
				   accep)
			  (progn (!= t1 (type-feature t1 'cdrtype))
				 (!= t2 (type-feature t2 'cdrtype))
				 (cond ((or (null t1) (null t2))
					(and (null t1) (null t2)))
				       (t (subtype t1 t2 accep))   )))))
		(t nil)   ))
	 (t nil)   ))

(defun some-list-type (ty)
   (or (is-subtype ty 'Objgenlist) (is-subtype ty 'Objlist))   )

(!= (type-feature 'Objlrcd 'subtype-fcn) !'lrcd-subtyper)
(!= (type-feature 'Objlist 'subtype-fcn) !'lst-subtyper)
(!= (type-feature 'Objgenlist 'subtype-fcn) !'glst-subtyper)

(declare-type-acceptable 'Objgenlist 'Objlist)

;; deleted 5.16.88
;(DEFUN LST-FILLER (TY SLOT WANTED)
;   (COND ((AND (EQ SLOT 'IS) (EQ WANTED 'ACC))
;          (LET ((ET (TYPE-FEATURE TY 'ELTYPE)) ELTST)
;             (COND (ET
;                    (!= ELTST (TYPE-SLOT-FUN ET 'IS 'ACC NIL))
;                    (COND (ELTST
;                           `(LAMBDA (X) (IS-LIST-OF X !',ELTST)   ))
;                          (T NIL)   ))
;                   (T NIL)   )))
;         (T NIL)   ))

;(!= (TYPE-FEATURE 'Objlist 'SLOT-FILLER-FCN) !'LST-FILLER)

(deftype Objcol Obj)

(datafun type-loader Collector 
   (defun :^ (definition _)
      (let ((lsteltyvar (gensym)))
	 `(let ((,lsteltyvar ,(type-loader
			         `(Lst ,(cadr definition))
				 false)))
	     (make-Type ',definition 'Objcol
			(list (make-Slot 'conser
					 '(*integrable () (empty-Collector))
					 false false '())
			      (make-Slot 'elements
					 'Collector-elements
					 false ,lsteltyvar '()))
			
			(list (list 'subtype-fcn #'col-subtyper)
			      (list 'eltype
				    (type-feature ,lsteltyvar 'eltype))))))))

(defun col-subtyper (t1 t2 accep)
;;;;   (out (tr col-subtyper ("col-subtyper> " t1 1 t2 1 accep)
      (cond ((eq t2 '*im-super)
             (and (!= t2 (Type-im-super (type-feature t1 'eltype)))
                  (make-collector-type t2)))
            ((and (is-subtype t1 'Objcol)
		  (is-subtype t2 'Objcol))
	     (subtype (type-feature t1 'eltype)
		      (type-feature t2 'eltype)
		      accep))
	    (t false))
;;;;      ("col-subtyper< " (car out-vals*))))
)

(defun make-collector-type (elty)
   (make-Type `(Collector ,(Type-desig elty))
      'Objcol
      (list (make-Slot 'elements 'Collector-elements false
		       (lstype elty) '()))
      (list (list 'eltype elty))))
	    
(defun collector-is-builder (ty must-be-defined)
   (let ((et (type-feature ty 'eltype)))
      (let ((eltst (get-is-tester et must-be-defined)))
	 (cond (eltst
		`(lambda (x)
		    (and (is-Collector x)
			 (is-list-of (Collector-elements x)
				     #',eltst))))
	       (t false)))))
