;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: mgcdcl.lisp,v 2.11 2005/12/26 03:28:53 dvm Exp $

;;; Copyright 1988 - 2002, Drew McDermott, Yale University

(depends-on :at-run-time %ydecl/ dclmacs sysdefs
			      strtype plextype listype hostypes)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(be)))

(datafun decl-compl make-Object
   (defun (exp dest-type)
      (type-trans
         `(make-Object ,(struc-clauses-massage (cadr exp) defining*)
		       ,@(<# compile-to-notype (cddr exp)))
	 'Obj dest-type)))

(eval-when (:compile-toplevel :load-toplevel)
   (defun zilch-decl-compl (exp dest-type)
      (type-trans exp 'Void dest-type)))

(eval-when (:load-toplevel)
   (datafun decl-compl dskin !'zilch-decl-compl)
   (datafun decl-compl dsklap !'zilch-decl-compl)
   (datafun decl-compl declare !'zilch-decl-compl))

;(DATAFUN DECL-COMPL IGNORE !'ZILCH-DECL-COMPL)

(datafun decl-compl ignore
   (defun (e dest-type)
      (make-Dclcmp dest-type
		   `(declare (cl:ignore ,@(cdr e))))))

;; (87.9.30: Moved EARROR-DECL-COMPL from MGCDCL to IODCL and redefined)
 
(datafun decl-compl quote
  (defun (exp dest-type)
    (cond ((not (= (length exp) 2))
	   (signal-problem quote-decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (type-trans exp
		       (constype (cadr exp))
		       ;;(COND ((NUMBERP (CADR EXP)) (ATOMTYPE (CADR EXP)))
		       ;;((SYMBOLP (CADR EXP)) 'symbol)
		       ;;(T 'sexp))
		       dest-type)))))

;; What would the type of ',C be?
(defun constype (c)
   (cond ((atom c) (atomconstype c))
	 (t
	  (lrcdtype (constype (car c)) (constype (cdr c))))))

(datafun decl-compl \;
(defun (exp dest-type)
    (ignore exp)
    (type-trans '(\;) 'Void dest-type)))

(defmacro ptr (exp) `(betype nil ,exp))

(defmacro betype (ty exp) (ignore ty) exp)


;; 87.9.28: Changed
;; Now accepts (BE * x), meaning, "Take x to be desired type, whatever it is,
;; and don't tell Common Lisp."
;; (BE () x) means something different, roughly, "Give me x as if this were
;; ordinary Lisp, and suppress any unusual coercions."  Since, as far as I
;; know, there are no unusual coercions in existence nowadays, the locution
;; is of little use.
;; 87.10.8 Changed 88.9.7 again
(datafun decl-compl be
  (defun (exp dest-type)
    (cond ((not (= (length exp) 3))
	   (signal-problem be-decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (let ((td (cadr exp)))
	     (let ((ty (and (not (memq td '(nil () *)))
			    (check-designated-type td)))
		   ;; 'Obj used to be '*NOTRANS which some decl-compl prop
		   ;; confused with a type (POP-DECL-COMPL applies LSTYPE
		   ;; to it with desastrous result). I think 'Obj should do
		   ;; just fine.
		   (edc (decl-compile (caddr exp) 'Obj)))
	       (!= exp (Dclcmp-exp edc))
;;;;	       (if (and ty (not (car-eq td '~)))
;;;;		   (let ((hty (nisp->hostype ty)))
;;;;		     (if (and hty (not (eq hty 't)) (not (car-eq hty 'function)))
;;;;			 (!= exp `(the ,hty ,exp)))))
               (let ((dc (cond ((eq td '*)
                                (make-Dclcmp (or dest-type (Dclcmp-typ edc))
                                             exp))
                               ((null ty)
                                (type-trans exp (Dclcmp-typ edc) dest-type))
                               (t
                                (type-trans exp ty dest-type)))))
                  (cond (ty
                         (maybe-wrap-the dc ty dest-type))
                        (t dc)))))))))

(datafun decl-compl betype be)

(define-setf-expander be (type ob)
   (multi-let (((intrnvars intrnforms storevars storeform accform)
		(get-setf-expansion ob)))
      (values intrnvars intrnforms storevars storeform `(be ,type ,accform))))

(defmacro ptr-set (&rest e) `(!= ,@e))
(defsetf ptr ptr-set)

(datafun decl-compl !=
  (defun (exp dest-type)
    (cond ((not (>= (length exp) 3)) ;can be != < ...
	   (signal-problem !=-decl-compl :fatal
	     0 "Too few arguments: " exp))
	  (t
	   (let ((lft (cadr exp)) (rgt (cddr exp)))
	     (match-cond lft
	       ?(< 
		 (decl-compile (multiple-value-!= rgt) dest-type))
	       ?((> ?@l)
		 (decl-compile `(multiple-value-setq ,(remove '< l :count 1) ,rgt) 
			       dest-type))
	       ?((< ?@vl)
		 (!= vl (remove '> *-* :count 1))
		 (let ((types (<# symtype vl)))
		   (let ((rdc (decl-compile (car rgt) (types-lrcdtype types))))
		     (type-trans
		      `(yt::spreadem ,@vl ,(Dclcmp-exp rdc))
		      'Void
		      dest-type))))
	       (t
		(cond ((not (null (cdr rgt)))
		       (signal-problem !=-decl-compl
			  "Excess arguments in != form: " exp
			  (:continue "I will ignore them"))))
		(setf-compile '!= lft (car rgt) dest-type))))))))

;;;;		(let ((lftdc (decl-compile lft false)))
;;;;		   (let ((rgtdc (with-declarations '(*-*) (list (Dclcmp-typ lftdc))
;;;;				   (decl-compile (car rgt) (Dclcmp-typ lftdc)))))
;;;;		      (let ((newlft (Dclcmp-exp lftdc))
;;;;			    (newrgt (Dclcmp-exp rgtdc)))
;;;;			 (make-Dclcmp
;;;;			    (Dclcmp-typ rgtdc)
;;;;			    `(setf ,newlft ,newrgt))))))))))))

(defun types-lrcdtype (types)
   (cond ((null types) 'Null)
	 (t (lrcdtype (car types) (types-lrcdtype (cdr types))))))

(defvar setf-in-decl* false)
(defvar accform-type*)

(defun setf-compile (op lft rgt dest-type)
   (ignore op)
   (let (lftdc rgtdc (be* false) no-op)
      ;; Normally we must check lft first so we know the type of *-*.
      ;; However, the (be * ...) construction requires us to check rgt
      ;; first, thus making it impossible to refer to *-*.
      (match-cond lft
         ?((be * ?v)
	   (!= be* true)
	   ;;--remove the BE wrapping otherwise SETF will be confused
	   (!= lft v)))
      (!= no-op (eq lft '_))
      ;; 'intrn' means "internval forms of lft"
      ;; The setf-in-decl* kludge communicates with !_-decl-compl (in tmcdcl)
      (bind ((setf-in-decl* true)
	     (accform-type* false))
;;;;	 (out "Getting setf expansion of " lft :%)
	 (multi-let (((intrnvars intrnforms storevars storeform accform)
		      (get-setf-expansion lft)))
;;;;	    (out "got setf expansion" :% :%)
	    (cond (no-op
		   (!= storeform (car storevars))))
            (let ((lft-type accform-type*))
	       ;; We must do the following with a loop to get let* semantics.
	       (bind ((vartypes* vartypes*))
		  (let ((intrndcs
			   (repeat :for ((var :in intrnvars)
					 (form :in intrnforms)
					 :collector intrndcs)
			    :within
			      (let ((form-dc (decl-compile form false)))
				 (:continue :collect form-dc)
				 (!= vartypes*
				     (cons (make-Vartype
					      var (Dclcmp-typ form-dc)
					      (Dclcmp-exp form-dc)
					      !())
					   *-*))))))
   ;;;;		  (out "binding vartypes* to " vartypes* :%)
   ;;;;		  (breakpoint setf-compile "huh?")
		     (let-fun ()
			(cond (be*
			       (!= rgtdc (decl-compile rgt dest-type))
			       (!= lftdc
				   (make-Dclcmp (Dclcmp-typ rgtdc)
						(Dclcmp-exp (compile-accform 'Obj)))))
			      (t
			       (!= lftdc (compile-accform false))
;;;;			       (dbg-save lftdc rgt lft accform lft-type)
;;;;			       (breakpoint setf-compile
;;;;				  "About to declare *-* of type "
;;;;				  (or lft-type (Dclcmp-typ lftdc)))
			       (!= rgtdc
				   (with-declarations
					   '(*-*)
					   (list (or lft-type (Dclcmp-typ lftdc)))
				      (decl-compile rgt (Dclcmp-typ lftdc))))))
			(let ((rgt-exp 
				  (cond ((occurs-in '*-* rgt)
					 `(let ((*-* ,(Dclcmp-exp lftdc)))
					    (declare (ignorable *-*))
					    ,(Dclcmp-exp rgtdc)))
					(t (Dclcmp-exp rgtdc)))))

			   (type-trans
			      `(let* ,(<# (\\ (v dc) (tuple v (Dclcmp-exp dc)))
					 intrnvars intrndcs)
				  ,(cond ((= (len storevars) 1)
					  `(let ((,(car storevars) ,rgt-exp))
					      ,(storeform-if-not-no-op)))
					 (t
					  `(multiple-value-let ,storevars
							       ,rgt-exp
					      ,(storeform-if-not-no-op)))))
			      (Dclcmp-typ rgtdc)
			      dest-type))

		       :where
		          (:def storeform-if-not-no-op ()
			      (cond (no-op `(declare (ignore ,@storevars)))
				    (t storeform)))

			  (compile-accform (to-type)
      ;;;;			  (cond ((car-eq lft 'alist-entry)
      ;;;;				 (dbg-save lft intrnvars intrnforms storevars
      ;;;;					   storeform accform)
      ;;;;				 (breakpoint compile-accform
      ;;;;				    "About to check " accform)))
   ;;;;			  (with-vartypes (<# (\\ (ivar idc)
   ;;;;						(make-Vartype ivar (Dclcmp-typ idc)
   ;;;;							      (Dclcmp-exp idc) nil))
   ;;;;					     intrnvars intrndcs) ...)
			     (decl-compile accform to-type))))))))))

(defun setf-left-unchanged (newlft lft)
   (cond ((car-eq newlft 'the)
	  (setf-left-unchanged (caddr newlft) lft))
	 (t
	  (or (atom newlft)
	      (and (is-Pair lft)
		   (eq (car newlft) (car lft)))))))

(datafun decl-compl setf
  (defun (exp dest-type)
    (cond ((not (= (length exp) 3))
	   (signal-problem setf-decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (let ((lft (cadr exp)) (rgt (caddr exp)))
	     (setf-compile 'setf lft rgt dest-type))))))

(datafun decl-compl setq
  (defun (exp dest-type)
    (cond ((not (= (length exp) 3))
	   (signal-problem setq-decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (let ((vexp (decl-compile (caddr exp) (symtype (cadr exp)))))
	     (type-trans `(setq ,(cadr exp) ,(Dclcmp-exp vexp))
			 (Dclcmp-typ vexp) dest-type))))))


(datafun decl-compl mapcar
   (defun (exp dest-type)
      (mapper-decl-compl 0 nil exp 
			 (\\ (ty lt) (ignore lt) (lstype ty))
			 dest-type)))

(datafun decl-compl mapeltlist mapcar)
(datafun decl-compl mapeltlist mapcar)

(datafun decl-compl maptaillist
   (defun (exp dest-type)
      (mapper-decl-compl 0 t exp 
			 (\\ (ty lt) (ignore lt) (lstype ty))
			 dest-type)))

(datafun decl-compl mapcan
   (defun (exp dest-type)
      (mapper-decl-compl 0 nil exp 
			 (\\ (ty lt) (ignore lt) ty   )
			 dest-type)))

(datafun decl-compl mappend mapcan)
(datafun decl-compl mapeltconc mapcan)
(datafun decl-compl mapelemconc mapcan)

(datafun decl-compl maptailconc
   (defun (exp dest-type)
      (mapper-decl-compl 0 t exp 
			 (\\ (ty lt) (ignore lt) ty   )
			 dest-type)))

(datafun decl-compl mapeltappend mapcan)
(datafun decl-compl mapelemappend mapcan)
(datafun decl-compl maptailappend maptailconc)

;; 87.9.28 Changed
(datafun decl-compl mapeltor
   (defun (exp dest-type)
      (mapper-decl-compl 0 nil exp 
			 (\\ (ty lt) (ignore ty)
			      (cond ((= (len lt) 1) (lstype (car lt)))
				    (t (mlv-type (<# lstype lt)))))
			 dest-type)))

(datafun decl-compl mapelemor mapeltor)

(datafun decl-compl maptailor
   (defun (exp dest-type)
      (mapper-decl-compl 0 t exp 
			 (\\ (ty lt) (ignore ty)
			      (cond ((= (len lt) 1) (lstype (car lt)))
				    (t (mlv-type (<# lstype lt)))))
			 dest-type)))

;(DATAFUN DECL-COMPL MAPELTCOLLECT MAPELTOR)
(datafun decl-compl remove-if
  (defun (exp dest-type)
    (mapper-decl-compl 0 nil exp
		       (\\ (ty lt)
			  (when (not (or (subtype ty 'Boolean t)
				         (eq (try-coerce-to-nisptype ty) univ-type*)))
			   (signal-problem mapeltcollect :continue
			      0 "Expected the result type of the function to be a"
			      :% "subtype of Boolean. Found: " ty
			      :% "OK to continue."))
			  (lstype (lastelt lt)))
		       dest-type)))

(datafun decl-compl mapeltcollect remove-if)
(datafun decl-compl mapelemcollect remove-if)

(datafun decl-compl maptailcollect
  (defun (exp dest-type)
    (mapper-decl-compl 0 t exp
		       (\\ (ty lt)
			  (when (not (or (subtype ty 'Boolean t)
				         (eq (try-coerce-to-nisptype ty) univ-type*)))
			   (signal-problem mapeltcollect :continue
			       0 "Expected the result type of the function to be a"
			       :% "subtype of Boolean. Found: " ty
			       :% "OK to continue."))
			  (lstype (lastelt lt)))
		       dest-type)))

;(DATAFUN DECL-COMPL MAPTAILCOLLECT
;   (DEFUN (EXP DEST-TYPE)
;      (MAPPER-DECL-COMPL 0 T EXP 
;			 (\\ (TY LT) (IGNORE TY) (LSTYPE (LASTELEM LT)))
;			 DEST-TYPE)))

(datafun decl-compl mapeltand
   (defun (exp dest-type)
      (mapper-decl-compl 0 nil exp 
			 (\\ (ty lt) (ignore ty lt) 'Boolean   )
			 dest-type)))

(datafun decl-compl mapelemand mapeltand)

(datafun decl-compl maptailand
   (defun (exp dest-type)
      (mapper-decl-compl 0 t exp 
			 (\\ (ty lt) (ignore ty lt) 'Boolean   )
			 dest-type)))

(datafun decl-compl mapreduce
   (defun (exp dest-type)
      (mapper-decl-compl 1 nil exp 
			 (\\ (ty lt) (ignore lt) ty   ) 
			 dest-type)))

;;;;(datafun decl-compl mapelemreduce mapeltreduce)

(datafun decl-compl maptailreduce
   (defun (exp dest-type)
      (mapper-decl-compl 1 t exp 
			 (\\ (ty lt) (ignore lt) ty   ) 
			 dest-type)))

;; 87.9.28: Added
(datafun decl-compl mapeltdo
  (defun (exp dest-type)
    (mapper-decl-compl 0 nil exp
		       (\\ (ty lt) (ignore ty lt) void-type*)
		       dest-type)))

(datafun decl-compl mapelemdo mapeltdo)

(datafun decl-compl maptaildo
  (defun (exp dest-type)
    (mapper-decl-compl 0 t exp
		       (\\ (ty lt) (ignore ty lt) void-type*)
		       dest-type)))

;; 87.9.28 Added
(datafun decl-compl mapeltsome
   (defun (exp dest-type)
      (mapper-decl-compl 0 nil exp
			 (\\ (ty lt) (ignore lt) ty   )
			 dest-type)))

(datafun decl-compl mapelemsome mapeltsome)

(datafun decl-compl maptailsome
   (defun (exp dest-type)
      (mapper-decl-compl 0 t exp
			 (\\ (ty lt) (ignore lt) ty   )
			 dest-type)))


;; XTYPEFN takes the result type of the function being mapped, and returns
;; the result of the whole map operation.  NONLISTS is the number of
;; nonlist arguments; 0 except for MAP...REDUCE.
(defun mapper-decl-compl (nonlists dot exp xtypefn dest-type)
  (cond ((not (>= (length exp) (+ 3 nonlists)))
	 (signal-problem mapper-decl-compl :fatal
	   0 "Too few arguments: " exp))
	(t
	 (multiple-value-let (explicit-lambda bvars body rtype)
			     (funarg-analyze (cadr exp))
	   (cond ((and explicit-lambda (not (types-in-arglist bvars)))
		  (nodecl-mapper 
		   nonlists dot exp bvars body rtype xtypefn dest-type))
		 (t 
		  (decl-mapper nonlists dot exp xtypefn dest-type)))))))

;; In the case where all the variables are untyped, their types should
;; be obtained from the lists being mapped over.
(defun nodecl-mapper (nonlists dot exp bvars body rtype xtypefn dest-type)
  (cond ((not (>= (length exp) (+ 3 nonlists)))
	 (signal-problem mapper-decl-compl :fatal
	   0 "Too few arguments: " exp))
	(t
	 (let ((nonlistargs (take nonlists (cddr exp)))
	       (listargs (nthcdr nonlists (cddr exp))))
	   (let ((nonlistargdcs (<# (\\ (a) (decl-compile a nil)   ) 
				    nonlistargs))
		 (listargdcs (<# (\\ (a) (decl-compile a 'Objlist)   )
				 listargs))
		 fundc atypes)
	     (!= atypes (<# Dclcmp-typ listargdcs))
	     (cond ((not dot)
		    (!= atypes (<# (\\ (atype)
				       (or (type-feature atype 'eltype)
					   'Obj)   )
				   *-*)))   )
	     (!= atypes (nconc (<# Dclcmp-typ nonlistargdcs) *-*))
	     (!= fundc (explicit-lambda-compile 
			(or rtype univ-type*) bvars atypes body exp))
	     (type-trans `(,(car exp) ,(Dclcmp-exp fundc)
				      ,@(<# Dclcmp-exp nonlistargdcs)
				      ,@(<# Dclcmp-exp listargdcs))
			 (funcall xtypefn (fun-resulttype (Dclcmp-typ fundc))
			   atypes)
			 dest-type)   )))))

; 1992.7.30: Did not handle functions with DOT argtypes.
(defun decl-mapper (nonlists dot exp xtypefn dest-type)
   (let ((fundc (decl-compile (cadr exp) nil)) atypes catypes)
      (cond ((is-Funtype (Dclcmp-typ fundc))
	     (!= atypes (fun-argtypes (Dclcmp-typ fundc)))
	     (!= catypes atypes)
	     (cond ((not dot) 
		    (!= catypes 
			(let-fun ((argtypes-listify (k atypes)
				     (cond ((= k 0)
					    (<# (\\ (x)
						   (cond ((eq x 'dot) 'dot)
							 (t (lstype x))   ))
						atypes))
					   ((null atypes)
					    (signal-problem decl-mapper :fatal
					       0 "Wrong number of arguments: "
					       exp))
					   ((eq (car atypes) 'dot)
					    (cons (cadr atypes)
						  (argtypes-listify (- k 1)
								    atypes)))
					   (t
					    (cons (car atypes)
						  (argtypes-listify
						     (- k 1)
						     (cdr atypes))))   )))
			    (argtypes-listify nonlists catypes)   )))   )
	     (multiple-value-let (argl tsub)
				 (matchargs (cddr exp) catypes exp nil)
	           ;;(!= ARGL (COERCE-ARGS (CDDR EXP) CATYPES EXP))
		(!= argl (<# Dclcmp-exp *-*))
		(type-trans `(,(car exp) ,(Dclcmp-exp fundc) ,@argl)
			    (funcall xtypefn 
				     (type-subst 
					 tsub
					 (fun-resulttype (Dclcmp-typ fundc)))
				     atypes)
			    dest-type)))
	    (t
	     (type-trans `(,(car exp) ,(Dclcmp-exp fundc)
			    ,@(<# compile-to-notype (cddr exp)))
			 'Obj dest-type))   )))

(datafun decl-compl apply
  (defun (exp dest-type)
    (multiple-value-let
	(explicit bvars body rtype)
	(funarg-analyze (cadr exp))
      (cond ((and explicit (not (types-in-arglist bvars)))
	     (nodecl-apply bvars body exp rtype dest-type))
	    (t (decl-apply exp dest-type))   ))))

;; Added 9.28.87, split/changed 7.7.88
(defun nodecl-apply (bvars body exp rtype dest-type)
    (let-fun ((apply-argtypes (argdcs)
		 (cond ((null (cdr argdcs))
			(listype-argtypes 
			   (Dclcmp-typ (car argdcs))))
		       (t
			(cons (Dclcmp-typ (car argdcs))
			      (apply-argtypes (cdr argdcs)))))))
      (let ((argdcs (<# (\\ (e) (decl-compile e nil))
			(cddr exp))))
	(let ((fundc 
	         (explicit-lambda-compile 
                    (or rtype dest-type)
                    bvars (apply-argtypes argdcs) 
                    body exp)))
	  (type-trans 
             `(apply ,(Dclcmp-exp fundc)
                     ,@(<# Dclcmp-exp argdcs))
             (fun-resulttype (Dclcmp-typ fundc))
             dest-type)))))

;; Added 7.7.88 (extracted from NODECL-APPLY)
(defun listype-argtypes (ltype)
		 (cond ((is-subtype ltype 'Objlrcd)
			(cons (type-feature ltype 'cartype)
			      (listype-argtypes 
			         (type-feature ltype 'cdrtype))))
		       (t 
			(let ((et (type-feature ltype 'eltype)))
			  (cond (et `(dot ,et))
				(t nil)   )))   ))

(defun decl-apply (exp dest-type)
    (let-fun ((arg-listypes (atypes argl)
		 (cond ((null (cdr argl))
			(list (arg-lrcdtype atypes)))
		       ((null atypes) 
			(wna-msg 'toomany exp)
			nil)
		       ((eq (car atypes) 'dot)
			(cons (cadr atypes) 
			      (arg-listypes atypes (cdr argl))))
		       (t
			(cons (car atypes) 
			      (arg-listypes (cdr atypes) 
					    (cdr argl))))   ))
	      (arg-lrcdtype (atypes)
		 (cond ((null atypes) 'Void) ;was constnil
		       ((eq (car atypes) 'dot) 
			(lstype (cadr atypes))) 
		       (t (lrcdtype (car atypes) 
				    (arg-lrcdtype (cdr atypes))))))) 

      (let ((fundc (decl-compile (cadr exp) nil)) funty compilefn)
	(!= funty (Dclcmp-typ fundc))
	(!= compilefn (type-feature funty 'decl-compl))
	(cond (compilefn
	       (funcall compilefn funty (Dclcmp-exp fundc) exp dest-type))
	      ((is-Funtype funty)
	       (multiple-value-let (args tsub)
		   (matchargs (cddr exp)
			      (arg-listypes (fun-argtypes funty) (cddr exp))
			      exp nil)
		 (type-trans
		  `(apply ,(Dclcmp-exp fundc) ,@(<# Dclcmp-exp args))
		  (type-subst tsub (fun-resulttype funty))
		  dest-type)))
	      (t (type-trans
		  `(apply ,(Dclcmp-exp fundc) ,@(<# compile-to-notype (cddr exp)))
		  univ-type*
		  dest-type))   ))))

;; (87.9.28: Moved EXPLICIT-LAMBDA-COMPILE to DCLMACS)

(datafun decl-compl values
   (defun (e dest-type)
      (cond ((and dest-type (is-subtype dest-type 'Objmultiple))
	     (let ((adcs (one-value 
			    (matchargs (cdr e) 
				       (type-feature dest-type 'valtypes)
				       e nil))))
		(make-Dclcmp
		   (mlv-type (<# Dclcmp-typ adcs))
		   `(values ,@(<# Dclcmp-exp adcs)))   ))
	    (t
	     (let ((adcs (<# (\\ (a) (decl-compile a nil)   )
			     (cdr e))))
		(type-trans
		   `(values ,@(<# Dclcmp-exp adcs))
		   (mlv-type (<# Dclcmp-typ adcs))
		   dest-type)  ))   )))

(datafun decl-compl one-value 
  (defun (e dest-type)
    (cond ((not (= (length e) 2))
	   (signal-problem one-value-decl-compl :fatal
	     0 "Wrong number of arguments: " e))
	  (t
	   (let ((adc (decl-compile (cadr e) nil)))
	     (type-trans
	      `(one-value ,(Dclcmp-exp adc))
	      (cond ((is-subtype (Dclcmp-typ adc) 'Objmultiple)
		     (argtypes-first (type-feature (Dclcmp-typ adc) 'valtypes)))
		    (t (Dclcmp-typ adc))   )
	      dest-type)   )))))   

;;;--changed DESIGNATED-TYPE to COERCE-TO-NISPTYPE because the
;;;--argument may already be a nisptype. not necessarily a designator. 
(defun argtypes-first (atl)
   (cond ((null atl) 'Void)
	 ((eq (car atl) 'dot) (coerce-to-nisptype (cadr atl)))
	 (t (coerce-to-nisptype (car atl)))   ))

(datafun decl-compl list->values 
  (defun (e dest-type)
    (cond ((not (= (length e) 2))
	   (signal-problem list->values-decl-compl :fatal
	     0 "Wrong number of arguments: " e))
	  (t
	   (let ((adc (decl-compile (cadr e) (lstype univ-type*))))
	     (type-trans
                `(list->values ,(Dclcmp-exp adc))
                (mlv-type (listype-argtypes (Dclcmp-typ adc)))
                dest-type)   )))))

(datafun decl-compl multiple-value-list 
  (defun (e dest-type)
    (cond ((not (= (length e) 2))
	   (signal-problem multiple-value-list-decl-compl :fatal
	     0 "Wrong number of arguments: " e))
	  (t
	   (let ((adc (decl-compile (cadr e) nil)))
	     (type-trans
	      `(multiple-value-list ,(Dclcmp-exp adc))
	       (cond ((is-subtype (Dclcmp-typ adc) 'Objmultiple)
		      (letrec ((lrcdify (tylist)
				  (cond ((null tylist)
					 'Null)
					(t
					 (lrcdtype (car tylist)
						   (lrcdify (cdr tylist)))))))
			 (lrcdify 
			    (type-feature (Dclcmp-typ adc) 'valtypes))))
		     (t
		      (lstype univ-type*)))
	      dest-type)   )))))

(datafun decl-compl values->list multiple-value-list)

;; 87.9.30: Changed
(defun argtypes-common-supertype (atypes)
   (cond ((null atypes) 'Void)
	 ((eq (car atypes) 'dot) (lstype (cadr atypes)))
	 (t
	  (common-supertype (car atypes)
			    (argtypes-common-supertype (cdr atypes))))   ))

(datafun decl-compl nth-value
   (defun :^ (exp dest-type)
      (match-cond exp
	 ?( (nth-value ?n ?form)
	   (let ((fdc (decl-compile form 'Objmultiple))
		 (ndc (decl-compile n 'Integer)))
	      (let ((vtl (type-feature (Dclcmp-typ fdc) 'valtypes)))
		 (let ((res-type
			  (cond ((is-Integer n)
				 (cond ((or (< n 0)
					    (>= n (len vtl)))
					(signal-problem nth-value-decl-compl
					   "Arg " n " out of bounds in "
					   :% exp
					   (:continue
					      !"A run-time error will ~
						probably ensue")))
				       (t (nth n vtl))))
				(t
				 (argtypes-common-supertype vtl)))))
		    (type-trans
		       `(nth-value ,(Dclcmp-exp ndc)
				   ,(Dclcmp-exp fdc))
		       res-type
		       dest-type)))))
	 (t
	  (signal-problem nth-value-decl-compl
	     "Ill-formed: " exp)))))

;;; Drew 7/21/89 added (VARS-DECLARATIONS)
(datafun decl-compl multiple-value-let
   (defun (e dest-type)
      (let (vars a body types)
	 (matchq (multiple-value-let ?vars ?a ?@body) e)
	 (!= < vars types > (types-separate vars nil nil))
	 (let ((adc (decl-compile a 
			(cond ((<& null types) 'Objmultiple)
			      (t (mlv-type (designated-argtypes types)))   ))))
	    (with-vartypes (mlv-let-vartypes vars types adc e)
	       (let ((bdc (body-compile body dest-type)))   
		  (make-Dclcmp
		     (Dclcmp-typ bdc)
		     `(multiple-value-let ,vars ,(Dclcmp-exp adc)
			 ,@(var-declarations)
			 ,@(var-setups)
			 ,@(Dclcmp-exp bdc)   ))   ))))))

(defun mlv-let-vartypes (vl tl adc exp)
   (cond ((<& null tl)
	  (explicit-lambda-vartypes 
	     vl (type-feature (Dclcmp-typ adc) 'valtypes) exp))
	 (t 
	  (<# (\\ (v ty) (initvartype v (designated-type ty) '*noinit)   )
	      vl tl))   ))

(datafun decl-compl multiple-value-call
   (defun (e dest-type)
      (let (bvars body)
         (cond ((or (matchq (\\ ?bvars ?@body) (cadr e))
                    (matchq (function (lambda ?bvars ?@body)) (cadr e)))
                (multiple-value-let (vl tl)
                                    (types-separate bvars nil nil)
                   (cond ((<& null tl)
                          (nodecl-mlv-call vl body (caddr e) dest-type))
                         (t
                          (decl-mlv-call e dest-type))   )))
              (t (decl-mlv-call e dest-type))   ))))

;; E is of form (MULTIPLE-VALUE-CALL F A) where F has its own
;; argument declarations.
;; Drew 88.3.6 changed DECL-COMPILE to DECL-COMPILE-EXP
(defun decl-mlv-call (e dest-type)
   (let ((fdc (decl-compile (cadr e) 'Objfun)))
      (let ((atypes (fun-argtypes (Dclcmp-typ fdc))))
         (type-trans
            `(multiple-value-call
                ,(Dclcmp-exp fdc)
                ,(decl-compile-exp
                               (caddr e)
                               (make-Type `(mlv ,@(<# Type-desig atypes))
                                          'Objmultiple
                                          nil
                                          (list (list 'valtypes atypes)))))
            (fun-resulttype (Dclcmp-typ fdc))
            dest-type)   )))

;; VL is arglist of explicit LAMBDA that occurred as function of
;; MULTIPLE-VALUE-CALL. BODY is its body.  Declare
;; variables appropriately while compiling body.
(defun nodecl-mlv-call (vl body exp dest-type)
   (let ((adc (decl-compile (caddr exp) 'Objmultiple))
         atypes)
      (cond ((is-subtype (Dclcmp-typ adc) 'Objmultiple)
             (!= atypes (type-feature (Dclcmp-typ adc) 'valtypes))
             (with-vartypes (explicit-lambda-vartypes vl atypes exp)
                (!= body (body-compile body dest-type))
		(type-trans
		   `(multiple-value-call
		       (function (lambda ,vl 
				    ,@(var-setups)
				    ,@(Dclcmp-exp body)  ))
		       ,(Dclcmp-exp adc))
		   (Dclcmp-typ body)
		   dest-type)   ))
           (t (decl-mlv-call exp dest-type))   )))

(datafun decl-compl multiple-value-setq
  (defun (exp dest-type)
    (cond ((not (= (length exp) 3))
	   (signal-problem multiple-value-setq-decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (let (vars a types adc)
	     (matchq (multiple-value-setq ?vars ?a) exp)
	     (!= types (<# symtype vars))
	     (!= adc (decl-compile a (mlv-type types)))
	     (type-trans
	      `(multiple-value-setq ,vars ,(Dclcmp-exp adc))
	      'Void
	      dest-type)   )))))
