;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: multiletdcl.lisp,v 2.10 2005/12/26 00:46:18 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)

(depends-on %ydecl/ dclmacs)

;;; Variable declarations in multi-let are tricky, because we want
;;; to allow them to occur in two places:
;;; (multi-let (((r - Float i - Integer)
;;;              (foo ...))
;;;             (x (baz1)) (y (baz2)) - Float)
;;;   -body-)

(datafun decl-compl multi-let
   (defun :^ (exp dest-type)
      (let-fun ()
	 (match-cond exp
	    ?( (?_ ?bindspecs ?@body)
	      (parse-vars-then-body bindspecs body))
	     (t
	      (signal-problem multi-let-decl-compl
		 "Ill-formed: " exp)))
       :where

 (:def parse-vars-then-body (bindspecs body)
    (multi-let (((bindspecs bs-types)
		 (bind ((types-separate-fcn* #'designated-type))
		    (types-separate bindspecs '() false))))
       (let ((bindspecs (yt::multi-let-bindspecs-analyze
			   bindspecs false body)))
	  (repeat :for ((bs :in bindspecs)
			vars types
			:collectors vars-lists types-lists val-list)
	   :collect (:into val-list (cadr bs))
	     (!= < vars types >
		 (bind ((types-separate-fcn* #'designated-type))
		    (types-separate (car bs) !() false)))
	   :collect (:into vars-lists vars)
	   :collect (:into types-lists types)
	   :result 
	       (progn
;;;;			 (dbg-save vars-lists types-lists bs-types)
;;;;			 (breakpoint multi-let
;;;;				"vars-lists = " vars-lists
;;;;				:% "types-lists = " types-lists
;;;;				:% "bs-types = " bs-types)
		   (repeat :for ((types :in types-lists)
				 (bs-type :in bs-types)
				 (val :in val-list :tail vl)
				 (vars :in vars-lists)
				 vdc vtype
				 :collectors bdgs)
		      (cond ((<& not types)
			     (cond (bs-type
				    (!= types
					(<# (\\ (_) bs-type)
					    *-*))))))
		      (!= vtype 
			  (cond ((<& not types)
				 (cond ((= (len types) 1)
					false)
				       (t
					'Objmultiple)))
				 (t
				  (mlv-type types))))
		      (!= vdc 
			  (decl-compile val vtype))
		      (cond ((<& not types)
			     (!= vtype (Dclcmp-typ vdc))
			     ))
;;;;			     (dbg-save vars bs val vdc types)
;;;;			     (breakpoint multi-let
;;;;				"Got vdc = " vdc)
		      (!= (car vl) (Dclcmp-exp vdc))
;;;;		      (dbg-save vars vtype vdc types)
;;;;		      (breakpoint multi-let-decl-compl
;;;;			 "Got vars = " vars "  vtype = " vtype)
;;;;			     (!= vars-lists* vars-lists)
;;;;			     (!= vars* vars)
;;;;			     (!= vdc* vdc)
		    :nconc (:into bdgs
				  (explicit-lambda-vartypes
				     vars
				     (or (type-feature vtype 'valtypes)
					 (list vtype))
				     `(multi-let-clause
					 (,vars ,val))))
		    :result (progn
;;;;			       (dbg-save bdgs)
;;;;			       (breakpoint multi-let-decl-compl
;;;;				  "Ready to process body, bdgs ="
;;;;				  :% bdgs)
			       (let ((bod-dc
				     (with-vartypes
					(<? (\\ (b)
					       (not (eq (Vartype-var b)
							'_)))
					    bdgs)
					(body-compile
					   body dest-type))))
;;;;				  (dbg-save bod-dc vars-lists val-list)
;;;;				  (breakpoint multi-let-decl-compl
;;;;				     "Got bod-dc")
			      (make-Dclcmp
				 (Dclcmp-typ bod-dc)
				 `(multi-let ,(<# (\\ (vars val)
						     `(,vars ,val))
						  vars-lists
						  val-list)
				     ,@(Dclcmp-exp bod-dc))))))))))))))
