;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;; Copyright 1988-2002 Drew McDermott

(depends-on %module/ nisp)
(depends-on %ytools/ debug)

;;;; (always-slurp)

(defnisptype Typea forward)
(defnisptype Typeb forward)

(defnisptype Typee forward)
(defnisptype Typee (Either Symbol (Lst Typee)))

(defnisptype Typea (Either Symbol (Lst Typeb)))

(defnisptype Typeb (Either Number (Lst Typea)))

(defnisptype Typec :forward)

(defnisptype Typec (Structure flag - Symbol rec - (Either Number (Lst Typec))))

(specdecl (c1* (make Typec 'c1 5)) - Typec)

(specdecl (c2* (make Typec 'c2 (list c1*))) - Typec)

(defnisptype Typed :forward)
(defnisptype Typed (Lrcd (Either Integer Typed) Symbol))

(test "EITHER"
   (check (is Typee '(a () (b c))) "Simple recursive EITHERs")
   (check (and (is Typed '(1 x))
	       (is Typed '((2 y) x))
	       (not (is Typed '((2 2) x))))
	  "LRCD-EITHER interaction")
   (check (and (is Typea 'a)     (not (is Typea '(a b)))
	       (is Typeb '(a b)) (not (is Typeb '(a (5 b)))))
	  "Recursive EITHERs")
   (check (= (!_rec (car (be (Lst Typec) (!_rec c2*)))) 5)
	  "EITHER slots")   )

(defopfunc get-b - Sexp (x - Obj n - Integer)
   (list n)   )

(defopproc flop - Void (x - Obj))

(defnisptype Abcstr (Structure a b c - Sexp
		     (:handler (print (s - Abcstr p - Stream)
				 (with s
			            (out (:to p) 
				         "#{abcstr " !>a 1 !>b 1 !>c 
					 "}"))   )
			      (get-b - (Lrcd Integer Sexp) 
				     (s - Abcstr n - Integer)
				 (lrecord n !>s.b)   )
			      (flop (s - Abcstr) 
				 (ignore s)
				 (out (:to *error-output*) "WOOWOO")))))

(test "operator"
   (decl ((a (make Abcstr 'fee 'fie 'foe)))
      (check (and (equal (get-b 'a 5) '(5))
	          (equal (get-b a 5) '(5 fie))))   ))


(defnisptype Rcd1 (Rcd Sexp Sexp))

(defnisptype Lrcd1 (Lrcd Sexp Sexp))

(defnisptype Ary1 (Ary Lrcd1 2))

(augtype Abcstr (r - (Lst Sexp) *integrable (s - Abcstr) 
		   (with s (list !>c !>b !>a))))

(defnisptype Vect1 (Vct Rcd1))

(defnisptype Htb1 (Htb Symbol))

(deffunc multfoo - (Mlv Sexp Sexp) (a - Sexp) (values a a))

(defnisptype Nam1 (Named Htb1))

(defnisptype Pl1 (Symplist S1 S2 - Sexp))

(defnisptype Kierkegaard (Either Pl1 Nam1))

(test "multiple values"
  (decl ()
	    (multiple-value-let (x y - Sexp) (multfoo 5)
               (check (and (= x 5) (= y 5)))   )))

(test "multiple-value-list"
  (decl ()
    (check (equal (multiple-value-list (multfoo 'a)) '(a a)))))
			     
(defnisptype Symlist (Lst Symbol))

(test "X"
   (decl ()
    (let-fun ((foo - (Lst Abcstr) (l - (Lst Symbol))
		(repeat :for ((r nil) - (Lst Abcstr)) 
		 :until (< (len l) 3)
		   (!= r (cons (make Abcstr (car l) (cadr l) (caddr l))
			       *-*))
		   (pop l)
		 :result (reverse r)   )))
      (check (equal !>(c (car (reverse (foo (list 'one 'two 'three 'four)))))
	            'four))   )))

(test "Y"
     (decl ((l1 (list (make Abcstr 'p1 'p2 'p3) 
		     (make Abcstr 'q1 'q2 'q3)
		     (make Abcstr 'r1 'r2 'r3)))
	    - (Lst Abcstr))
       (let ((l l1))
	(check (repeat :for ((x :in l))
	        :result nil
	        :until (eq !>x.c 'q3)
	        :result t)   ))))

(defnisptype Footype :forward)

(defnisptype Footype Symbol)

(specdecl footype foo*)

(test "Z"
     (decl ((l1 (list (make Abcstr 'p1 'p2 'p3) 
		     (make Abcstr 'q1 'q2 'q3)
		     (make Abcstr 'r1 'r2 'r3)))
	    - (Lst Abcstr)
	    (t1 (make-eq-hash-table)) - Htb1)
       (!= (table-entry t1 'q3) 'q3a)
       (with (cadr l1)
	  (!= !>c (table-entry t1 *-*))
	  (check (eq !>c 'q3a)))
       ))

(test "mapper"
     (decl ((l1 (list (make Abcstr 'p1 'p2 'p3) 
		     (make Abcstr 'q1 'q2 'q3)
		     (make Abcstr 'r1 'r2 'r3)))
	    - (Lst Abcstr))
	 (check (equal (</ (\\ (l a) (cons !>a.c l)   )
	                   nil l1)
	               (reverse (<# \!_ c l1))))   ))

(defnisptype Foostring String (c - Char (s) (string-elt s 0))   )

(deffunc aptest - (Lst Sexp) (s - Symbol i - Number f - Foostring &rest l - Foostring)
   (append l (list i f s))   )

(deffunc vap - (Lst (nisp::*Typevar X)) (l1 l2 - (Lst (nisp::*Typevar X)))
   (append (reverse l2) (reverse l1))   )

(test "APPLY"
    (decl ((ll '("twinkle" "little" "star")) - (Lst Foostring))
       (check
	  (let ((l1 (list (make Abcstr 'p1 'p2 'p3) 
			  (make Abcstr 'q1 'q2 'q3)))
		(l2 (list (make Abcstr 'r1 'r2 'r3))))
             (out (:to *query-io*) "L1 = " l1 " L2 = " l2 :%)
             (let ((x (car (apply #'vap (list l1 l2)))))
                (out (:to *query-io*) "x = " x :%)
	        (equal !>x>c
		    'r3)  ) )
	:else "APPLY TYPEVAR BREAKDOWN")
       (check
          (let ((magic (<< (\\ (l) (<< + l))
		           (<? (\\ (p) (> (car p) (cadr p)))
			       '((1 3) (2 2) (3 1))))))
            (out (:to *query-io*) "magic = " magic :%)
	    (equal magic
		 4))
	:else "Apply / <v breakdown")
       (check
       (and (member  5 (apply #'aptest 'foo 5 ll) :test #'equal)
	    (equal (apply (\\ (w x y z) (list !>w.c !>x.c !>y.c !>z.c)  )
		          (be Foostring "oh") ll)
		   '(#\o #\t #\l #\s))))   ))

(defnisptype Tricky (Either Symbol (Lrcd Tricky . Symbol)))

(deffunc chompit - Symbol - (x - Sexp)
   (caar x)   )

(test "CHOMP"
    (decl ((x '((a . b) . c)) - Tricky)
       (check (equal (chompit x) 'a))   ))

(specdecl (type-of-x-can-change* nil) - Boolean)

(test "COND"
   (decl ((x 'a) - (Either Fixnum Symbol))
     (check
      (progn
	(if type-of-x-can-change* 
	    (!= x 4))
	(cond ((is Integer x) (= x 5))
	      (t (eq x 'a))   )))))

(test "LOOP"
    (decl ((k 2) (n 9) - Fixnum)
     (check
       (equal (repeat :for ((x = 2 :to n :by k) - Fixnum
			    (s = 'first :then 'then) - Symbol
			    (l = nil :then (cons `(,s ,x) l))
			    - (Lst Sexp))
	       :result (reverse l)
	       :until (< x 1)
	       :result l   )
	      '((first 2) (then 4) (then 6) (then 8))))   ))

(defnisptype Ipoint (Structure i j - Fixnum))

(deffunc ratfink - Rational (r - Rational) (/ 1 r)   )

(test "ARITH"
   (decl ((x 4) - Float)
      (let ((pie (atan2 0 -1)))
	 (check (and (eql (+ (abs 4.0) 2) 6.0)
		     (eql (+ (abs 4) 2) 6))
	  :else "ABS hackery")
         (check (= (+ pie (atan2 (- x) 2))
		   (- (atan2 (- x) -2)))
		"ATAN2 hackery")
	 (check (= (ratfink (expt (/ 1 3) 1)) 3) ;T can't compile 1/3
		"EXPT and rational hackery")
	   )))

(defnisptype Frib (Structure foo - (Fun Integer (Float)) baz - (~ String)))

(test "Slot Declaration"
   (decl ((x (make Frib (\\ (y - Float) (round (expt y 2))   )
			(be (~ String) '*))))
      (check (and (= (funcall (!_foo x) 2.9) 8)
		  (eq (!_baz x) '*))
	     "Slot declaration test")   ))

(test "FOR declarations"
    (decl ()
       (let ((l '(a b c)) (nl '(1 2 3)))
	  (check (equal (repeat :for ((s :in l))
			     :when (not (eq s 'b))
			     :collect s)
			'(a c))
		 "FOR decl-compl")
	  (check (equal (repeat :for ((n :in nl) - Sexp)
			   :collect (list n))
			'((1) (2) (3)))
		 "FOR declaration syntax")
	  (check (and (forall (n :in nl)
			      (< n 5))
		      (exists (n :in nl)
			      (> n 2)))
		 "FORALL-EXISTS test")
	    )))

(defnisptype Lstr1 (Lstructure a - Integer (b) (c1 &rest c2)))

(deffunc foo - Sexp (a - Lstr1)
   (list !>a.c1 !>a.b !>a.a)   )

(test "LSTRUCTURE"
    (decl ()
       (let ((l1 (make Lstr1 5 'b '(c11 c12) '(c21 c22 c23))))
	  (check (and (equal !>l1.c2 '(c21 c22 c23))
		      (equal !>l1.b 'b))
		 "LSTRUCTURE access"))))

(defnisptype Spexp Sexp
    (conser (x y) (be Spexp (list y x))   ))

(deffunc spexp-combo - Spexp (e1 e2 - Spexp) (be Spexp (list e2 e1))   )

(test "BE*"
   (decl ()
      (let ((x '(below 5)) - Sexp (l (make Spexp 'out 'look)) - Spexp
	    n)
	 (declare (ignore n))
	 (check (progn (!= (be * x) (spexp-combo (be Spexp x) l))
		       (equal x '((look out) (below 5))))
		"BE * construction")
	 (check (matchq ((look out) (below ?((be * _))))
		        x)
		"BE * in MATCHQ")   )))

(test "NIL type"
   (decl ()
      (let ((x nil) (y (make Spexp 'there 'hi))
	    - (~ Spexp)
	    )
	 (!= x y)
	 (check (equal x '(hi there))
		"Object bound to NIL not settable")   )))

(defnisptype Stak0 (Structure () x - Symbol y - Integer))

(defnisptype Stak1 (Structure () x - Symbol y - Stak0))

(defnisptype Stak2 (Structure () x - Symbol y - Stak1))

(test "!> complexity"
   (decl ()
      (let ((y (make Stak2 'x2 (make Stak1 'x1 (make Stak0 'x0 5)))))
	 (check (with y
		   (and (eq !>>x 'x2)
			(eq !>x 'x2)
			(eq !>y>x 'x2)
			(eq !>>y>x 'x1)
			(eq !>>y.x 'x1)
			(eq !>>y>y>x 'x0)))
		"!>> hackery"))))

(defnisptype Rekur (Lstructure () a - Symbol b - (~ Rekur)))

(specdecl (rk* (make Rekur 'car (make Rekur 'caadr nil))) 
	  (rko* (make Rekur 'car (make Rekur 'caadr (make Rekur 'caadadr nil))))
         - Rekur)

(test "~ stuff"
   (decl ()
      (check (eq (!_a (!_b rk*)) 'caadr)
	     "Squiggle access")
      (check (eq (!_a (!_b (!_b rko*))) 'caadadr)
	     "Squirming through squiggles")   ))

(test "DO unto others"
   (decl ()
      (let ((y (make Stak0 'x 5)))
	 (check (do ((n !>y>y (+ n 1))
		     (m 10) - Integer
		     (x) - Symbol)
		    ((= n m) (eq x 'x))
                   (!= x !>y.x)   )
		"DO diddled"))))

