;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: numdcl.lisp,v 2.10 2005/12/26 00:46:18 dvm Exp $

(depends-on :at-compile-time %ydecl/ tmcdcl)
				  
(depends-on :at-run-time %ydecl/ dclmacs sysdefs 
				  plextype listype strtype)

;; Syntax keeps us from declaring "-" !
(!= (prop 'type '-) (designated-type '(Fun Number Number ())))

(bind ((allow-ftype* false))
; See comment in datadcl about ALLOW-FTYPE*
(specdecl float - (Fun Float (Number) ())
	  < > <= >= - (Fun Boolean (Number Number) ())
          / - (Fun Number (Number Number) ())
	  floor ceiling truncate round - (Fun Integer (Number) ())
	  gcd - (Fun Integer (Integer Integer) ())
	  atan log - (Fun Float (Float) ())
	  logand logior logxor - (Fun Integer (Integer Integer) ())
))

(specdecl truncate - (Fun Integer (Number) ())
	  float - (Fun Float (Number) ())
	  is-Even is-Odd - (Fun Boolean (Integer) ())
	  =< - (Fun Boolean (Number Number) ())
          min max - (Fun (*Typevar X Number) (*Typevar X Number) ())
	  + * - (Fun Number Number ())
	  floor2 ceiling2 truncate2 round2 
			    - (Fun (Mlv Integer Number) (Number Number) ())
	  quotient remainder mod - (Fun Integer (Integer Integer) ())
          sqrt - (Fun Number (Number) ())
          abs - (Fun (*Typevar X Number) ((*Typevar X Number)) ())
	  sin cos tan asin acos exp - (Fun Float (Float) ())
	  atan2 - (Fun Float (Float Float) ())
	  logor ash - (Fun Integer (Integer Integer) ())
	  lognot - (Fun Integer (Integer) ())
	  bit-field - (Fun Integer (Integer Integer Integer) ())
	  bit-field-modified - (Fun Integer (Integer Integer Integer Integer) 
				            ())
	  random - (Fun (*Typevar X Number) ((*Typevar X Number)) t)
	  fxrandom - (Fun Integer (Integer) t)
	  flrandom - (Fun Float (Float) t)
)

;; 87.9.30: New
(datafun decl-compl /
  (defun (exp dest-type)
    (cond ((not (= (length exp) 3))
	   (signal-problem /-decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (let ((numer (decl-compile (cadr exp) 'Number))
		 (denom (decl-compile (caddr exp) 'Number))
		 (rtype 'Number))
	     (cond ((and (subtype (Dclcmp-typ numer) 'Rational nil)
			 (subtype (Dclcmp-typ denom) 'Rational nil))
		    (!= rtype 'Rational))
		   ((or (subtype (Dclcmp-typ numer) 'Float nil)
			(subtype (Dclcmp-typ denom) 'Float nil))
		    (!= rtype 'Float))   )
	     (type-trans `(/ ,(Dclcmp-exp numer) ,(Dclcmp-exp denom))
			 rtype dest-type)   )))))

(datafun decl-compl expt
  (defun (exp dest-type)
    (cond ((not (= (length exp) 3))
	   (signal-problem expt-decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (let ((dc1 (decl-compile (cadr exp) 'Number))
		 (dc2 (decl-compile (caddr exp) 'Number))
		 (rtype 'Number))
	     (cond ((subtype (Dclcmp-typ dc2) 'Integer nil)
		    (cond ((subtype (Dclcmp-typ dc1) 'Integer nil)
			   (!= rtype 'Integer))
			  ((subtype (Dclcmp-typ dc1) 'Rational nil)
			   (!= rtype 'Rational))
			  ((subtype (Dclcmp-typ dc1) 'Float nil)
			   (!= rtype 'Float))   ))   
		   ((or (subtype (Dclcmp-typ dc2) 'Rational nil)
			(subtype (Dclcmp-typ dc2) 'Float nil))
		    (!= rtype 'Float))   )
	     (type-trans `(expt ,(Dclcmp-exp dc1) ,(Dclcmp-exp dc2))
			 rtype dest-type)   )))))

(eval-when (:compile-toplevel :load-toplevel)
;;; Check types for generic arith function.  Transform to appropriate type.
(defun arith-decl-compl (exp dest-type)
   (let ((argdcs (<# (\\ (a) (decl-compile a 'Number)   )
		     (cdr exp)))
	 (fname (car exp))
	 (argtype nil) argl rtype)
      (!= argtype
	  (cond ((<& (\\ (dc) (subtype (Dclcmp-typ dc) 'Fixnum nil))
		     argdcs)
		 'Fixnum)
		((<& (\\ (dc) (subtype (Dclcmp-typ dc) 'Integer nil))
		     argdcs)
		 'Integer)
		((<& (\\ (dc) (subtype (Dclcmp-typ dc) 'Rational nil))
		     argdcs)
		 'Rational)
		((<& (\\ (dc) (or (numberp (Dclcmp-exp dc))
				  (subtype (Dclcmp-typ dc) 'Float nil))   )
		     argdcs)
		 'Float)
		(t 'Number)   ))
      (!= argl 
          (<# (\\ (dc)
		 (let ((e (Dclcmp-exp dc)))
		    (cond ((and (eq argtype 'Float)
				(numberp e))
			   (float e))
			  (t e)   )))
	       argdcs))
      (!= rtype
	  (cond ((memq (car exp) '(= > < =< >=)) 'Boolean)
		(t argtype)   ))
      (type-trans `(,fname . ,argl) rtype dest-type)))
)

(datafun decl-compl + !'arith-decl-compl)
(datafun decl-compl - !'arith-decl-compl)
(datafun decl-compl * !'arith-decl-compl)
(datafun decl-compl = !'arith-decl-compl)
(datafun decl-compl < !'arith-decl-compl)
(datafun decl-compl > !'arith-decl-compl)
(datafun decl-compl =< !'arith-decl-compl)
(datafun decl-compl >= !'arith-decl-compl)

(defun numtrans (x source-type dest-type)
   (cond ((or (null dest-type) (subtype dest-type 'Void nil))
	  '*noway)
	 ((subtype dest-type 'Integer nil)
	  (cond ((subtype source-type 'Integer nil)
		 x)
		((is-Number x) (truncate x))
		((subtype source-type 'Number nil)
		 `(truncate ,x))
		(t '*noway)   ))
	 ((subtype dest-type 'Float nil)
	  (cond ((subtype source-type 'Float nil)
		 x)
		((is-Number x) (float x))
		((subtype source-type 'Number nil)
		 `(float ,x))
		(t '*noway)   ))
	 (t '*noway)   ))

(!= (type-feature 'Integer 'type-transfn) !'numtrans)
(!= (type-feature 'Float 'type-transfn) !'numtrans)
