;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: objdcl.lisp,v 2.12 2006/05/16 14:34:48 dvm Exp $

;;;;(depends-on :at-run-time %ydecl/ objtype)

(depends-on :at-compile-time %ydecl/ dclmacs typekern sysdefs datadcl)

(depends-on (:at :run-time) %ydecl/ sysdefs)

(eval-when (:compile-toplevel :load-toplevel :slurp-toplevel)
   (export '(defmethfunc defmethproc))
   (import '(yt::get-ytools-class-descriptor
	     yt::ytd-medium yt::ytd-key-conser)))

; FLAVOR type +
; Declaration-context versions of flavor manipulators: 
;    DEFMETH, SLOT, MAKE-INST

(datafun :slurp-macros defmethfunc #'slurp-ignore)
(datafun :slurp-macros defmethproc #'slurp-ignore)

(defmacro defmethfunc (&rest defin) (meth-expand defin)   )
(defmacro defmethproc (&rest defin) (meth-expand defin)   )

(defun meth-expand (defin)
   (let ((name (car defin)) (qualifiers '()) op)
      (cond ((atom name)
	     (!= op name)
	     (repeat
	        (!= defin (cdr defin))
	      :until (or (null defin)
			(eq (car defin) '-)
			(consp (car defin)))
	        (!= qualifiers (cons (car defin) *-*))))
	    (t
	     ;; Old style.  NAME may be of the form (qualifier op), or
	     ;; just op.  And I suppose we should allow (flavor
	     ;; combiner op), in which case the flavor overrides the
	     ;; type of the first arg.
	     (let (qualifier)
		(cond ((not (matchq (?qualifier ?op) name))
		       (signal-problem meth-definition :fatal
			  "Ill-formed method definition for op: " name))   )
		(!= qualifiers (list qualifier))
		(!= defin (cdr defin))   ))   )
      (multiple-value-let (name argl ft body)
			  (funclause-analyze `(,op ,@defin))
	 (ignore name)
         (let ((expect-argtypes
		  (let ((optype (symtype op)))
		     (cond ((is-Funtype optype) (fun-argtypes optype))
			   (t '*no)   ))))
	    (!= argl
		(method-args-massage *-* (fun-argtypes ft)
				     expect-argtypes defin))   )
	 (cond ((not (is-Symbol op))
		(signal-problem defmeth :continue
				"Meaningless operation: "
			            op " in definition " :% defin :%))   )
	 `(meth-define (,op ,@qualifiers)
		       ,argl
	       ,ft
	       ,@body   ))   ))

(defun method-args-massage (argl types expect defin)
     (cond ((null types)
	    (cond ((or (null expect)
		       (eq expect '*no)
		       (eq (car expect) 'dot))
		   '())
		  (t
		   (signal-problem meth-definition :continue
		      "Method has too few arguments: "
		      defin)
		   '())   ))
	   ((eq (car types) 'dot)
	    argl)
	   ((eq expect '*no)
	    `((,(car argl)
	       ,(type-class-name (car types)))
	      ,@(method-args-massage (cdr argl) (cdr types) '*no defin)))
	   ((or (null expect) (eq (car expect) 'dot))
	    argl)
	   ((subtype (car expect) (car types) false)
	    `(,(car argl)
	      ,@(method-args-massage (cdr argl)
				  (cdr types)
				  (cdr expect)
				  defin)))
	   (t
	    (cond ((not (subtype (car types) (car expect) true))
		   (out (:to *error-output*)
			"Warning -- for arg " (car argl)
			" arg type " (car types)
			" does not match operation arg type "
			(car expect)
			:% " in " defin :%))   )
	    `((,(car argl)
	       ,(type-class-name (car types)))
	      ,@(method-args-massage (cdr argl)
				  (cdr types)
				  (cdr expect)
				  defin)))   ))

(defun type-class-name (ty)
   (cond ((subtype univ-type* ty false) 't)
	 (t
	  (or (type-feature ty 'class-name)
	      (let ((spec (nisp->cltype ty)))
		 (cond ((atom spec) spec)
		       ((memq (car spec) '(and or eql not))
			't)
		       (t (car spec))   ))))   ))

;;;;(datafun to-slurp meth-define defun)

(defmacro meth-define (name argl ft &rest body)
   `(def-meth ,@(meth-definition name argl ft nil body))   )

(datafun :slurp-macros meth-define
   (defun :^ (_ _)
      false))

(def-file-segment objdcl-nt-slurpers (nisp-types-handlers)

 (datafun :slurp-nisp-types meth-define
    (defun :^ (_ _)
       false))
)

(defvar combined-meth-type* nil)

(defun meth-definition (id argl ft slotvartypes body)
; ID is (operation -qualifiers-)
   (let ((name (car id))
	 (qualifiers (cdr id))
         (args (repeat :for (a :in argl)
		  :collect
		     (cond ((atom a) a) (t (car a))))))
      (let ((meth-type (symtype name))
	    (ob-type (car (fun-argtypes ft))))
	 (cond ;((NULL (INTERSECTIONQ QUALIFIERS '(COMBINED :COMBINED :AROUND)))
		;(!= METH-TYPE NIL))
	       ((not (is-Funtype meth-type))
		(!= meth-type ft))   )
	 (cond ((and (is-Pair argl) (not (eq (car argl) '&rest)))
		(bind ((implicit-ob*
			  `(*dc ,(make-Dclcmp ob-type (car args))))
		       (combined-meth-type* meth-type)
		       (freeslots*
			  (class-slot-types ob-type)))
                   (with-declarations (<# car freeslots*)
				      (<# caddr freeslots*)
		      `(,name ,@qualifiers ,argl
			    ,@(with-vartypes slotvartypes
				  (fundecl-expand args ft false body name))))))
	       (t
		(signal-problem meth-definition :fatal
		   "Argument list " argl
		   :% " to method " id " does not start with variable"))))))

(defun class-slot-types (ob-type)
   (let ((class (type-feature ob-type 'class-name)))
      (cond ((not class)
	     (signal-problem class-slot-types :fatal
		"Couldn't find class for type " ob-type))   )
      (cond ((not (is-Symbol class))
             '())
            (t
	     (let ((slots (yt::class-all-slots class)))
		(repeat :for (s :in slots)
		   :collect
			(lrecord s `(slot ,s)
				 (or (type-slot-fun ob-type s 'type nil)
                                     'Obj)))))   )))

; Syntax: (EXPECT-SLOTS (-slots-n-types-) -body-) allows floating !>sl to occur
; in body with appropriate type.
(datafun decl-compl expect-slots
   (defun (exp dest-type)
      (multiple-value-let (vars types) (types-separate (cadr exp) nil nil)
         (!= types (<# (\\ (ty) (designated-type (or ty 'Obj))   )
		       *-*))
         (with-declarations vars types
            (bind ((freeslots* (nconc (<# (\\ (v ty) (list v `(slot ,v) ty)   )
					  vars types)
				      freeslots*)))
	       (let ((bdc (body-compile (cddr exp) dest-type)))
		  (make-Dclcmp (Dclcmp-typ bdc)
			       `(expect-slots ,vars ,@(Dclcmp-exp bdc)))
	       ))))))

(datafun decl-compl slot
   (defun (exp dest-type)
      (let ((s (cadr exp)) p)
         (repeat
	   (!= p (assq (cadr exp) freeslots*))
          :until p
	  :result (type-trans (cadr p) (caddr p) dest-type)
            (defining-info)
	    (!= s (signal-problem slot-decl-compl 
		      "Unexpected slot " s
		      (:prompt-for "New slot: " s)))))))

(datafun decl-compl call-next-method
   (defun (exp dest-type)
      (cond (combined-meth-type*
	     (form-decl-compile combined-meth-type*
				'call-next-method exp dest-type))
            (t
	     (defining-info)
	     (signal-problem call-next-method :continue
		 "CALL-NEXT-METHOD type obscurity")
	     (make-Dclcmp dest-type exp))   
       )))

(datafun decl-compl make-inst
   (defun (exp dest-type)
      (let ((class (cadr exp))
	    (args (remove '= (cddr exp)))
	    flavname)
	 (cond ((is-type-desig class)
		(!= class (designated-type class))
		(!= flavname (type-feature class 'class-name))
		(cond ((null flavname)
		       (defining-info)
		       (signal-problem make-inst 
			       "Can't make instance of class "
			       class))
		      (t
		       (let ((nd (get-ytools-class-descriptor flavname)))
			 (cond ((and nd
				     (eq (ytd-medium nd) ':structure)
				     (not (ytd-key-conser nd)))
				(signal-problem make-inst
				   "Can't make-inst of class " flavname
				   " -- no key-conser"))))))
		(repeat :for ((al args (cddr al))
			      (r nil) a
			      (initargs (class-assemble-initargs class)))
		 :while al
		   (!= a (car al))
		   ;(!= STR (SYMBOL->STRING A))
		   ;(!= S (INTERN STR KEYWORD-PACKAGE*))
		   (!= r (cons
			    (decl-compile-exp
			       (cadr al)
			       (let ((p (assq a initargs)))
				  (cond (p
					 (type-slot-fun class (cadr p)
							'type true))
					(t 'Obj))))
			    (cons a r)))
		 :result (type-trans `(make-inst ,flavname ,@(reverse r))
				     class dest-type)   ))
	       (t
		(make-Dclcmp 'Obj exp))   ))))

(deffunc ->class-name - Symbol (n - Symbol)
   (cond ((is-type-desig n)
	  (let ((ty (designated-type n)))
	     (let ((c (type-feature ty 'class-name)))
	        (or c n)   )))
	 (t n)   ))

(datafun decl-compl slot-is-filled
   (defun (exp dest-type)
      (type-trans exp 'Boolean dest-type)   ))

; Variant of SLOTMETHODS that believes in types
(defmacro decl-slotmethods (class &rest specs)
   (cond ((memq class '(gettable settable))
	  (out (:to *error-output*) "Use of old form of DECL-SLOTMETHODS: "
	       `(decl-slotmethods ,class ,@specs))
	  (!= class (car specs))
	  (!= specs `((,class ,@(cdr specs)))))   )
   (let ((cname 
	   (cond ((is-type-desig class)
		  (type-feature class 'class-name))
		 (t class)   )))
      (cond ((null cname)
	     (signal-problem decl-slotmethods :continue
			     "Attempt to use DECL-SLOTMETHODS"
					  " on a nonflavor type: " class))   )
      `(slotmethods ,cname ,@specs)   ))
;      `(SLOTMETHODS ,WHICH ,CNAME ,SLOTS)   ))


(bind ((allow-ftype* false))
   (specdecl print - (Fun Void (Obj Stream) t)))

(!= (type-feature 'Fixnum 'class-name) 'Integer)