;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: plextype.lisp,v 2.11 2005/12/26 03:28:54 dvm Exp $

(depends-on :at-run-time %ydecl/ typekern dclmacs)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(~ Either Alt Htb Mlv Multvals Named Vct Ary)))

(end-header :continue-slurping)

(datafun type-loader Ary
   (defun (d typename)
      (ignore typename)
      `(make-Type ',d 'Objarray nil
		  (list (list 'eltype ,(type-or-desig-loader (cadr d) nil))
			(list 'array-rank 
			      ',(cond ((is-Number (caddr d))
				       (caddr d))
				      (t '*)   ))))   ))
(defun arraytype (eltype rank)
   (make-Type `(Ary ,(Type-desig eltype) ,rank) 'Objarray nil
              (list (list 'eltype eltype)
		    (list 'array-rank rank)))   )

;; Nov.4.87 added
(defun ary-initexp (ty feat)
   (ignore feat)
   (let ((r (type-feature ty 'array-rank)))
      (cond ((is-Number r)
	     `',(make-array (<# (\\ (i) (ignore i) 0)
				(series r))))
	    (t ''#())   )))

;; Added 7.8.88
(!= (type-feature 'Objarray 'initexp) `(*feature-fcn ,!'ary-initexp))

(datafun type-loader Vct
   (defun (d typename)
      (ignore typename)
      `(make-Type '(Ary ,(cadr d) 1) 'Objarray nil
		  (list (list 'eltype ,(type-or-desig-loader (cadr d) nil))
			(list 'array-rank '1)))   ))

;; Drew patch added 7.30.87:
(defun array-subtyper (t1 t2 accep)
  (cond ((eq t2 '*im-super)
	 (!= t2 (Type-im-super (type-feature t1 'eltype)))
	 (cond (t2 
		(arraytype t2 (type-feature t1 'array-rank)))
	       (t nil)   ))
	((and (is-subtype t1 'Objarray) (is-subtype t2 'Objarray))
	 (or (is-subtype t1 t2)
	    (and (let ((r1 (type-feature t1 'array-rank))
		       (r2 (type-feature t2 'array-rank)))
		    (or (eq r1 r2)
			(cond ((and (is-Number r1) (is-Number r2))
			       (= r1 r2))
			      (t accep)   ))   )
		 (subtype (type-feature t1 'eltype)
			  (type-feature t2 'eltype)
			  accep))))
	(t nil)   ))

(!= (type-feature 'Objarray 'subtype-fcn) !'array-subtyper)

;; (HTB type): hash table whose entries are as shown.  Someday this may
;; be extended to (HTB entrytype (-argtypes-)).
(datafun type-loader Htb
   (defun (d name)
      (ignore name)
      `(make-Type ',d 'Objhashtable
	  nil
	  (list (list 'eltype ,(type-or-desig-loader (cadr d) nil))))   ))

(defun htbtype (eltype)
   (make-Type `(Htb ,(Type-desig eltype)) 'Objhashtable 
	      nil
	      (list (list 'eltype eltype)))   )

;; Changed 11.14.88
(defun htb-subtyper (t1 t2 accep)
  (cond ((eq t2 '*im-super)
	 (!= t2 (Type-im-super (type-feature t1 'eltype)))
	 (cond (t2 (htbtype t2))
	       (t nil)   ))
	((and (is-subtype t1 'Objhashtable) (is-subtype t2 'Objhashtable))
	 (or (is-subtype t1 t2)
	    (and (subtype (type-feature t1 'eltype)
			  (type-feature t2 'eltype)
			  accep))))
	(t nil)   ))

(!= (type-feature 'Objhashtable 'subtype-fcn) !'htb-subtyper)

(datafun type-loader Mlv
   (defun (d name)
      (ignore name)
      `(make-Type ',d 'Objmultiple
	  nil
	  (list (list 'valtypes ,(argtypes-loader (cdr d)))))   ))

(defun mlv-type (valtypes)
   (cond ((null valtypes) 'Void)
         ((eq (car valtypes) 'dot)
          (make-Type `(Mlv dot ,(Type-desig (cadr valtypes)))
                     'Objmultiple
                     nil
                     (list (tuple 'valtypes `(dot ,(cadr valtypes))))))
         ((null (tail valtypes))
	  (car valtypes))
	 (t
	  (make-Type `(Mlv ,@(argtype-desigs valtypes))
		     'Objmultiple
		     nil
		     (list (tuple 'valtypes valtypes))))))

(defun mlv-subtyper (t1 t2 accep)
      (cond ((eq t2 '*im-super) nil)  ; No one will ever ask this
	    ((and (is-subtype t1 'Objmultiple) (is-subtype t2 'Objmultiple))
	     (or (is-subtype t1 t2)
		(sub-argtypes (type-feature t1 'valtypes)
			      (type-feature t2 'valtypes)
			      accep)))
	    (t nil)   ))

(!= (type-feature 'Objmultiple 'subtype-fcn) !'mlv-subtyper)

(defun mlv-component-types (maybe-mlv-type)
   (cond ((is-subtype maybe-mlv-type 'Objmultiple)
          (type-feature maybe-mlv-type 'valtypes))
         (t
          ;; maybe, but no ...
          (list maybe-mlv-type))))

; (Multvals -types-n-vars-) defines an Mlv but giving
; mnemonic names to the values (and saving having to repeat the types).
(datafun type-former Multvals
   (defun (d typename)  
      (ignore typename)  ; Would this ever occur in a DEFTYPE?
      (multiple-value-let (slotnames slotypes)
			  (types-separate (cdr d) nil nil)
	 (ignore slotnames)
	 (designated-type `(Mlv ,@slotypes)))))

;; (FUN resulttype (-argtypes-) [side-effects])
(datafun type-loader Fun
   (defun (def typename)
      (ignore typename)
      `(make-Type ',def 'Objfun nil
          (list (list 'resulttype ,(type-or-desig-loader (cadr def) nil))
                (list 'argtypes ,(argtypes-loader (caddr def)))
                (list 'side-effects ',(cond ((eq (cadddr def) 'nil) '())
					    (t (cadddr def))   ))))   ))

;;;--Denys 1/11/89
(defun fun-subtyper (t1 t2 accep)
  (and (not (eq t2 '*im-super))
       (is-Funtype t1)
       (is-Funtype t2)
       (subtype      (fun-resulttype t1) (fun-resulttype t2) accep)
       (sub-argtypes (fun-argtypes   t2) (fun-argtypes   t1) accep)))

;;;--Denys 1/11/89
(defun sub-argtypes (atl1 atl2 accep)
   (cond ((null atl1)
          (or (null atl2) (eq (car atl2) 'dot)))
         ((null atl2) nil)
         ((eq (car atl1) 'dot)
	  (and (eq (car atl2) 'dot)
	       (subtype (cadr atl1) (cadr atl2) accep)))
         ((eq (car atl2) 'dot)
          (and (subtype (car atl1) (cadr atl2) accep)
               (sub-argtypes (cdr atl1) atl2 accep)))
         (t (and (subtype (car atl1) (car atl2) accep)
                 (sub-argtypes (cdr atl1) (cdr atl2) accep)))   ))

(!= (type-feature 'Objfun 'subtype-fcn) !'fun-subtyper)

;;(NAMED type [flag])
;;is a type implemented as a Symbol, whose slots are found on its
;;property list, as elements of the object of type type under the
;;indicator DATA (or flag if it is present).  For example,

;;(DEFTYPE employee-class (STRUCTURE NIL (PAY fixnum) (BENEFITS boolean)))
;;(DEFTYPE employee (NAMED employee-class CLASS)
;;   (CLASS (E) (PROP 'CLASS E))
;;   (CONSER (NAME CLASS) (:= (PROP 'CLASS NAME) CLASS) NAME   )
;;   (IS (X) (AND (IS Symbol X) (PROP 'CLASS X))))

;;defines a type employee, elements of which are Symbols with a CLASS
;;property giving their pay and whether they have benefits.  These
;;are accessed, as usual, by saying (:(employee PAY) E1), etc.
;;It is unnecessary, in fact frowned upon, to say (:(employee-class PAY)
;;(PROP 'CLASS E1)), or (shudder) (CAR (PROP 'CLASS E1)).

;;Note that the NAMED notation does not automatically create a conser
;;or IS-tester, because named types tend to do these things in indiosyncratic
;;ways.

;;It is not necessary to define employee-class as a separate type.  We
;;could have written
;;(DEFTYPE employee (NAMED (STRUCTURE NIL (PAY ...)) CLASS) ...).

(datafun type-loader Named
   (defun (def typename)
      (ignore typename)
      (let ((basetype (check-designated-type (cadr def)))
            (flag (cond ((cddr def) (caddr def))
                        (t 'data)   )))
         `(make-Type ',def 'Symbol
	     (list 
		. ,(</ (\\ (slots slotspec)
			  (let ((sname (Slot-name slotspec)))
			     (cond ((or (memq sname '(conser is =))
					(assq sname slots))
				    slots)
				   (t 
				    `(,(slot-embed-loader 
                                         slotspec `(prop ',flag x))
				      . ,slots))   )))
		       nil
		       (type-allslots basetype)))
             nil)   )))

(defun slot-embed-loader (slotspec extract)
  (let ((sn (Slot-name slotspec))
        (base-acc (slotfn-deint (Slot-acc slotspec)))
        (base-set (slotfn-deint (Slot-set slotspec))))
    `(make-Slot ',sn
       '(lambda (x) (,base-acc ,extract)   )
       '(lambda (x y) (,base-set ,extract y)   )
       ,(type-or-desig-loader (Type-desig (Slot-type slotspec)) nil)
       nil)   ))

;; Format: (SYMPLIST -types-and-vars-)
(datafun type-loader Symplist
   (defun (d typename)
      (ignore typename)
      (multiple-value-let (slotnames slotypes)
			  (types-separate (cdr d) nil nil)
	`(make-Type ',d 'Symbol
	    (list 
	       . ,(<# (\\ (dg s)
		         `(make-Slot ',s
			    '(lambda (a) (prop ',s a)   )
			    '(lambda (a v) (!= (prop ',s a) v)   )
			    ,(type-or-desig-loader dg nil)
			    nil)   )
		      slotypes slotnames))
	    nil)   )))

;; Is every type in list TL1 a subtype of some type in TL2?
(defun all-subtypes (tl1 tl2 accep)
   (<& (\\ (ty1)
	  (<v (\\ (ty2) (subtype ty1 ty2 accep)   )
	      tl2)   )
       tl1)   )

;; 5.27.88 changed #'SLOT-FILLERs ... to !' to delay evaluation until available

;; (~ ty) behaves like (EITHER ty NULL), except that slots are
;; inherited from ty.  It is *not* a subtype of ty any longer.
;; Changed 3.21.88, 3.23.88 (WOULD-BE -> IS)
;; Changed 88.4.1; 88.5.3 args to MAKE-TYPE for TILDE-TYPE
;; Changed 5.16.88 for revised is testing
(datafun type-loader ~
  (defun (d typename)
	 (ignore typename)
    (let ((basedesig (cadr d)))
      `(make-Type ',d 
		  'Obj 
		  nil
		  (list (list 'either-type-desigs '(Null ,basedesig))
			(list 'either-types 
			      `(*feature-fcn ,!'compute-either-types))
			(list 'slot-filler-fcn !'tilde-slot-filler)
			(list 'feature-filler-fcn !'tilde-feature-filler)
			(list 'subtype-fcn !'squiggle-subtyper)
			;;;;(list 'type-transfn !'squiggle-transfn)
			(list 'is-builder !'tilde-is-builder)
			(list 'nil-acceptable true)
			(list 'initexp 'false))))))

(defun tilde-slot-filler (ty slot wanted)
   (type-slot-fun (cadr (type-feature ty 'either-types)) 
		  slot wanted nil)   )

(defun tilde-is-builder (ty must-be-defined)
   (let ((tester (get-is-tester (cadr (type-feature ty 'either-types)) 
				must-be-defined)))
      (cond (tester
	     `(lambda (x) (or (null x) (,tester x))   ))
	    (t nil)   )))

;; added  88.4.1, changed 5.3.88
(defun tilde-feature-filler (ty feat)
   (list feat (type-feature (cadr (type-feature ty 'either-types))
			    feat))   )

;; Added 9.7.88 for use in ctldcl
(defun squiggle (basetype)
  (if (or (eq (Type-desig basetype) 'Boolean)
	  (matchq (~ ?_) (Type-desig basetype)))
      basetype
      (make-Type `(~ ,(Type-desig basetype))
		 'Obj
		 nil
		 (list (list 'either-types (list 'Null basetype))
		       (list 'slot-filler-fcn !'tilde-slot-filler)
		       (list 'feature-filler-fcn !'tilde-feature-filler)
		       (list 'subtype-fcn !'squiggle-subtyper)
		       ;;;;(list 'type-transfn !'squiggle-transfn)
		       (list 'is-builder !'tilde-is-builder)))   ))
  

;;; This is like 'either-subtyper', except if 'accep'=true, it
;;; checks only the main component type.
(defun squiggle-subtyper (ty1 ty2 accep)
  (cond ((eq ty2 '*im-super)
         (cond ((type-local-feature ty1 'either-type-desigs)
                (type-feature ty1 'either-types))) ; Execute for side effect
         (Type-super ty1))
        (t
         (let ((tl1 (type-feature ty1 'either-types)))
           (or (and (not (null tl1))
                    (if accep
                        (progn
;;;;			       (dbg-save tl1 ty2)
;;;;			       (breakpoint squiggle-subtyper
;;;;				  "tl1 = " tl1)
			       (subtype (cadr tl1) ty2 accep))
		        (<& (\\ (tly1) (subtype tly1 ty2 accep)) tl1)))
               (let ((tl2 (type-feature ty2 'either-types)))
                 (or (<v (\\ (tly2) (subtype ty1 tly2 accep)) tl2)
                     (and (null tl1) (null tl2)
                          (progn (signal-problem squiggle-subtyper :continue
				  "Neither is an either")
				 false)))))))))

;;;;(defun squiggle-transfn (x _ _)
;;;;   (cond ((eq x 'false) x)
;;;;	 (t '*noway)))

;; added Oct.13 87: WOULD-BE
(defmacro would-be (td e)
  `(decl () (would-be ,td ,e))) ; ->(IS ... -> (WOULD-BE ...

(datafun decl-compl would-be
  (defun (exp dest-type)
    (let ((ty (check-designated-type (cadr exp))))
      (let ((tester (type-slot-fun ty 'is 'acc nil)))
        (cond (tester
               (type-trans
                 `(,tester ,@(coerce-args (cddr exp)
                                          (or (type-slot-fun ty 'is 'atypes nil)
                                              '(Obj))
                                          exp))
                 'Boolean
                 dest-type))
              (t
               (type-trans 
		`(signal-problem (is ,(cadr exp)) 
		         "No IS-tester for " ',(cadr exp)
			 (:continue "I'll treat it as nil"))
		'Boolean
		dest-type)))))))

;;; ----------- The infamous EITHER (here to end of file)
;;; Last change: Oct. 8 87 "(This time for sure!)"

;; Changed 3.21.88 (flushed WOULD-BE):
;; changed 5.3.88: args to MAKE-TYPE
;; changed 5.16.88 revised IS system
(datafun type-loader Either
   (defun (def typename)
      (ignore typename)
      (let ((tdl (cdr def)))
	 (cond ((null tdl) `(designated-type 'void))
	       (t   
		`(make-Type ',def 'Obj 
			    nil
			    (list (list 'either-type-desigs ',tdl)
				  (list 'either-types 
					(tuple '*feature-fcn !'compute-either-types))
				  (list 'initexp
					(tuple '*feature-fcn !'compute-either-initexp))
				  (list 'slot-filler-fcn !'either-slot-filler)
				  (list 'subtype-fcn !'either-subtyper)
				  (list 'is-builder !'either-is-builder))))   ))))

(datafun type-loader Alt Either)

;;======================================================================
;; Rule 1:
;;    T < T1 => T < (T1 v T2)
;; Rule 2:
;;    (T1 < T) & (T2 < T) => (T1 v T2) < T
;; The implementation below is not complete. In order to be complete, it
;; would have to take into account the transitivity and commutativity of
;; the union operation. As it stands, it first tries Rule#2, then Rule#1
;; and then fails instead of trying permutations of either disjunctions.
;;======================================================================
(defun either-subtyper (ty1 ty2 accep)
  (cond ((eq ty2 '*im-super)
         (cond ((type-local-feature ty1 'either-type-desigs)
                (type-feature ty1 'either-types))) ; Execute for side effect
         (Type-super ty1))
        (t
         (let ((tl1 (type-feature ty1 'either-types)))
           (or (and (not (null tl1))
;;;;                    (if accep
;;;;                        (<v (\\ (tly1) (subtype tly1 ty2 accep)) tl1) ...)
		    (<& (\\ (tly1) (subtype tly1 ty2 accep)) tl1))
               (let ((tl2 (type-feature ty2 'either-types)))
                 (or (<v (\\ (tly2) (subtype ty1 tly2 accep)) tl2)
                     (and (null tl1) (null tl2)
                          (progn
			     (signal-problem either-subtyper :continue
				  "either-types missing")
			     nil)))))))))

;; 87.10.8: Add to PLEXTYPE
;; 88.5.3: deleted penultimate line - (TYPE-SLOT-GENERAL EITY 'IS 'ACC)
(defun compute-either-types (xty feat)
   (ignore feat)
   (multiple-value-let (eity etd) (either-supertype xty)
      (let ((etl (<# designated-type etd)))
	 (!= (type-feature eity 'either-types) etl)
	 (!= (Type-super eity) 
	     (</ common-supertype void-type* etl))
	 etl   )))

(defun compute-either-initexp (ty _)
   (let ((either-types (type-feature ty 'either-types)))
      (repeat :for ((eity :in either-types))
       :result nil
       :within
         (let ((ie (type-feature eity 'initexp)))
	    (:continue
	     :until ie
	     :result ie)))))

;; Find supertype of XTY that is an either-type; return it plus either-designators
(defun either-supertype (xty)
  (let ((eity xty) etd)
      (repeat
	 (!= etd (type-local-feature eity 'either-type-desigs))
       :until etd
         (!= eity (Type-super eity))
       :while eity   )
      (cond ((null eity)
	     (signal-problem compute-either-types :continue
			     "Fumbled either-supertype for " xty))   )
      (values eity etd)   ))

;; changed 88.5.3,  5.16.88
(defun either-slot-filler (ty slot wanted)
   (type-feature ty 'either-types) ; Important for side effect
   (type-slot-fun (Type-super (one-value (either-supertype ty)))
		  slot wanted nil)   )

(defun either-is-builder (eity must-be-defined)
   (let ((either-types (type-feature eity 'either-types)))
      (let ((is-testers nil)(tester nil))
	 (repeat :for ((eity :in either-types))
	  :result `(lambda (x) (or . ,(<# (\\ (tst) `(,tst x)   )
					 (reverse is-testers)))   )
	    (!= tester (get-is-tester eity must-be-defined))
	  :while (or tester must-be-defined) 
	  else :result nil
            (cond (tester
	           (!= is-testers (cons tester *-*))))))))

;(DEFUN EITHER-IS-BUILDER (EITY MUST-BE-DEFINED)
;   (LET ((EITHER-TYPES (TYPE-FEATURE EITY 'EITHER-TYPES)))
;      (LET ((IS-TESTERS NIL)(TESTER NIL))
;	 (LOOP FOR ((EITY IN EITHER-TYPES))
;	  RESULT `(LAMBDA (X) (OR . ,(<# (\\ (TST) `(,TST X)   )
;					 (REVERSE IS-TESTERS)))   )
;	    (!= TESTER (GET-IS-TESTER EITY MUST-BE-DEFINED))
;	  WHILE (OR TESTER MUST-BE-DEFINED) 
;	  ELSE RESULT NIL
;	    (!= IS-TESTERS (CONS TESTER *-*))   ))))

;; Format of entry: (is-name . types-to-be-cleaned-up)

;; 87.10.8: Deleted RESOLVE-EITHER-SUPERTYPE, RESOLVE-EITHER-TYPES

;; Added 11.4.87, changed 7.7.88
(defun boole-subtyper (t1 t2 accep)
   (cond ((eq t2 '*im-super) 'Obj)
	 ((is-subtype t2 'Boolean)
	  (and accep (subtype 'Null t1 t))) ;was (SUBTYPE T1 'Null T)
	 (t nil)   ))

(!= (type-feature 'Boolean 'subtype-fcn) !'boole-subtyper)
