;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: repeatdcl.lisp,v 2.12 2006/05/18 04:07:37 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)

(depends-on %ydecl/ ctldcl listype)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (import '(ytools::repeat-analyze ytools::repeat-vars-analyze
	     ytools::repeat-reassemble yt::repeat-clause-reassemble
	     ytools::tests-results-match yt::clauses-search-for-modes
	     ytools::Rep-clause-stuff ytools::Rep-clause-mode
	     ytools::Rep-var-prop-val ytools::Rep-var-mode
	     ytools::Rep-var-name ytools::Rep-var-alist
             ytools::Within-clauses-subclauses
	     ytools::repeat-var-implied-front ytools::lookup-rep-var-prop
	     ytools::*throughlist ytools::*simple ytools::*step
	     ytools::*reset ytools::*each-iter ytools::iterfcnvar ytools::init)))

(datafun decl-compl repeat
   (defun :^ (exp dest-type)
      (multiple-value-let (vars decls clauses local-fundefs _)
			  (repeat-analyze (cdr exp))
	 (multiple-value-let (vars vars-type-desigs)
			        ;; Too blunt an instrument:
			        ;;;;(bind ((types-separate-fcn*
			        ;;;;         #'designated-type)) ...)
			     (types-separate vars '(:collectors :collector)
					     false)
	       (multiple-value-let (standard-vars collectors _)
				   (repeat-vars-analyze vars)
		  (let ((vars-types
			   (<# (\\ (td)
				  (cond (td (designated-type td))
					(t false)))
			       vars-type-desigs)))
		     (let ((std-vartypes
			      (repeat-vars-decl-compile
				 standard-vars vars-types))
			   (norm-col-vartypes
			      (build-collector-vartypes
				 collectors vars-types #'make-collector-type !()))
			   (res-col-vartypes
			      (build-collector-vartypes
				 collectors vars-types #'lstype clauses)))
			(multi-let
			      (((expanded-fundefs ftype-decls res-type)
				(with-vartypes (append std-vartypes
						       norm-col-vartypes)
				     (repeat-vars-inner-decl-compile
					standard-vars vars-types)
;;;;				     (out "vartypes* = "
;;;;					  vartypes* :%)
				     (repeat-decl-compile
				         local-fundefs
					 (mapcan #'repeat-var-implied-front
						 standard-vars)
					 clauses
					 res-col-vartypes
					 dest-type))))
			   (make-Dclcmp
			      res-type
			      (repeat-reassemble
				 standard-vars collectors
				 `(,@decls
				   ,@(include-if
				        (and (< debuggability* 0)
					     (not (null ftype-decls)))
					`(declare ,@ftype-decls))
				   ,@(vartypes-declarations std-vartypes)
				   ,@(vartypes-declarations norm-col-vartypes))
				 expanded-fundefs clauses))))))))))

;;; Type-check vars whose values are in outer scope
(defun repeat-vars-decl-compile (rep-vars types)
   (letrec ((compile-prop (p ty must-be-type)
	    ;; If p is not false, it is a Rep-var-prop
	    ;; Compile its 'val' and returns its type.
;;;;	       (trace-around compile-prop
;;;;		  (:> "(compile-prop: " p 1 ty 1 must-be-type ")")
	       (cond (p
		      (let ((dc (decl-compile-to-subtype
				   (Rep-var-prop-val p) ty must-be-type)))
			 (!= (Rep-var-prop-val p) (Dclcmp-exp dc))
			 (Dclcmp-typ dc)))
		     (t false))
;;;;		  (:< (val &rest _) "compile-prop: " val))
	       )
	    (compile-prop-found (p ty must-be-type)
	       (or (compile-prop p ty must-be-type)
		   (signal-problem repeat-vars-decl-compile
		      "Rep-var-prop " p " val's prop doesn't compute"))))
      (repeat :for ((rv :in rep-vars)
		    (ty :in types))
;;;;	 (out "Compling " rv :%)
       :nconc
	 (let ((alist (Rep-var-alist rv))
	       (var (Rep-var-name rv)))
	    (let ((val (lookup-rep-var-prop 'init alist)))
	       (ecase (Rep-var-mode rv)
		  (*simple
		   (multi-let (((init-val var-ty)
				(cond (val
				       (let ((ty1 (compile-prop val ty false)))
					  (values (Rep-var-prop-val val)
						  (or ty ty1 'Obj))))
				      (ty
				       (let ((ie (type-feature ty 'initexp)))
					  (!= (Rep-var-alist rv)
					      (cons (tuple 'init ie)
						    *-*))
					  (values
					     (or ie 'false)
					     ty)))
				      (t
				       (values 'nil 'Obj)))))
		      (list (make-Vartype var var-ty init-val !()))))
		  (*throughlist
		   (let ((list-type (lstype (or ty 'Obj)))
			 initexp)
;;;;		      (!= list-type (compile-prop val list-type false))
		      (let ((ty1 (compile-prop-found val list-type false)))
			 (cond ((not ty)
				(!= ty (type-feature ty1 'eltype))
				(cond ((not ty)
				       (breakpoint repeat-vars-decl-compile
					  "Null eltype for " ty1))))))
		      (cond ((not (eq var '_))
			     (!= initexp (lookup-rep-var-prop ':initbind alist))
			     (cond ((not initexp)
				    (!= initexp (type-feature ty 'initexp))
				    (cond (initexp
					   (!= alist (cons (tuple ':initbind initexp)
							   *-*))
					   (!= (Rep-var-alist rv) alist)))))))
		      (nconc (cond ((not (eq var '_))
				    (list (make-Vartype
					     var ty (or initexp false)
					     '())))
				   (t '()))
			     (let ((tailvar (assq ':tail alist)))
				(cond (tailvar
				       (list (make-Vartype
						(Rep-var-prop-val tailvar)
						list-type
						false !())))
				      (t
				       !(Vartype))))
			     )))
		  (*step
		   (compile-prop val ty 'Integer)
		   (let ((by (lookup-rep-var-prop ':by alist))
			 (to (lookup-rep-var-prop ':to alist)))
		      (compile-prop by ty 'Integer)
		      (compile-prop to ty 'Integer))
		   (list (make-Vartype var ty false '())))
		  (*reset
		   (compile-prop val ty false)
;;;;		   (let ((next (lookup-rep-var-prop ':then alist)))
;;;;		      (compile-prop next ty false))
		   (list (make-Vartype var ty false '())))
		  (*each-iter
		   (let ((iterfcnvar (Rep-var-prop-val
				        (lookup-rep-var-prop
					   'iterfcnvar alist))))
		      (list (make-Vartype
			       iterfcnvar
			       (make-Funtype ty '() true)
			       `(\\ () ,val)
			       '())
			    (make-Vartype
			       var ty false '()))))))))))
			 
;;; type-check vars whose values have vars from inner scope
(defun repeat-vars-inner-decl-compile (rep-vars types)
   (repeat :for ((rv :in rep-vars)
		 (ty :in types))
      (let ((alist (Rep-var-alist rv)))
	 (cond ((eq (Rep-var-mode rv)
		    '*reset)
		(let ((next (lookup-rep-var-prop ':then alist)))
		   (!= (cadr next)
		       (decl-compile-exp *-* ty))))))))

;;; 'collectors' is either false or a list (:collectors v1 v2 ...)
;;; 'checkable-for-anon' is either false or the list of clauses;
;;; if collect clauses but no collector, we create one.
(defun build-collector-vartypes (collectors types typeconser checkable-for-anon)
   (cond (collectors
	  (repeat :for ((c :in (cdr collectors))
			(ty :in (nthcdr (- (len types) (len collectors)
					   -1)
					types)))
	   :collect
	      (make-Vartype c (funcall typeconser (or ty 'Obj))
			    false '())))
	 ((and checkable-for-anon
	       (clauses-search-for-modes checkable-for-anon
					 '(:collect :nconc :append)))
	  (list (make-Vartype '| anon-collector|
                              false ;;;;(funcall typeconser 'Obj)
			      false !())))
	 (t !(Vartype))))

;;; This is redefined in an upward-compatible way from its
;;; definition in '%ytools/repeat.lisp'.
;;; The old version returned a boolean value.  This one actually
;;; returns a list of all the clause modes found somewhere in 'clauses'
;;; that are also members of the list 'modes'.
(defun clauses-search-for-modes (clauses modes)
   (mapcan (\\ (c)
              (nconc (cond ((memq (Rep-clause-mode c) modes)
                            (list c))
                           (t !()))
                     (cond ((eq (Rep-clause-mode c) ':within)
                            (mapcan (\\ (wc)
			               (clauses-search-for-modes
                                          (Within-clauses-subclauses wc)
                                          modes))
                                    (cadr (Rep-clause-stuff c))))
                           (t !()))))
           clauses))

;;; At this point 'collectors' is a list of explicitly declared
;;; collector variables, possibly ().
;;; Replaces code in 'clauses' with decl-compiled version.
(defun repeat-decl-compile (local-fundefs front-clauses clauses
			    res-col-vartypes dest-type)
;;;;   (dbg-save res-col-vartypes)
;;;;   (breakpoint repeat-decl-compile
;;;;      "res-col-vartypes = " res-col-vartypes)
   (multiple-value-let (fundef-expansions fundef-vartypes ftype-decls)
		       (local-fundefs-decl-compile local-fundefs)
      (multi-let ((res-type
		     (with-vartypes fundef-vartypes
			(repeat-body-decl-compile
			   front-clauses clauses res-col-vartypes dest-type))))
	 (values fundef-expansions ftype-decls res-type))))

(def-class Within-decl-frame
   res-col-vartypes  ; collector declarations
   dest-type         ; dest-type for containing 'repeat'
   res-type          ; res-type for this :within (a subtype of 'dest-type')
   )

;; When handling a :within, this is bound to a Within-decl-frame holding
;; information for :continue's.
(defvar within-frame* false)

;;; Clobbers evaluable pieces of 'clauses' with compiled versions.
;;; Returns res-type for whole 'repeat'
(defun repeat-body-decl-compile (front-clauses clauses res-col-vartypes dest-type)
   (let ((res-type
	    (repeat-clauses-decl-compile
	       clauses res-col-vartypes dest-type)))
      ;; 'implicit-res-and-type' must be called *after*
      ;; 'repeat-clauses-decl-compile', because the latter can alter
      ;; the type of the anonymous collector
      (multi-let (((ires iresty)
		   (implicit-res-and-type (append front-clauses clauses)
					  res-col-vartypes)))
	 (cond (iresty
		(let ((res-dc (type-trans ires iresty dest-type)))
		   (let ((iresty (Dclcmp-typ res-dc)))
		      (supertype-but-not-greater res-type iresty dest-type))))
	       (t res-type)))))

(defun repeat-clauses-decl-compile (clauses res-col-vartypes dest-type)
      (repeat :for ((c :in clauses)
		    (ret-type 'Void))
       :result ret-type
;;;;	 (out "Clause " c :%)
;;;;         (dbg-save res-col-vartypes c)
;;;;         (breakpoint repeat-clauses-decl-compile
;;;;            "c = " c)
	 (selq (Rep-clause-mode c)
	    (:do (!= (Rep-clause-stuff c)
		     (<# (\\ (d) (decl-compile-exp d 'Void))
			 *-*)))
	    (:result
	     (let ((resdcls (vartypes-declarations res-col-vartypes))
		   (resdc (with-vartypes res-col-vartypes
				    (decl-compile (Rep-clause-stuff c)
						  dest-type))))
;;;;		(out ":result type = " resdc :%)
		(!= ret-type
		    (supertype-but-not-greater *-* (Dclcmp-typ resdc) dest-type))
		(!= (Rep-clause-stuff c)
		    (cond ((null resdcls)
			   (Dclcmp-exp resdc))
			  (t
			   `(locally ,@resdcls ,(Dclcmp-exp resdc)))))))
	    ((:collect :nconc :append)
	     (collect-clause-decl-compile c res-col-vartypes))
	    ((:when :while :until while until)
	     (!= (Rep-clause-stuff c)
		 (decl-compile-exp *-* 'Boolean)))
	    ((:within)
	     (bind ((within-frame*
		       (make-Within-decl-frame
			  res-col-vartypes dest-type void-type*)))
		(let ((within-dc (decl-compile
				    (car (Rep-clause-stuff c))
				    'Void)))
		   (!= (car (Rep-clause-stuff c))
		       (Dclcmp-exp within-dc))
;;;;		   (breakpoint repeat-clauses-decl-compile
;;;;		      "Done with :within, frame-res-type = "
;;;;		      (Within-decl-frame-res-type within-frame*))
		   (!= ret-type (supertype-but-not-greater
				   *-* (Within-decl-frame-res-type within-frame*)
				   dest-type)))))
	    (t
	     (signal-problem repeat-clauses-decl-compile
		"Fumbled clause " c)))))

(defun collect-clause-decl-compile (c res-col-vartypes)
   (let ((mode (Rep-clause-mode c))
	 (col (car (Rep-clause-stuff c)))
	 (exp (cadr (Rep-clause-stuff c))))
      (multi-let ((col-vt
		   (cond (col
			  (let ((vt (var-lookup col res-col-vartypes)))
			     (cond ((not vt)
				    (signal-problem collect-clause-decl-compile :fatal
				       "Undeclared collector in 'repeat' clause: "
				       mode 1 (Rep-clause-stuff c))))
			     vt))
			 ((not (null res-col-vartypes))
			  (car res-col-vartypes))
			 (t
			  (signal-problem collect-clause-decl-compile
			     "Failed to provide anonymous collector for "
			     c)))))
	 (!= col (Vartype-var col-vt))
	 (let ((dc (decl-compile
		      exp
		      (cond ((eq col '| anon-collector|)
			     (cond ((eq mode ':collect)
				    univ-type*)
				   (t
				    (designated-type '(Lst Obj)))))
			    ((eq mode ':collect)
			     (type-feature (Vartype-typ col-vt)
					   'eltype))
			    (t
			     (Vartype-typ col-vt))))))
;;;;            (dbg-save exp dc col-vt)
;;;;            (breakpoint collect-clause-decl-compile
;;;;               "dc = " dc)
	    (!= (cadr (Rep-clause-stuff c))
		(Dclcmp-exp dc))
	    (cond ((eq col '| anon-collector|)
		   (let ((new-type 
			    (cond ((eq mode ':collect)
				   (lstype (Dclcmp-typ dc)))
				  (t (Dclcmp-typ dc)))))
		      (!= (Vartype-typ col-vt)
			  (cond ((not *-*) new-type)
				(t
				 (common-supertype
				     *-* new-type)))))
;;;;		   (out "anon-collector type set to " (Vartype-typ col-vt) :%)
		   ))))))

;;; Duplicates logic from 'tests-results-match' in repeat.lisp .
;;; Stop as soon as we find a test with no explicit :result following it,
;;; and return the < implicit-result, its-type >.  If we find nothing, return
;;; < nil, false >.
(defun implicit-res-and-type (clauses res-col-vartypes)
;;;;   (trace-around implicit-res-and-type
;;;;      (:> "(implicit-res-and-type: " clauses :% 3 res-col-vartypes")")
   (let-fun ((search-clauses (clauses outer-layers)
		;; 'outer-layers' is list of lists of clauses to search for
		;; matches.
;;;;		(trace-around search-clauses
;;;;                   (:> "(search-clauses: " clauses ")")
                (repeat :for ((this-clause :in clauses :tail cl))
		 :result (values nil false)
		 :within
		    (case (Rep-clause-mode this-clause)
		       ((:within)
			(multi-let (((ires irt)
				     (search-within (cadr (Rep-clause-stuff
							     this-clause)))))
			   (:continue
			    :until irt
			    :result (values ires irt))))
		       ((:while :until)
			(:continue
			 :when (not (is-String (Rep-clause-stuff this-clause)))
			 :until (not (or (assoc ':result (cdr cl))
					 (some (\\ (clause-list)
						  (assoc ':result
							 clause-list))
					       outer-layers)))
			 :result (cond ((null res-col-vartypes)
					(values 'nil 'Null))
				       (t
					(let ((col-vt
						 (car res-col-vartypes)))
					   (values
					      (Vartype-var col-vt)
					      (or (Vartype-typ col-vt)
						  (assume-type col-vt)))))))))

		 :where

		   (:def search-within (inner-clauses)
		      (repeat :for ((continue :in inner-clauses))
		       :result (values nil false)
		       :within (multi-let (((ires irt)
					    (search-clauses
					       continue
					       (cons (cdr cl) outer-layers))))
				  (:continue
				   :until irt
				   :result (values ires irt)))))

		   (:def assume-type (col-vt)
		       (signal-problem implicit-res-and-type
			  "Implied collector never got a type: " col-vt
			  (:proceed "I will assume it is (Lst Obj)"))
		       (designated-type '(Lst Obj))))
;;;;                   (:< (implicit-res ir-type) "search-clauses: "
;;;;                       implicit-res 1 ir-type))
                ))

      (search-clauses clauses !()))
;;;;      (:< (implicit-res ir-type) "implicit-res-and-type: <" implicit-res 1 ir-type ">"))
   )

(defun decl-compile-to-subtype (e dest-type supertype)
   (let ((dc (decl-compile e dest-type)))
      (cond (supertype
	     (!= dc (type-trans (Dclcmp-exp dc)
				(Dclcmp-typ dc)
				supertype))))
      dc))

;;;;(datafun decl-compl loop repeat)
	   
(datafun decl-compl :continue
   (defun :^ (exp dest-type)
      (cond ((not within-frame*)
	     (signal-problem :continue
		":continue outside a :within -- " exp)))
      (multi-let (((vars decls clauses local-fundefs _)
		   (repeat-analyze (cdr exp)))
		  (repeat-res-col-vartypes
		     (Within-decl-frame-res-col-vartypes within-frame*))
		  (repeat-dest-type
		     (Within-decl-frame-dest-type within-frame*)))
	 (cond ((or (not (null vars))
		    (not (null decls))
		    (not (null local-fundefs)))
		(signal-problem :continue-decl-compl
		   "Illegal :continue clause " exp)))
	 (let ((cont-res-type
		  (repeat-clauses-decl-compile
			  clauses repeat-res-col-vartypes repeat-dest-type)))
;;;;	    (dbg-save (wf1 within-frame*) cont-res-type repeat-dest-type)
;;;;	    (breakpoint :continue-decl-compl
;;;;	       "wf1 = " within-frame*)
	    (!= (Within-decl-frame-res-type within-frame*)
		(supertype-but-not-greater *-* cont-res-type repeat-dest-type))
	    (type-trans
	      `(:continue
	       ,@(mapcan #'repeat-clause-reassemble clauses))
	      void-type*
	      dest-type)))))

(defun supertype-but-not-greater (ty1 ty2 sup-ty)
   (let ((cs (common-supertype ty1 ty2)))
      (cond ((or (not sup-ty) (subtype cs sup-ty true))
	     cs)
	    (t sup-ty))))