;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: strtype.lisp,v 2.12 2006/05/16 14:34:48 dvm Exp $

(depends-on :at-compile-time %ydecl/ deftyp types typvarsyn)
(depends-on :at-run-time %ydecl/ types typekern listype hostypes dclmacs)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(&flag Lstructure Rcd Structure Object)))

;; There are two cases: If this construct occurred inside a DEFTYPE, then
;; we are to reduce it to DEFCLASS.  Otherwise, it is anonymous, and we must
;; simulate using vectors.  Slight confusion: If a (STRUCTURE () ...) occurs
;; inside a DEFTYPE with no HANDLER, it reduces to the anonymous case.
;; The conventions for ID are confused and obsolete...
(datafun type-loader Structure
   (defun :^ (d typename)  ; TYPENAME non-() iff this occurred inside a DEFTYPE.
      (let (flag contents h clauses slotvartypes
	    components defaults (already-defined false)
	    (include false) ; Type included
	    (includestruct false)) ; Structure included
	 (!= < flag contents > (str-flag-extract (cdr d) typename))
         (!= components (member-if (\\ (e) (car-eq e ':include))
				   contents))
         (cond ((not (null components))
		(!= contents (remove1q (car components) *-*))
		(!= components (cdar *-*))
		(cond ((or (not (= (len components) 1))
			   (not (is-Symbol (car components))))
		       (signal-problem structure :fatal
			  "Illegal to :INCLUDE in STRUCTURE: " components)))
		(!= include (car components))
		(repeat
		   (cond ((is-type-desig include)
			  (!= includestruct
			      (type-feature include 'class-name))))
		 :until (or (and includestruct (is-struct-name includestruct))
			   (is-struct-name include))
	           (!= include
		       (signal-problem flavor-type 
		          "Can't :INCLUDE nonstructure type " include
                          " in " typename
		          (:prompt-for "Correct typename>" include))))
	        (cond ((not includestruct)
		       (!= includestruct include)
		       (!= include false)))))
         (!= h (member-if (\\ (e) (or (car-eq e 'handler)
				      (car-eq e ':handler)))
			  contents))
         (cond (h
                (!= contents (remove1q (car h) *-*))
                (!= clauses (cdar h))))
         (!= < already-defined contents >
	     (check-for-already-defined contents typename))
         (!= slotvartypes
	     (bvars-vartypes nil contents (not deftype-slurping*)))
         (!= defaults (exists (vt in slotvartypes)
                              (not (memq (Vartype-initial vt)
					 '(*noalloc *noinit)))))
	 (!= clauses
	     (let ((m (struc-clauses-massage (remove-if #'atom *-*)
					     typename)))
		(cond ((memq ':allow-other-ops *-*)
		       `(:allow-other-ops ,@m))
		      (t m))))
         (cond ((and typename (or flag clauses defaults already-defined))
		; Global, DEFTYPE case.
                (real-structure-loader
                   d typename already-defined
                   slotvartypes clauses include includestruct))
               (includestruct
		(signal-problem structure :fatal
		    "Can't :INCLUDE " (or include includestruct)
		    " in anonymous structure"))
               (already-defined
                (signal-problem structure :fatal
                    "Anonymous structure can't be constructed from "
                    already-defined))
               (t
                (let ((slotnames (<# Vartype-var slotvartypes))
	              (slotypes (<# (\\ (vt)
				       (cond ((Vartype-typ vt)
					      (Type-desig (Vartype-typ vt)))
					     (t 'Obj)))
				    slotvartypes)))
                   (cond ((null clauses)
		          ; Vector with named slots
		          (vec-structure-loader d flag slotypes slotnames))
                         (t
		          (obj-structure-loader d flag slotypes slotnames
                                                clauses)))))))))

(defun struc-clauses-massage (clauses typename)
   (repeat :for (c :in clauses)
      :collect
	  (multiple-value-let (name argl ft body)
			      (funclause-analyze
			         (cond ((car-eq c ':def) (cdr c))
				       (t c)))
             (cond (deftype-slurping*
	            `(,name ,argl 
		      (declare (ignore ,@argl))
		      nil))
		   (t
                    (cond ((not (subtype ft (symtype name) t))
			   (out (:to *error-output*)
				"Warning-- method for " name
				    " in " typename " is not of type "
				    (type-pname (symtype name)) :%)))
         	    `(,name ,argl
		      ,@(fundecl-expand argl ft false body typename)))))))

(defun real-structure-loader (d typename already-defined slotvartypes clauses
			      include includestruct)
   (let ((strucname (or already-defined (build-symbol (:< typename) -struct)))
	 (slotnames (<# Vartype-var slotvartypes))
	 (slotypes (<# vartype-type-or-obj slotvartypes)))
      (maybe-def-struct-class strucname already-defined includestruct
			      clauses slotvartypes)
      (let ((class-prec-list
	       (cond (include (class-precedence-list (list include)
						     typename))
		     (t !()))))
	 (let ((all-initargs
		  (assemble-all-initargs class-prec-list slotvartypes)))
	    (multi-let (((consname struc-const)
			 (cond ((null all-initargs)
				(values false false))
			       (t
				(values 
				   (build-symbol make- (:< strucname))
				   (build-symbol (:< typename) -const*))))))
	      (let ((xpr `(make-Type
			      ',d ',(or include 'Objstruct)
			      (list ,@(include-if consname
					`(make-Slot 'conser ',consname nil
						    univ-type*
						    ,(typelist-loader
							(<# third
							    all-initargs))))
				    (make-Slot 'is
					       ',(build-symbol
						   is- (:< strucname))
					       nil 'boolean nil)
				    ,@(<# (\\ (nam typ)
					     (stype-slot
						strucname nam
						(Type-desig typ)))
					   slotnames slotypes))
			      (list (tuple 'class-name ',strucname)
				    (tuple 'component-types
					   ,(cond (include `(list ',include))
						  (t !())))
				    ,@(include-if struc-const
					 `(tuple 'initexp ',struc-const))
					;;;;	 '(val-if-boundp ',struc-const)
				    (tuple 'initargs
					   ,(vartypes->initargs-loader
					       slotvartypes))))))
	     (cond ((and struc-const (not deftype-slurping*))
		    (on-list
		       (initexp-const-defn
				struc-const strucname all-initargs)
		       deftype-funs*)))
	     (!= xpr `(progn
			(!= (table-entry nisp->cl-tab* ',typename)
			    (\\ (ty) (ignore ty) ',strucname))
			,@(include-if (and struc-const deftype-slurping*)
			     `(defvar ,struc-const))
			,*-*))
	     xpr))))))

(defun maybe-def-struct-class (strucname already-defined includestruct
			       clauses slotvartypes)
   (cond ((not (check-for-nisp-descriptor already-defined ':structure))
	  (let ((defclass-form
		   `(def-class ,strucname
				(:options
				    ;;;;:nokey
				    (:kind :structure
				       ,@(include-if already-defined
						     ':already-defined))
				       ,@(include-if
					   (and includestruct
						(not already-defined))
					   `(:include ,includestruct)))
		       (:handler
			,@(cond (deftype-slurping*
				 (<# (\\ (c)
					(cond ((atom c) c)
					      (t
					       `(,(car c) ,(cadr c) 
						  (declare
						   (ignore ,@(cadr c)))
						  nil))))
				   clauses))
				(t clauses)))
		      ,@(<# vartype->slotspec slotvartypes))))
	     (cond (deftype-slurping*
		       (eval defclass-form))
		   (t
		    (!= deftype-funs* (cons defclass-form *-*))))))))

(defun vartype->slotspec (svt)
   (cond ((and now-compiling* (< debuggability* 0))
	  (let ((ty (vartype-type-or-obj svt)))
	     `(,(Vartype-var svt)
	       ,(cond ((memq (Vartype-initial svt) '(*noinit *noalloc))
		       (or (type-feature ty 'initexp) 'nil))
		      (t (Vartype-initial svt)))
	       :type ,(type-ok-for-slot (nisp->hostype ty)))))
	 ((memq (Vartype-initial svt) '(*noinit *noalloc))
	  (Vartype-var svt))
	 (t `(,(Vartype-var svt) ,(Vartype-initial svt)))))

(defun all-struct-slotypes (include includestruct)
   (cond (include
          (repeat :for (p :in (class-assemble-initargs include))
	   :collect (third p)
;;;;	        (Type-desig
;;;;                      (type-slot-fun include (cadr p) 'type true))
	  ))
         (t
          (<# (\\ (n) (ignore n) 'Obj)
              (all-slot-names includestruct)))))

; Type (OBJECT -options- -slots-n-types-)
; where options are
;     (:SLOTMETHODS ...)
;     (:INCLUDE -components-)
;     (:HANDLER -clauses-)


(datafun type-loader Object
   (defun :^ (fd typename)
      (cond ((null typename)
	     (signal-problem object-type-loader :continue
		     "Can't have an OBJECT type outside a DEFTYPE")))
      (let (flavname consname
	    (stuff (cdr fd))
	    slotmethods clauses already-defined components
	    slotvartypes ;;;; slotypes
	    (class-const (build-symbol (:< typename) "-" const "*"))
	    ;(SLOTPACKAGE NIL)
            ;PACKAGED-NAMES
	    component-classes component-types)
	 (!= slotmethods (member-if (\\ (a) (or (car-eq a 'slotmethods)
						(car-eq a ':slotmethods)))
				    stuff))
	 (cond (slotmethods
		(!= stuff (remove1q (car slotmethods) *-*))
		(!= slotmethods (cdar *-*))))
	 (!= clauses (member-if (\\ (a) (or (car-eq a 'handler)
					    (car-eq a ':handler)))
				stuff))
	 (cond (clauses
		(!= stuff (remove1q (car clauses) *-*))
		(!= clauses (cdar *-*))))
	 (!= < already-defined stuff >
	     (check-for-already-defined stuff typename))
	 (!= flavname
	     (or already-defined
		 (build-symbol (:< typename) -class)))
	 (!= components (member-if (\\ (a) (or (car-eq a 'include)
					       (car-eq a ':include)))
				   stuff))
	 (cond (components
		(!= stuff (remove1q (car components) *-*))
		(!= components (cdar *-*))))
	 (!= component-types '())
	 (repeat :for ((c :in components) cf)
	    (repeat
	       (cond ((is-type-desig c)
		      (!= cf (type-feature c 'class-name))))
	     :until (or (and cf (is-objclass-name cf))
                       (is-objclass-name c))
	       (!= c
		   (signal-problem flavor-type 
		      " Can't :INCLUDE nonobject type " c
		      " in " typename
		      (:prompt-for "Correct typename>" c))))
	    (cond (cf 
		   (!= component-types (cons c *-*))
		   (!= component-classes (cons cf *-*)))
		  (t
		   (!= component-classes (cons c *-*)))))
	 (!= component-types (dreverse *-*))
	 (!= component-classes (dreverse *-*))
         (!= slotvartypes (bvars-vartypes nil stuff true))
;;;;	 (!= slotypes (<# vartype-type-or-obj
;;;;                          slotvartypes))
	 (maybe-def-object-class flavname already-defined
				 slotmethods component-classes
				 slotvartypes)
	 (!= deftype-funs*
	     (append (class-clauses-massage clauses)
		     *-*))
	 (let ((class-prec-list
		   (class-precedence-list component-types typename)))
;;;;	    (cond ((eq typename 'Txt-txtlisp-mode)
;;;;		   (dbg-save class-prec-list component-types)
;;;;		   (breakpoint Object-type-loader
;;;;		      "Loading Txt-txtlisp-mode, class-prec-list = "
;;;;		      class-prec-list)))
	    ;; 'class-prec-list' is in reverse order, and doesn't
	    ;; include this class itself.
	    (let ((all-initargs 
		    (assemble-all-initargs class-prec-list slotvartypes)))
	       (!= consname (build-symbol make- (:< flavname)))
;;;;	       (out "Loading " typename
;;;;	            " Component types: " component-types :%)
	       (let ((xpr `(make-Type ',fd 'Obj
			      (list (make-Slot 'conser ',consname
					       nil univ-type*
					       ,(typelist-loader
						   (<# third all-initargs)))
				    (make-Slot 'is 
					       '(*integrable (x)
						   (typep x ',flavname))
					       nil
					       'boolean nil)
				    ,@(<# (\\ (vt)
					     (stype-slot
						flavname
						(Vartype-var vt)
						(Type-desig
						   (vartype-type-or-obj
							       vt))))
					  slotvartypes))
			      (list (tuple 'class-name ',flavname)
				    (tuple 'component-types ',component-types)
				    (tuple 'initexp ',class-const)
					;;;;	 '(val-if-boundp ',class-const)
				    (tuple 'initargs
					  ,(vartypes->initargs-loader
					      slotvartypes))
				    (tuple 'subtype-fcn !'flavor-subtype)
				    (tuple 'slot-filler-fcn
					   (class-slot-filler-fcn
					      ,(typelist-loader
						  (reverse
						      class-prec-list))))))))
		 (cond ((and class-const (not deftype-slurping*))
			(on-list
			   (initexp-const-defn
				    class-const flavname all-initargs)
			   deftype-funs*)))
		(!= xpr `(progn
			   (!= (table-entry nisp->cl-tab* ',typename)
			       (\\ (ty) (ignore ty) ',flavname))
			   ,@(include-if (and class-const deftype-slurping*)
				`(defvar ,class-const))
			   ,*-*))
		xpr))))))

(defun maybe-def-object-class (flavname already-defined
			       slotmethods component-classes
			       slotvartypes)
   (cond ((not (check-for-nisp-descriptor already-defined ':object))
	  (let ((classdef
		   `(def-class ,flavname
			         (:options
				     ;;;;:nokey
				     (:kind :object
					    ,@(include-if already-defined
							  ':already-defined))
				     (:slotmethods :noinherit
						   ,@slotmethods)
				     (:include ,@component-classes))
		       ,@(repeat :for (vt :in slotvartypes)
			    :collect
			       (let ((v (Vartype-var vt)))
				  (cond ((eq (Vartype-initial vt) '*noinit)
					 v)
					(t `(,v ,(Vartype-initial vt)))))))))
	     (!= deftype-funs*
		 (cons classdef *-*))
	     (cond (deftype-slurping*
		    (eval classdef)))))))

(defvar notify-if-redeclaring-class* false)

;;;;(defun assemble-all-slot-types (class-prec-list new-class-slots)
;;;;   (<# third (assemble-all-initargs class-prec-list new-class-slots)))

;;; Associated with every classoid type is a feature 'initargs'
;;; which is a list of triples (keyword symbol type), giving the
;;; initialization argument, slot name, and slot type for all the
;;; local slots of this type.   
;;; This procedure returns a list of all the triples for the class and
;;; its superclasses, with duplicates removed in (what I hope is) the
;;; official CL way.
;;; Note, however, that the 'class-prec-list' is in the opposite order
;;; from its official self, with superclasses coming first.   
(defun assemble-all-initargs (class-prec-list new-class-slots)
       (remove-duplicates
	  (nconc (<$ (\\ (cty)
			(type-feature cty 'initargs))
		     class-prec-list)
		 (<# (\\ (vt)
			(let ((var (Vartype-var vt)))
			   (tuple (intern (symbol-name var) keyword-package*)
				  var
				  (Vartype-typ vt))))
		     new-class-slots))
	  :key #'second
	  :test #'eq))

;;; Return builder of list of triples (keyword slot-name slot-type).  
;;; The slot-name and keyword
;;; are symbols with the same printname, but living in different packages.
(defun vartypes->initargs-loader (vartypes)
   `(list
       ,@(<# (\\ (vt)
		(let ((v (Vartype-var vt)))
		    `(tuple ',(intern (symbol-name v) keyword-package*)
			    ',v
			    ,(let ((td (Type-desig (Vartype-typ vt))))
			        (cond ((is-Symbol td) `',td)
				      (t (type-loader td false)))))))
	     vartypes)))

(defun initexp-const-defn (class-const class-name all-initargs)
   (cond (deftype-slurping*
	  `(defvar ,class-const))
	 (t
	  `(defparameter
	      ,class-const
	       (make-inst ,class-name
			  ,@(<! (\\ (ia)
				   (list (first ia)
					 (safe-type-initexp (third ia))))
				all-initargs))))))

(defun safe-type-initexp (ty)
   (let ((ie (type-feature ty 'initexp)))
      (cond (ie
	     (cond ((is-Symbol ie)
		    `(val-if-boundp ',ie))
		   (t ie)))
	    (t 'nil))))

;; Returns t if a descriptor for the class with the given name
;; already exists.  
(defun check-for-nisp-descriptor (classname kind)
   (let ((existing-descriptor (seek-ytools-class-descriptor classname)))
      (cond (existing-descriptor
	     (cond ((and notify-if-redeclaring-class*
			 deftype-slurping*)
		    (out (:to *error-output*)
		       (:a kind) " class " classname
		       " already declared Nisp class -- won't redeclare" :%)))
	     (cond ((not (eq (ytd-medium existing-descriptor)
			     kind))
		    (signal-problem check-for-nisp-descriptor
		       classname " is declared to be of kind "
		       (ytd-medium existing-descriptor)
		       " but is being redeclared to be of kind "
		       kind
		       (:novalue "I'll ignore the redeclaration"))))
	     true)
	    (t false))))

(defun check-for-already-defined (contents typename)
   (let ((flags '(:already-defined :built-in :built-in-class built-in)))
      (let ((already-defined (member-if (\\ (e) (or (memq e flags)
						    (and (consp e)
							 (memq (car e) flags))))
					contents)))
         (cond (already-defined
		(values (cond ((and (consp (car already-defined))
				    (not (null (cdar already-defined))))
			       (cadar already-defined))
			      (t typename))
			(remove1q (car already-defined) contents)))
	       (t
		(values false contents))))))

(defun flavor-subtype (t1 t2 accep)
   (cond ((eq t2 '*im-super) 'Obj)
	 (t
	  (<v (\\ (c1) (subtype c1 t2 accep))
	      (type-feature t1 'component-types)))))

(defun class-clauses-massage (clauses)   
   (repeat :for (c :in clauses)
      :collect
	   (let ((name (car c)) (stuff (cdr c)))
	      `(defmethproc        ;(,FLAVNAME ,@(COND ((ATOM NAME) NAME)
		                   ;                   (T NAME)))
                  ,name
		  ,@stuff))))

(datafun type-former eql 
   (defun :^ (def typename)
      (cond (typename
             (signal-problem eql-type-former :fatal
                "Can't have type " def " in a DEFTYPE with name " typename)))
      (let ((dc (decl-compile (cadr def) nil)))
         (make-Type def
                    (Dclcmp-typ dc)
                    '()
                    (list (list 'class-name `(eql ,(Dclcmp-exp dc))))))))

;;; The triples (in format generated by vartypes->initargs)
;;; are returned in an order that puts supertypes before subtypes.
(defun class-assemble-initargs (class-type)
   (append (let ((cl (type-local-feature class-type 'component-types)))
              (cond ((null cl)
                     (let ((s (Type-super class-type)))
                        (cond (s (class-assemble-initargs s))
                              (t '()))))
                    (t
                     (<! class-assemble-initargs cl))))
           (or (type-local-feature class-type 'initargs) '())))

(defun class-precedence-list (component-types new-type-name)
   (let ((rel (class-precedence-relation component-types))
	 ;; This is collected in reverse order  --
	 (prec-list !()))
      (repeat :for (next)
       :until (null rel)
       :result prec-list
	 (!= next (elts-with-no-pred rel))
	 (cond ((null next)
		(signal-problem class-precedence-list
		   "Inconsistent class hierarchy above " new-type-name)))
	 (let ((chosen
		  (cond ((null (tail next))
			 (head next))
			(t
			 ;; Tie breaker: Find which element of 'next' has
			 ;; a direct subclass first in 'prec-list' (i.e.,
			 ;; rightmost after reversal).
			 (repeat :for ((n :in next)
				       ;; If not 'false', this is the
				       ;; longest tail of 'prec-list'.
				       ;; whose first element is a direct
				       ;; subclass of an element of 'next' --
				       (prec-list-tail false)
				       (best-so-far false))
			  :result (or best-so-far
				      (signal-problem class-precedence-list
					    "Unable to find direct subclass"
					    " of classes in " next))
			     (let ((next-tail
				      (repeat :for ((c :in prec-list
						       :tail pl-tail))
				       :result false
				       :until (memq n (type-feature
							 c 'component-types))
				       :result pl-tail)))
				(cond ((and next-tail
					    (or (null prec-list-tail)
						(memq (car prec-list-tail)
						      next-tail)))
				       (!= prec-list-tail
					   next-tail)
				       (!= best-so-far n)))))))))
	    (!= prec-list (cons chosen *-*))
	    (!= rel (repeat :for ((chain :in rel))
		     :within
		       (cond ((eq (head chain) chosen)
			      (let ((rem (tail chain)))
				 (cond ((not (null rem))
					(:continue
					 :collect rem)))))
			     (t
			      (:continue
			       :collect chain))))))

       :where
         (:def elts-with-no-pred (rel)
	     (remove-duplicates
		(repeat :for ((chain :in rel))
		 :when (and (not (null chain))
			    (not (exists (ch2 :in rel)
				    (memq (first chain) (rest ch2)))))
		 :collect (first chain))
		:test #'eq)))))

;;; Relation is represented as a list of lists, each of the form
;;; (c c c ... c)
;;; meaning that the c's are a chain of immediate precedence relations.
(defun class-precedence-relation (classoid-types)
   (cond ((null classoid-types)
	  !())
	 (t
	  (let ((explored !())
		(left-to-explore classoid-types))
	     (repeat :for ((next = classoid-types))
	      :collect next
	      :while (not (null left-to-explore))
		 (let ((c (off-list left-to-explore)))
		    (cond ((memq c explored)
			   (!= next !()))
			  (t
			   (!= next (cons c (type-feature c 'components)))
			   (on-list c explored)
			   (repeat :for ((component :in (cdr next)))
			      (!= left-to-explore
				  (adjoinq component *-*)))))))))))

;;;;(defun class-precedence-relation (classoid-types)
;;;;   (let ((explored !())
;;;;	 (left-to-explore classoid-types))
;;;;      (repeat :for ((next = classoid-types))
;;;;       :nconc (seed-precedence-relation next)
;;;;       :while (not (null left-to-explore))
;;;;          (let ((c (off-list left-to-explore)))
;;;;	     (cond ((memq c explored)
;;;;		    (!= next !()))
;;;;		   (t
;;;;		    (!= next (cons c (type-feature c 'components)))
;;;;		    (on-list c explored)
;;;;		    (repeat :for ((component :in (cdr next)))
;;;;		       (!= left-to-explore (adjoinq component *-*)))))))))

(defun seed-precedence-relation (classoid-types)
   (cond ((null classoid-types) !())
	 (t
	  (repeat :for ((cl = classoid-types :then (tail cl)))
	   :until (null (tail cl))
	   :collect (tuple (head cl) (head (tail cl)))))))

(defun vartype-type-or-obj (vt) (or (Vartype-typ vt) 'Obj))

(defun seek-ytools-class-descriptor (name)
   (and name
	(get-ytools-class-descriptor name)))

(defun stype-slot (strucname n ty)
   (let ((accfname (build-symbol (:< strucname) - (:< n))))
      `(make-Slot ',n
                  ',accfname
                  '(*integrable (s x) (setf (,accfname s) x))
                  ,(type-or-desig-loader ty nil)
                  nil)))

; Take a clause (op (-args-) -body-) and throw body away.
;(DEFUN CLAUSE-TRIVIALIZE (C)
;   `(,(CAR C) ,(CADR C) (IGNORE ,@(CADR C)) NIL))
                

(defun obj-structure-loader (def flag slotypes slotnames clauses)
   (let ((vlen (cond (flag (+ (len slotnames) 2))
                     (t (+ (len slotnames) 1)))))
      `(make-Type ',def 'Objstruct
	          (list (make-Slot 'conser
			    '(lambda ,slotnames
				     ,(cond (flag
					     `(make-Object ,clauses
						 ',flag ,@slotnames))
					    (t
					     `(make-Object ,clauses
						 ,@slotnames))))
			    nil 'Obj ,(argtypes-loader slotypes))
			 ,@(include-if flag
				  `(make-Slot 'is
					'(lambda (x)
					    (and (is-Object x)
						 (eq (obref x 0) ',flag)))
					nil 'Boolean nil))
			 ,@(mapcar
			       (\\ (n i ty)
				  `(make-Slot ',n
				       '(lambda (v) (obref v ,i))
				       '(lambda (v x)
					   (setf (obref v ,i) x))
				       ,(type-or-desig-loader ty nil)
				       nil))
			       slotnames
			       (series (cond (flag 1) (t 0))
					     (- vlen 1))
			       slotypes)))))

(defun vec-structure-loader (def flag slotypes slotnames)
   (let ((vlen (cond (flag (+ (len slotnames) 1))
		     (t (len slotnames)))))
      `(make-Type ',def
		  ,(rcd-loader (cond (flag (cons 'symbol slotypes))
				     (t slotypes)))
		  (list ,@(include-if flag
			    `(make-Slot 'conser
					 '(*integrable ,slotnames
					     (vector ',flag ,@slotnames))
					 nil 'Obj ,(argtypes-loader slotypes)))
			,@(cond (flag
				 `((make-Slot 'is
					      '(*integrable (x)
						    (and (is-Vector x)
							 (eq (aref x 0)
							     ',flag)))
					      nil 'Boolean nil)))
				(t nil))
			,@(<# (\\ (n i ty)
				 `(make-Slot ',n
					     '(*integrable (v) (aref v ,i))
					     '(*integrable (v x)
						      (setf (aref v ,i) x))
					     ,(type-or-desig-loader ty nil)
					     nil))
			       slotnames
			       (series (cond (flag 1) (t 0))
				       (- vlen 1))
			       slotypes))
		  (list (tuple 'initexp
                               ',(sequence-initexp-constructor-form
                                    'vector flag slotypes))))))

(datafun type-loader Rcd
   (defun :^ (def typename)
      (ignore typename)
      (rcd-loader (cdr def))))

(defun rcd-loader (slotype-desigs)
   (let ((n (len slotype-desigs))
         (slotypes (<# check-designated-type slotype-desigs)))
      (let ((elty
	       (Type-desig
		  (</ (\\ (ety sty)
		         (common-supertype ety sty))
		      void-type*
		      slotypes))))
	  (let ((h (nisp->hostype elty)))
	    `(make-Type '(rcd ,@slotype-desigs)
			(make-Type `(Ary ,',elty 1)
				   'Objarray
				   nil
				   (list (list 'eltype ,(type-loader
							   elty nil))
					 (list 'array-rank '1)
					 (list 'array-dims (list ',n))))
			(cons (make-Slot 'conser
				      `(*integrable ,@(cl-rcd-conser ',n ',h))
				      nil univ-type*
				      ,(argtypes-loader slotype-desigs))
			   (list
			    ,@(<# (\\ (i ty)
				     `(make-Slot ',(build-symbol < (:< i) >)
						 '(*integrable (v)
						     (aref v ,(- i 1)))
						 '(*integrable (v x)
						     (setf (aref v ,(- i 1)) x))
						,(type-or-desig-loader ty nil)
						nil))
				  (series 1 n)
				  slotype-desigs)))
			(list (tuple 'initexp
                                     ',(sequence-initexp-constructor-form
                                          'vector false slotypes))))))))


;; (LSTRUCTURE [flag] specs) defines the usual list structure thingie.
;; Changed 3.21.88
;; 4.29.88 Gave in and defined &FLAG syntax for LSTRUCTURE.
(datafun type-loader Lstructure
   (defun :^ (def typnam)
      (let ((typfns nil) (struc (cdr def)) slots types args super)
	 (!= < typnam struc > (str-flag-extract struc typnam))
	 (cond ((eq (car struc) '&flag)
		(!= typnam (cadr struc))
		(!= struc (cddr struc))))
         (!= < slots types >
             (types-separate struc '(&rest) (\\ (x) (ignore x) t)))
         (!= typfns (slots-extract slots
                                   (cond (typnam '(cdr x))
                                         (t 'x))
                                   types))
	 (!= super (lstruc-lrcd slots types))
	 (cond (typnam 
		(!= super (cons `(Atomconst ,typnam) *-*))
                (!= typfns
                    (cons `(make-Slot 'is
                                      '(*integrable (x)
                                          (and (consp x)
                                               (eq (car x) ',typnam)))
                                      nil 'Boolean nil)
                          *-*))))
         (!= < args types > (vars-types-flatten slots types '(&rest)))
	 (!= types (<# (\\ (ty) (or ty 'Obj)) *-*))
         (!= typfns
             (cons `(make-Slot 'conser
                               '(*integrable ,args
                                  ,(cond (typnam
                                          (cons-Expression
                                              `',typnam
                                              (struc-cons-form slots)))
                                         (struc
                                          (struc-cons-form slots))
                                         (t (signal-problem lstructure :continue
                                              "Empty structure for type "
                                              (or typnam def))
					  nil)))
                              nil
                              univ-type*
                              ,(argtypes-loader types))
                    *-*))
         (let ((lstruc-const 
                  (cond (typnam (build-symbol (:< typnam) -const*))
                        (t false))))
            (cond (lstruc-const
                   (on-list
                      `(defparameter ,lstruc-const
                                     ,(sequence-initexp-constructor-form
                                         'tuple typnam types))
                      deftype-funs*)))
            `(make-Type ',def ,(type-loader `(Lrcd ,@super) nil) 
                        (list ,@typfns)
                        (list (tuple 'initexp
                                     ',(or lstruc-const
                                           (sequence-initexp-constructor-form
                                              'tuple typnam types)))))))))

;; Changed 3.21.88
(defun slots-extract (struc path types)
   (cond ((null struc) nil)
         ((atom struc)
	  (list `(make-Slot ',struc
			    '(*integrable (x) ,path)
			    '(*integrable (x y) (!= ,path y))
			    ,(cond (types (type-or-desig-loader types nil))
				   (t ''Obj))
			    nil)))   
	 ((eq (car struc) '&rest)
	  (slots-extract (cadr struc) path (cadr types)))
         ((and path
               (car-eq path 'car)
               (consp struc)
               (symbolp (car struc))
               (null (cdr struc)))
          ; Ignore redundant parens.
          (slots-extract (car struc) path (car types)))
         (t
          (nconc (slots-extract (car struc) `(car ,path) (car types))
                 (slots-extract (cdr struc) `(cdr ,path) (cdr types))))))

;; DEF is args to [L]STRUCTURE; TYPENAME is non-() if found in a DEFTYPE.
;; Extract (flag slots).  Flag is () if anonymous, else suitable flag.
;; Added 3.21.88
(defun str-flag-extract (def typename)
   (cond ((memq (car def) '(nil ()))
	  (values nil (cdr def)))
	 ((memq '- def)
	  ; New style; flag iff typename
	  (values typename def))
	 ((and (not (is-type-desig (car def)))
	       (not (is-type-desig (lastelt def)))
	       (<v is-type-desig def))
	  ; Old style.  Flag is any symbol at front that can't possibly be
	  ; a type designator
	  (values (car def) (cdr def)))
	 (t
	  ; It's of form (slot slot ...).  Assume everything is actually 
	  ; a slot
	  (values typename def))))

(defun struc-cons-form (struc)
   (cond ((null struc) nil)
         ((atom struc) struc)
	 ((eq (car struc) '&rest)
	  (struc-cons-form (cadr struc)))
         (t (cons-Expression (struc-cons-form (car struc))
                             (struc-cons-form (cdr struc))))))

(defun cons-Expression (x y)
   (cond ((and (consp x)
               (eq (car x) 'list)
               (null (cddr x)))
          (!= x (cadr x))))
   (cond ((null y) (list 'list x))
         ((and (not (atom y)) (eq (car y) 'list))
          (cons 'list (cons x (cdr y))))
         (t (list 'cons x y))))

; Convert to *designator* of appropriate LRCD, minus initial "LRCD"
; flag itself.
(defun lstruc-lrcd (struc types)
  (cond ((null struc) nil)
	((eq (car struc) '&rest)
	 ;;--careful here, the rest may have extra levels of parens.
	 ;;--you can't just return (CADR TYPES).
	 (if (consp (cadr struc))
	     (lstruc-lrcd (cadr struc) (cadr types))
	     (cadr types)))
	((atom (car struc))
	 (cons (or (car types) 'Obj)
	       (lstruc-lrcd (cdr struc) (cdr types))))
	((and (is-Symbol (caar struc)) (null (cdar struc)))
	 (cons (or (caar types) 'Obj)
	       (lstruc-lrcd (cdr struc) (cdr types))))
	(t
	 (cons `(Lrcd ,@(lstruc-lrcd (car struc) (car types)))
	       (lstruc-lrcd (cdr struc) (cdr types))))))

;; Nov.12.87 added
;;;;(!= (type-feature 'Objstruct 'initexp) ''#(structure))

(defun typelist-loader (types)
   (argtypes-loader (<# Type-desig types)))

(defun sequence-initexp-constructor-form (conser maybe-flag argtypes)
   `(,conser ,@(include-if maybe-flag `',maybe-flag)
             ,@(<# (\\ (aty) (type-feature aty 'initexp))
                   argtypes)))