;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: sysdefs.lisp,v 2.11 2005/12/26 03:28:54 dvm Exp $

;;; Copyright 1988-2002, Drew McDermott

(depends-on %ydecl/ listype)
(depends-on :at-compile-time %ydecl/ deftyp strtype)
(depends-on :at-run-time %ydecl/ types typekern hostypes)
(depends-on %ydecl/ plextype)

(end-header :continue-slurping)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(String Atomconst Const Form Lambda-exp Stream
	     Number Float Fixnum Rational Integer Ratio
	     Filespec Keyword Pathname
	     host device name directory type version)))

;; A form is an Sexp whose CAR is a function and whose CDR
;; are its arguments
(deftype Form (lstructure () fun - Objfun &rest args - Sexp))

(!= (type-feature 'Form 'initexp) ''(car cdr))

(deftype Macro
         (cluster Symbol
             (is *integrable (x) (is-Macro x)   )   ))

(deftype String Sexp
   (is *integrable (x) (is-String x)   )
   (= *integrable (x y) (equal x y))   )
(!= (type-feature 'String 'initexp) ''"")

(needed-by-macros
(declare-nisp-cltype String simple-string)
)

(deftype Number Sexp
   (is *integrable (x) (is-Number x)   )
   (= *integrable (m n) (= m n))   )
(!= (type-feature 'Number 'initexp) '0)

(deftype Float Number
      (is *integrable (x) (is-Single-float x)   ))
(!= (type-feature 'Float 'initexp) '0.0)

(deftype Double-float Number
     (is *integrable (x) (double-float-p x)))
(!= (type-feature 'Double-float 'initexp) '1.0d0)

(deftype Rational Number
      (is *integrable (x) (is-Rational x)   ))
(!= (type-feature 'Rational 'initexp) '0)

(deftype Integer Rational
      (is *integrable (x) (is-Integer x)   ))
(!= (type-feature 'Integer 'initexp) '0)

(deftype Fixnum Integer
      (is *integrable (x) (is-Fixnum x)   ))

(deftype Ratio Rational
      (is *integrable (x) (is-Ratio x)   ))

;(!= (PROP 'DEFINED 'fixnum) 'integer)
(!= (prop 'defined 'flonum) 'Float)


(needed-by-macros
;(DATAFUN NISP->CLTYPE float !'TYPE-DESIG)
(declare-nisp-cltype Float single-float)

;;;;(defun desig-downcase (ty)
;;;;   (intern (string-downcase (Type-desig ty))
;;;;	   :common-lisp))

(declare-nisp-cltype Rational rational)
(declare-nisp-cltype Ratio ratio)
(declare-nisp-cltype Integer integer)
(declare-nisp-cltype Fixnum fixnum)
(declare-nisp-cltype Number number)

)

(deftype Char Sexp
   (is *integrable (x) (is-Char x)   )
   (= *integrable (c1 c2) (char= c1 c2)   ))
(!= (type-feature 'Char 'initexp) ''#\0)

(needed-by-macros
(declare-nisp-cltype Char standard-char)
)  

; (ATOMCONST a)
(datafun type-former Atomconst
   (defun (def typename)
      (ignore typename)
      (make-Type def
	 (atomconstype (cadr def))
         (list (make-Slot 'is `(lambda (x) (eq x ',(cadr def))   )
                          nil
                          'Boolean nil))
         nil)   ))

;; Nov.4.87 modified
; Find type of ',C where C is an atom
;;--T must be acceptable as a boolean and as a Symbol--Denys
(needed-by-macros
(defun atomconstype (c)
   (cond ((null c) 'Null)
	 ((eq c 't) 'Boolean-true)
	 ((is-Symbol c) 'Symbol)
	 ((is-Number c) (numtype c))
	 ((is-String c) 'String)
	 ((is-Char c) 'Char)
	 (t 'Obj)   ))

;; (CONST a b c ...)
;; Changed 7.7.88
;;--Fall 1990--new version allows (CONST A B) as a subtype of (CONST A B C)
(defun const-subtyper (t1 t2 accep)
  (ignore accep)
  (cond ((eq t2 '*im-super) nil)
	(t
	 (let ((c1 (type-feature t1 'consts))
	       (c2 (type-feature t2 'consts)))
	    (and c1 c2
		 (is-sublist c1 c2))   ))   ))

(datafun type-former Const
   (defun (def typename)
      (ignore typename)
      (let ((consts (cdr def)))
	 (cond ((null consts)
		'Void)
	       (t
		(make-Type def
		   (</ (\\ (ty a) (common-supertype ty (atomconstype a))   )
		       'Void (cdr def))
		   (list (make-Slot 'is `(lambda (x) (memq x ',(cdr def))   )
				    nil
				    'Boolean nil))
		   (nconc (cond ((memq false (cdr def))    
				 (list (list 'null-okay true)))
				(t '())   )
			  (list (tuple 'consts (cdr def))
				(tuple 'subtype-fcn #'const-subtyper)
                                (tuple 'initexp `',(car consts))))))   ))))
)

;; 3.30.88 LAMBDA flag in LSTRUCTURE changed to slot/is-tester/conser (new syntax)
(deftype Lambda-exp
   (lstructure () type-flag - (Const lambda) 
                  bvars - (Lst Symbol)
                  &rest body - (Lst Sexp))
  (is (x) (car-eq x 'lambda))
  (conser (bvars body) (cons 'lambda (cons bvars body))))

(deftype Stream Obj)

(needed-by-macros
(declare-nisp-cltype Stream stream)
)


(deftype Pathname Obj
   (is *integrable (x) (is-Pathname x))
   (host - Obj *integrable (pn) (Pathname-host pn)   )
   (device - Obj *integrable (pn) (Pathname-device pn)   )
   (directory - Obj *integrable (pn) (Pathname-directory pn)   )
   (name - (~ String) *integrable (pn) (Pathname-name pn)   )
   (:access type - (~ String) *integrable (pn) (Pathname-type pn)   )
   (version - Obj *integrable (pn) (Pathname-version pn)   ))

(needed-by-macros
(declare-nisp-cltype Pathname pathname)
)

(declare-type-acceptable 'String 'Pathname)
(declare-type-acceptable 'Symbol 'Pathname)
   
(deftype *Gen Objfun
   (conser *integrable (l) (make-*gen l)   )
   (is *integrable (x) (is-*gen x)   )
   (gclo *integrable (g) (*gen-gclo g)   ))


(defun slots-embed (typfns extract skip typename)
      (</ (\\ (slots slotspec)
             (cond ((or (memq (Slot-name slotspec) skip)
                        (assq (Slot-name slotspec) slots))
                    slots)
                   (t (cons (slot-embed slotspec extract typename)
                            slots))   ))
          nil
          typfns)   )

(defun slot-embed (slotspec extract typename)
  (ignore typename)
  (let ((sn (Slot-name slotspec))
        (base-acc (slotfn-deint (Slot-acc slotspec)))
        (base-set (slotfn-deint (Slot-set slotspec))))
    (make-Slot
       sn
       `(lambda (x) (,base-acc ,extract)   )
       `(lambda (x y) (,base-set ,extract y)   )
       (Slot-type slotspec)
       nil)   ))

;; Nov.4.87 added
(!= (type-feature 'Objlrcd 'initexp) ''(random . cons))

;; Nov.4.87 added:
;; A type is acceptable as boolean only if falsehood is an element of it.
;; So even though every object is of type boolean, most subtypes are not
;; acceptable as boolean (?).
(declare-type-acceptable 'Sexp 'Boolean)
(declare-type-acceptable 'Boolean 'Sexp)
(declare-type-acceptable 'Objlist 'Boolean)
(declare-type-acceptable 'Objgenlist 'Boolean)
(declare-type-acceptable 'Null 'Boolean) 

; This is used at run-time by code generated by strtype.nsp .
(defun cl-rcd-conser (n ty)
   (let ((al (<# (\\ (i) (build-symbol consarg- (< i)))
		 (series n))))
      `(,al
	(let ((ar (make-Array '(,n) :element-type ',ty)))
	   (cl:declare
	      (type (simple-array ,ty (,n)) ar))
	   ,@(repeat :for ((a :in al)
			   (i in (series 0 (- n 1))))
		:collect
		     `(setf (aref ar ,i) ,a))
	   ar   ))   ))

(defnisptype Filespec (Either String Pathname))

(specdecl keyword-package* - Obj)

(defnisptype Keyword Symbol
   (is *integrable (x) (keywordp x)))