;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: tmcdcl.lisp,v 2.12 2006/05/18 04:07:37 dvm Exp $

(depends-on :at-run-time %ydecl/ dclmacs sysdefs)

;;; Declaration moved to dclchk.lisp.
;;;;(defvar implicit-ob* nil) ;Implicit object in !>slot constructions inside WITH

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(!_ equ if-is is make with
	     subst= member= remove1= remove-every=
	     dremove1= dremove-every= adjoin= assoc= union=
	     intersection= is-sublist= complement= nodup= dnodup= atomconst)))

;; Outside of DECL, the macros turn into DECLs,
;; so we call the DECL-COMPL handlers below.

(defmacro make (ty &rest args)
   `(decl () (make ,ty ,@args)   ))

(defmacro is (td ^x)
   (let ((ty (check-designated-type td)))
      (let ((tester (get-is-tester ty nil)))
         (cond (tester
		`(,tester ,^x))
	       (t
		`(decl () (is ,td ,^x)))   ))))

;(DEFMACRO IS (TY . ARGS)
;   `(DECL () (IS ,TY ,@ARGS)   ))

(def-excl-dispatch #\_ (_ _)
   '\!_)

(defmacro !_ (sl &rest args)
   (cond ((and (consp sl) (consp args))
	  (let ((ob (car args))
		(obtype (check-designated-type (car sl)))
		(slot (cadr sl))
		accer)
	     (!= (< ob obtype slot accer >)
		 (must-type-slot ob obtype slot 'acc))
	     (cond ((eq obtype '*abort)
		    ob)
		   (t
		    `(,accer ,ob ,@(cdr args)))   )))
	 (t
          `(decl () (!_ ,sl ,@args)  ))   ))

(defmacro \!_-set (sl &rest args)
   (cond ((and (consp sl) (consp args) (consp (cdr args)))
	  (let ((ob (car args))
		(obtype (check-designated-type (car sl)))
		(slot (cadr sl))
		setter)
	     (!= (< ob obtype slot setter >)
		 (must-type-slot ob obtype slot 'set))
	     (cond ((eq obtype '*abort)
		    `(!= ,ob ,@(cdr args)))
		   (t
		    `(,setter ,ob ,@(cdr args)))   )))
	 (t `(decl () (\:-set ,sl ,@args)   ))))


;;; See set-compile in mgcdcl.
(declaim (special setf-in-decl*))

(define-setf-expander \!_ (slot &optional (e implicit-ob*) &rest others)
   (multi-let (((slot-of-type slot)
		(cond ((atom slot)
		       (values false slot))
		      (t
		       (values (car slot) (cadr slot))))))
      (multi-let (((ob obtype)
		   (cond (setf-in-decl*
			  (let ((edc (decl-compile e slot-of-type)))
			     (values (Dclcmp-exp edc) (Dclcmp-typ edc))))
			 (t
			  (values e slot-of-type)))))
	 (cond (obtype
		(let (setter accesser)
		   (!= (< ob obtype slot accesser >)
		       (must-type-slot ob obtype slot 'acc))
		   (cond ((eq obtype '*abort)
			  (get-setf-expansion ob))
			 (t
			  (let ((accform-type
				     (type-slot-fun obtype slot 'nisp::type true)))
			     (!= (< ob obtype slot setter >)
				 (must-type-slot ob obtype slot 'set))
			     (let ((expsyms (<# (\\ (_) (gensym))
						(cons ob others)))
				   (newvalsym (gensym)))
				(values expsyms
					`(,ob ,@others)
					`(,newvalsym)
					`(,setter ,@expsyms ,newvalsym)
					`(exp-of-type (,accesser ,@expsyms)
						      ,accform-type))))))))
	       (t
		(signal-problem \!_-setf-expander :fatal
		   "No known type for " e
		   :% " in search for setf-expander of slot " slot))))))

(datafun decl-compl exp-of-type
   (defun :^ (exp dest-type)
      (let ((dc (decl-compile (cadr exp) dest-type)))
	 (make-Dclcmp
	    (caddr exp)
	    (Dclcmp-exp dc)))))

(defmacro exp-of-type (exp^ type)
                      (ignore type)
   exp^)

;(DEFMACRO !_ (SL . ARGS)
;   `(DECL () (!_ ,SL ,@ARGS)   ))

(defmacro \: (sl &rest args)
   `(!_ ,sl ,@args)   )

(defmacro \:-set (sl &rest args)
   `(\:-set ,sl ,@args)   )

;(DEFSETF \!_ \:-SET)
(defsetf \: \:-set)

(def-excl-dispatch #\> (stream _)
;;;;      (read-char stream)
      (let-fun ((sym-partition (sym)
		 ; Break symbol of form s1>s2>...>sN into pieces and
		 ; return them.
		   (let ((s (symbol->string sym)))
		      (repeat :for ((i = 0 :to (- (length s) 1))
				 (startpiece 0) (pieces nil))
			 (cond ((member (elt s i) '(#\> #\.) :test #'char=)
				(!= pieces (cons (cond ((= startpiece i) '())
						       (t
							(intern
							 (subseq 
							  s startpiece i))))
						 *-*))
				(!= startpiece (+ i 1)))   )
		       :result
			 (dreverse
			    (cond ((> i startpiece)
				   (cons (intern
					    (subseq s startpiece i))
					 pieces))
				  (t pieces)   ))))))
	 (let ((e (read stream)))
;;;;            (out :% "[: " e " :]" :%)
	    (cond ((is-Symbol e)
		   (!= e (sym-partition e))
		   (cond ((eq (car e) '())   ;||
			  (</ (\\ (e slot) `(!_ ,slot ,e)   )
			      `(!_ ,(cadr e))
			      (cddr e)))
			 ((= (len e) 1)
			  `(!_ ,(car e)))
			 (t (</ (\\ (e slot) `(!_ ,slot ,e)   )
				(car e)
				(cdr e)))   ))
		  ((member (peek-char false stream) '(#\> #\.) :test #'char=)
		   (read-char stream)
		   (cond ((is-whitespace (peek-char false stream))
			  `(!_ ,@e))
			 (t
			  (!= e (cons e (sym-partition (read stream))))
			  (cond ((= (len e) 1)
				 `(!_ ,@(car e)))
				(t (</ (\\ (e slot) `(!_ ,slot ,e)   )
				       (car e)
				       (cdr e)))))))
		  (t `(!_ ,@e))))))

(datafun mapmac \!_
   (defun (l)
      (match-cond l
	 ?((?(:\| \!_ \:) ?sl . ?args)
	   (let ((bv (<# (\\ (a) (ignore a) (gensym)   )
			 args)))
	     `(#'(lambda ,bv (\!_ ,sl ,@ bv)   )
	       ,@args)   ))
	 ; Else of form ((\!_ ...) ...)
	 (t l)   )))

(datafun mapmac is
   (defun (l)
      `((\\ (x) (is ,(cadr l) x)) ,@(cddr l))   ))

(defmacro with (type e &body body)
   `(decl () (with ,type ,e ,@body)   ))
   
;IF-IS MACRO Format: (IF-IS type exp -body-) expands into
;(COND ((IS type exp) (WITH type exp -body-))   )
;E.g., (IF-IS ptrm FOO (LIST !>OB !>FR))
(defmacro if-is (ty e &body body)
      `(cond ((is ,ty ,e)
	      (with ,ty ,e ,@body))
	     (t nil)   ))

(defmacro equ (&rest l)
   (match-cond l
      ?((?ty ?x ?y)
	`(!_(,ty =) ,x ,y))
      ?((?x ?y)
	`(!_ = ,x ,y))
      (t (signal-problem equ :continue "Meaningless: " `(equ ,@l))
	 nil)   ))

;; Changed 3.21.88
; Slight worry:  A while back, I changed SPECDECL at Denys's urging, so that
; at slurp time the values bound to the variables would be ignored.  That means
; that in (SPECDECL (X (MAKE foo ...))), X is declared to be of type Obj.
; Elsewhere in Nisp, such a construction would imply that X is of type foo.
; If we enforced this, we wouldn't need the (MAKE * ...) construct, which
; is often untransparent.
(datafun decl-compl make
   (defun (exp dest-type)
      (multiple-value-let (ty args)
			  (cond ((eq (cadr exp) '*)
				 (values dest-type (cddr exp)))
				((is-type-desig (cadr exp))
                                 (values (designated-type (cadr exp))
					 (cddr exp)))
				(t
				 (values
				    (signal-problem make
			              "MAKE with no type: " exp
				      (:prompt-for "Type (default *):" dest-type))
				    (cdr exp)))   )
         (type-trans
             `(,(type-slot-fun ty 'conser 'acc t)
                ,@(coerce-args args
                                (type-slot-fun ty 'conser
                                               'atypes nil)
                                exp))
             ty
             dest-type)   )))

;; datadcl now (3.21.88) needs this at compile-time:
;; 5.16.88 revised IS system
(needed-by-macros
(datafun decl-compl is
  (defun (exp dest-type)
    (cond ((not (= (length exp) 3))
	   (signal-problem is-Decl-compl :fatal
	     0 "Wrong number of arguments: " exp))
	  (t
	   (let ((ty (check-designated-type (cadr exp))))
	     (let ((tester (get-is-tester ty nil)))
	       (repeat 
		 :until tester
		 (repeat 
		   (!= ty
		       (signal-problem is 
			 "No IS-tester for type " (type-pname ty)
			 (:prompt-for "Intended type: " nil)))
		   :until (is-type-desig ty)   )
		 (!= ty (designated-type ty))
		 (!= tester (get-is-tester ty nil))   )
	       (type-trans
		`(,tester ,@(coerce-args (cddr exp)
					  '(Obj)
					  exp))
		'Boolean
		dest-type)   ))))))
)

;;;--changed '*NOTRANS to NIL. somewhere down the line I was getting
;;;--an error because DEST-TYPE has become (LST *NOTRANS). --Denys 7/21/89
(datafun decl-compl !_
  (defun (exp dest-type)
    (let (ob obdc obtype slot accer source-type atypes)
      (!= ob (cond ((cddr exp) (caddr exp))
		   (implicit-ob* implicit-ob*)
                   (t (defining-info)
                      (signal-problem decl 
			:% "ERROR: Missing object: " exp
			(:prompt-for "Object"  'ok)))   ))
      (cond ((atom (cadr exp))
             (!= slot (cadr exp))
             (!= obdc (must-exptype ob))
             (!= obtype (Dclcmp-typ obdc))
             (!= ob (Dclcmp-exp obdc)))
            (t (!= obtype (check-designated-type (caadr exp)))
               (!= ob (Dclcmp-exp (decl-compile ob nil))) ;; changed '*NOTRANS to NIL
               (!= slot (cadadr exp)))   )
      (!= (< ob obtype slot accer >)
          (must-type-slot ob obtype slot 'acc))
      (cond ((eq obtype '*abort)
             (decl-compile ob dest-type))
            (t
             (!= source-type (or (type-slot-fun obtype slot 'type nil) 'Obj))
             (!= atypes (type-slot-fun obtype slot 'atypes nil))
             (type-trans
	      `(,accer ,ob ,@(coerce-args (cdddr exp) atypes exp))
	      source-type dest-type))   ))))

(datafun decl-compl \:-set
  (defun (exp dest-type)
    (let (ob obdc slot source-type setter obtype atypes 
	  (newval (lastelt exp)))
      (!= exp (drop -1 exp))
      (!= ob (cond ((cddr exp) (caddr exp))
		   (implicit-ob* implicit-ob*)
		   (t (defining-info)
		      (signal-problem decl 
			:% "ERROR: Missing object: " exp
			(:prompt-for "Object" 'ok)))))
      (cond ((atom (cadr exp))
	     (!= slot (cadr exp))
	     (!= obdc (must-exptype ob))
	     (!= obtype (Dclcmp-typ obdc))
	     (!= ob (Dclcmp-exp obdc)))
	    (t (!= obtype (check-designated-type (caadr exp)))
	       (!= ob (Dclcmp-exp (decl-compile ob nil))) ;; changed '*NOTRANS to NIL
	       (!= slot (cadadr exp)))   )
      ;(!= SETTER (TYPE-SLOT-FUN OBTYPE SLOT 'SET NIL))
      ;(COND ((NULL SETTER)
      ;(!= ACCER (TYPE-SLOT-FUN OBTYPE SLOT 'ACC NIL))
      ;(COND ((AND ACCER (SYMBOLP ACCER) (PROP 'SET ACCER))
      ;(!= SETTER (PROP 'SET ACCER)))
      ;(T    ))))
      (!= (< ob obtype slot setter >)
	  (must-type-slot ob obtype slot 'set))
      (cond ((eq obtype '*abort)
	     (decl-compile `(!= ,ob ,@(cdddr exp) ,newval) dest-type))
	    (t
	     (!= source-type 
		 (or (type-slot-fun obtype slot 'type nil) 'Obj))
	     (!= atypes (type-slot-fun obtype slot 'atypes nil))
	     (type-trans
	      `(,setter ,ob
			,@(coerce-args (cdddr exp) atypes exp)
			,(decl-compile-exp newval source-type))
	      source-type dest-type))   ))))

(datafun decl-compl with
   (defun (exp dest-type)
      (let (ty e body)
	 (cond ((is-type-desig (cadr exp))
		(!= ty (cadr exp))
		(!= e (make-Dclcmp (check-designated-type ty)
			           (decl-compile-exp 
				      (caddr exp) 
				      nil
				      ;(DESIGNATED-TYPE (CADR EXP))
				      )))
		(!= body (cdddr exp)))
	       (t
		(!= e (decl-compile (cadr exp) nil))
		(!= body (cddr exp))
		(!= ty `(*typequote ,(Dclcmp-typ e))))   )
	 (cond ((is-Symbol (Dclcmp-exp e))  ;; was: ATOM
		;; 5.16.88 changed for case: (with type variable ...)
		(bind ((implicit-ob* `(*dc ,e)))
		  (with-declarations
		        (list (Dclcmp-exp e))
		        (list (Dclcmp-typ e))
	            (let ((bdc (body-compile body dest-type)))
		      (make-Dclcmp
		       (Dclcmp-typ bdc)
		       `(progn ,@(Dclcmp-exp bdc)))   ))))
	       (t
		(let ((v (gensym)))
		  (bind ((implicit-ob* `(*dc ,(make-Dclcmp (Dclcmp-typ e)
							   v))))
			(let ((bdc (body-compile body dest-type)))
			  (make-Dclcmp
			   (Dclcmp-typ bdc)
			   `(let ((,v ,(Dclcmp-exp e)))
			      ,@(Dclcmp-exp bdc)   ))))))   ))))
				
(eval-when (:compile-toplevel :load-toplevel)

(defun generic-decl-compl (exp dest-type)
   (let ((ft (symtype (car exp))) actual-argno actual-args obdc atype eqtest)
      (cond ((is-Funtype ft)
             (!= actual-argno (- (len (type-feature ft 'argtypes)) 1)))
            (t
             (signal-problem generic-decl-compl :continue
                "I should know the type of " (car exp) ", but I don't"))   )
      (cond ((or (< (len (cdr exp)) actual-argno)
                 (> (len (cdr exp)) (+ actual-argno 1)))
             (cond (type-check*
                    (out (:to *error-output*)
                             "Wrong number of arguments: " exp :%)))))
      (cond ((> (len (cdr exp)) actual-argno)
             (!= actual-args (cddr exp))
             (!= eqtest (cadr exp))
             (cond ((is-type-desig eqtest)
                    (!= eqtest (type-eqtest-exp *-*)))   ))
            (t
             (!= obdc (must-exptype (cadr exp)))
             (!= actual-args `((*dc ,obdc) ,@(cddr exp)))
             (!= atype (Dclcmp-typ obdc))
             (cond ((is-subtype (cadr (type-feature ft 'argtypes)) 'Objlist)
                    (!= atype
                        (cond ((subtype atype 'Objlist t)
                               (or (type-feature *-* 'eltype) 'Obj))
                              (t
                               (out (:to *error-output*)
                                    "Warning -- first arg of " exp
                                    :% "cannot"
                                    " be interpreted as a list" :%)
                               'Obj)   )))   )
            (!= eqtest (type-eqtest-exp atype)))   )
      (multiple-value-let (args tsub)
			  (matchargs `(,eqtest ,@actual-args)
				     (fun-argtypes ft) exp nil)
	 (type-trans
            `(,(generic-trans (car exp)) ,@(<# Dclcmp-exp (cdr args))
					 :test ,(Dclcmp-exp (car args)))
	    (type-subst tsub (fun-resulttype ft))
	    dest-type))))

)

(defun generic-trans (fcn-name)
   (alref '((subst= subst) (member= member)
	    (remove1= remove) (remove-every= remove-every)
	    (dremove1= delete) (dremove-every= delete)
	    (adjoin= adjoin) (assoc= assoc) (union= union)
	    (intersection= intersection) (is-sublist= subsetp)
	    (complement= set-difference) (nodup= nodup) (dnodup= dnodup))
	  fcn-name
	  (signal-problem generic-trans
	     "No translation for " fcn-name)))

;; Used for objects which must have a type, since they are supporting
;; an ellipsis in a !_, WITH, or the like
(defun must-exptype (exp)
   (repeat :for (r)
      (!= r (decl-compile exp nil))
    :until (not (memq (Type-desig (Dclcmp-typ r)) '(Obj)))
    :result r
      (!= r
	  (signal-problem declaration-context
	     exp " is undeclared or mistyped"
	     (:prompt-for
              !"Intended expression,~
                ~%  or 'ok' (after declaring it with 'specdecl'),~
                ~%  or a type designator (when I will declare it)"
	      '*try-again)))

      (cond ((is-type-desig r)
	     (cond ((symbolp exp)
		    (declare-on-fly exp r))
		   (t (!= exp `(be ,r ,*-*)))   ))
	    ((not (eq r '*try-again)) (!= exp r))   )))

;;;;(out (:to *query-io*) "Setting them up ..." :%)

(datafun decl-compl subst= !'generic-decl-compl)
(datafun decl-compl member= !'generic-decl-compl)
(datafun decl-compl remove1= !'generic-decl-compl)
(datafun decl-compl dremove1= !'generic-decl-compl)
(datafun decl-compl remove-every= !'generic-decl-compl)
(datafun decl-compl dremove-every= !'generic-decl-compl)
(datafun decl-compl adjoin= !'generic-decl-compl)
(datafun decl-compl assoc= !'generic-decl-compl)
(datafun decl-compl union= !'generic-decl-compl)
(datafun decl-compl intersection= !'generic-decl-compl)
(datafun decl-compl is-Sublist= !'generic-decl-compl)
(datafun decl-compl complement= !'generic-decl-compl)
(datafun decl-compl nodup= !'generic-decl-compl)
(datafun decl-compl dnodup= !'generic-decl-compl)

;;;;(out (:to *query-io*) "Done setting them up: " (get 'member= 'decl-compl) :%)

; Produce an expression that DECL-COMPILEs properly to the name of the
; equality tester for TY.
(defun type-eqtest-exp (ty)
   `(*dc ,(make-Dclcmp '(Fun Boolean (Obj Obj) ())
                       `(function ,(type-slot-fun ty '= 'acc t))))   )

(datafun decl-compl atomconst
   (defun :^ (exp dest-type)
      (match-let (atomconst ?a) exp
	 (type-trans `',a (designated-type `(Atomconst ,a)) dest-type))))
		 