;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: typekern.lisp,v 2.11 2005/12/26 03:28:54 dvm Exp $

(depends-on %module/ ytools %ytools/ nilscompat)
(depends-on (:at (:slurp-time :nisp-types)) %ydecl/ hostypes)
(depends-on (:at compile-time (:slurp-time :nisp-types))
	    %ydecl/ deftyp)
(depends-on :at-run-time %ydecl/ types hostypes)

(self-compile-dep :macros :nisp-types)

(end-header :continue-slurping)

;;; This is a mistake, because it means that the type (Either Foo Baz),
;;; where Baz has an initexp and Foo does not, the system will grab
;;; the 'nil inherited from Obj by Foo.
;;; (!= (type-feature 'Obj 'initexp) ''nil)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(Sexp Symbol)))

;; 5.17.88 cut: (conser *integrable (&rest l) l)
(deftype Objlist Obj)

(!= (type-feature 'Objlist 'eltype) 'Obj)
(!= (type-feature 'Objlist 'is-lst) t)

(deftype Objgenlist Obj)

(!= (type-feature 'Objgenlist 'eltype) 'Obj)

;; Added 4.1.88
(defun lst-car-cdr-type-feature (ty feat)
   (cond ((eq feat 'cartype) (type-feature ty 'eltype))
	 (t ty)   ))

(!= (type-feature 'Objlist 'cartype)
    (list '*feature-fcn #'lst-car-cdr-type-feature))

(!= (type-feature 'Objlist 'cdrtype)
    (list '*feature-fcn #'lst-car-cdr-type-feature))

(!= (type-feature 'Objlist 'initexp)
    ''(:uninitialized-list-element :uninitialized-list-element))

(!= (type-feature 'Objgenlist 'cartype)
    (list '*feature-fcn #'lst-car-cdr-type-feature))

(!= (type-feature 'Objgenlist 'cdrtype)
    (list '*feature-fcn #'lst-car-cdr-type-feature))

(deftype Objlrcd Obj)

(!= (type-feature 'Objlrcd 'cartype) 'Obj)
(!= (type-feature 'Objlrcd 'cdrtype) 'Obj)
(!= (type-feature 'Objlrcd 'eltype) 'Obj)
(!= (type-feature 'Objlrcd 'is-lrcd) t)

(deftype Objmultiple Obj)

(!= (type-feature 'Objmultiple 'valtypes) (list 'dot 'Obj))

(!= (type-feature 'Objfun 'resulttype) 'Obj)
(!= (type-feature 'Objfun 'argtypes) (list 'dot 'Obj))

;; Nov.12.87 added
(deftype Objstruct Obj)

; An sexp is a finite list structure with atoms at the leaves.
(deftype Sexp Obj
   (car Sexp *integrable (e) (car e)   )
   (cdr Sexp *integrable (e) (cdr e)   )   )

(!= (type-feature 'Sexp 'initexp) ''(:uninitialized-s-expression))

(deftype Symbol Sexp
   (is *integrable (x) (is-Symbol x)   )
   (= - Boolean *integrable (x y) (eq x y)   ))

(!= (type-feature 'Symbol 'initexp) '':uninitialized-symbol)

(datafun nisp->cltype Symbol
   (defun :^ (ty) (ignore ty) 'cl:symbol)   )

(!= (prop 'defined 'cl:symbol) (designated-type 'Symbol))

;(NEEDED-BY-MACROS
;(DATAFUN NISP->CLTYPE symbol !'TYPE-DESIG)
;)

;;--Hack for 'T case of ATOMCONSTYPE in sysdefs --Denys
(defvar boolean-true* nil)
(defun boolean-true-subtyper (t1 t2 accep)
  (and (not (eq t2 '*im-super))
       (eq t1 boolean-true*)
       (or (subtype 'Boolean t2 accep)
	   (subtype 'Symbol  t2 accep))))

(!= boolean-true*
    (make-Type 'Boolean-true 'Symbol nil
	       (list (tuple 'subtype-fcn !'boolean-true-subtyper)
                     (tuple 'initexp 't))))

(!= (prop 'defined 'Boolean-true) boolean-true*)

(load-type 'Null 
	   (make-Type 'Null 'Obj
		      (list (make-Slot 'is 'null nil 'Boolean nil))
		      (list (tuple 'initexp ''nil))
		      ))

(deftype Objhashtable Obj)

(!= (type-feature 'Objhashtable 'eltype) 'Obj)

(defvar null-hashtable* (make-hash-table :test #'eq :size 1))

(!= (type-feature 'Objhashtable 'initexp) 'null-hashtable*)

(deftype Objarray Obj)

(!= (type-feature 'Objarray 'eltype) 'Obj)

;;; This is needed by code generated by strtype.lisp, and is put here so it will
;;; be available at run time.
(defun val-if-boundp (var)
   (and (boundp var) (symbol-value var)))

(load-type 'Block-name
	   (make-Type 'Block-name 'Obj !() !()))