;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: types.lisp,v 2.11 2005/12/26 03:28:54 dvm Exp $

;;; Copyright 1988 - 2004, Drew McDermott, Yale University

(depends-on %module/ ytools %ytools/ nilscompat)

(eval-when (:compile-toplevel :load-toplevel :execute :slurp-toplevel)
   (export '(access all Boolean declare-type-acceptable conser Fun Obj typesee Void)))

(end-header :continue-slurping)

; A Nisp type -- Note that in this file and everywhere else these things
; are just called "types."  The NISPTYPE class is just the underlying
; implementation.
(def-class Nisptype
     (:handler
        (print (ty stream)
	     (out (:to stream) "#{Nisp type " 
			      (td-massage (Nisptype-desig ty)) "}")   ))
   desig super slotfns features)

;; 87.9.28 Changed 2nd cond clause;
;; the way variable types print now is just too confusing.
(defun td-massage (td)
  (cond ((atom td) td)
	((eq (car td) '*Typevar)
	 (cond ((cddr td) `(\? ,(cadr td) ,(td-massage (caddr td))))
	       (t `(\? ,(cadr td)))   ))
	(t (cons (td-massage (car td)) (td-massage (cdr td))))   ))

(defun make-Type (desig super slotfns features)
   (cond ((and super (is-Symbol super)) 
          (cond ((prop 'defined super)
		 (!= super (prop 'defined super)))
		(t
		 ;;;;(dbg-save :run-loud desig super slotfns features)
		 (out (:to *error-output*) "Warning -- supertype " super 
				    " undefined " :%)
;;;;		 (breakpoint make-Type
;;;;		    "desig = " desig)
		 )   ))   )
   (let ((new-type (make-Nisptype desig super slotfns features)))
;;;;      (cond ((eq desig 'optop::Opt-domain)
;;;;	     (dbg-save desig super slotfns features new-type)
;;;;	     (breakpoint make-Type
;;;;		  "super = " super)))
      new-type)   )

(defun Type-desig (x)
   (cond ((is-Nisptype x) (Nisptype-desig x))
         ((atom x) x)
         ((eq (car x) '*typequote)
          (cond ((is-type-desig (cadr x))
                 (Type-desig (designated-type (cadr x))))
                (t (Type-desig (cadr x)))   ))
         ((is-type-desig x) x)
         (t
	  (signal-problem Type-desig
	     "Attempt to find designator of non-Type " x))))

(defun Type-desig-set (x y)
   (!= x (coerce-to-nisptype x))
   (!= (Nisptype-desig x) y)   )

(eval-when (:compile-toplevel :load-toplevel)
  (defsetf Type-desig Type-desig-set))

; TYPE-SUPER is a supertype of this one, but not necessarily the
; immediate supertype.  E.g., TYPE-SUPER of (LST fixnum) is "Objlist,"
; but the immediate supertype is (LST number).  This is to avoid
; having to generate all those supertypes.
(defun Type-super (x)
   (!= x (try-coerce-to-nisptype x))
   (and x (Nisptype-super x))   )

; 87.9.28 Changed TYPE-FEATURE to TYPE-LOCAL-FEATURE
; TYPE:IM-SUPER is the immediate supertype
(defun Type-im-super (x)
   (let ((sfn (type-local-feature x 'subtype-fcn)))
      (or (and sfn (funcall sfn x '*im-super nil))
          (Type-super x))   ))

(defun Type-slotfns (x)
   (!= x (try-coerce-to-nisptype x))
   (cond ((null x) nil)
	 (t (Nisptype-slotfns x))   ))

(defun type-slotfns-set (x v)
   (!= x (coerce-to-nisptype x))
   (!= (Nisptype-slotfns x) v)   )

(eval-when (:compile-toplevel :load-toplevel)
  (defsetf Type-slotfns type-slotfns-set))

(defun type-allslots (x)
   (cond (x
          (append (Type-slotfns x)
                  (type-allslots (Type-super x))))
         (t nil)   ))

(defun Type-features (x)
   (!= x (try-coerce-to-nisptype x))
   (cond ((null x) nil)
	 (t (Nisptype-features x))  ))

(defun type-features-set (x y)
   (!= x (coerce-to-nisptype x))
   (!= (Nisptype-features x) y)   )

(eval-when (:compile-toplevel :load-toplevel)
  (defsetf Type-features type-features-set))

(defvar slots-use-desigs* nil)
; With several types
; defined in a file, using the symbol instead of the type for
; atomic-named types allows a type to be used before being
; defined in slightly more circumstances.  The efficiency
; cost is negligible.

; A slot consists of four things: name, access fun name, set fun name,
; TYP and ATYPES.  Normally, TYP is the type of the thing in the slot
; and ATYPES are the types of all access-fun arguments except the first
; (which is of the type owning this slot).  For the CONSER slot,
; the TYP is irrelevant (the CONSER constructs the type owning this
; slot).


(defun make-Slot (name accname setname typ atypes)
   (let (d)
      (cond ((not (and (consp typ) (memq (car typ) '(*indirect :indirect))))
             (!= d (Type-desig typ))
             (cond ((or (eq slots-use-desigs* 'all) (symbolp d))
                    (!= typ d))   ))   )
      (list name accname setname typ atypes)   ))

(eval-when (:compile-toplevel :load-toplevel :execute)
   (subr-synonym Slot-name car settable)

   (subr-synonym Slot-acc cadr settable)

   (subr-synonym Slot-set caddr settable)

   (subr-synonym Slot-type cadddr settable)

   (defun Slot-atypes (s) (cadr (cdddr s)))

   (defun (setf Slot-atypes) (v s) (!= (cadr (cdddr s)) v)))

(defvar univ-type*
             (make-Type 'Obj nil nil
                 '((accept-any t))))  ; Any expression will work as an Obj.

(!= (prop 'defined 'Obj) univ-type*)

;; Nov.4.87 modified
(defvar void-type*
      (make-Type 'Void univ-type* nil 
		 '((accept-any t))))

(!= (prop 'defined 'Void) void-type*)

(!= (prop 'defined 'Boolean)
    (make-Type 'Boolean 'Obj
	       (list (make-Slot 'is '(lambda (x) (memq x '(t nil))   )
				nil 'Boolean nil)
		     (make-Slot '= '(lambda (x y) (cond (x y) (t (not y))))
				nil 'Boolean '(Boolean)))
	       (list (tuple 'initexp 't))))

(defun type-slot-fun (ty slot wanted meanit)
   (let ((type1 ty)
         (selectorfn (case wanted
                           ((acc access) !'Slot-acc)
                           (set !'Slot-set)
                           (type !'Slot-type)
                           (atypes !'Slot-atypes)
                           (t !'cr)   )))
     (repeat :for (slotspec res)
         (!= slotspec (assq slot (Type-slotfns ty)))
         (if slotspec (!= res (funcall selectorfn slotspec)))
       :until (and slotspec res)
       :result
            (cond ((and (consp res) (memq (car res) '(*indirect :indirect)))
                   (let ((replacement
                          (type-slot-fun (or (cadr res) ty)
                                         (caddr res) wanted meanit)))
                      (case wanted
                         ((acc access)
                          (!= (Slot-acc slotspec) replacement))
                         (set (!= (Slot-set slotspec) replacement))
                         (type (!= (Slot-type slotspec) replacement))
                         (t (!= (Slot-atypes slotspec) replacement))   )
                      replacement   ))
                  ((eq res '*none) nil)
                  (t (slotfn-deint res))   )
         (!= ty (Type-super ty))
       :while ty
       :else :result (type-slot-not-found type1 slot wanted meanit)   )))

;; 3.31.88 changed next 2
(defun type-slot-not-found (ty slot wanted meanit)
   (let (revised)
      (or ;(AND (EQ WANTED 'TYPE) UNIV-TYPE*)
          (type-slot-general ty slot wanted)
          (cond (meanit
                 (!= revised
                    (signal-problem type-slot-fun
                        "No "
                        (:q ((memq wanted '(acc access))
			     "access function")
			    ((eq wanted 'set)
			     "set function")
			    ((eq wanted 'type)
			     "slot type determinable")
			    ((eq wanted 'atypes)
			     "accessor/setter argument types determinable")
			    (t "slot found")   )
			 " for (type slot) = ("
			 (type-pname ty) 1 slot ")"
			(:prompt-for "Intended (type slot): " false)))
                 (repeat
                  :until (and (consp revised)
                             (consp (cdr revised))
                             (is-type-desig (car revised)))
                    (out (:to *query-io*) "Type a list (type slot):")
                    (!= revised (in (:from *query-io*) :obj))   )
                 (type-slot-fun (check-designated-type (car revised))
                                (cadr revised)
                                wanted meanit))
                (t nil)   ))   ))

(defun type-slot-general (ty slotname wanted)
   (let ((superfn (type-feature ty 'slot-filler-fcn)))
      (cond (superfn
             (let ((new (funcall superfn ty slotname wanted)))
                (cond (new
                       (let ((slot (assq slotname (Type-slotfns ty))))
                          (cond ((null slot)
                                 (cond ((null wanted)
                                        (!= slot new))
                                       (t
                                        (!= slot
                                            (make-Slot slotname nil nil nil nil))))
                                 (!= (Type-slotfns ty) (cons slot *-*)))   )
                          (case wanted
                             ((nil ()) slot)
                             (acc
                              (!= (Slot-acc slot) new)
                              (slotfn-deint new))
                             (set
                              (!= (Slot-set slot) new)
                              (slotfn-deint new))
                             (type
                              (!= (Slot-type slot) new)
                              new)
                             (t
                              (!= (Slot-atypes slot) new)
                              new))  ))
		      (t nil)  )))
	    (t nil)   )))
                          
;;; The following function produces the sort of slot-filler-fcn
;;; that 'type-slot-general' calls.
;;; It must be defined in this file so that the run-time expansion
;;; of (Object ...) (defined in strtype.lisp) can call it.
;;; The filler function this returns is called only when the local
;;; search for the slot has failed, so we don't have to check the type
;;; itself, only its components from the the class precedence list.
(defun class-slot-filler-fcn (super-class-prec-list)
   (\\ (this-ty slotname wanted)
       (declare (ignorable this-ty))
;;;;      (trace-around class-slot-filler
;;;;	 (:> "(class-slot-filler <" (cons this-ty super-class-prec-list) ">: "
;;;;	     slotname " [" wanted "])")
      (repeat :for ((ct :in super-class-prec-list))
       :within
	  (let ((sffcn 
		   (type-slot-fun
		      ct slotname wanted nil)))
	     (:continue
	      :until sffcn
	      :result sffcn)))
;;;;	 (:< (val &rest _) "class-slot-filler: " val
;;;;	    (:e (cond ((and (not val)
;;;;			    (eq (Type-desig this-ty)
;;;;				'Tex-txtlisp-mode))
;;;;		       (dbg-save super-class-prec-list slotname wanted)
;;;;		       (breakpoint class-slot-filler-fcn
;;;;			  wanted " of slot " slotname "is nil, "
;;;;			  :% " and prec-list = " super-class-prec-list))))))
      ))

; Changed 88.4.11
; A slot function of the form (:inline vars . body) means the same
; as (lambda vars . body), but is a signal to DEFTYP not to transform it
; into a named function.  SLOTFN-DEINT strips off this form when
; necessary
(defun slotfn-deint (e)
   (cond ((and (is-Pair e)
	       (memq (car e) '(:inline :integrable *integrable)))
	  (match-cond (cdr e)
	     (:? (?a (?f ?,@a))
		f)
	     (t `(lambda ,@(cdr e)))))
	 (t e)))

;;;;   (let (a f else)
;;;;      (cond ((matchq (?(:\| :inline :integrable *integrable)
;;;;		      ?@(:\| (?a (?f ?,@a))
;;;;			     ?else))
;;;;		     e)
;;;;             (or f `(lambda ,@else)))

;;;;            ((car-eq e '*integrable)
;;;;             `(lambda ,@(cdr e)))
;;;;            (t e))))

; Changed 88.4.1: Allow generalized procedural attachment for features:
; A FEATURE-FILLER-FCN feature is a function that generates new feature
; pairs.
(defun type-feature (ty feat)
      (repeat :for (fp (original-type ty))
         (!= fp (assq feat (Type-features ty)))
       :until fp
       :then :result (match-cond (cadr fp)
		      ?((*feature-fcn ?fcn) (funcall fcn original-type feat))
		      (t (cadr fp))   )
         (!= fp (assq 'feature-filler-fcn (Type-features ty)))
	 (cond (fp
		(!= fp (funcall (cadr fp) original-type feat)))   )
       :until fp
       :then :result (cadr fp)
         (!= ty (Type-super ty))
       :while ty
       else :result nil   ))

(defun type-feature-set (ty feat val)
   (let ((fp (assq feat (Type-features ty))))
      (cond ((null fp)
             (!= fp (list feat nil) )
             (!= (Type-features ty) (cons fp *-*)))   )
      (!= (cadr fp) val)   ))

(eval-when (:compile-toplevel :load-toplevel)
  (defsetf type-feature type-feature-set))
    
; Get type feature without inheritance
(defun type-local-feature (ty feat)
   (cadr (assq feat (Type-features ty))))

; The SUBTYPE-FCN feature of a type is a function that takes two
; arguments, and return T if one is definitely a subtype of the other,
; () if it might not be.  If the second argument is *IM-SUPER, the
; function should return the immediate supertype of the first argument.
; (TYPE:SUPER is not guaranteed to do this.)

(defvar subtypes-in-progress* nil)
; List of pairs (t1 t2) of subtype checks that are being done.  If recursive
; call to SUBTYPE occurs for a check in progress, just return T.

; Is T1 a subtype of T2? If ACCEP=T, check to see if T2 is an element
; of the ACCEPTABLE-AS feature list of T2.  
;; Nov.4.87 modified
(defun subtype (t1 t2 accep)
   (!= t1 (coerce-to-nisptype *-*))
   (!= t2 (coerce-to-nisptype *-*))
   (or ;(EQ (TYPE-DESIG T1) 'Void)
       (eq (Type-desig t2) 'Obj)
       (is-subtype t1 t2)
       (equivalent-types t1 t2)
       (<v (\\ (p) (and (eq t1 (car p)) (eq t2 (cadr p)))   )
	   subtypes-in-progress*)
       (let ((testfn1 (type-feature t1 'subtype-fcn))
             (testfn2 (type-feature t2 'subtype-fcn)))
	  (cond ((or testfn1 testfn2)
		 (bind ((subtypes-in-progress* 
			   (cons (lrecord t1 t2) subtypes-in-progress*)))
		    (or (and testfn1 (funcall testfn1 t1 t2 accep))
			(and testfn2 
			     (not (eq testfn1 testfn2))
			     (funcall testfn2 t1 t2 accep)))   ))
		(t nil)   ))
        ;; If SUBTYPE-FCN returns (), that means "I don't know."
       ;; Other methods still get a chance.
       (and accep
            (or (eq (Type-desig t1) 'Obj)
                (type-local-feature t2 'accept-any)
                (<v (\\ (a) (subtype a t2 nil)   )
                    (type-local-feature t1 'acceptable-as)))))   )

; Cheap, simple test that just goes up the type hierarchy.  
(defun is-subtype (t1 t2)
   (!= t1 (try-coerce-to-nisptype *-*))
   (!= t2 (try-coerce-to-nisptype *-*))
   (cond ((and t1 t2)
	  (repeat 
	   :until (eq t1 t2)
	   ;;was:
	   ;; :until (OR (EQ T1 T2)
	   ;;           (EQ (TYPE-DESIG T1) 'Void))
	   :then :result t
	     (!= t1 (Type-super t1))
	   :while t1
	   else :result nil   ))
	 (t nil)   ))

(defun equivalent-types (t1 t2)
   (cond ((and (is-type-desig t1) (not (is-Forward-defined t1)))
	  (!= t1 (designated-type t1)))   )
   (cond ((and (is-type-desig t2) (not (is-Forward-defined t2)))
	  (!= t2 (designated-type t2)))   )
   (equal (Type-desig t1) (Type-desig t2))   )


(defun declare-type-acceptable (got want)
   (!= want (check-for-type want))
   (cond (got
          (!= got (check-for-type got))
; should be TYPE-LOCAL-FEATURE!
          (!= (type-feature got 'acceptable-as)
               (adjoinq want (type-local-feature got 'acceptable-as))))
         (t (!= (type-feature want 'accept-any) t))   ))

; Find the least inclusive common supertype
;; Nov.4.87 modified
(defun common-supertype (t1 t2)
   (!= t1 (coerce-to-nisptype *-*))
   (!= t2 (coerce-to-nisptype *-*))
   (cond ((or (is-Variable-type t1)
	      (is-Variable-type t2))
	  univ-type*)
	 ((eq t2 void-type*) t1)
	 ((eq t1 void-type*) t2) 
	 ((subtype t2 t1 nil) t1)
         (t
          (repeat
           :until (subtype t1 t2 nil)
           :result t2
             (!= t2 (Type-im-super t2))
           :until (null t2)
           :result 'Obj   ))   ))

; Transform X from an expression of type SOURCE-TYPE to an expression
; of type DEST-TYPE.  E.g., (TYPE-COERCE 'R 'flonum 'fixnum) => (FIX R),
; but of course this is redundant in LISP.  If no one knows how to
; do the transformation, return *NOWAY.  DEST-TYPE may be (), in which
; case it cannot have a transfn.
(defun type-coerce (x source-type dest-type)
   (let ((transfn1 (type-feature source-type 'type-transfn))
         (transfn2 (and dest-type (type-feature dest-type 'type-transfn)))
         (r '*noway))
      (cond (transfn1
             (!= r (funcall transfn1 x source-type dest-type)))   )
      (cond ((not (eq r '*noway))
             r)
            (t
             (cond (transfn2
                    (!= r (funcall transfn2 x source-type dest-type)))   )
             r)   )))
                   

; NEW FEATURE: Local types, kept in a alist called LOCAL-TYPES*

(defvar local-types* nil)

(defun is-type-desig (x)
   (cond ((atom x)
          (and (symbolp x)
               (or (prop 'defined x)
                   (assq x local-types*))))
         (t (or (eq (car x) '*typequote)
                (and (symbolp (car x))
                     (or (prop 'type-loader (car x))
                         (prop 'type-former (car x))))))   ))

(datafun attach-datafun type-loader #'datafun-on-plist)
(datafun attach-datafun type-former #'datafun-on-plist)

(defun is-Type (x)
   (or (is-type-desig x) (is-Nisptype x))   )

(defun type-pname (td) (td-massage (Type-desig td))   )

; HOW TYPE DESIGNATORS WORK: A type designator is either a symbol,
; with the type under its DEFINED property; or a list of the form
; (head -components-), where the head is a symbol with either a TYPE-FORMER
; property or a TYPE-LOADER property.  The TYPE-FORMER is a
; function that maps the designator into a type.  The TYPE-LOADER is a
; function that maps the designator into a printable expression that
; evaluates to a type, *using only resources available in the Nisp
; runtime environment.*
; Typically a designator has either a former or a loader, but not both,
; because one can be produced from the other.
; Each of these functions takes two arguments, the designator and a typename.
; The latter is usually (), but if non-() it indicates that the designator
; occurred in a DEFTYPE, as in (DEFTYPE typename designator).  In this case,
; the type-loader for the designator is allowed to define auxiliary functions
; and to have their names appear in the type expression, subject to these
; restrictions:
;  -- The global variable DEFTYPE-SLURPING* must be non-()
;  -- The auxiliary function is defined by adding a form defining it to the
;     list DEFTYPE-FUNS*.  Actually, any evaluable expression can be
;     added to this list, which will appear as part of the expansion of
;     the DEFTYPE macro (before anything else).
;  -- It is the responsibility of the type loader to make sure that the
;     functions have unique names.  Currently only STRUCTURE and CLUSTER
;     define auxiliary functions, and they are careful to obey this restriction.

(defun check-designated-type (d)
   (cond ((is-type-desig d)
          (designated-type d))
         (t (signal-problem check-designated-type 
                "Meaningless type designator " 
		(td-massage d)
		(:prompt-for "Correction" (designated-type 'Obj))))))

(defun designated-type (d)
   (multiple-value-let (ty fw) (designated-type-if-available d)
      (cond (ty ty)
	    (fw
	     (signal-problem designated-type
		"Type designated by " d " as yet unknown"))
	    (t
	     (signal-problem designated-type
		"Meaningless type " (td-massage d)))   )))

; Return two values <type-or-nil forward-defined-or-not-at-all>
(defun designated-type-if-available (d)
   (cond ((symbolp d)
	  (let ((p (assq d local-types*)))
	     (cond (p (values (cadr p) nil))
		   (t
		    (let ((e (prop 'defined d)))
		       (cond (e
			      (cond ((eq e 'forward)
				     (values nil t))
				    ((is-type-desig e)
				     (!= e (designated-type e))
				     (!= (prop 'defined d) e)
				     (values e nil))
				    (t 
				     (values e nil))   ))
			     (t 
			      (values nil nil))   )))   )))
         ((eq (car d) '*typequote)
          (cond ((is-type-desig (cadr d)) 
		 (designated-type-if-available (cadr d)))
                (t 
		 (values (cadr d) nil))   ))
         (t
          (values (form-type d nil) nil))   ))


(defun form-type (d typename)
    (let ((s (car d)) tfun)
       (cond ((is-Symbol s)
              (!= tfun (prop 'type-former (car d)))
              (cond (tfun
                     (funcall tfun d typename))
                    (t
                     (!= tfun (prop 'type-loader (car d)))
                     (cond (tfun
                            (eval (funcall tfun d typename)))
                           (t
                            (signal-problem form-type
				    "CAR has no TYPE-FORMER"
                                    " or TYPE-LOADER property: " (condense d)))
                     ))   ))
             (t
              (signal-problem form-type "CAR is not a symbol: " (condense d)))
        )))

(defun named-designated-type (d typename)
   (cond ((or (symbolp d) (eq (car d) '*typequote))
          (designated-type d))
         (t
          (form-type d typename))   ))

(defun check-type-or-desig (d)
   (cond ((is-type-desig d)
          (cond ((symbolp d) d)
                (t (designated-type d))   ))
         (t (signal-problem type-or-desig 
               "Meaningless type designator " (condense d)))   ))

(defun type-or-desig (d)
   (cond ((symbolp d) d)
         (t (designated-type d))   ))

(defun check-for-type (ty)
   (repeat
    :until (is-Type ty)
      (!= ty (signal-problem check-for-type 
                "Meaningless type " (condense ty)
                (:prompt-for "Correct-type" ty)))
    :result ty   ))

; Produce an expression that will evaluate to the type designated by
; TYPEDESIG in the Nisp runtime environment.
(defun type-loader (typedesig typename)
   (cond ((and (is-Pair typedesig)
               (is-Symbol (car typedesig))
               (prop 'type-loader (car typedesig)))
          (funcall (prop 'type-loader (car typedesig)) typedesig typename))
         (t `(designated-type ',typedesig))   ))

(defun type-or-desig-loader (typedesig typename)
   (cond ((is-Symbol typedesig) `',typedesig)
         (t (type-loader typedesig typename))   ))

; Most actual types are defined later, in TYPEKERN and SYSDEFS.
; But we're going to need function types sooner.

;; changed 8.25.87
(defvar fun-type*
    (make-Type 'Objfun univ-type* nil
        (list (list 'is-Fun t)
	      (list 'initexp ''degenerate-function))   ))
(!= (prop 'defined 'Objfun) fun-type*)

(defun degenerate-function (&rest a) 
   (out (:to *error-output*)
	"Function intended for initializations only was actually"
	:% " called, with arguments "(<# condense a) :%)
   nil   )

(defun make-Funtype (rtype atypes se)
      (make-Type `(Fun ,(Type-desig rtype)
                        ,(argtype-desigs atypes)
                        ,se)
                 fun-type*
          nil
          (list (list 'resulttype rtype)
                (list 'argtypes atypes)
                (list 'side-effects se)))   )

(defun is-Funtype (ft) (and (is-Type ft) (type-feature ft 'is-Fun))   )

(defun fun-resulttype (ft) (type-feature ft 'resulttype)   )

(defun fun-argtypes (ft) (type-feature ft 'argtypes)   )

(defun fun-se (ft) (type-feature ft 'side-effects)   )

; Argtypes are in funny format.  E.g., (FIXNUM . FIXNUM)
; becomes (<fixnum type> DOT <fixnum type>).  The reason is because
; there is no way to distinguish a type after a . from a type
; designator occurring in a list.  (<fixnum type> . <fixnum type>)
; would actually look like ((FIXNUM ...) FIXNUM ...).
(defun argtype-desigs (a)
   (cond ((null a) nil)
         ((eq (car a) 'dot) (Type-desig (cadr a)))
         (t (cons (Type-desig (car a))
                  (argtype-desigs (cdr a))))   ))

; This is the inverse:
(defun designated-argtypes (a)
   (cond ((is-type-desig a)
          (list 'dot (type-or-desig a)))
         ((atom a)
          (cond ((null a) nil)
                (t (signal-problem designated-argtypes
		      "Illegal argtypes " a))   ))
         ((is-type-desig (car a))
          (cons (type-or-desig (car a)) (designated-argtypes (cdr a))))
         (t (signal-problem designated-argtypes
               "Meaningless type designator " (td-massage (car a))))   ))

;; Produces straight list of designators.
(defun argtype-desigs-list (a)
    (cond ((is-type-desig a)  (list `(lst ,a))) ;5.16.88, was: (LIST A)
          ((atom a) nil)
          (t (cons (car a) (argtype-desigs-list (cdr a))))   ))

; This is the "loader," which produces an expression that evaluates to
; the type.
(defun argtypes-loader (a)
   (cond ((is-type-desig a) `(list 'dot ,(type-or-desig-loader a nil)))
         ((atom a)
          (cond ((null a) ''())
                (t (signal-problem argtypes-loader "Illegal argtypes " a))   ))
         ((is-type-desig (car a))
          `(cons ,(type-or-desig-loader (car a) nil)
                ,(argtypes-loader (cdr a))))
         (t (signal-problem argtypes-loader
               "Meaningless type designator " (td-massage (car a))))   ))

(defmacro label-type (tvar desig^ sup^ slots^ features^)
   `(let ((,tvar (make-Type ,desig^ ,sup^ nil nil)))
       (!= (Type-slotfns ,tvar) ,slots^)
       (!= (Type-features ,tvar) ,features^)
       ,tvar   ))

(datafun type-former *Typevar
   (defun (d typename)
      (ignore typename)
      (cond ((cddr d) 
             ; 87.9.28 was: (MAKE-TYPE D (CHECK-DESIGNATED-TYPE (CADDR D)) NIL NIL))
             (let ((sup (check-designated-type (caddr d))))
		(label-type me d sup nil 
		        (list (list 'subtype-fcn
				   (\\ (t1 t2 accep)
				      (cond ((eq t2 '*im-super) 
					     sup)
					    ((eq t2 me)
					     (subtype t1 sup accep))
					    (t nil)   )))))   ))
	    (t
	     (make-Type d 'Obj
		 (list (make-Slot 'is '(lambda (x) (ignore x) true)
				  nil 'Boolean nil))
		 (list (list 'accept-any t)
		       (list 'subtype-fcn
			     (\\ (t1 t2 accep)
				(ignore t1 accep)
				(cond ((eq t2 '*im-super) 'Obj)
				      (t t)   )))))   ))   ))

(defun is-Variable-type (ty)
   (car-eq (Nisptype-desig ty)
	   '*Typevar))

; Debugging
(defun typesee (typ)
   (cond ((is-type-desig typ) 
	  (cond ((is-Forward-defined typ)
		 (out "As yet undefined" :%)
		 (!= typ nil))
		(t
                 (!= typ (designated-type typ)))   ))
	 ((is-Symbol typ)
	  (!= typ (symtype *-*)))   )
   (cond ((is-Type typ)
          (out "Designator: " (td-massage (Type-desig typ)))
          (cond ((Type-slotfns typ)
                 (out
                  :% "Slots: " (:e (slots-print (Type-slotfns typ)))))
                (t (out :% "NO SLOTS"))   )
          (cond ((Type-features typ)
                 (out :% "Features: ")
                 (cond ((atom (Type-features typ))
                        (out (Type-features typ)))
                       (t
                        (repeat :for ((f :in (Type-features typ)))
                           (out :% (car f) ": " (condense (cadr f)))
                 ))   )))
         (cond ((Type-super typ)
		(cond ((atom (Type-desig typ))
		       (out :% :% "Supertype: " :%)
		       (typesee (Type-super typ)))
		      (t
		       (out :% :% "Supertype:" (Type-super typ) :%))   )
		)   ))
       (t (out (condense typ) " is not a type"))   )
   '*   )

(defun symtype (_)
   (out (:to *error-output*) "symtype called when not defined" :%)
   univ-type*)

(defun atype-desigs (atl)
   (cond ((eq atl '*none) nil)
         (t (argtype-desigs atl))   ))

(defun slots-print (sl)
   (repeat :for ((s :in sl :tail tsl))
      (case (car s)
         (conser
          (out "CONSER: " (Slot-acc s))
          (cond ((not (atom (Slot-acc s)))
                 (out :% 5))
                (t (out 1))   )
          (out "Arg Types: " (td-massage (atype-desigs (Slot-atypes s)))))
         (is
          (out "Is-tester: " (Slot-acc s)))
         (t
	  (out (:pp-block (:pp-ind :block (length (Symbol-name (Slot-name s))))
		  (Slot-name s)
		  (:q ((Slot-type s)
		       " [" (type-pname (Slot-type s)) "]: ")
		      (t ": "))
		  (:pp-nl :linear)
		  (:q ((Slot-acc s)
		       (Slot-acc s) 1)
		      (t "No accesser "))
		  (:pp-nl :linear)
		  (:q ((Slot-atypes s)
		       "Arg Types: "
                         (td-massage (atype-desigs (Slot-atypes s))) 1)
		      (t 1))
		  (:pp-nl :linear)
		  (:q  ((Slot-set s)
			"Set by " (Slot-set s)))))))
      (cond ((not (null tsl))
	     (out :%)))))

;; Needed by any file with a DEFTYPE
;; 5.16.88 added check for existing PROP
(defun forward-define (typename)
  (or (prop 'defined typename)
      (!= (prop 'defined typename) 'forward)))

(defun is-Forward-defined (typename)
   (and typename
	(is-Symbol typename)
	(eq (prop 'defined typename) 'forward))   )

(defun coerce-to-nisptype (x)
   (cond ((is-Nisptype x) x)
	 ((is-type-desig x)
	  (designated-type x))
	 (t (signal-problem coerce-to-nisptype :continue
	       "Meaningless type " x)
	    (coerce-to-nisptype x))))

(defun try-coerce-to-nisptype (x)
   (cond ((is-Nisptype x) x)
	 ((is-type-desig x)
	  (nth-value 0 (designated-type-if-available x)))
	 (t (signal-problem coerce-to-nisptype :continue
	       "Meaningless type " x)
	    (coerce-to-nisptype x))))

(defun load-type (name type)
   (!= (prop 'defined name)
        (make-Type name (Type-super type) (Type-slotfns type)
                        (Type-features type)))
  name   )

(defvar dofiles* true)

(defun typedecl (sym typ initial)
   (cond ((and dofiles* now-loading*)
          (!= (prop 'files sym)
              (cons `(,now-loading* ,(Type-desig typ) ,initial) *-*)))   )
   (!= (prop 'type sym) typ)   ;(check-designated-type typ)
   sym   )

;  Needed at run time by any file with an AUGTYPE.
(defun merge-slots (typ patches)
   (let ((dt (check-designated-type typ)) typfns spec)
      (!= typfns (Type-slotfns dt))
      (repeat :for ((patch :in patches))
         (cond ((and (not slots-use-desigs*)
                     (is-type-desig (Slot-type patch))
                     (not (symbolp (Slot-type patch))))
                (!= (Slot-type patch) (designated-type *-*)))   )
         (cond ((!= spec (assq (car patch) typfns))
                (merge-spec spec patch))
               (t
                (!= typfns (cons patch *-*)))   ))
      (!= (Type-slotfns dt) typfns)
      typ  ))

; Blatant violation of slot type -- cdr down it!
(defun merge-spec (spec patch)
    (repeat
       (!= patch (cdr *-*))    (!= spec (cdr *-*))
     :while (and patch spec)
       (cond ((car patch) (!= (car spec) (car patch)))   )))

(defun type-super-set (x y)
   (!= x (coerce-to-nisptype x))
   (!= (Nisptype-super x) y)   )

(eval-when (:compile-toplevel :load-toplevel)
  (defsetf Type-super type-super-set))

;; 5.16.88: Complete redesign of the IS-test system.

;; IS-testers are no longer inherited.  TYPE-SLOT-FUN is not used to
;; build IS-testers, which are instead built using GET-IS-TESTER.
;; This function maintains a stack IS-TESTER-STACK* that keeps track
;; of what's being built, and detects loops.
;; If an is-tester cannot be found for a type, GET-IS-TESTER looks
;; for a (local) feature IS-BUILDER, a function of two arguments:
;; the type and a Boolean indicating whether the function must be
;; defined at build time or not.  (Remember that this whole enterprise
;; is an attempt to build the *name* of an is-tester.)

;; Add to TYPES:
(defvar is-Tester-stack* nil)
(defvar isno* 0)

(defun get-is-tester (typ must-be-defined)
   (!= typ (try-coerce-to-nisptype typ))
   (cond (typ
	  (let ((s (assq 'is (Type-slotfns typ))))
	     (cond ((and s (Slot-acc s) 
			 (or (not must-be-defined) 
			     (appears-defined (Slot-acc s))))
		    ;; Flush *INDIRECT hack here.  It's obsolete anyway
		    (slotfn-deint (Slot-acc s)))
		   (t
		    (let ((p (assq typ is-Tester-stack*)))
		       (cond (p
			      (cond ((cadr p) (cadr p))
				    (t
				     (let ((is-Name (build-symbol is (++ isno*))))
					(!= (cadr p) is-Name)
					is-Name   ))   ))
			     ((type-local-feature typ 'is-builder)
			      (!= p (list typ nil))
			      (bind ((is-Tester-stack*
					(cons p is-Tester-stack*)))
				 (let ((tester (funcall (type-local-feature typ 
									    'is-builder)
							typ must-be-defined)))
				    (cond ((and tester (cadr p))
					   (!= tester
					       `(lambda (x)
						   (let-fun ((,(cadr p) (x)
							      (,(slotfn-deint tester) 
								x)   ))
						      (,(cadr p) x)   ))))   )
				    (cond ((and tester (null is-Tester-stack*))
					   (cond ((null s)
						  (!= s (make-Slot 'is nil nil 
								   'Boolean nil))
						  (!= (Type-slotfns typ) 
						      (cons s *-*)))   )
					   (cond ((null (Slot-acc s))
						  (!= (Slot-acc s) tester))   ))   )
				    (cond ((and tester (or (not must-be-defined)
							   (appears-defined tester)))
					   tester)
					  (t nil)   ))))
			     (t nil)   )))   )))
	 (t nil)   ))

(defun appears-defined (fn) (cond ((is-Symbol fn) (is-fun-name fn)) (t t)   ))

;; Nov.4.87 added
;; 5.27.88 moved LRCD-MASSAGE from listype to types because type-loaders
;;   include calls needed at run-time
(defun lrcd-massage (ld)
   (let-fun ((internal-lrcds-elim (d)
		(cond ((eq (cdr d) 'null)
		       `(,(car d)))
		      ((car-eq (cdr d) 'Lrcd)
		       `(,(car d) . ,(internal-lrcds-elim (cddr d))))
		      (t d)   )))
      `(Lrcd . ,(internal-lrcds-elim (cdr ld)))   ))

; This is here so dclchk and sysdefs can load it without trying to load
; each other.  The numerical types are defined in sysdefs .
(defun numtype (exp)
   (cond ((typep exp 'fixnum) 'Fixnum)
	 ((is-Integer exp) 'Integer)
	 ((is-Ratio exp) 'Ratio)
	 ((is-Double-float exp) 'Double-float)
	 ((is-Single-float exp) 'Float)
	 (t 'Number)   ))

(defun is-Fun (x)
   (cond ((is-Symbol x)
          (fboundp x))
         (t
          (let ((xty (type-of x)))
             (or (eq xty 'function)
                 (car-eq xty 'function))))))