;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)

;;;$Id: typvarsyn.lisp,v 2.10 2005/12/26 00:46:19 dvm Exp $

;;; Copyright 1988 - 2002, Drew McDermott, Yale University

;;; Syntax of variable bindings with intermixed types.

(depends-on %module/ ytools %ytools/ nilscompat)
(depends-on :at-run-time %ydecl/ types)

;; Return 4 values: A list of variables, their types (in ARGTYPE-DESIGS format),
;; an arglist (with types stripped out but otherwise the same as the
;; initial list), and a decl-list (suitable for declaring the variables).
;; There is a fair amount of redundancy here, but if &OPTIONALs etc.
;; are ever added it might come in handy.
;; Also, we now allow "var - type" syntax.
;; However, we don't allow esoteric multiparen junk, except in LSTRUCTURE,
;; which cannot use this version.
(defun types-vars-analyze (types-n-vars)
   (multiple-value-let (vars types)
                       (types-separate types-n-vars '(&rest) nil)
         (types-vars-analyze-flabel types-n-vars vars types)))

;; was FLABEL, but T3 compiler screwed up
(defun types-vars-analyze-flabel (types-n-vars vars types)
   (cond ((null vars) (values nil nil nil nil))
	 ((atom vars)
	  (signal-problem types-vars-analyze :continue
		  "Function variables end illegally: "
		  types-n-vars)
	  (values nil nil nil nil))
	 ((eq (car vars) '&rest)
	  (cond ((not (= (len (cdr vars)) 1))
		 (out (:to *error-output*)
			 "&REST not followed by exactly one"
			 " variable in " types-n-vars :%))   )
	  (match-cond (cadr types)
		      ((null (cdr vars))
		       (values nil nil nil nil))
		      ?((lst ?etype)
			(values (list (cadr vars))
				etype
				`(&rest ,(cadr vars))
				`(,(cadr vars) - ,(cadr types))))
		      (t
		       (let ((ty (or (cadr types) 'Obj)))
			    (values (list (cadr vars))
				    ty
				    `(&rest ,(cadr vars))
				    `(,(cadr vars) - (Lst ,ty)))   ))))
	 (t
	  (multiple-value-let (dvars dtypes args decl)
			      (types-vars-analyze-flabel types-n-vars (cdr vars) (cdr types))
	      (cond ((not (is-Symbol (car vars)))
		     (out (:to *error-output*) "Illegal variable "
			     (car vars) " in "
			     types-n-vars :%))   )
	      (values (cons (car vars) dvars)
		      (cons (or (car types) 'Obj) dtypes)
		      (cons (car vars) args)
		      `(,(car vars) - ,(or (car types) 'Obj)
			. ,decl))   ))   ))

;; Extract type designators.
(defun argtypes (l cur)
  (ignore cur)
  (out (:to *error-output*) "Warning -- obsolete function ARGTYPES called on " l :%)
  (multiple-value-let (args types) 
      (types-separate l nil nil)
    (multiple-value-let (args types) 
	(vars-types-flatten args types nil)
      (ignore args)
      types   )))

;; Extract variables
(defun argvars (l)
  (out (:to *error-output*) "Warning -- obsolete function ARGVARS called on " l :%)
  (multiple-value-let (args types) (types-separate l nil nil)
    (multiple-value-let (args types) (vars-types-flatten args types nil)
      (ignore types)
      args   )))

;; VARS and TYPES are as returned by TYPES-SEPARATE, and (what is not
;; in general true) all the goodies in VARS are atomic.  Hence we can
;; unambiguously flatten them out, and this function does so.
(defun vars-types-flatten (vars types junk)
   (cond ((null vars) (values nil nil))
	 ((atom vars) 
	  (cond ((memq vars junk) (values nil nil))
		(t (values (list vars) (list types)))   ))
         (t
          (multiple-value-let (avars atypes)
                              (vars-types-flatten (car vars) (car types) junk)
             (multiple-value-let (dvars dtypes)
                                 (vars-types-flatten 
				    (cdr vars) (cdr types) junk)
                (values (append avars dvars)
                        (append atypes dtypes))   )))   ))
                           
;; Return two list structures, corresponding to the type designators
;; and variables in TYPES-AND-VARS.  These will be ordinary lists, unless
;; DESCEND is non-(), in which case the function will  go into sublists,
;; and produce isomorphic trees.  In any case, the two lists always
;; have the type for a variable in exactly the same point in list2 as
;; the occurrence of the variable in list 1.  Hence if there is junk
;; like &REST to skip around in list 1, a () will appear at the corresponding
;; place in list 2.  JUNK is a list of such junk to ignore in this way.
;;; ** Don't descend in the sexp that occurs right after a hyphen. --Denys 7/21/89
;;; ** Don't complain if new syntax is used and TYPE-SEPARATOR-CHECK* is false
;;; ** If TYPES-SEPARATE-FCN* is non NIL then is bound to a function that
;;;    is applied to each type descriptor (if non NIL). this means you can
;;;    bind it to #'DESIGNATED-TYPE and thus return types rather than type
;;;    designators, and furthermore it only has to be applied one for each
;;;    occurrence of a type designator rather than once for each variable.
(defvar type-separator-check* true)
(defvar types-separate-fcn*   false)

(defun types-separate (types-n-vars junk descend)
   ;; If a hyphen occurs, then it signals the new experimental syntax
   ;; (x y - integer z - real).  In this syntax, type designators follow
   ;; hyphens, and occur nowhere else.  Otherwise, we have the usual
   ;; ambiguities.
   (let-fun (

 (hyphens-separate (l)
   (cond ((null l) (values nil nil))
         ((memq (car l) junk)
          (multiple-value-let (vars types)
                              (hyphens-separate (cdr l))
             (values (cons (car l) vars) (cons nil types))   ))
         ((eq (car l) '-)
          (out (:to *error-output*) "Ignoring hyphen in meaningless"
                           " place in " types-n-vars :%)
          (hyphens-separate (cdr l)))
         ((and descend (is-Pair (car l)) (funcall descend (car l)))
          (multiple-value-let (avars atypes)
                              (hyphens-separate (car l))
             (multiple-value-let (dvars dtypes)
                                 (hyphens-separate (cdr l))
                (values (cons avars dvars)
                        (cons atypes dtypes))   )))
         (t
          ;; Normal case: look for: -vars- - type-desig
          (let ((tl (memq '- l)) vl td)
             (!= vl (ldiff l tl))
             (cond ((null tl) (!= td '()))
                   ((and (cdr tl)
			 (or (null type-separator-check*)
			     (is-type-desig (cadr tl))))
                    (!= td (cadr tl))
                    (!= tl (cddr tl)))
                   (t
                    (!= td (signal-problem types-separate 
                              "Hyphen followed by non-type-designator "
                              (cadr tl) " in " types-n-vars
                              (:prompt-for "Type-designator (default Obj)>"  'Obj)))
		    
                    (!= tl (cond ((cdr tl) (cddr tl))
                                 (t nil)   )))   )
	     (if (and td types-separate-fcn*)
		 (!= td (funcall types-separate-fcn* td)))
             ;(REPEAT FOR ((X IN VL))
             ;   (COND ((IS-TYPE-DESIG X)
             ;         (OUT (TO *ERROR-OUTPUT*) "Warning-- type designator "
             ;                            X " occurred as variable in "
             ;                            TYPES-N-VARS :%))   ))
             (cond ((and tl (eq (car tl) '-)) (!= tl (cdr tl)))   )
             (multiple-value-let (vars types)
                                 (hyphens-separate tl)
                (values (append vl vars)
                        (nconc (<# (\\ (v) (ignore v) td   )
                                   vl)
                               types))   )))   ))

 (massage (td) (if types-separate-fcn* (funcall types-separate-fcn* td) td))

 (nohyphens-separate (l cur)
   (cond ((null l) (values nil nil))
         ;((ATOM L) (VALUES L CUR))
         ((memq (car l) junk)
          (multiple-value-let (vars types)
                              (nohyphens-separate (cdr l) cur)
             (values (cons (car l) vars) (cons nil types))   ))
         ((is-type-desig (car l))
          (cond ((is-Pair (car l))
                 (nohyphens-separate (cdr l) (massage (car l))))
                ((null (cdr l))
                 (out (:to *error-output*) "Warning: Assuming " (car l)
                                    " is a variable in " types-n-vars :%)
                 (values (list (car l)) (list cur)))
                ((and (is-Pair (cdr l)) (is-type-desig (cadr l)))
                 (out (:to *error-output*) "Warning: Assuming " (cadr l)
                                    " is a variable in " types-n-vars :%)
		 (let ((td (massage (car l))))
		   (multiple-value-let (vars types)
		       (nohyphens-separate (cddr l) td)
                    (values (cons (cadr l) vars)
                            (cons td types))   )))
                (t
                 (nohyphens-separate (cdr l) (massage (car l))))   ))
         ((and descend (is-Pair (car l)) (funcall descend (car l)))
          (multiple-value-let (avars atypes)
                              (nohyphens-separate 
				 (unscramble-if-necessary (car l)) nil)
             (multiple-value-let (dvars dtypes)
                                 (nohyphens-separate (cdr l) cur)
                (values (cons avars dvars)
                        (cons atypes dtypes))   )))
         (t
          (multiple-value-let (vars types)
                              (nohyphens-separate (cdr l) cur)
             (values (cons (car l) vars)
                     (cons cur types))   ))   ))

 (unscramble-if-necessary (l)
    (cond ((or (is-type-desig (car l))
               (not (is-type-desig (lastelemifany l))))
	   l)
	  (t (types-unscramble l))   ))

 (check-syntax (x)   ; Return values <legal, hyphenated>
    (cond ((and (atom x) (not (null x)))
	   (values nil nil))
	  (t
	   (let ((legal t) (found-hyphen nil) (just-after-hyphen nil))
	      (repeat 
	       :until (null x)
	       :result (if just-after-hyphen (!= legal nil))
	       :until (atom x)
	       :result (!= legal nil)
		 (cond ((eq (car x) '-)
			(!= found-hyphen t)
			(if just-after-hyphen (!= legal nil))
			(!= just-after-hyphen t))
		       ((and (not just-after-hyphen)
			     descend
			     (consp (car x))
			     (funcall descend (car x)))
			(multiple-value-let (l h) (check-syntax (car x))
			   (cond ((null l) (!= legal nil))   )
			   (cond (h (!= found-hyphen t))   )))
		       (t (!= just-after-hyphen nil)))
	       :while legal
		 (!= x (cdr x))  )
	      (values legal found-hyphen)   ))   ))
)
   ;; Body of TYPES-SEPARATE:
   (multiple-value-let (legal found-hyphen) (check-syntax types-n-vars)
      (cond ((not legal)
	     (signal-problem types-separate :continue 
	        "Illegal type-var-list: " types-n-vars)
	     (values nil nil))
	    (found-hyphen (hyphens-separate types-n-vars))
            (t
             (nohyphens-separate (unscramble-if-necessary types-n-vars)
				 nil))   ))))

;; Old Nisp function extracted from LET-FUN above because of use in DUCK
(defun types-unscramble (l)
   (cond ((null (cdr l)) l)
         (t
          (let ((r (types-unscramble (cdr l))))
             (cond ((is-type-desig (car l))
                    (cons (car l) r))
                   (t (cons (car r)
                            (cons (car l) (cdr r))))   )))   ))

(defun types-in-arglist (al)
   (or (memq '- al)
       (<v is-type-desig al))   )

(defun lastelemifany (x)
   (cond ((atom x) nil)
         ((null (cdr x)) (car x))
         (t (lastelemifany (cdr x)))   ))
