;-*- Mode: Common-lisp; Package: ydecl; Readtable: ytools; -*-
(in-package :ydecl)
;;;$Id: ydcopy.lisp,v 1.4 2006/06/15 21:30:18 dvm Exp $

(depends-on %module/ nisp)

(depends-on (:at :run-time) %ytools/ ytcopy)

;;; Nothing in this file seems to actually require that Nisp
;;; be loaded -- or even ever have run on this computer.
;;; Except that if Nisp is loaded the version number will be
;;; conveniently printed by 'nisp-build-for-export'.

;;; For logical names --
(import '(yt::wkg yt::cvs yt::doc))

(defparameter cyndra-cvs-host*
              ":ext:dvm@cyndra.cs.yale.edu:/homes/ai/dvm/cvsroot/")

(defparameter ynisp-levels* '("prog" "ydecl"))

(defun nisp-build-for-export (&key (dest-dir "%wkg/CVStemp/prog/ydecl/"))
   (let ((expanded-dest-dir (->pathname dest-dir)))
      (err-out "Exporting Nisp to " expanded-dest-dir)
      (cvs-export expanded-dest-dir ynisp-levels* :host cyndra-cvs-host*)
      (err-out "Creating compressed tar file")
      (create-tar-file expanded-dest-dir)
      (!= (port:default-directory)
          (->pathname tar-file-dir*))
      (err-out "Copying tar file to cyndra (takes a while)")
      (try-run-shell-command
         !"scp ydecl.tar.gz ~
               dvm@cyndra.cs.yale.edu:ftparea/software/ynisp.tar.gz"
         :show-window ':hide)
      (err-out "Don't forget to edit webpage to reflect [Y]Nisp "
               (:q ((boundp '+nisp-version+)
                    (:a +nisp-version+) 1)
                   (t
                     "(version ???) "))
               "availability")
      '***))
                
